/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.person.creditsplit;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.kuali.coeus.common.framework.type.InvestigatorCreditType;
import org.kuali.coeus.common.framework.unit.Unit;
import org.kuali.coeus.propdev.api.person.creditsplit.ProposalUnitCreditSplitContract;
import org.kuali.coeus.propdev.impl.person.ProposalPersonUnit;
import org.kuali.coeus.propdev.impl.person.creditsplit.CreditSplit;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.coeus.sys.framework.persistence.ScaleTwoDecimalConverter;

@Entity
@Table(name="EPS_PROP_UNIT_CREDIT_SPLIT")
@IdClass(value=ProposalUnitCreditSplitId.class)
public final class ProposalUnitCreditSplit
extends KcPersistableBusinessObjectBase
implements CreditSplit,
ProposalUnitCreditSplitContract {
    @Id
    @ManyToOne
    @JoinColumns(value={@JoinColumn(name="PROPOSAL_NUMBER", referencedColumnName="PROPOSAL_NUMBER"), @JoinColumn(name="PROP_PERSON_NUMBER", referencedColumnName="PROP_PERSON_NUMBER"), @JoinColumn(name="UNIT_NUMBER", referencedColumnName="UNIT_NUMBER")})
    private ProposalPersonUnit proposalPersonUnit;
    @Id
    @Column(name="INV_CREDIT_TYPE_CODE")
    private String invCreditTypeCode;
    @Column(name="CREDIT")
    @Convert(converter=ScaleTwoDecimalConverter.class)
    private ScaleTwoDecimal credit;
    @Transient
    private Unit unit;
    @ManyToOne
    @JoinColumn(name="INV_CREDIT_TYPE_CODE", referencedColumnName="INV_CREDIT_TYPE_CODE", insertable=false, updatable=false)
    private InvestigatorCreditType investigatorCreditType;

    public InvestigatorCreditType getInvestigatorCreditType() {
        return this.investigatorCreditType;
    }

    public void setInvestigatorCreditType(InvestigatorCreditType argInvCreditType) {
        this.investigatorCreditType = argInvCreditType;
    }

    @Override
    public String getInvCreditTypeCode() {
        return this.invCreditTypeCode;
    }

    @Override
    public void setInvCreditTypeCode(String argInvCreditTypeCode) {
        this.invCreditTypeCode = argInvCreditTypeCode;
    }

    @Override
    public ScaleTwoDecimal getCredit() {
        return this.credit == null ? ScaleTwoDecimal.ZERO : this.credit;
    }

    @Override
    public void setCredit(ScaleTwoDecimal argCredit) {
        this.credit = argCredit;
    }

    public void setUnit(Unit argUnit) {
        this.unit = argUnit;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public String getProposalNumber() {
        return this.getProposalPersonUnit().getProposalPerson().getDevelopmentProposal().getProposalNumber();
    }

    public Integer getProposalPersonNumber() {
        return this.getProposalPersonUnit().getProposalPersonNumber();
    }

    public String getUnitNumber() {
        return this.getProposalPersonUnit().getUnitNumber();
    }

    public ProposalPersonUnit getProposalPersonUnit() {
        return this.proposalPersonUnit;
    }

    public void setProposalPersonUnit(ProposalPersonUnit proposalPersonUnit) {
        this.proposalPersonUnit = proposalPersonUnit;
    }

    public static final class ProposalUnitCreditSplitId
    implements Serializable,
    Comparable<ProposalUnitCreditSplitId> {
        private ProposalPersonUnit.ProposalPersonUnitId proposalPersonUnit;
        private String invCreditTypeCode;

        public ProposalPersonUnit.ProposalPersonUnitId getProposalPersonUnit() {
            return this.proposalPersonUnit;
        }

        public void setProposalPersonUnit(ProposalPersonUnit.ProposalPersonUnitId proposalPersonUnit) {
            this.proposalPersonUnit = proposalPersonUnit;
        }

        public String getInvCreditTypeCode() {
            return this.invCreditTypeCode;
        }

        public void setInvCreditTypeCode(String invCreditTypeCode) {
            this.invCreditTypeCode = invCreditTypeCode;
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("proposalPersonUnit", (Object)this.proposalPersonUnit).append("invCreditTypeCode", (Object)this.invCreditTypeCode).toString();
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other == this) {
                return true;
            }
            if (other.getClass() != this.getClass()) {
                return false;
            }
            ProposalUnitCreditSplitId rhs = (ProposalUnitCreditSplitId)other;
            return new EqualsBuilder().append((Object)this.proposalPersonUnit, (Object)rhs.proposalPersonUnit).append((Object)this.invCreditTypeCode, (Object)rhs.invCreditTypeCode).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder(17, 37).append((Object)this.proposalPersonUnit).append((Object)this.invCreditTypeCode).toHashCode();
        }

        @Override
        public int compareTo(ProposalUnitCreditSplitId other) {
            return new CompareToBuilder().append((Object)this.proposalPersonUnit, (Object)other.proposalPersonUnit).append((Object)this.invCreditTypeCode, (Object)other.invCreditTypeCode).toComparison();
        }
    }
}

