/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.paymentreports.awardreports.reporting.service;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.framework.version.VersionStatus;
import org.kuali.coeus.common.notification.impl.bo.NotificationType;
import org.kuali.coeus.common.notification.impl.service.KcNotificationService;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardService;
import org.kuali.kra.award.notification.AwardNotificationContext;
import org.kuali.kra.award.notification.AwardReportTrackingDigestNotificationRenderer;
import org.kuali.kra.award.notification.AwardReportTrackingNotificationRenderer;
import org.kuali.kra.award.notification.AwardUnitHierarchyDescendingNotificationContext;
import org.kuali.kra.award.paymentreports.ReportStatus;
import org.kuali.kra.award.paymentreports.awardreports.reporting.ReportTracking;
import org.kuali.kra.award.paymentreports.awardreports.reporting.service.ReportTrackingDao;
import org.kuali.kra.award.paymentreports.awardreports.reporting.service.ReportTrackingNotification;
import org.kuali.kra.award.paymentreports.awardreports.reporting.service.ReportTrackingNotificationDetails;
import org.kuali.kra.award.paymentreports.awardreports.reporting.service.ReportTrackingNotificationService;
import org.kuali.kra.award.paymentreports.awardreports.reporting.service.ReportTrackingNotificationTask;
import org.kuali.kra.award.paymentreports.awardreports.reporting.service.ReportTrackingService;
import org.kuali.kra.award.paymentreports.awardreports.reporting.service.SentReportNotification;
import org.kuali.kra.award.version.service.AwardVersionService;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.ken.api.notification.NotificationRecipient;
import org.kuali.rice.krad.service.BusinessObjectService;

public class ReportTrackingNotificationServiceImpl
implements ReportTrackingNotificationService {
    private static final Logger LOG = LogManager.getLogger(ReportTrackingNotificationServiceImpl.class);
    private static final String ASCEND_UNIT_HIERARCHY_FOR_DIGEST_NOTIFICATIONS_PARAM = "Ascend_Unit_Hierarchy_For_Report_Tracking_Digest_Unit_Admins";
    private BusinessObjectService businessObjectService;
    private AwardService awardService;
    private AwardVersionService awardVersionService;
    private KcNotificationService notificationService;
    private ParameterService parameterService;
    private ReportTrackingDao reportTrackingDao;
    private ReportTrackingService reportTrackingService;
    private List<ReportTrackingNotification> notifications = new ArrayList<ReportTrackingNotification>();

    @Override
    public List<ReportTrackingNotificationDetails> runReportTrackingNotifications() {
        ArrayList<ReportTrackingNotificationDetails> resultDetails = new ArrayList<ReportTrackingNotificationDetails>();
        AwardReportTrackingNotificationRenderer renderer = new AwardReportTrackingNotificationRenderer();
        Set validStatusCode = Stream.of(this.reportTrackingService.getPendingReportStatus(), this.reportTrackingService.getDueReportStatus()).map(ReportStatus::getReportStatusCode).collect(Collectors.toSet());
        for (ReportTrackingNotification notification : this.notifications) {
            ReportTrackingNotificationDetails details = new ReportTrackingNotificationDetails();
            details.setActionCode(notification.getActionCode());
            details.setNotificationName(notification.getName());
            resultDetails.add(details);
            try {
                NotificationType notificationType = this.notificationService.getNotificationType("1", notification.getActionCode());
                if (!this.canSendNotifications(notificationType)) continue;
                details.setNotificationActive(true);
                details.setNotificationRecipients(notificationType.getNotificationTypeRecipients().size());
                int recordsFound = 0;
                int recordsMatched = 0;
                int notificationsSent = 0;
                Calendar checkFor = Calendar.getInstance();
                if (notification.isOverdue()) {
                    checkFor.add(5, (notification.getDays() + notification.getScope()) * -1);
                } else {
                    checkFor.add(5, notification.getDays() - notification.getScope());
                }
                Calendar until = (Calendar)checkFor.clone();
                until.add(5, notification.getScope());
                this.clearTimeFields(checkFor);
                this.clearTimeFields(until);
                HashMap<Award, List> matchedReports = new HashMap<Award, List>();
                TreeMap<String, List> recipients = new TreeMap<String, List>();
                for (ReportTrackingNotificationTask task : notification.getTasks()) {
                    List<ReportTracking> reports = this.getReportTrackingDao().getDetailResults(task.getReportTrackingValueMap(), Collections.emptyList());
                    recordsFound += reports.size();
                    for (ReportTracking reportTracking : reports) {
                        Award curAward;
                        if (reportTracking.getDueDate() == null || !this.doDatesMatch(reportTracking.getDueDate(), checkFor, until) || this.hasSentNotification(reportTracking, notification) || reportTracking.getStatusCode() == null || !validStatusCode.contains(reportTracking.getStatusCode()) || !this.isAwardActive(curAward = this.awardService.getAward(reportTracking.getAwardId()))) continue;
                        ++recordsMatched;
                        reportTracking.setAward(curAward);
                        List curReports = matchedReports.computeIfAbsent(curAward, k -> new ArrayList());
                        curReports.add(reportTracking);
                    }
                    for (Award award : matchedReports.keySet()) {
                        Set<NotificationRecipient.Builder> recips = this.notificationService.getNotificationRecipients(new AwardNotificationContext(award, notification.getActionCode(), notification.getName()));
                        for (NotificationRecipient.Builder recip : recips) {
                            List curReports = recipients.computeIfAbsent(recip.getRecipientId(), k -> new ArrayList());
                            curReports.addAll((Collection)matchedReports.get(award));
                        }
                    }
                    for (Map.Entry entry : recipients.entrySet()) {
                        renderer.setReports((List)entry.getValue());
                        String message = renderer.render(notificationType.getMessage());
                        this.notificationService.sendNotification(notification.getName(), notificationType.getSubject(), message, Collections.singletonList((String)entry.getKey()));
                        ++notificationsSent;
                    }
                    ArrayList<SentReportNotification> sentReports = new ArrayList<SentReportNotification>();
                    for (Map.Entry entry : matchedReports.entrySet()) {
                        for (ReportTracking report : (List)entry.getValue()) {
                            sentReports.add(new SentReportNotification(notification.getActionCode(), report));
                        }
                    }
                    this.businessObjectService.save(sentReports);
                }
                details.setTrackingRecordsFound(recordsFound);
                details.setTrackingRecordsMatched(recordsMatched);
                details.setNotificationsSent(notificationsSent);
            }
            catch (Exception e) {
                LOG.error("Error sending report tracking notifications for " + notification.getActionCode(), (Throwable)e);
                details.setErrorMessage(e.getMessage());
            }
        }
        return resultDetails;
    }

    @Override
    public ReportTrackingNotificationDetails runReportDigestNotification(String actionCode, String notificationName, boolean includeDue, boolean includeOverdue) {
        AwardReportTrackingDigestNotificationRenderer renderer = new AwardReportTrackingDigestNotificationRenderer();
        renderer.setIncludeDue(includeDue);
        renderer.setIncludeOverdue(includeOverdue);
        ReportStatus dueStatus = this.reportTrackingService.getDueReportStatus();
        ReportTrackingNotificationDetails details = new ReportTrackingNotificationDetails();
        details.setNotificationName(notificationName);
        details.setActionCode(actionCode);
        NotificationType notificationType = this.notificationService.getNotificationType("1", actionCode);
        if (this.canSendNotifications(notificationType)) {
            details.setNotificationActive(true);
            try {
                Map<String, String> dueCriteria = Collections.singletonMap("statusCode", dueStatus.getReportStatusCode());
                List<ReportTracking> dueReports = this.getReportTrackingDao().getDetailResults(dueCriteria, Collections.emptyList());
                Map<String, Set<ReportTracking>> reportsByRecipient = this.groupReportsByRecipient(dueReports, actionCode, notificationName);
                reportsByRecipient.forEach((recipientId, reports) -> {
                    renderer.setDigestReports((Collection<ReportTracking>)reports);
                    String message = renderer.render(notificationType.getMessage());
                    String subject = renderer.render(notificationType.getSubject());
                    this.notificationService.sendNotification(notificationName, subject, message, Collections.singletonList(recipientId));
                });
                this.populateReportDetails(reportsByRecipient, dueReports, details);
            }
            catch (Exception e) {
                LOG.error("Error sending report tracking digest notification for " + actionCode, (Throwable)e);
                details.setErrorMessage(e.getMessage());
            }
        }
        return details;
    }

    protected boolean doDatesMatch(Date date1, Calendar from, Calendar until) {
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(date1);
        this.clearTimeFields(cal1);
        return cal1.after(from) && (cal1.equals(until) || cal1.before(until));
    }

    protected boolean hasSentNotification(ReportTracking report, ReportTrackingNotification notification) {
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put("awardNumber", report.getAwardNumber());
        values.put("reportClassCode", report.getReportClassCode());
        values.put("reportCode", report.getReportCode());
        values.put("dueDate", report.getDueDate());
        values.put("actionCode", notification.getActionCode());
        List notifications = this.getBusinessObjectService().findMatching(SentReportNotification.class, values);
        return notifications != null && !notifications.isEmpty();
    }

    protected boolean isAwardActive(Award award) {
        return award != null && award.getStatusCode() != 3 && award.getStatusCode() != 2 && award.getAwardSequenceStatus().equals(VersionStatus.ACTIVE.name());
    }

    protected void clearTimeFields(Calendar date) {
        date.set(11, 0);
        date.set(12, 0);
        date.set(13, 0);
        date.set(14, 0);
    }

    protected boolean canSendNotifications(NotificationType notificationType) {
        return notificationType != null && notificationType.isActive() && notificationType.getNotificationTypeRecipients() != null && !notificationType.getNotificationTypeRecipients().isEmpty();
    }

    protected Map<String, Set<ReportTracking>> groupReportsByRecipient(Collection<ReportTracking> reports, String actionCode, String notificationName) {
        HashMap<String, Set<ReportTracking>> reportsByRecipient = new HashMap<String, Set<ReportTracking>>();
        for (ReportTracking report : reports) {
            report.setAward(this.awardService.getAward(report.getAwardId()));
            if (!this.isAwardActive(report.getAward())) continue;
            AwardUnitHierarchyDescendingNotificationContext notificationContext = new AwardUnitHierarchyDescendingNotificationContext(report.getAward(), actionCode, notificationName);
            notificationContext.setDescendsHierarchy(this.shouldNotificationContextDescendHierarchy());
            this.notificationService.getNotificationRecipients(notificationContext).forEach(recipient -> {
                Set recipientReports = reportsByRecipient.getOrDefault(recipient.getRecipientId(), new HashSet());
                recipientReports.add(report);
                reportsByRecipient.put(recipient.getRecipientId(), recipientReports);
            });
        }
        return reportsByRecipient;
    }

    protected void populateReportDetails(Map<String, Set<ReportTracking>> reportsByRecipient, List<ReportTracking> foundReports, ReportTrackingNotificationDetails details) {
        details.setNotificationRecipients(reportsByRecipient.size());
        details.setNotificationsSent(details.getNotificationRecipients());
        details.setTrackingRecordsMatched(foundReports.size());
        details.setTrackingRecordsFound(details.getTrackingRecordsMatched());
    }

    protected boolean shouldNotificationContextDescendHierarchy() {
        return this.getParameterService().getParameterValueAsBoolean(AwardDocument.class, ASCEND_UNIT_HIERARCHY_FOR_DIGEST_NOTIFICATIONS_PARAM, Boolean.valueOf(true));
    }

    protected BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    protected KcNotificationService getNotificationService() {
        return this.notificationService;
    }

    public void setNotificationService(KcNotificationService notificationService) {
        this.notificationService = notificationService;
    }

    public List<ReportTrackingNotification> getNotifications() {
        return this.notifications;
    }

    public void setNotifications(List<ReportTrackingNotification> notifications) {
        this.notifications = notifications;
    }

    public AwardService getAwardService() {
        return this.awardService;
    }

    public void setAwardService(AwardService awardService) {
        this.awardService = awardService;
    }

    public AwardVersionService getAwardVersionService() {
        return this.awardVersionService;
    }

    public void setAwardVersionService(AwardVersionService awardVersionService) {
        this.awardVersionService = awardVersionService;
    }

    public ReportTrackingDao getReportTrackingDao() {
        return this.reportTrackingDao;
    }

    public void setReportTrackingDao(ReportTrackingDao reportTrackingDao) {
        this.reportTrackingDao = reportTrackingDao;
    }

    public ReportTrackingService getReportTrackingService() {
        return this.reportTrackingService;
    }

    public void setReportTrackingService(ReportTrackingService reportTrackingService) {
        this.reportTrackingService = reportTrackingService;
    }
}

