/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.document.authorization;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.kuali.coeus.common.framework.auth.KcTransactionalDocumentAuthorizerBase;
import org.kuali.coeus.common.framework.auth.perm.KcAuthorizationService;
import org.kuali.coeus.common.framework.auth.task.ApplicationTask;
import org.kuali.coeus.sys.framework.model.KcTransactionalDocumentBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.award.awardhierarchy.AwardHierarchy;
import org.kuali.kra.award.awardhierarchy.AwardHierarchyService;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.document.authorization.AwardTask;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardLimitedEditAuthorizationService;
import org.kuali.kra.award.home.AwardService;
import org.kuali.kra.award.infrastructure.AwardPermissionConstants;
import org.kuali.kra.award.infrastructure.AwardTaskNames;
import org.kuali.kra.external.award.AwardAccountService;
import org.kuali.kra.timeandmoney.AwardHierarchyNode;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.doctype.service.DocumentTypePermissionService;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.routeheader.service.RouteHeaderService;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.krad.bo.DocumentHeader;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.document.authorization.PessimisticLock;
import org.kuali.rice.krad.util.GlobalVariables;

public class AwardDocumentAuthorizer
extends KcTransactionalDocumentAuthorizerBase {
    public static final String ADD_BUDGET = "addBudget";
    public static final String OPEN_BUDGETS = "openBudgets";
    public static final String MODIFY_AWARD_BUDGET = "modifyAwardBudget";
    public static final String CREATE_AWARD_ACCOUNT = "createAwardAccount";
    public static final String POST_AWARD = "postAward";
    public static final String POST_TIME_AND_MONEY = "postTimeAndMoney";
    public static final String AWARD_SYNC = "awardSync";
    public static final String CAN_MAINTAIN_AWARD_ATTACHMENTS = "CAN_MAINTAIN_AWARD_ATTACHMENTS";
    public static final String CAN_VIEW_AWARD_ATTACHMENTS = "CAN_VIEW_AWARD_ATTACHMENTS";
    public static final String CAN_SEND_AWARD_NOTICE = "sendAwardNotice";
    private static final String VIEW_ACCOUNT_ELEMENT = "viewAccountElement";
    private static final String VIEW_CHART_OF_ACCOUNTS_ELEMENT = "viewChartOfAccountsElement";
    private static final String MAINTAIN_PERSONNEL_UNITS = "maintainPersonnelUnits";
    public static final String LIMITED_EDIT_AWARD_SPONSOR_CONTACTS = "limitedEditAwardSponsorContacts";
    public static final String LIMITED_EDIT_AWARD_ATTACHMENTS = "limitedEditAwardAttachments";
    public static final String LIMITED_EDIT_AWARD_REPORT_CLASSES = "limitedEditAwardReportClasses";
    public static final String LIMITED_EDIT_AWARD_NOTES = "limitedEditAwardNotes";
    private AwardHierarchyService awardHierarchyService;
    private transient AwardAccountService awardAccountService;
    private AwardLimitedEditAuthorizationService awardLimitedEditAuthorizationService;

    public Set<String> getEditModes(Document document, Person user, Set<String> currentEditModes) {
        HashSet<String> editModes = new HashSet<String>();
        AwardDocument awardDocument = (AwardDocument)document;
        if (awardDocument.getAward().getAwardId() == null) {
            if (this.canCreateAward(user.getPrincipalId())) {
                editModes.add("fullEntry");
                if (this.canViewChartOfAccountsElement(awardDocument)) {
                    editModes.add(VIEW_CHART_OF_ACCOUNTS_ELEMENT);
                }
                if (this.canViewAccountElement(awardDocument)) {
                    editModes.add(VIEW_ACCOUNT_ELEMENT);
                }
            } else {
                editModes.add("unviewable");
            }
        } else {
            boolean isCanceled = awardDocument.isCanceled();
            if (!awardDocument.isCanceled() && this.canExecuteAwardTask(user.getPrincipalId(), awardDocument, AwardTaskNames.MODIFY_AWARD.getAwardTaskName())) {
                editModes.add("fullEntry");
            } else if (this.canExecuteAwardTask(user.getPrincipalId(), awardDocument, AwardTaskNames.VIEW_AWARD.getAwardTaskName())) {
                editModes.add("viewOnly");
            } else {
                editModes.add("unviewable");
            }
            if (!isCanceled && this.canExecuteAwardTask(user.getPrincipalId(), awardDocument, ADD_BUDGET)) {
                editModes.add(ADD_BUDGET);
            }
            if (this.canExecuteAwardTask(user.getPrincipalId(), awardDocument, OPEN_BUDGETS)) {
                editModes.add(OPEN_BUDGETS);
            }
            if (!isCanceled && this.canExecuteAwardTask(user.getPrincipalId(), awardDocument, "modifyBudget")) {
                editModes.add(MODIFY_AWARD_BUDGET);
            }
            if (this.canCreateAward(user.getPrincipalId())) {
                editModes.add("canCreateAward");
            }
            if (this.canCreateAwardAccount(document)) {
                editModes.add(CREATE_AWARD_ACCOUNT);
            }
            if (this.canViewPostHistory(awardDocument, user.getPrincipalId())) {
                editModes.add(POST_AWARD);
            }
            if (this.canViewPostHistory(user.getPrincipalId())) {
                editModes.add(POST_TIME_AND_MONEY);
            }
            if (this.awardHasHierarchyChildren(document)) {
                editModes.add(AWARD_SYNC);
            }
            if (this.canViewChartOfAccountsElement(awardDocument)) {
                editModes.add(VIEW_CHART_OF_ACCOUNTS_ELEMENT);
            }
            if (this.canViewAccountElement(awardDocument)) {
                editModes.add(VIEW_ACCOUNT_ELEMENT);
            }
            if (editModes.contains("fullEntry") || this.canMaintainAwardAttachments(awardDocument, user)) {
                editModes.add(CAN_MAINTAIN_AWARD_ATTACHMENTS);
            }
            if (editModes.contains(CAN_MAINTAIN_AWARD_ATTACHMENTS) || this.canViewAwardAttachments(awardDocument, user)) {
                editModes.add(CAN_VIEW_AWARD_ATTACHMENTS);
            }
            if (this.canSendAwardNotice(user.getPrincipalId())) {
                editModes.add(CAN_SEND_AWARD_NOTICE);
            }
            if (this.canMaintainPersonnelUnits(awardDocument, user)) {
                editModes.add(MAINTAIN_PERSONNEL_UNITS);
            }
            if (this.getAwardLimitedEditAuthorizationService().canLimitedModifyAwardSponsorContacts(awardDocument, user.getPrincipalId())) {
                editModes.add(LIMITED_EDIT_AWARD_SPONSOR_CONTACTS);
            }
            if (this.getAwardLimitedEditAuthorizationService().canLimitedModifyAwardAttachments(awardDocument, user.getPrincipalId())) {
                editModes.add(LIMITED_EDIT_AWARD_ATTACHMENTS);
            }
            if (this.getAwardLimitedEditAuthorizationService().canLimitedModifyAwardReportClasses(awardDocument, user.getPrincipalId())) {
                editModes.add(LIMITED_EDIT_AWARD_REPORT_CLASSES);
            }
            if (this.getAwardLimitedEditAuthorizationService().canLimitedModifyAwardNotes(awardDocument, user.getPrincipalId())) {
                editModes.add(LIMITED_EDIT_AWARD_NOTES);
            }
        }
        return editModes;
    }

    public boolean canViewPostHistory(String principalId) {
        return this.isTimeAndMoneyPostEnabled() && this.hasPostTimeAndMoneyPermission(principalId);
    }

    public boolean hasPostTimeAndMoneyPermission(String principalId) {
        return AwardDocumentAuthorizer.getPermissionService().hasPermission(principalId, "KC-SYS", "Post Time and Money");
    }

    protected boolean isTimeAndMoneyPostEnabled() {
        return this.getParameterService().getParameterValueAsBoolean("KC-T", "All", "TM_POST_ENABLED");
    }

    public boolean canInitiate(String documentTypeName, Person user) {
        return this.canCreateAward(user.getPrincipalId());
    }

    public boolean canCreateAwardAccount(Document document) {
        AwardDocument awardDocument = (AwardDocument)document;
        Award award = awardDocument.getAward();
        boolean hasPermission = false;
        String status = document.getDocumentHeader().getWorkflowDocument().getStatus().getCode();
        if (this.accountCreateAllowed(award) && (status.equalsIgnoreCase("P") || status.equalsIgnoreCase("F")) && (this.isFinancialsystemIntegrationOn() || this.isFinancialRestApiEnabled())) {
            hasPermission = this.hasCreateAccountPermission(awardDocument);
            if (award.getFinancialAccountDocumentNumber() != null) {
                hasPermission = true;
            }
        }
        return hasPermission;
    }

    public boolean accountCreateAllowed(Award award) {
        boolean allowAcctCreate = award.getAwardSequenceStatus().equalsIgnoreCase("active");
        AwardService awardService = KcServiceLocator.getService(AwardService.class);
        if (awardService.hierarchyLevel(award) == 0 && this.isParentAwardAccountDisallowed()) {
            allowAcctCreate = false;
        }
        return allowAcctCreate;
    }

    public boolean canViewPostHistory(AwardDocument document, String principalId) {
        return this.isFinancialRestApiEnabled() && document.hasPostAwardPermission(principalId);
    }

    protected boolean isFinancialRestApiEnabled() {
        return this.getAwardAccountService().isFinancialRestApiEnabled();
    }

    protected boolean isParentAwardAccountDisallowed() {
        return this.getParameterService().getParameterValueAsBoolean("KC-AWARD", "Document", "DISABLE_PARENT_AWARD_ACCOUNTS");
    }

    protected boolean isFinancialsystemIntegrationOn() {
        return this.getParameterService().getParameterValueAsBoolean("KC-AWARD", "Document", "KUALI_FINANCIALS_INTEGRATION_ON");
    }

    protected boolean isPostAwardFinancialsEnabled() {
        return this.getParameterService().getParameterValueAsBoolean("KC-AWARD", "Document", "Enable_PostAwardFinancials");
    }

    protected AwardAccountService getAwardAccountService() {
        if (this.awardAccountService == null) {
            this.awardAccountService = KcServiceLocator.getService(AwardAccountService.class);
        }
        return this.awardAccountService;
    }

    public AwardLimitedEditAuthorizationService getAwardLimitedEditAuthorizationService() {
        if (this.awardLimitedEditAuthorizationService == null) {
            this.awardLimitedEditAuthorizationService = KcServiceLocator.getService(AwardLimitedEditAuthorizationService.class);
        }
        return this.awardLimitedEditAuthorizationService;
    }

    public void setAwardLimitedEditAuthorizationService(AwardLimitedEditAuthorizationService awardLimitedEditAuthorizationService) {
        this.awardLimitedEditAuthorizationService = awardLimitedEditAuthorizationService;
    }

    public boolean hasCreateAccountPermission(AwardDocument document) {
        return this.canExecuteAwardTask(GlobalVariables.getUserSession().getPrincipalId(), document, AwardTaskNames.CREATE_AWARD_ACCOUNT.getAwardTaskName());
    }

    public boolean canViewChartOfAccountsElement(AwardDocument document) {
        return this.hasCreateAccountPermission(document) && this.isFinancialsystemIntegrationOn() || this.isPostAwardFinancialsEnabled();
    }

    public boolean canViewAccountElement(AwardDocument document) {
        boolean hasPermission = true;
        if (this.isFinancialsystemIntegrationOn() && !this.hasCreateAccountPermission(document)) {
            hasPermission = false;
        }
        return hasPermission;
    }

    public boolean canSendAwardNotice(String principalId) {
        return AwardDocumentAuthorizer.getPermissionService().hasPermission(principalId, "KC-AWARD", AwardPermissionConstants.SEND_AWARD_NOTICE.getAwardPermission());
    }

    public boolean canOpen(Document document, Person user) {
        AwardDocument awardDocument = (AwardDocument)document;
        if (awardDocument.getAward().getAwardId() == null) {
            return this.canCreateAward(user.getPrincipalId());
        }
        return this.canExecuteAwardTask(user.getPrincipalId(), (AwardDocument)document, AwardTaskNames.VIEW_AWARD.getAwardTaskName());
    }

    @Override
    public boolean canEdit(Document document, Person user) {
        boolean isCanceled = ((AwardDocument)document).isCanceled();
        return !isCanceled && this.canExecuteAwardTask(user.getPrincipalId(), (AwardDocument)document, AwardTaskNames.MODIFY_AWARD.getAwardTaskName()) && !this.isPessimisticLocked((AwardDocument)document);
    }

    protected boolean isPessimisticLocked(AwardDocument document) {
        boolean isLocked = false;
        for (PessimisticLock lock : document.getPessimisticLocks()) {
            if (lock.isOwnedByUser(GlobalVariables.getUserSession().getPerson())) continue;
            isLocked = true;
        }
        return isLocked;
    }

    @Override
    public boolean canSave(Document document, Person user) {
        return this.canEdit(document, user);
    }

    @Override
    public boolean canCopy(Document document, Person user) {
        return false;
    }

    private boolean doesAwardHierarchyContainFinalChildren(AwardHierarchy currentAward, Map<String, AwardHierarchyNode> awardHierarchyNodes) {
        for (AwardHierarchy child : currentAward.getChildren()) {
            AwardHierarchyNode childInfo = awardHierarchyNodes.get(child.getAwardNumber());
            if (childInfo.isAwardDocumentFinalStatus().booleanValue()) {
                return true;
            }
            this.doesAwardHierarchyContainFinalChildren(childInfo, awardHierarchyNodes);
        }
        return false;
    }

    private boolean isCurrentAwardTheFirstVersion(Award currentAward) {
        return currentAward.getSequenceNumber() == 1;
    }

    @Override
    public boolean canCancel(Document document, Person user) {
        if (!this.canEdit(document, user)) {
            return false;
        }
        boolean canCancel = true;
        DocumentHeader docHeader = document.getDocumentHeader();
        WorkflowDocument workflowDoc = docHeader.getWorkflowDocument();
        if (workflowDoc.isSaved()) {
            AwardDocument awardDocument = (AwardDocument)document;
            AwardHierarchyService awardHierarchyService = KcServiceLocator.getService(AwardHierarchyService.class);
            Award currentAward = awardDocument.getAward();
            HashMap<String, AwardHierarchyNode> awardHierarchyNodes = new HashMap<String, AwardHierarchyNode>();
            Map<String, AwardHierarchy> awardHierarchyItems = awardHierarchyService.getAwardHierarchy(awardDocument.getAward().getAwardNumber(), new ArrayList<String>());
            AwardHierarchy currentAwardNode = awardHierarchyItems.get(currentAward.getAwardNumber());
            if (currentAwardNode != null && currentAwardNode.isRootNode() && this.isCurrentAwardTheFirstVersion(currentAward)) {
                awardHierarchyService.populateAwardHierarchyNodes(awardHierarchyItems, awardHierarchyNodes, currentAward.getAwardNumber(), currentAward.getSequenceNumber().toString());
                canCancel = !this.doesAwardHierarchyContainFinalChildren(currentAwardNode, awardHierarchyNodes);
            }
        }
        return canCancel;
    }

    @Override
    public boolean canApprove(Document document, Person user) {
        return this.isEnroute(document) && super.canApprove(document, user);
    }

    @Override
    public boolean canDisapprove(Document document, Person user) {
        return this.canApprove(document, user);
    }

    @Override
    public boolean canBlanketApprove(Document document, Person user) {
        if (this.areConditionsMetForBlanketApproval(document, user)) {
            if (this.allowBlanketApproveWhileEnroute()) {
                return this.canEdit(document);
            }
            WorkflowDocument workflowDocument = document.getDocumentHeader().getWorkflowDocument();
            return this.canRoute(document) || workflowDocument.isApprovalRequested();
        }
        return false;
    }

    private boolean allowBlanketApproveWhileEnroute() {
        try {
            if (this.getBlanketApprovalParameter().booleanValue()) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return false;
    }

    private Boolean getBlanketApprovalParameter() {
        return this.getParameterService().getParameterValueAsBoolean("KR-NS", "Document", "ALLOW_ENROUTE_BLANKET_APPROVE_WITHOUT_APPROVAL_REQUEST_IND");
    }

    private boolean areConditionsMetForBlanketApproval(Document document, Person user) {
        return this.isInRightStateToApprove(document) && this.hasPermissionToBlanketApprove(document, user);
    }

    private boolean isInRightStateToApprove(Document document) {
        return !this.isFinal(document) && !this.isProcessed(document) && !this.isCanceled(document) && !((KcTransactionalDocumentBase)document).isViewOnly();
    }

    protected boolean hasPermissionToBlanketApprove(Document document, Person user) {
        WorkflowDocument workflowDocument = document.getDocumentHeader().getWorkflowDocument();
        DocumentRouteHeaderValue routeHeader = this.getRouteHeaderService().getRouteHeader(workflowDocument.getDocumentId());
        return this.getDocumentTypePermissionService().canBlanketApprove(user.getPrincipalId(), routeHeader);
    }

    private RouteHeaderService getRouteHeaderService() {
        return KcServiceLocator.getService(RouteHeaderService.class);
    }

    private DocumentTypePermissionService getDocumentTypePermissionService() {
        return KcServiceLocator.getService(DocumentTypePermissionService.class);
    }

    private boolean canCreateAward(String userId) {
        ApplicationTask task = new ApplicationTask("createAward");
        return this.getTaskAuthorizationService().isAuthorized(userId, task);
    }

    private boolean canExecuteAwardTask(String userId, AwardDocument doc, String taskName) {
        AwardTask task = new AwardTask(taskName, doc.getAward());
        return this.getTaskAuthorizationService().isAuthorized(userId, task);
    }

    protected boolean awardHasHierarchyChildren(Document document) {
        AwardDocument awardDocument = (AwardDocument)document;
        AwardHierarchy hierarchy = this.getAwardHierarchyService().loadAwardHierarchyBranch(awardDocument.getAward().getAwardNumber());
        return hierarchy != null && hierarchy.hasChildren();
    }

    public AwardHierarchyService getAwardHierarchyService() {
        if (this.awardHierarchyService == null) {
            this.awardHierarchyService = KcServiceLocator.getService(AwardHierarchyService.class);
        }
        return this.awardHierarchyService;
    }

    public boolean canSendNoteFyi(Document document, Person user) {
        return false;
    }

    @Override
    public boolean canFyi(Document document, Person user) {
        return this.isProcessed(document) && super.canFyi(document, user);
    }

    @Override
    public boolean canRecall(Document document, Person user) {
        AwardDocument awardDocument = (AwardDocument)document;
        return awardDocument.getDocumentHeader().hasWorkflowDocument() && awardDocument.getDocumentHeader().getWorkflowDocument().isEnroute() && this.getKcAuthorizationService().hasPermission(user.getPrincipalId(), awardDocument, "Recall Document");
    }

    @Override
    public boolean canRoute(Document document, Person user) {
        return this.isInRightStateToApprove(document) && AwardDocumentAuthorizer.getPermissionService().hasPermission(user.getPrincipalId(), "KC-AWARD", AwardPermissionConstants.SUBMIT_AWARD.getAwardPermission());
    }

    @Override
    public boolean canAcknowledge(Document document, Person user) {
        return this.isProcessed(document) && super.canAcknowledge(document, user);
    }

    protected boolean canMaintainAwardAttachments(AwardDocument document, Person user) {
        return this.getKcAuthorizationService().hasPermission(user.getPrincipalId(), document, AwardPermissionConstants.CREATE_AWARD.getAwardPermission()) || this.getKcAuthorizationService().hasPermission(user.getPrincipalId(), document, AwardPermissionConstants.MAINTAIN_AWARD_ATTACHMENTS.getAwardPermission());
    }

    protected boolean canViewAwardAttachments(AwardDocument document, Person user) {
        return this.getKcAuthorizationService().hasPermission(user.getPrincipalId(), document, AwardPermissionConstants.VIEW_AWARD_ATTACHMENTS.getAwardPermission());
    }

    private KcAuthorizationService getKcAuthorizationService() {
        return KcServiceLocator.getService(KcAuthorizationService.class);
    }

    protected boolean isProcessed(Document document) {
        String status = document.getDocumentHeader().getWorkflowDocument().getStatus().getCode();
        return status.equalsIgnoreCase("P");
    }

    protected boolean isCanceled(Document document) {
        String status = document.getDocumentHeader().getWorkflowDocument().getStatus().getCode();
        return status.equalsIgnoreCase("X");
    }

    private boolean canMaintainPersonnelUnits(AwardDocument awardDocument, Person user) {
        return this.getKcAuthorizationService().hasPermission(user.getPrincipalId(), awardDocument, AwardPermissionConstants.MAINTAIN_AWARD_PERSONNEL_UNITS.getAwardPermission());
    }
}

