/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl.krms;

import org.kuali.coeus.common.framework.krms.KrmsEngineExecutionService;
import org.kuali.coeus.common.framework.krms.KrmsRulesContext;
import org.kuali.rice.krms.api.engine.Engine;
import org.kuali.rice.krms.api.engine.EngineResults;
import org.kuali.rice.krms.api.engine.ExecutionFlag;
import org.kuali.rice.krms.api.engine.ExecutionOptions;
import org.kuali.rice.krms.api.engine.Facts;
import org.kuali.rice.krms.api.engine.SelectionCriteria;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Component;

@Component(value="krmsEngineExecutionService")
public class KrmsEngineExecutionServiceImpl
implements KrmsEngineExecutionService {
    @Autowired
    @Qualifier(value="rice.krms.engine")
    private Engine engine;

    @Override
    @Cacheable(cacheResolver="requestLevelCacheResolver", cacheNames={"rules"}, key="'contextQualifiers=' + T(org.kuali.rice.core.api.cache.CacheKeyUtils).mapKey(#p0.contextQualifiers) + '|' + 'agendaQualifiers=' + T(org.kuali.rice.core.api.cache.CacheKeyUtils).mapKey(#p0.agendaQualifiers) + '|' + 'documentNumber=' + #p1.documentNumber")
    public EngineResults execute(SelectionCriteria selectionCriteria, KrmsRulesContext rulesContext, boolean logExecution) {
        ExecutionOptions xOptions = new ExecutionOptions();
        if (logExecution) {
            xOptions.setFlag(ExecutionFlag.LOG_EXECUTION, true);
        }
        Facts.Builder factsBuilder = Facts.Builder.create();
        rulesContext.addFacts(factsBuilder);
        return this.engine.execute(selectionCriteria, factsBuilder.build(), xOptions);
    }
}

