/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.hr.impl;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.PreDestroy;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.hr.impl.ImportError;
import org.kuali.coeus.hr.impl.ImportStatus;
import org.kuali.coeus.hr.impl.ImportStatusService;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.support.JdbcDaoSupport;
import org.springframework.stereotype.Component;

@Component(value="importStatusService")
public class JdbcImportStatusServiceImpl
extends JdbcDaoSupport
implements ImportStatusService {
    private static final Logger LOG = LogManager.getLogger(JdbcImportStatusServiceImpl.class);
    private static final String ORACLE_PRODUCT = "ORACLE";
    private static final String SQL_CREATE_STATUS = "INSERT INTO cx_hrapi_import_status(importId, numRecords, startTime) VALUES (?, ?, ?)";
    private static final String SQL_CREATE_ERROR_MYSQL = "INSERT INTO cx_hrapi_import_errors(importId, recordNum, principalName, exception) VALUES (?, ?, ?, ?)";
    private static final String SQL_CREATE_ERROR_ORACLE = "INSERT INTO cx_hrapi_import_errors(errorId, importId, recordNum, principalName, exception) VALUES (SEQ_CX_HRAPI_ERROR_ID.NEXTVAL, ?, ?, ?, ?)";
    private static final String SQL_UPDATE_STATUS = "UPDATE cx_hrapi_import_status SET status = ?, endTime = ? WHERE importId = ?";
    private static final String SQL_UPDATE_STATUS_DETAIL = "UPDATE cx_hrapi_import_status SET status = ?, detail = ?, endTime = ? WHERE importId = ?";
    private static final String SQL_INCREMENT = "UPDATE cx_hrapi_import_status SET numProcessed = numProcessed + ? WHERE importId = ?";
    private static final String SQL_SELECT_STATUS = "SELECT importId, numRecords, numProcessed, status, detail, startTime, endTime FROM cx_hrapi_import_status WHERE importId = ?";
    private static final String SQL_SELECT_ERRORS = "SELECT errorId, recordNum, principalName, exception FROM cx_hrapi_import_errors WHERE importId = ?";
    private static final String SQL_SELECT_MISSING_IDS = "SELECT personId FROM cx_hrapi_import_persons WHERE importId != ? AND recordStatus != 'INACTIVE' AND personId <> ''";
    private static final String SQL_PERSON_INSERT_UPDATE_MYSQL = "INSERT INTO cx_hrapi_import_persons(personId, importId, recordStatus) VALUES(?, ?, ?) ON DUPLICATE KEY UPDATE importId=?, recordStatus=?";
    private static final String SQL_PERSON_SELECT = "SELECT count(*) from cx_hrapi_import_persons where personId=?";
    private static final String SQL_PERSON_INSERT = "INSERT INTO cx_hrapi_import_persons(personId, importId, recordStatus) VALUES(?, ?, ?)";
    private static final String SQL_PERSON_UPDATE = "update cx_hrapi_import_persons set importId=?, recordStatus=? where personId=?";
    private static final String SQL_SELECT_UNMANAGED_PRINCIPALS = "SELECT prncpl.prncpl_nm FROM cx_hrapi_import_persons persons RIGHT JOIN krim_prncpl_t prncpl ON persons.personId = prncpl.prncpl_nm WHERE persons.personId IS NULL";
    private static final Integer DEFAULT_RECORD_NUMBER = 999999;
    private boolean oracle;
    protected ImportStatusExtractor statusExtractor = new ImportStatusExtractor();
    protected ImportErrorMapper errorMapper = new ImportErrorMapper();
    private final ConcurrentHashMap<String, AtomicInteger> pendingIncrements = new ConcurrentHashMap();
    private int batchSize = 500;

    private AtomicInteger counterFor(String importId) {
        return this.pendingIncrements.computeIfAbsent(importId, k -> new AtomicInteger());
    }

    private void flushDelta(String importId) {
        AtomicInteger counter = this.counterFor(importId);
        int delta = counter.getAndSet(0);
        if (delta <= 0) {
            return;
        }
        try {
            this.getJdbcTemplate().update(SQL_INCREMENT, new Object[]{delta, importId});
        }
        catch (DataAccessException e) {
            counter.addAndGet(delta);
            LOG.warn("flushDelta failed (restored) importId={}, delta={}", (Object)importId, (Object)delta, (Object)e);
            throw e;
        }
    }

    private void incrementProcessedBuffered(String importId) {
        int cur = this.counterFor(importId).incrementAndGet();
        if (cur >= this.batchSize) {
            this.flushDelta(importId);
        }
    }

    private void clearCounter(String importId) {
        this.pendingIncrements.remove(importId);
    }

    @Override
    public ImportStatus getImportStatus(String importId) {
        ImportStatus status = (ImportStatus)this.getJdbcTemplate().query(conn -> {
            PreparedStatement stmt = conn.prepareStatement(SQL_SELECT_STATUS);
            stmt.setString(1, importId);
            return stmt;
        }, (ResultSetExtractor)this.statusExtractor);
        if (status == null) {
            return null;
        }
        List errors = this.getJdbcTemplate().query(conn -> {
            PreparedStatement stmt = conn.prepareStatement(SQL_SELECT_ERRORS);
            stmt.setString(1, importId);
            return stmt;
        }, (RowMapper)this.errorMapper);
        status.setErrors(errors);
        return status;
    }

    @Override
    public ImportStatus initiateImport(String importId, int numRecords) {
        long start = System.currentTimeMillis();
        this.getJdbcTemplate().update(SQL_CREATE_STATUS, new Object[]{importId, numRecords, start});
        ImportStatus status = new ImportStatus(importId, numRecords);
        status.setStartTimeInMillis(start);
        return status;
    }

    protected void updateStatus(ImportStatus.Status status, String importId) {
        this.updateStatus(status, importId, null);
    }

    protected void updateStatus(ImportStatus.Status status, String importId, String detail) {
        this.getJdbcTemplate().update(conn -> {
            PreparedStatement stmt = detail == null ? conn.prepareStatement(SQL_UPDATE_STATUS) : conn.prepareStatement(SQL_UPDATE_STATUS_DETAIL);
            int i = 1;
            stmt.setString(i++, status.toString());
            if (detail != null) {
                stmt.setString(i++, detail);
            }
            stmt.setLong(i++, System.currentTimeMillis());
            stmt.setString(i, importId);
            return stmt;
        });
    }

    @Override
    public void abort(String importId) {
        this.flushDelta(importId);
        this.updateStatus(ImportStatus.Status.ABORTED, importId);
        this.clearCounter(importId);
    }

    @Override
    public void abort(String importId, String detailMessage) {
        this.flushDelta(importId);
        this.updateStatus(ImportStatus.Status.ABORTED, importId, detailMessage);
        this.clearCounter(importId);
    }

    @Override
    public void abnormalTermination(String importId) {
        this.flushDelta(importId);
        this.updateStatus(ImportStatus.Status.ABNORMAL_TERMINATION, importId);
        this.clearCounter(importId);
    }

    @Override
    public void abnormalTermination(String importId, String detailMessage) {
        this.flushDelta(importId);
        this.updateStatus(ImportStatus.Status.ABNORMAL_TERMINATION, importId, detailMessage);
        this.clearCounter(importId);
    }

    @Override
    public void completeImport(String importId) {
        this.flushDelta(importId);
        ImportStatus status = this.getImportStatus(importId);
        if (!ImportStatus.Status.PROCESSING.equals((Object)status.getStatus())) {
            LOG.debug("completeImport called on an import that has already stopped - doing nothing");
            return;
        }
        if (status.getProcessedRecordCount() != status.getRecordTotal()) {
            this.abnormalTermination(importId, "import completed without processing all records");
        } else {
            this.updateStatus(ImportStatus.Status.COMPLETE, importId);
            this.clearCounter(importId);
        }
    }

    protected void updatePersonStatus(String importId, String personId, String status) {
        if (this.isOracle()) {
            Integer count = (Integer)this.getJdbcTemplate().queryForObject(SQL_PERSON_SELECT, Integer.class, new Object[]{personId});
            if (count != null && count > 0) {
                this.getJdbcTemplate().update(SQL_PERSON_UPDATE, new Object[]{importId, status, personId});
            } else {
                this.getJdbcTemplate().update(SQL_PERSON_INSERT, new Object[]{personId, importId, status});
            }
        } else {
            this.getJdbcTemplate().update(SQL_PERSON_INSERT_UPDATE_MYSQL, new Object[]{personId, importId, status, importId, status});
        }
    }

    @Override
    public void recordProcessed(String importId, String personId) {
        this.incrementProcessedBuffered(importId);
        this.updatePersonStatus(importId, personId, "ADDED");
    }

    @Override
    public void recordInactivated(String importId, String personId) {
        this.incrementProcessedBuffered(importId);
        this.updatePersonStatus(importId, personId, "INACTIVE");
    }

    @Override
    public void recordError(String importId, ImportError error) {
        JdbcTemplate tmpl = this.getJdbcTemplate();
        String principalName = error.getPrincipalName();
        this.flushDelta(importId);
        tmpl.execute(conn -> {
            try (PreparedStatement errStmt = conn.prepareStatement(this.isOracle() ? SQL_CREATE_ERROR_ORACLE : SQL_CREATE_ERROR_MYSQL);){
                errStmt.setString(1, importId);
                errStmt.setInt(2, error.getRecordNumber());
                errStmt.setString(3, principalName);
                errStmt.setBlob(4, IOUtils.toInputStream((String)error.getException(), (Charset)StandardCharsets.UTF_8));
                errStmt.executeUpdate();
            }
            return null;
        });
        if (principalName != null && error.getRecordNumber() != DEFAULT_RECORD_NUMBER.intValue()) {
            this.updatePersonStatus(importId, principalName, "ERROR");
        }
    }

    @Override
    public List<String> getActivePrincipalNamesMissingFromImport(String importId) {
        return this.getJdbcTemplate().query(conn -> {
            PreparedStatement stmt = conn.prepareStatement(SQL_SELECT_MISSING_IDS);
            stmt.setString(1, importId);
            return stmt;
        }, (rs, rowNum) -> rs.getString("personId"));
    }

    @Override
    public List<String> getPrincipalNamesUnmanagedByHRImport() {
        return this.getJdbcTemplate().queryForList(SQL_SELECT_UNMANAGED_PRINCIPALS, String.class);
    }

    protected void initDao() throws Exception {
        super.initDao();
        this.oracle = this.getConnection().getMetaData().getDatabaseProductName().toUpperCase().contains(ORACLE_PRODUCT);
    }

    public boolean isOracle() {
        return this.oracle;
    }

    public void setOracle(boolean oracle) {
        this.oracle = oracle;
    }

    @PreDestroy
    public void onShutdown() {
        ((ConcurrentHashMap.KeySetView)this.pendingIncrements.keySet()).forEach(this::flushDelta);
    }

    private static class ImportStatusExtractor
    implements ResultSetExtractor<ImportStatus> {
        private ImportStatusExtractor() {
        }

        public ImportStatus extractData(ResultSet rs) throws SQLException, DataAccessException {
            if (rs.next()) {
                String importId = rs.getString("importId");
                int recordCount = rs.getInt("numRecords");
                ImportStatus status = new ImportStatus(importId, recordCount);
                status.setMessageDetail(rs.getString("detail"));
                status.setStatus(ImportStatus.Status.valueOf(rs.getString("status")));
                status.setStartTimeInMillis(rs.getLong("startTime"));
                status.setEndTimeInMillis(rs.getLong("endTime"));
                status.setProcessed(rs.getInt("numProcessed"));
                return status;
            }
            return null;
        }
    }

    private static class ImportErrorMapper
    implements RowMapper<ImportError> {
        private ImportErrorMapper() {
        }

        public ImportError mapRow(ResultSet rs, int rowNum) throws SQLException {
            int recordNumber = rs.getInt("recordNum");
            String principalName = rs.getString("principalName");
            byte[] buf = rs.getBytes("exception");
            String exception = buf != null ? new String(buf, StandardCharsets.UTF_8) : "";
            return new ImportError(recordNumber, principalName, exception);
        }
    }
}

