/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl.auth.perm;

import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Multimaps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.auth.UnitAuthorizationService;
import org.kuali.coeus.common.framework.auth.docperm.DocumentAccess;
import org.kuali.coeus.common.framework.auth.perm.DocumentLevelPermissionable;
import org.kuali.coeus.common.framework.auth.perm.KcAuthorizationService;
import org.kuali.coeus.common.framework.auth.perm.Permissionable;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PredicateFactory;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.kim.api.permission.PermissionService;
import org.kuali.rice.kim.api.role.Role;
import org.kuali.rice.kim.api.role.RoleService;
import org.kuali.rice.kim.api.type.KimType;
import org.kuali.rice.kim.api.type.KimTypeInfoService;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.PersistenceOption;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="kcAuthorizationService")
public class KcAuthorizationServiceImpl
implements KcAuthorizationService {
    @Autowired
    @Qualifier(value="unitAuthorizationService")
    private UnitAuthorizationService unitAuthorizationService;
    @Autowired
    @Qualifier(value="roleService")
    private RoleService roleManagementService;
    @Autowired
    @Qualifier(value="permissionService")
    private PermissionService permissionService;
    @Autowired
    @Qualifier(value="dataObjectService")
    private DataObjectService dataObjectService;
    @Autowired
    @Qualifier(value="kimTypeInfoService")
    private KimTypeInfoService kimTypeInfoService;

    @Override
    public void addDocumentLevelRole(String userId, String roleName, Permissionable permissionable) {
        if (permissionable instanceof DocumentLevelPermissionable) {
            String updatedRoleName = this.validateDocumentLevelArguments(((DocumentLevelPermissionable)permissionable).getDocumentNumber(), userId, roleName, permissionable.getNamespace());
            if (StringUtils.isNotBlank((CharSequence)updatedRoleName)) {
                this.dataObjectService.save((Object)new DocumentAccess(((DocumentLevelPermissionable)permissionable).getDocumentNumber(), userId, updatedRoleName, permissionable.getNamespace()), new PersistenceOption[0]);
            }
        } else {
            Map<String, String> qualifiedRoleAttributes = this.createStandardQualifiers(permissionable);
            this.roleManagementService.assignPrincipalToRole(userId, permissionable.getNamespace(), roleName, new HashMap<String, String>(qualifiedRoleAttributes));
        }
    }

    @Override
    public void removeDocumentLevelRole(String userId, String roleName, Permissionable permissionable) {
        if (permissionable instanceof DocumentLevelPermissionable) {
            String updatedRoleName = this.validateDocumentLevelArguments(((DocumentLevelPermissionable)permissionable).getDocumentNumber(), userId, roleName, permissionable.getNamespace());
            if (StringUtils.isNotBlank((CharSequence)updatedRoleName)) {
                this.dataObjectService.deleteMatching(DocumentAccess.class, QueryByCriteria.Builder.fromPredicates((Predicate[])new Predicate[]{PredicateFactory.equal((String)"documentNumber", (Object)((DocumentLevelPermissionable)permissionable).getDocumentNumber()), PredicateFactory.equal((String)"principalId", (Object)userId), PredicateFactory.equal((String)"roleName", (Object)updatedRoleName), PredicateFactory.equal((String)"namespaceCode", (Object)permissionable.getNamespace())}));
            }
        } else {
            Map<String, String> qualifiedRoleAttributes = this.createStandardQualifiers(permissionable);
            this.roleManagementService.removePrincipalFromRole(userId, permissionable.getNamespace(), roleName, new HashMap<String, String>(qualifiedRoleAttributes));
        }
    }

    @Override
    public boolean hasDocumentLevelRole(String userId, String roleName, Permissionable permissionable) {
        String updatedRoleName = roleName;
        if (permissionable instanceof DocumentLevelPermissionable) {
            updatedRoleName = this.validateDocumentLevelArguments(((DocumentLevelPermissionable)permissionable).getDocumentNumber(), userId, roleName, permissionable.getNamespace());
        }
        if (StringUtils.isNotBlank((CharSequence)updatedRoleName)) {
            Map<String, String> qualifiedRoleAttributes = this.createStandardQualifiers(permissionable);
            Role role = this.roleManagementService.getRoleByNamespaceCodeAndName(permissionable.getNamespace(), updatedRoleName);
            return role != null && this.roleManagementService.principalHasRole(userId, Collections.singletonList(role.getId()), qualifiedRoleAttributes);
        }
        return false;
    }

    protected String validateDocumentLevelArguments(String documentNumber, String principalId, String roleName, String namespaceCode) {
        if (StringUtils.isBlank((CharSequence)documentNumber)) {
            throw new IllegalArgumentException("documentNumber is blank");
        }
        if (StringUtils.isBlank((CharSequence)principalId)) {
            throw new IllegalArgumentException("principalId is blank");
        }
        return this.validateRoleArguments(roleName, namespaceCode);
    }

    protected String validateRoleArguments(String roleName, String namespaceCode) {
        if (StringUtils.isBlank((CharSequence)roleName)) {
            throw new IllegalArgumentException("roleName is blank");
        }
        if (StringUtils.isBlank((CharSequence)namespaceCode)) {
            throw new IllegalArgumentException("namespaceCode is blank");
        }
        Object modifiedRoleName = !roleName.endsWith(" Document Level") ? roleName + " Document Level" : roleName;
        Role modifiedRole = this.roleManagementService.getRoleByNamespaceCodeAndName(namespaceCode, (String)modifiedRoleName);
        if (modifiedRole == null) {
            Role role = this.roleManagementService.getRoleByNamespaceCodeAndName(namespaceCode, roleName);
            if (role == null) {
                throw new IllegalStateException("role not found with namespace: " + namespaceCode + " and name " + (String)modifiedRoleName + " or name " + roleName);
            }
            KimType type = this.kimTypeInfoService.getKimType(role.getKimTypeId());
            if (!type.getName().equals("Derived Role: Document Access") || !type.getNamespaceCode().equals("KC-SYS")) {
                return null;
            }
            return roleName;
        }
        KimType type = this.kimTypeInfoService.getKimType(modifiedRole.getKimTypeId());
        if (!type.getName().equals("Derived Role: Document Access") || !type.getNamespaceCode().equals("KC-SYS")) {
            return null;
        }
        return modifiedRoleName;
    }

    @Override
    public boolean hasPermission(String userId, Permissionable permissionable, String permissionName) {
        return this.hasPermission(userId, permissionable, permissionable == null ? null : permissionable.getNamespace(), permissionName);
    }

    protected boolean hasPermission(String userId, Permissionable permissionable, String permissionNamespace, String permissionName) {
        boolean userHasPermission = false;
        if (permissionable != null) {
            Map<String, String> qualifiedRoleAttributes = this.createStandardQualifiers(permissionable);
            permissionable.populateAdditionalQualifiedRoleAttributes(qualifiedRoleAttributes);
            String unitNumber = permissionable.getLeadUnitNumber();
            if (StringUtils.isNotEmpty((CharSequence)permissionable.getDocumentNumberForPermission())) {
                userHasPermission = this.permissionService.isAuthorized(userId, permissionNamespace, permissionName, qualifiedRoleAttributes);
            }
            if (!userHasPermission && StringUtils.isNotEmpty((CharSequence)unitNumber)) {
                userHasPermission = this.unitAuthorizationService.hasPermission(userId, unitNumber, permissionNamespace, permissionName);
            }
        }
        return userHasPermission;
    }

    @Override
    public <P extends Permissionable> Collection<P> filterForPermission(String userId, Collection<P> permissionables, String permissionNamespace, String permissionName) {
        HashSet authorizedDocumentNumbers = new HashSet();
        Multimap leadUnitToDocumentNumbersMap = (Multimap)permissionables.stream().filter(permissionable -> permissionable.getLeadUnitNumber() != null).collect(Multimaps.toMultimap(Permissionable::getLeadUnitNumber, Permissionable::getDocumentNumberForPermission, () -> ((MultimapBuilder.ListMultimapBuilder)MultimapBuilder.hashKeys().arrayListValues()).build()));
        leadUnitToDocumentNumbersMap.keySet().forEach(unitNumber -> {
            if (this.unitAuthorizationService.hasPermission(userId, (String)unitNumber, permissionNamespace, permissionName)) {
                authorizedDocumentNumbers.addAll(leadUnitToDocumentNumbersMap.get(unitNumber));
            }
        });
        permissionables.stream().filter(permissionable -> !authorizedDocumentNumbers.contains(permissionable.getDocumentNumberForPermission())).forEach(permissionable -> {
            Map<String, String> qualifiedRoleAttributes = this.createStandardQualifiers((Permissionable)permissionable);
            permissionable.populateAdditionalQualifiedRoleAttributes(qualifiedRoleAttributes);
            if (this.permissionService.isAuthorized(userId, permissionNamespace, permissionName, qualifiedRoleAttributes)) {
                authorizedDocumentNumbers.add(permissionable.getDocumentNumberForPermission());
            }
        });
        return permissionables.stream().filter(permissionable -> authorizedDocumentNumbers.contains(permissionable.getDocumentNumberForPermission())).collect(Collectors.toList());
    }

    @Override
    public List<String> getPrincipalsInRole(String roleName, Permissionable permissionable) {
        String modifiedRoleName;
        HashSet principals = new HashSet();
        if (permissionable != null && StringUtils.isNotBlank((CharSequence)roleName) && StringUtils.isNotBlank((CharSequence)(modifiedRoleName = this.validateRoleArguments(roleName, permissionable.getNamespace())))) {
            principals.addAll(this.roleManagementService.getRoleMemberPrincipalIds(permissionable.getNamespace(), modifiedRoleName, this.createStandardQualifiers(permissionable)));
            if (permissionable instanceof DocumentLevelPermissionable && this.roleManagementService.getRoleByNamespaceCodeAndName(permissionable.getNamespace(), modifiedRoleName) != null) {
                principals.addAll(this.roleManagementService.getRoleMemberPrincipalIds(permissionable.getNamespace(), modifiedRoleName, this.createStandardQualifiers(permissionable)));
            }
        }
        return new ArrayList<String>(principals);
    }

    protected Map<String, String> createStandardQualifiers(Permissionable permissionable) {
        HashMap<String, String> qualifiedRoleAttributes = new HashMap<String, String>();
        qualifiedRoleAttributes.put(permissionable.getDocumentKey(), permissionable.getDocumentNumberForPermission());
        this.addDocumentQualifiers(permissionable, qualifiedRoleAttributes);
        return qualifiedRoleAttributes;
    }

    protected void addDocumentQualifiers(Permissionable permissionable, Map<String, String> qualifiers) {
        if (permissionable instanceof DocumentLevelPermissionable && qualifiers != null) {
            qualifiers.put("documentNumber", ((DocumentLevelPermissionable)permissionable).getDocumentNumber());
        }
    }

    public void setUnitAuthorizationService(UnitAuthorizationService unitAuthorizationService) {
        this.unitAuthorizationService = unitAuthorizationService;
    }

    public void setRoleManagementService(RoleService roleManagementService) {
        this.roleManagementService = roleManagementService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public RoleService getRoleService() {
        return this.roleManagementService;
    }

    public UnitAuthorizationService getUnitAuthorizationService() {
        return this.unitAuthorizationService;
    }

    public RoleService getRoleManagementService() {
        return this.roleManagementService;
    }

    public PermissionService getPermissionService() {
        return this.permissionService;
    }

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    public KimTypeInfoService getKimTypeInfoService() {
        return this.kimTypeInfoService;
    }

    public void setKimTypeInfoService(KimTypeInfoService kimTypeInfoService) {
        this.kimTypeInfoService = kimTypeInfoService;
    }
}

