/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.budget.subaward;

import com.lowagie.text.pdf.PdfReader;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.encryption.InvalidPasswordException;
import org.kuali.coeus.common.framework.ruleengine.KcBusinessRule;
import org.kuali.coeus.common.framework.ruleengine.KcEventMethod;
import org.kuali.coeus.common.framework.ruleengine.KcEventResult;
import org.kuali.coeus.propdev.impl.budget.subaward.BudgetSubAwardsEvent;
import org.kuali.coeus.propdev.impl.s2s.FormUtilityService;
import org.kuali.coeus.sys.api.model.KcFile;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@KcBusinessRule(value="budgetSubAwardsRule")
public class BudgetSubAwardsRule {
    private static final Logger LOG = LogManager.getLogger(BudgetSubAwardsRule.class);
    public static final String SUBAWARD_ORG_NAME_FIELD_NAME = "organizationId";
    @Autowired
    @Qualifier(value="formUtilityService")
    private FormUtilityService formUtilityService;
    @Autowired
    @Qualifier(value="globalVariableService")
    private GlobalVariableService globalVariableService;

    @KcEventMethod
    public KcEventResult processSubaward(BudgetSubAwardsEvent event) {
        KcEventResult result = new KcEventResult();
        result.getMessageMap().addToErrorPath(event.getErrorPath());
        this.verifyAttachment(event, result);
        event.getBudgetSubAwards().setNewSubAwardFileError(result.getSuccess());
        this.verifyOrganizationName(event, result);
        return result;
    }

    protected void verifyOrganizationName(BudgetSubAwardsEvent event, KcEventResult result) {
        if (StringUtils.isBlank((CharSequence)event.getBudgetSubAwards().getOrganizationId())) {
            result.getMessageMap().putError(SUBAWARD_ORG_NAME_FIELD_NAME, "newSubAward.organizationName.required", new String[0]);
            result.setSuccess(false);
        } else if (event.getBudgetSubAwards().getOrganization() == null) {
            result.getMessageMap().putError(SUBAWARD_ORG_NAME_FIELD_NAME, "newSubAward.organizationName.invalid", new String[0]);
            result.setSuccess(false);
        }
    }

    protected void verifyAttachment(BudgetSubAwardsEvent event, KcEventResult result) {
        if (event.getBudgetSubAwards().getNewSubAwardFile() != null) {
            try {
                byte[] subAwardData = event.getBudgetSubAwards().getNewSubAwardFile().getBytes();
                String contentType = event.getBudgetSubAwards().getNewSubAwardFile().getContentType();
                if (ArrayUtils.isEmpty((byte[])subAwardData) || !contentType.equals("application/pdf")) {
                    result.getMessageMap().putError("newSubAwardFile", "newSubAward.subAwardFile.required", new String[0]);
                    result.setSuccess(false);
                } else if (this.isEncryptedFile(subAwardData)) {
                    result.getMessageMap().putError("newSubAwardFile", "newSubAward.subAwardFile.encrypted", new String[0]);
                    result.setSuccess(false);
                }
            }
            catch (IOException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                result.getMessageMap().putError("newSubAwardFile", "newSubAward.subAwardFile.required", new String[0]);
                result.setSuccess(false);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isEncryptedFile(byte[] data) throws IOException {
        try (PDDocument pdd = Loader.loadPDF((byte[])data);){
            if (pdd.isEncrypted()) {
                boolean bl = true;
                return bl;
            }
            PdfReader reader = new PdfReader(data);
            List<KcFile> attachments = this.getFormUtilityService().extractAttachments(reader);
            for (KcFile file : attachments) {
                if (!this.isEncryptedFile(file.getData())) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (InvalidPasswordException ipe) {
            return true;
        }
    }

    public FormUtilityService getFormUtilityService() {
        return this.formUtilityService;
    }

    public void setFormUtilityService(FormUtilityService formUtilityService) {
        this.formUtilityService = formUtilityService;
    }

    public GlobalVariableService getGlobalVariableService() {
        return this.globalVariableService;
    }

    public void setGlobalVariableService(GlobalVariableService globalVariableService) {
        this.globalVariableService = globalVariableService;
    }
}

