/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.coi.framework;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.coi.framework.Project;
import org.kuali.coeus.coi.framework.ProjectPerson;
import org.kuali.coeus.coi.framework.ProjectRetrievalService;
import org.kuali.coeus.coi.framework.ProjectSponsor;
import org.kuali.coeus.sys.framework.util.CollectionUtils;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.JdbcOperations;

public abstract class AbstractProjectRetrievalService
implements ProjectRetrievalService {
    protected static final String SOURCE_UNIQUE_IDENTIFIER_METADATA = "sourceUniqueIdentifier";
    @Autowired
    @Qualifier(value="jdbcOperations")
    private JdbcOperations jdbcOperations;
    @Autowired
    @Qualifier(value="kualiConfigurationService")
    private ConfigurationService configurationService;

    @Override
    public Collection<Project> retrieveProjects() {
        Map<String, Project> projects = this.getProjectsMap();
        if (!projects.isEmpty()) {
            Map<String, List<ProjectPerson>> persons = this.getPersonsMap();
            persons.forEach((k, v) -> ((Project)projects.get(k)).setPersons((List<ProjectPerson>)v));
        }
        return projects.values();
    }

    protected Map<String, Project> getProjectsMap() {
        return this.jdbcOperations.query(c -> c.prepareStatement(this.allProjectQuery()), (rs, rowNum) -> {
            Project project = this.toProject(rs);
            return CollectionUtils.entry(project.getSourceIdentifier(), project);
        }).stream().collect(CollectionUtils.entriesToMap());
    }

    protected Map<String, List<ProjectPerson>> getPersonsMap() {
        return this.jdbcOperations.query(c -> c.prepareStatement(this.allProjectPersonQuery()), (rs, rowNum) -> this.toProjectPerson(rs)).stream().collect(Collectors.groupingBy(ProjectPerson::getSourceIdentifier));
    }

    @Override
    public Project retrieveProject(String sourceIdentifier) {
        if (StringUtils.isBlank((CharSequence)sourceIdentifier)) {
            throw new IllegalArgumentException("sourceIdentifier is blank");
        }
        Project project = (Project)this.jdbcOperations.query(c -> {
            PreparedStatement statement = c.prepareStatement(this.projectQuery());
            statement.setString(1, sourceIdentifier);
            return statement;
        }, rs -> rs.next() ? this.toProject(rs) : null);
        if (project != null) {
            List persons = this.jdbcOperations.query(c -> {
                PreparedStatement statement = c.prepareStatement(this.projectPersonQuery());
                statement.setString(1, sourceIdentifier);
                return statement;
            }, (rs, rowNum) -> this.toProjectPerson(rs));
            project.setPersons(persons);
        }
        return project;
    }

    public String getBaseShortUrl() {
        return this.getConfigurationService().getPropertyValueAsString("application.url");
    }

    protected void setSponsorFields(List<ProjectSponsor> sponsors, Project project) {
        sponsors.stream().findFirst().ifPresent(sponsor -> {
            project.setSponsorCode(sponsor.getSponsorCode());
            project.setSponsorName(sponsor.getSponsorName());
        });
        project.setSponsors(sponsors);
    }

    protected abstract Project toProject(ResultSet var1) throws SQLException;

    protected abstract ProjectPerson toProjectPerson(ResultSet var1) throws SQLException;

    protected abstract String allProjectQuery();

    protected abstract String allProjectPersonQuery();

    protected abstract String projectQuery();

    protected abstract String projectPersonQuery();

    public JdbcOperations getJdbcOperations() {
        return this.jdbcOperations;
    }

    public void setJdbcOperations(JdbcOperations jdbcOperations) {
        this.jdbcOperations = jdbcOperations;
    }

    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }
}

