/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.budget.framework.nonpersonnel;

import java.sql.Date;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.budget.api.nonpersonnel.BudgetLineItemContract;
import org.kuali.coeus.common.budget.framework.core.Budget;
import org.kuali.coeus.common.budget.framework.core.CostElement;
import org.kuali.coeus.common.budget.framework.core.category.BudgetCategory;
import org.kuali.coeus.common.budget.framework.nonpersonnel.AbstractBudgetCalculatedAmount;
import org.kuali.coeus.common.budget.framework.nonpersonnel.BudgetFormulatedCostDetail;
import org.kuali.coeus.common.budget.framework.nonpersonnel.BudgetLineItemBase;
import org.kuali.coeus.common.budget.framework.nonpersonnel.BudgetLineItemCalculatedAmount;
import org.kuali.coeus.common.budget.framework.nonpersonnel.BudgetRateAndBase;
import org.kuali.coeus.common.budget.framework.period.BudgetPeriod;
import org.kuali.coeus.common.budget.framework.personnel.BudgetPersonnelDetails;
import org.kuali.coeus.propdev.impl.budget.subaward.BudgetSubAwards;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.coeus.propdev.impl.hierarchy.HierarchyMaintainable;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.coeus.sys.framework.persistence.BooleanNFConverter;
import org.kuali.coeus.sys.framework.persistence.ScaleTwoDecimalConverter;
import org.kuali.rice.krad.data.jpa.PortableSequenceGenerator;
import org.kuali.rice.krad.data.jpa.converters.BooleanYNConverter;
import org.kuali.rice.krad.util.ObjectUtils;

@Entity
@Table(name="BUDGET_DETAILS")
public class BudgetLineItem
extends BudgetLineItemBase
implements HierarchyMaintainable,
Comparable<BudgetLineItem>,
BudgetLineItemContract {
    @Column(name="COST_SHARING_AMOUNT")
    private ScaleTwoDecimal costSharingAmount = ScaleTwoDecimal.ZERO;
    @Column(name="BUDGET_DETAILS_ID")
    @Id
    @PortableSequenceGenerator(name="SEQ_BUDGET_DETAILS_ID")
    @GeneratedValue(generator="SEQ_BUDGET_DETAILS_ID")
    private Long budgetLineItemId;
    @Column(name="BUDGET_PERIOD_NUMBER", insertable=false, updatable=false)
    private Long budgetPeriodId;
    @Column(name="LINE_ITEM_NUMBER")
    private Integer lineItemNumber;
    @Column(name="BUDGET_ID", insertable=false, updatable=false)
    private Long budgetId;
    @Column(name="BUDGET_PERIOD")
    private Integer budgetPeriod;
    @Column(name="APPLY_IN_RATE_FLAG")
    @Convert(converter=BooleanYNConverter.class)
    private Boolean applyInRateFlag;
    @Column(name="BASED_ON_LINE_ITEM")
    private Integer basedOnLineItem;
    @Column(name="BUDGET_CATEGORY_CODE")
    private String budgetCategoryCode;
    @Column(name="BUDGET_JUSTIFICATION")
    @Lob
    private String budgetJustification;
    @Column(name="COST_ELEMENT")
    private String costElement;
    @Column(name="GROUP_NAME")
    private String groupName;
    @Transient
    private ScaleTwoDecimal totalCostSharingAmount;
    @Column(name="END_DATE")
    private Date endDate;
    @Column(name="LINE_ITEM_COST")
    private ScaleTwoDecimal lineItemCost = ScaleTwoDecimal.ZERO;
    @Column(name="LINE_ITEM_DESCRIPTION")
    private String lineItemDescription;
    @Column(name="LINE_ITEM_SEQUENCE")
    private Integer lineItemSequence;
    @Column(name="ON_OFF_CAMPUS_FLAG")
    @Convert(converter=BooleanNFConverter.class)
    private Boolean onOffCampusFlag;
    @Column(name="QUANTITY")
    private Integer quantity;
    @Column(name="START_DATE")
    private Date startDate;
    @Column(name="UNDERRECOVERY_AMOUNT")
    @Convert(converter=ScaleTwoDecimalConverter.class)
    private ScaleTwoDecimal underrecoveryAmount = ScaleTwoDecimal.ZERO;
    @Column(name="SUBMIT_COST_SHARING")
    @Convert(converter=BooleanYNConverter.class)
    private Boolean submitCostSharingFlag = Boolean.TRUE;
    @Column(name="IS_FORMULATED_COST_ELELMENT")
    private Boolean formulatedCostElementFlag;
    @OneToMany(mappedBy="budgetLineItem", orphanRemoval=true, cascade={CascadeType.ALL})
    private List<BudgetLineItemCalculatedAmount> budgetLineItemCalculatedAmounts;
    @OneToMany(mappedBy="budgetLineItem", orphanRemoval=true, cascade={CascadeType.ALL})
    private List<BudgetPersonnelDetails> budgetPersonnelDetailsList = new ArrayList<BudgetPersonnelDetails>();
    @Column(name="SUBAWARD_NUMBER", insertable=false, updatable=false)
    private Integer subAwardNumber;
    @ManyToOne(cascade={CascadeType.REFRESH})
    @JoinColumns(value={@JoinColumn(name="BUDGET_ID", referencedColumnName="BUDGET_ID", insertable=false, updatable=false), @JoinColumn(name="SUBAWARD_NUMBER", referencedColumnName="SUB_AWARD_NUMBER")})
    private BudgetSubAwards budgetSubAward;
    @Column(name="HIERARCHY_PROPOSAL_NUMBER")
    private String hierarchyProposalNumber;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.REFRESH})
    @JoinColumn(name="HIERARCHY_PROPOSAL_NUMBER", referencedColumnName="PROPOSAL_NUMBER", insertable=false, updatable=false)
    private DevelopmentProposal hierarchyProposal;
    @Column(name="HIDE_IN_HIERARCHY")
    @Convert(converter=BooleanYNConverter.class)
    private boolean hiddenInHierarchy;
    @OneToMany(mappedBy="budgetLineItem", orphanRemoval=true, cascade={CascadeType.ALL})
    private List<BudgetRateAndBase> budgetRateAndBaseList;
    @OneToMany(mappedBy="budgetLineItem", orphanRemoval=true, cascade={CascadeType.ALL})
    private List<BudgetFormulatedCostDetail> budgetFormulatedCosts;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.REFRESH})
    @JoinColumn(name="BUDGET_CATEGORY_CODE", referencedColumnName="BUDGET_CATEGORY_CODE", insertable=false, updatable=false)
    private BudgetCategory budgetCategory;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.REFRESH})
    @JoinColumn(name="COST_ELEMENT", referencedColumnName="COST_ELEMENT", insertable=false, updatable=false)
    private CostElement costElementBO;
    @ManyToOne(cascade={CascadeType.REFRESH})
    @JoinColumn(name="BUDGET_ID", referencedColumnName="BUDGET_ID")
    private Budget budget;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.REFRESH})
    @JoinColumn(name="BUDGET_PERIOD_NUMBER", referencedColumnName="BUDGET_PERIOD_NUMBER")
    private BudgetPeriod budgetPeriodBO;
    @Transient
    private transient boolean displayTotalDetail = false;
    @Transient
    private transient ScaleTwoDecimal objectTotal;
    @Transient
    private boolean budgetPersonnelLineItemDeleted;
    @Transient
    private Date oldStartDate;
    @Transient
    private Date oldEndDate;

    public BudgetLineItem() {
        this.budgetLineItemCalculatedAmounts = new ArrayList<BudgetLineItemCalculatedAmount>();
        this.budgetRateAndBaseList = new ArrayList<BudgetRateAndBase>();
        this.objectTotal = ScaleTwoDecimal.ZERO;
        this.budgetFormulatedCosts = new ArrayList<BudgetFormulatedCostDetail>();
    }

    public Long getBudgetLineItemId() {
        return this.budgetLineItemId;
    }

    public void setBudgetLineItemId(Long budgetLineItemId) {
        this.budgetLineItemId = budgetLineItemId;
    }

    @Override
    public Long getBudgetPeriodId() {
        return this.budgetPeriodId;
    }

    @Override
    public void setBudgetPeriodId(Long budgetPeriodId) {
        this.budgetPeriodId = budgetPeriodId;
    }

    @Override
    public Integer getLineItemNumber() {
        return this.lineItemNumber;
    }

    @Override
    public void setLineItemNumber(Integer lineItemNumber) {
        this.lineItemNumber = lineItemNumber;
    }

    @Override
    public Integer getBudgetPeriod() {
        return this.budgetPeriod;
    }

    @Override
    public void setBudgetPeriod(Integer budgetPeriod) {
        this.budgetPeriod = budgetPeriod;
    }

    @Override
    public Boolean getApplyInRateFlag() {
        return this.applyInRateFlag;
    }

    @Override
    public void setApplyInRateFlag(Boolean applyInRateFlag) {
        this.applyInRateFlag = applyInRateFlag;
    }

    @Override
    public Integer getBasedOnLineItem() {
        return this.basedOnLineItem;
    }

    @Override
    public void setBasedOnLineItem(Integer basedOnLineItem) {
        this.basedOnLineItem = basedOnLineItem;
    }

    @Override
    public String getBudgetCategoryCode() {
        return this.budgetCategoryCode;
    }

    @Override
    public void setBudgetCategoryCode(String budgetCategoryCode) {
        this.budgetCategoryCode = budgetCategoryCode;
    }

    @Override
    public String getBudgetJustification() {
        return this.budgetJustification;
    }

    @Override
    public void setBudgetJustification(String budgetJustification) {
        this.budgetJustification = budgetJustification;
    }

    @Override
    public String getCostElement() {
        return this.costElement;
    }

    @Override
    public void setCostElement(String costElement) {
        this.costElement = costElement;
    }

    @Override
    public String getGroupName() {
        return this.groupName;
    }

    @Override
    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    @Override
    public Date getEndDate() {
        return this.endDate;
    }

    @Override
    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    @Override
    public String getLineItemDescription() {
        return this.lineItemDescription;
    }

    @Override
    public void setLineItemDescription(String lineItemDescription) {
        this.lineItemDescription = lineItemDescription;
    }

    @Override
    public Integer getLineItemSequence() {
        return this.lineItemSequence;
    }

    @Override
    public void setLineItemSequence(Integer lineItemSequence) {
        this.lineItemSequence = lineItemSequence;
    }

    @Override
    public Boolean getOnOffCampusFlag() {
        return this.onOffCampusFlag;
    }

    @Override
    public void setOnOffCampusFlag(Boolean onOffCampusFlag) {
        this.onOffCampusFlag = onOffCampusFlag;
    }

    @Override
    public Integer getQuantity() {
        return this.quantity;
    }

    @Override
    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    @Override
    public Date getStartDate() {
        return this.startDate;
    }

    @Override
    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    @Override
    public List<BudgetFormulatedCostDetail> getBudgetFormulatedCosts() {
        return this.budgetFormulatedCosts;
    }

    @Override
    public void setBudgetFormulatedCosts(List<BudgetFormulatedCostDetail> budgetFormulatedCosts) {
        this.budgetFormulatedCosts = budgetFormulatedCosts;
    }

    @Override
    public BudgetCategory getBudgetCategory() {
        return this.budgetCategory;
    }

    @Override
    public void setBudgetCategory(BudgetCategory budgetCategory) {
        this.budgetCategory = budgetCategory;
    }

    @Override
    public CostElement getCostElementBO() {
        return this.costElementBO;
    }

    @Override
    public void setCostElementBO(CostElement costElementBO) {
        this.costElementBO = costElementBO;
    }

    @Override
    public BudgetPeriod getBudgetPeriodBO() {
        if (this.budgetPeriodId != null && ObjectUtils.isNull((Object)this.budgetPeriodBO)) {
            this.refreshReferenceObject("budgetPeriodBO");
        }
        return this.budgetPeriodBO;
    }

    @Override
    public void setBudgetPeriodBO(BudgetPeriod budgetPeriodBO) {
        this.budgetPeriodBO = budgetPeriodBO;
    }

    @Override
    public Long getBudgetId() {
        return this.budgetId;
    }

    @Override
    public void setBudgetId(Long budgetId) {
        this.budgetId = budgetId;
    }

    public List<BudgetPersonnelDetails> getBudgetPersonnelDetailsList() {
        return this.budgetPersonnelDetailsList;
    }

    public void setBudgetPersonnelDetailsList(List<BudgetPersonnelDetails> budgetPersonnelDetailsList) {
        this.budgetPersonnelDetailsList = budgetPersonnelDetailsList;
    }

    public BudgetPersonnelDetails getBudgetPersonnelDetails(int index) {
        while (this.getBudgetPersonnelDetailsList().size() <= index) {
            this.getBudgetPersonnelDetailsList().add(this.getNewBudgetPersonnelLineItem());
        }
        return this.getBudgetPersonnelDetailsList().get(index);
    }

    public BudgetPersonnelDetails getNewBudgetPersonnelLineItem() {
        return new BudgetPersonnelDetails();
    }

    public List<BudgetLineItemCalculatedAmount> getBudgetLineItemCalculatedAmounts() {
        return this.budgetLineItemCalculatedAmounts;
    }

    public void setBudgetLineItemCalculatedAmounts(List<BudgetLineItemCalculatedAmount> budgetLineItemCalculatedAmounts) {
        this.budgetLineItemCalculatedAmounts = budgetLineItemCalculatedAmounts;
    }

    @Override
    public List<BudgetLineItemCalculatedAmount> getBudgetCalculatedAmounts() {
        return this.getBudgetLineItemCalculatedAmounts();
    }

    public boolean isBudgetPersonnelLineItemDeleted() {
        return this.budgetPersonnelLineItemDeleted;
    }

    public void setBudgetPersonnelLineItemDeleted(boolean budgetPersonnelLineItemDeleted) {
        this.budgetPersonnelLineItemDeleted = budgetPersonnelLineItemDeleted;
    }

    public List<BudgetRateAndBase> getBudgetRateAndBaseList() {
        return this.budgetRateAndBaseList;
    }

    public void setBudgetRateAndBaseList(List<BudgetRateAndBase> budgetRateAndBaseList) {
        this.budgetRateAndBaseList = budgetRateAndBaseList;
    }

    public Date getOldStartDate() {
        return this.oldStartDate;
    }

    public void setOldStartDate(Date oldStartDate) {
        this.oldStartDate = oldStartDate;
    }

    public Date getOldEndDate() {
        return this.oldEndDate;
    }

    public void setOldEndDate(Date oldEndDate) {
        this.oldEndDate = oldEndDate;
    }

    @Override
    public void setHierarchyProposalNumber(String hierarchyProposalNumber) {
        this.hierarchyProposalNumber = hierarchyProposalNumber;
    }

    public String getHierarchyProposalNumber() {
        return this.hierarchyProposalNumber;
    }

    public boolean isHiddenInHierarchy() {
        return this.hiddenInHierarchy;
    }

    @Override
    public void setHiddenInHierarchy(boolean hiddenInHierarchy) {
        this.hiddenInHierarchy = hiddenInHierarchy;
    }

    public boolean isDisplayTotalDetail() {
        return this.displayTotalDetail;
    }

    public void setDisplayTotalDetail(boolean displayTotalDetail) {
        this.displayTotalDetail = displayTotalDetail;
    }

    public ScaleTwoDecimal getObjectTotal() {
        return this.objectTotal;
    }

    public void setObjectTotal(ScaleTwoDecimal objectTotal) {
        this.objectTotal = objectTotal;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getLineItemNumber() == null ? 0 : this.getLineItemNumber().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BudgetLineItem other = (BudgetLineItem)obj;
        if (this.getLineItemNumber() == null ? other.getLineItemNumber() != null : !this.getLineItemNumber().equals(other.getLineItemNumber())) {
            return false;
        }
        return !(this.getCostElement() == null ? other.getCostElement() != null : !this.getCostElement().equals(other.getCostElement()));
    }

    public AbstractBudgetCalculatedAmount getNewBudgetLineItemCalculatedAmount() {
        return new BudgetLineItemCalculatedAmount();
    }

    @Override
    public int compareTo(BudgetLineItem o) {
        int compare = this.getCostElementName().compareTo(o.getCostElementName());
        if (compare == 0) {
            compare = this.getLineItemNumber().compareTo(o.getLineItemNumber());
        }
        return compare;
    }

    public boolean isSubAwardLineItem() {
        return this.getBudgetSubAward() != null;
    }

    public Integer getSubAwardNumber() {
        return this.subAwardNumber;
    }

    public void setSubAwardNumber(Integer subAwardNumber) {
        this.subAwardNumber = subAwardNumber;
    }

    @Override
    public ScaleTwoDecimal getCostSharingAmount() {
        return ScaleTwoDecimal.returnZeroIfNull((ScaleTwoDecimal)this.costSharingAmount);
    }

    @Override
    public void setCostSharingAmount(ScaleTwoDecimal costSharingAmount) {
        this.costSharingAmount = costSharingAmount;
    }

    @Override
    public ScaleTwoDecimal getLineItemCost() {
        return ScaleTwoDecimal.returnZeroIfNull((ScaleTwoDecimal)this.lineItemCost);
    }

    @Override
    public void setLineItemCost(ScaleTwoDecimal lineItemCost) {
        this.lineItemCost = lineItemCost;
    }

    @Override
    public ScaleTwoDecimal getUnderrecoveryAmount() {
        return ScaleTwoDecimal.returnZeroIfNull((ScaleTwoDecimal)this.underrecoveryAmount);
    }

    @Override
    public void setUnderrecoveryAmount(ScaleTwoDecimal underrecoveryAmount) {
        this.underrecoveryAmount = underrecoveryAmount;
    }

    @Override
    public ScaleTwoDecimal getTotalCostSharingAmount() {
        return ScaleTwoDecimal.returnZeroIfNull((ScaleTwoDecimal)this.totalCostSharingAmount);
    }

    @Override
    public void setTotalCostSharingAmount(ScaleTwoDecimal totalCostSharingAmount) {
        this.totalCostSharingAmount = totalCostSharingAmount;
    }

    @Override
    public void setSubmitCostSharingFlag(Boolean submitCostSharingFlag) {
        this.submitCostSharingFlag = submitCostSharingFlag;
    }

    @Override
    public Boolean getSubmitCostSharingFlag() {
        if (this.getBudget() != null) {
            return this.getBudget().getSubmitCostSharingFlag() != false ? this.submitCostSharingFlag : false;
        }
        return this.getBudgetPeriodBO() != null && this.getBudgetPeriodBO().getBudget().getSubmitCostSharingFlag() != false ? this.submitCostSharingFlag : false;
    }

    @Override
    public Boolean getFormulatedCostElementFlag() {
        return this.formulatedCostElementFlag == null ? Boolean.FALSE : this.formulatedCostElementFlag;
    }

    @Override
    public void setFormulatedCostElementFlag(Boolean formulatedCostElementFlag) {
        this.formulatedCostElementFlag = formulatedCostElementFlag;
    }

    public String getLineItemGroupDescription() {
        StringBuilder personDetailGroup = new StringBuilder();
        personDetailGroup.append(this.getCostElementBO().getDescription());
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.getGroupName()})) {
            personDetailGroup.append(" (");
            personDetailGroup.append(this.getGroupName());
            personDetailGroup.append(")");
        }
        return personDetailGroup.toString();
    }

    public Budget getBudget() {
        return this.budget;
    }

    public void setBudget(Budget budget) {
        this.budget = budget;
        this.budgetId = budget != null ? budget.getBudgetId() : null;
    }

    public boolean isPersonnelLineItem() {
        return this.getBudgetPersonnelDetailsList().size() > 0;
    }

    public BudgetSubAwards getBudgetSubAward() {
        return this.budgetSubAward;
    }

    public void setBudgetSubAward(BudgetSubAwards budgetSubAward) {
        this.budgetSubAward = budgetSubAward;
        if (budgetSubAward != null) {
            this.subAwardNumber = budgetSubAward.getSubAwardNumber();
            this.setBudget(budgetSubAward.getBudget());
        }
    }

    public DevelopmentProposal getHierarchyProposal() {
        return this.hierarchyProposal;
    }

    public void setHierarchyProposal(DevelopmentProposal hierarchyProposal) {
        this.hierarchyProposal = hierarchyProposal;
    }
}

