/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.framework.country;

import java.util.ArrayList;
import java.util.List;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.krad.uif.control.UifKeyValuesFinderBase;
import org.kuali.rice.location.api.country.Country;
import org.kuali.rice.location.api.country.CountryService;

public class CountryCodeValuesFinder
extends UifKeyValuesFinderBase {
    private CountryService countryService;

    public List<KeyValue> getKeyValues() {
        List countries = this.getCountryService().findAllCountries();
        Country defaultCountry = this.getCountryService().getDefaultCountry();
        ArrayList<KeyValue> keyValues = new ArrayList<KeyValue>();
        if (defaultCountry != null) {
            keyValues.add((KeyValue)new ConcreteKeyValue(defaultCountry.getAlternateCode(), defaultCountry.getName()));
        }
        for (Country country : countries) {
            keyValues.add((KeyValue)new ConcreteKeyValue(country.getAlternateCode(), country.getName()));
        }
        return keyValues;
    }

    public CountryService getCountryService() {
        if (this.countryService == null) {
            this.countryService = KcServiceLocator.getService(CountryService.class);
        }
        return this.countryService;
    }

    public void setCountryService(CountryService countryService) {
        this.countryService = countryService;
    }
}

