/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.elasticsearch.serializers;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.kuali.coeus.elasticsearch.GrantsSearchDocument;
import org.kuali.coeus.elasticsearch.serializers.ElasticsearchDocumentSerializer;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.kra.award.contacts.AwardPersonBoLite;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.fundingproposal.AwardFundingProposal;
import org.kuali.kra.award.infrastructure.AwardPermissionConstants;
import org.kuali.kra.institutionalproposal.proposaladmindetails.ProposalAdminDetails;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.springframework.beans.factory.annotation.Autowire;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Configurable;
import org.springframework.beans.factory.annotation.Qualifier;

@Configurable(autowire=Autowire.BY_TYPE)
public class ElasticsearchAwardSerializer
extends ElasticsearchDocumentSerializer {
    @Autowired
    @Qualifier(value="businessObjectService")
    private BusinessObjectService businessObjectService;

    @Override
    public GrantsSearchDocument translateDocument(Object doc) {
        AwardDocument document = (AwardDocument)doc;
        Award award = document.getAward();
        GrantsSearchDocument esDoc = new GrantsSearchDocument();
        this.setGenericDocumentFields(esDoc, (Document)document);
        esDoc.setPrimaryKey(String.valueOf(award.getAwardId()));
        esDoc.setModuleIdentifier(award.getAwardNumber());
        esDoc.setSequenceNumber(award.getSequenceNumber());
        esDoc.setTypeCode(String.valueOf(award.getAwardTypeCode()));
        esDoc.setTypeDescription(award.getAwardType().getDescription());
        esDoc.setTitle(award.getTitle());
        esDoc.setSponsorCode(award.getSponsorCode());
        esDoc.setSponsorName(award.getSponsorName());
        esDoc.setLeadUnitNumber(document.getLeadUnitNumber());
        esDoc.setLeadUnitName(award.getLeadUnitName());
        this.setAwardPersonFields(esDoc, award);
        this.setPdSpecificFields(esDoc, this.getProposalsForAward(award));
        return esDoc;
    }

    protected void setAwardPersonFields(GrantsSearchDocument esDoc, Award award) {
        Map<String, Long> personnelCriteria = Collections.singletonMap("awardId", award.getAwardId());
        Collection projectPersons = this.businessObjectService.findMatching(AwardPersonBoLite.class, personnelCriteria);
        esDoc.setPersonIds(projectPersons.stream().map(AwardPersonBoLite::getPersonId).filter(Objects::nonNull).collect(Collectors.toList()));
        esDoc.setRolodexIds(projectPersons.stream().map(AwardPersonBoLite::getRolodexId).filter(Objects::nonNull).collect(Collectors.toList()));
        esDoc.setPersonnelNames(projectPersons.stream().map(AwardPersonBoLite::getFullName).collect(Collectors.toList()));
        projectPersons.stream().filter(AwardPersonBoLite::isPrincipalInvestigator).findFirst().map(AwardPersonBoLite::getFullName).ifPresent(esDoc::setPrincipalInvestigatorName);
    }

    protected Collection<DevelopmentProposal> getProposalsForAward(Award award) {
        Map fundingProposalCriteria;
        List proposalNumbers;
        if (CollectionUtils.isNotEmpty(award.getFundingProposals()) && !(proposalNumbers = this.businessObjectService.findMatching(ProposalAdminDetails.class, fundingProposalCriteria = Collections.singletonMap("instProposalId", award.getFundingProposals().stream().map(AwardFundingProposal::getProposalId).collect(Collectors.toList()))).stream().map(ProposalAdminDetails::getDevProposalNumber).collect(Collectors.toList())).isEmpty()) {
            return this.dataObjectService.findMatching(DevelopmentProposal.class, QueryByCriteria.Builder.forAttribute((String)"proposalNumber", proposalNumbers).build()).getResults();
        }
        return Collections.emptyList();
    }

    @Override
    public Set<String> getViewPermissions() {
        return Set.of(AwardPermissionConstants.VIEW_AWARD.getAwardPermission());
    }

    @Override
    public boolean supports(Object document) {
        return document instanceof AwardDocument;
    }
}

