/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.elasticsearch.serializers;

import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.kuali.coeus.elasticsearch.GrantsSearchDocument;
import org.kuali.coeus.elasticsearch.serializers.ElasticsearchDocumentSerializer;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocument;
import org.kuali.coeus.propdev.impl.person.ProposalPerson;
import org.kuali.rice.krad.document.Document;

public class ElasticsearchDevelopmentProposalSerializer
extends ElasticsearchDocumentSerializer {
    @Override
    public GrantsSearchDocument translateDocument(Object doc) {
        ProposalDevelopmentDocument document = (ProposalDevelopmentDocument)doc;
        DevelopmentProposal devProposal = document.getDevelopmentProposal();
        GrantsSearchDocument esDoc = new GrantsSearchDocument();
        this.setGenericDocumentFields(esDoc, (Document)document);
        esDoc.setPrimaryKey(devProposal.getProposalNumber());
        esDoc.setModuleIdentifier(devProposal.getProposalNumber());
        esDoc.setSequenceNumber(0);
        esDoc.setTypeCode(devProposal.getProposalTypeCode());
        esDoc.setTypeDescription(devProposal.getProposalType().getDescription());
        esDoc.setTitle(devProposal.getTitle());
        esDoc.setPersonIds(devProposal.getProposalPersons().stream().map(ProposalPerson::getPersonId).filter(Objects::nonNull).collect(Collectors.toList()));
        esDoc.setRolodexIds(devProposal.getProposalPersons().stream().map(ProposalPerson::getRolodexId).filter(Objects::nonNull).collect(Collectors.toList()));
        esDoc.setPersonnelNames(devProposal.getProposalPersons().stream().map(ProposalPerson::getFullName).collect(Collectors.toList()));
        esDoc.setPrincipalInvestigatorName(devProposal.getPrincipalInvestigatorName());
        esDoc.setSponsorCode(devProposal.getSponsorCode());
        esDoc.setSponsorName(devProposal.getSponsorName());
        esDoc.setLeadUnitNumber(document.getLeadUnitNumber());
        esDoc.setLeadUnitName(devProposal.getOwnedByUnitName());
        this.setPdSpecificFields(esDoc, devProposal);
        return esDoc;
    }

    @Override
    public Set<String> getViewPermissions() {
        return Set.of("View Proposal");
    }

    @Override
    public boolean supports(Object document) {
        return document instanceof ProposalDevelopmentDocument;
    }
}

