/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.elasticsearch.serializers;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.elasticsearch.GrantsSearchDocument;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.coeus.propdev.impl.sponsor.ProposalCfda;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PredicateFactory;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.kew.actionrequest.ActionRequestValue;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.action.RecipientType;
import org.kuali.rice.kew.api.document.DocumentStatus;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.group.GroupService;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.document.Document;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public abstract class ElasticsearchDocumentSerializer {
    @Autowired
    @Qualifier(value="dataObjectService")
    protected DataObjectService dataObjectService;
    @Autowired
    @Qualifier(value="groupService")
    protected GroupService groupService;
    @Autowired
    @Qualifier(value="personService")
    protected PersonService personService;

    public abstract GrantsSearchDocument translateDocument(Object var1);

    public abstract Set<String> getViewPermissions();

    public abstract boolean supports(Object var1);

    protected void setGenericDocumentFields(GrantsSearchDocument esDoc, Document document) {
        WorkflowDocument workflowDoc = document.getDocumentHeader().getWorkflowDocument();
        esDoc.setDocumentNumber(document.getDocumentNumber());
        esDoc.setRouteStatus(workflowDoc.getStatus().getLabel());
        esDoc.setInitiatorPrincipalId(workflowDoc.getInitiatorPrincipalId());
        esDoc.setDocumentType(workflowDoc.getDocumentTypeName());
        esDoc.setCreateDate(workflowDoc.getDateCreated().toDate());
        if (workflowDoc.getStatus() == DocumentStatus.ENROUTE) {
            this.setActionRequestFields(esDoc, document);
        }
    }

    protected void setActionRequestFields(GrantsSearchDocument esDoc, Document document) {
        QueryByCriteria activeRequestsCriteria = QueryByCriteria.Builder.fromPredicates((Predicate[])new Predicate[]{PredicateFactory.equal((String)"documentId", (Object)document.getDocumentNumber()), PredicateFactory.equal((String)"status", (Object)"A"), PredicateFactory.equal((String)"actionRequested", (Object)"A")});
        this.dataObjectService.findMatching(ActionRequestValue.class, activeRequestsCriteria).getResults().stream().filter(request -> StringUtils.isBlank((CharSequence)request.getParentActionRequestId())).findFirst().ifPresent(request -> this.setActionRequestFieldsForParentRequest(esDoc, (ActionRequestValue)request));
    }

    protected void setActionRequestFieldsForParentRequest(GrantsSearchDocument esDoc, ActionRequestValue parentRequest) {
        List approverPrincipalIds;
        esDoc.setApprovalType(parentRequest.getRecipientTypeLabel());
        esDoc.setApprovalPriorityStop(parentRequest.getPriority());
        if (RecipientType.GROUP.getCode().equals(parentRequest.getRecipientTypeCd())) {
            Group group = this.groupService.getGroup(parentRequest.getGroupId());
            esDoc.setPrimaryApprover(group.getName());
            approverPrincipalIds = this.groupService.getMemberPrincipalIds(parentRequest.getGroupId());
        } else {
            List<ActionRequestValue> directRequests;
            esDoc.setPrimaryApprover(StringUtils.isNotBlank((CharSequence)parentRequest.getQualifiedRoleNameLabel()) ? parentRequest.getQualifiedRoleNameLabel() : parentRequest.getQualifiedRoleName());
            List<ActionRequestValue> list = directRequests = CollectionUtils.isNotEmpty((Collection)parentRequest.getChildrenRequests()) ? parentRequest.getChildrenRequests() : Collections.singletonList(parentRequest);
            if (directRequests.size() == 1 && StringUtils.isBlank((CharSequence)directRequests.get(0).getPrincipalId())) {
                this.setActionRequestFieldsForParentRequest(esDoc, directRequests.get(0));
                return;
            }
            approverPrincipalIds = directRequests.stream().map(ActionRequestValue::getPrincipalId).collect(Collectors.toList());
        }
        esDoc.setApproverIds(approverPrincipalIds);
        esDoc.setApproverNames(approverPrincipalIds.stream().map(arg_0 -> ((PersonService)this.personService).getPerson(arg_0)).map(Person::getName).collect(Collectors.toList()));
    }

    protected void setPdSpecificFields(GrantsSearchDocument esDoc, DevelopmentProposal devProposal) {
        this.setPdSpecificFields(esDoc, Collections.singletonList(devProposal));
    }

    protected void setPdSpecificFields(GrantsSearchDocument esDoc, Collection<DevelopmentProposal> devProposals) {
        block0: {
            Iterator<DevelopmentProposal> iterator = devProposals.iterator();
            if (!iterator.hasNext()) break block0;
            DevelopmentProposal proposal = iterator.next();
            esDoc.setOriginatingProposalNumber(proposal.getProposalNumber());
            esDoc.setOpportunityId(proposal.getOpportunityIdForGG());
            esDoc.setPrevGrantsGovTrackingID(proposal.getPrevGrantsGovTrackingID());
            esDoc.setProgramAnnouncementNumber(proposal.getProgramAnnouncementNumber());
            esDoc.setProgramAnnouncementTitle(proposal.getProgramAnnouncementTitle());
            esDoc.setCfdaNumbers(proposal.getProposalCfdas().stream().map(ProposalCfda::getCfdaNumber).collect(Collectors.toList()));
            esDoc.setAgencyRoutingIdentifier(proposal.getAgencyRoutingIdentifier());
            esDoc.setDeadlineDate(proposal.getDeadlineDate());
        }
    }

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    public GroupService getGroupService() {
        return this.groupService;
    }

    public void setGroupService(GroupService groupService) {
        this.groupService = groupService;
    }

    public PersonService getPersonService() {
        return this.personService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }
}

