/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.elasticsearch.serializers;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.kuali.coeus.elasticsearch.GrantsSearchDocument;
import org.kuali.coeus.elasticsearch.serializers.ElasticsearchDocumentSerializer;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalPersonBoLite;
import org.kuali.kra.institutionalproposal.document.InstitutionalProposalDocument;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.kra.institutionalproposal.proposaladmindetails.ProposalAdminDetails;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.springframework.beans.factory.annotation.Autowire;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Configurable;
import org.springframework.beans.factory.annotation.Qualifier;

@Configurable(autowire=Autowire.BY_TYPE)
public class ElasticsearchInstitutionalProposalSerializer
extends ElasticsearchDocumentSerializer {
    @Autowired
    @Qualifier(value="businessObjectService")
    private BusinessObjectService businessObjectService;

    @Override
    public GrantsSearchDocument translateDocument(Object doc) {
        InstitutionalProposalDocument document = (InstitutionalProposalDocument)doc;
        InstitutionalProposal ip = document.getInstitutionalProposal();
        GrantsSearchDocument esDoc = new GrantsSearchDocument();
        this.setGenericDocumentFields(esDoc, (Document)document);
        esDoc.setPrimaryKey(String.valueOf(ip.getProposalId()));
        esDoc.setModuleIdentifier(ip.getProposalNumber());
        esDoc.setSequenceNumber(ip.getSequenceNumber());
        esDoc.setTypeCode(String.valueOf(ip.getProposalTypeCode()));
        esDoc.setTypeDescription(ip.getProposalType().getDescription());
        esDoc.setTitle(ip.getTitle());
        esDoc.setSponsorCode(ip.getSponsorCode());
        esDoc.setSponsorName(ip.getSponsorName());
        esDoc.setLeadUnitNumber(document.getLeadUnitNumber());
        esDoc.setLeadUnitName(ip.getLeadUnitName());
        this.setInstitutionalProposalPersonFields(esDoc, ip);
        this.setPdSpecificFields(esDoc, this.getDevProposalsForIP(ip));
        return esDoc;
    }

    protected void setInstitutionalProposalPersonFields(GrantsSearchDocument esDoc, InstitutionalProposal ip) {
        Map<String, Long> personnelCriteria = Collections.singletonMap("proposalId", ip.getProposalId());
        Collection projectPersons = this.businessObjectService.findMatching(InstitutionalProposalPersonBoLite.class, personnelCriteria);
        esDoc.setPersonIds(projectPersons.stream().map(InstitutionalProposalPersonBoLite::getPersonId).filter(Objects::nonNull).collect(Collectors.toList()));
        esDoc.setRolodexIds(projectPersons.stream().map(InstitutionalProposalPersonBoLite::getRolodexId).filter(Objects::nonNull).collect(Collectors.toList()));
        esDoc.setPersonnelNames(projectPersons.stream().map(InstitutionalProposalPersonBoLite::getFullName).collect(Collectors.toList()));
        projectPersons.stream().filter(InstitutionalProposalPersonBoLite::isPrincipalInvestigator).findFirst().map(InstitutionalProposalPersonBoLite::getFullName).ifPresent(esDoc::setPrincipalInvestigatorName);
    }

    protected Collection<DevelopmentProposal> getDevProposalsForIP(InstitutionalProposal ip) {
        Map<String, Long> proposalAdminCriteria = Collections.singletonMap("instProposalId", ip.getProposalId());
        List proposalNumbers = this.businessObjectService.findMatching(ProposalAdminDetails.class, proposalAdminCriteria).stream().map(ProposalAdminDetails::getDevProposalNumber).collect(Collectors.toList());
        if (!proposalNumbers.isEmpty()) {
            return this.dataObjectService.findMatching(DevelopmentProposal.class, QueryByCriteria.Builder.forAttribute((String)"proposalNumber", proposalNumbers).build()).getResults();
        }
        return Collections.emptyList();
    }

    @Override
    public Set<String> getViewPermissions() {
        return Set.of("Open Institutional Proposal");
    }

    @Override
    public boolean supports(Object document) {
        return document instanceof InstitutionalProposalDocument;
    }
}

