/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.s2s.nih;

import gov.nih.era.sads.external.ExternalSubmissionAgencyDataServiceStub;
import gov.nih.era.sads.external.GetFOAInfoFault;
import gov.nih.era.sads.types.FOAInfoType;
import gov.nih.era.sads.types.GetFOAInfoRequest;
import gov.nih.era.sads.types.GetFOAInfoResponse;
import java.util.Objects;
import java.util.Optional;
import javax.xml.ws.soap.SOAPFaultException;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.propdev.impl.s2s.connect.S2sCommunicationException;
import org.kuali.coeus.propdev.impl.s2s.nih.FOAInfoDto;
import org.kuali.coeus.propdev.impl.s2s.nih.NihServiceBase;
import org.kuali.coeus.propdev.impl.s2s.nih.NihSubmissionAgencyDataService;
import org.springframework.stereotype.Component;

@Component(value="nihSubmissionAgencyDataService")
public class NihSubmissionAgencyDataServiceImpl
extends NihServiceBase
implements NihSubmissionAgencyDataService {
    private static final String NIH_GOV_S2S_SADS_HOST = "nih.gov.s2s.sads.host";
    private static final String NIH_GOV_S2S_SADS_PORT = "nih.gov.s2s.sads.port";
    private static final Logger LOG = LogManager.getLogger(NihSubmissionAgencyDataServiceImpl.class);

    @Override
    public String getServiceHost() {
        return this.getS2SConfigurationService().getValueAsString(NIH_GOV_S2S_SADS_HOST);
    }

    @Override
    public String getServicePort() {
        return this.getS2SConfigurationService().getValueAsString(NIH_GOV_S2S_SADS_PORT);
    }

    @Override
    public Optional<FOAInfoDto> getFOAInfo(String dunsNumber, String packageId) {
        if (StringUtils.isBlank((CharSequence)packageId) || !this.isNihServiceEnabled()) {
            return Optional.empty();
        }
        return (Optional)this.optionallyCache(Objects.hash(packageId), () -> this.callGetFOAInfo(dunsNumber, packageId));
    }

    @Override
    public boolean isNIHOpportunity(String dunsNumber, String packageId) {
        try {
            return this.getFOAInfo(dunsNumber, packageId).isPresent();
        }
        catch (S2sCommunicationException s2sCommunicationException) {
            LOG.error("Nih service unreachable at: " + this.getServiceHost(), (Throwable)s2sCommunicationException);
            return false;
        }
    }

    protected Optional<FOAInfoDto> callGetFOAInfo(String dunsNumber, String packageId) {
        GetFOAInfoRequest parameters = new GetFOAInfoRequest();
        parameters.setPackageId(packageId);
        try {
            this.debugLogJaxbObject(GetFOAInfoRequest.class, parameters, LOG);
            ExternalSubmissionAgencyDataServiceStub serviceStub = this.createConfiguredService(dunsNumber, ExternalSubmissionAgencyDataServiceStub.class);
            GetFOAInfoResponse response = serviceStub.getFOAInfo(parameters);
            this.debugLogJaxbObject(GetFOAInfoResponse.class, response, LOG);
            return this.toDto(response);
        }
        catch (GetFOAInfoFault | SOAPFaultException validateApplicationError) {
            throw new S2sCommunicationException("error.nih.service.unknown", (Exception)validateApplicationError);
        }
    }

    private Optional<FOAInfoDto> toDto(GetFOAInfoResponse response) {
        if (response == null || response.getFoa() == null) {
            return Optional.empty();
        }
        FOAInfoDto dto = new FOAInfoDto();
        FOAInfoType foa = response.getFoa();
        dto.setFundingOpportunityNumber(foa.getFundingOpportunityNumber());
        dto.setActivityCode(foa.getActivityCode());
        dto.setPhsOrgCode(foa.getPhsOrgCode());
        dto.setOptOutCode(foa.getOptOutCode());
        dto.setCombinedMechanism(foa.isIsCombinedMechanism());
        dto.setProgramTypeCode(foa.getProgramTypeCode());
        dto.setDirectPhaseII(foa.getDirectPhaseII());
        dto.setNoticeTitle(foa.getNoticeTitle());
        dto.setNoticeTypeCode(foa.getNoticeTypeCode());
        dto.setCollaborativeTypeCode(foa.getCollaborativeTypeCode());
        dto.setCouncilMeetingDate(foa.getCouncilMeetingDate());
        dto.setAgency(foa.getAgency());
        dto.setAidsRelatedCode(foa.getAidsRelatedCode());
        dto.setComplex(foa.isIsComplex());
        dto.setProjectPeriodExceptionFlag(foa.getProjectPeriodExceptionFlag());
        dto.setProjectCostExceptionFlag(foa.getProjectCostExceptionFlag());
        dto.setPageLimitExceptionFlag(foa.getPageLimitExceptionFlag());
        dto.setProjectPeriodExcepLT5YFlag(foa.getProjectPeriodExcepLT5YFlag());
        dto.setDiversityFlag(foa.getDiversityFlag());
        dto.setClinicalTrialCode(foa.getClinicalTrialCode());
        dto.setCombinedActivityCode(foa.getCombinedActivityCode());
        return Optional.of(dto);
    }
}

