/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.framework.security;

import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.annotation.web.servlet.configuration.EnableWebMvcSecurity;
import org.springframework.security.web.header.HeaderWriter;
import org.springframework.security.web.header.writers.frameoptions.XFrameOptionsHeaderWriter;

@Configuration
@EnableWebMvcSecurity
@Deprecated
public class SpringRestSecurity
extends WebSecurityConfigurerAdapter {
    private static final String ADMIN_ROLE = "ADMIN";
    private static final String KC_REST_ADMIN_PASSWORD = "kc.rest.admin.password";
    private static final String KC_REST_ADMIN_USERNAME = "kc.rest.admin.username";
    private static final String AUTH_REST_URLS_REGEX = "auth.rest.urls.regex";
    @Autowired
    @Qualifier(value="kualiConfigurationService")
    private ConfigurationService configurationService;

    @Autowired
    public void configureGlobal(AuthenticationManagerBuilder auth) throws Exception {
        String userName = this.configurationService.getPropertyValueAsString(KC_REST_ADMIN_USERNAME);
        String password = this.configurationService.getPropertyValueAsString(KC_REST_ADMIN_PASSWORD);
        if (StringUtils.isNotBlank((CharSequence)userName) && StringUtils.isNotBlank((CharSequence)password)) {
            auth.inMemoryAuthentication().withUser(userName).password(password).roles(new String[]{ADMIN_ROLE});
        }
    }

    protected void configure(HttpSecurity http) throws Exception {
        http.csrf().disable();
        http.headers().xssProtection().and().addHeaderWriter((HeaderWriter)new XFrameOptionsHeaderWriter(XFrameOptionsHeaderWriter.XFrameOptionsMode.SAMEORIGIN));
        String authRestUrlsRegex = this.configurationService.getPropertyValueAsString(AUTH_REST_URLS_REGEX);
        if (StringUtils.isNotBlank((CharSequence)authRestUrlsRegex)) {
            Stream.of(authRestUrlsRegex.split(",")).map(String::trim).forEach(regex -> {
                try {
                    ((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().regexMatchers(new String[]{regex})).hasRole(ADMIN_ROLE).and()).httpBasic();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
        }
    }

    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }
}

