/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.impl.dd;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.kuali.coeus.sys.framework.util.CollectionUtils;
import org.kuali.rice.krad.datadictionary.DataDictionary;
import org.kuali.rice.krad.datadictionary.DataDictionaryException;
import org.springframework.core.io.Resource;
import org.springframework.security.util.InMemoryResource;

public final class DataDictionaryOverrideUtils {
    private DataDictionaryOverrideUtils() {
        throw new UnsupportedOperationException("do not call");
    }

    public static DataDictionary createNewWithOverride(DataDictionary old, String overrideId, byte[] override) throws DataDictionaryException {
        DataDictionary modifiedDataDictionary = DataDictionaryOverrideUtils.copyDataDictionaryWithOverride(old);
        DataDictionaryOverrideUtils.addOrReplaceOverrideResource(modifiedDataDictionary, overrideId, (Resource)new InMemoryResource(override, overrideId));
        modifiedDataDictionary.parseDataDictionaryConfigurationFiles();
        modifiedDataDictionary.validateDD();
        return modifiedDataDictionary;
    }

    public static DataDictionary createNewRemovingOverride(DataDictionary old, String overrideId) throws DataDictionaryException {
        DataDictionary modifiedDataDictionary = DataDictionaryOverrideUtils.copyDataDictionaryWithOverride(old);
        DataDictionaryOverrideUtils.removeOverrideResource(modifiedDataDictionary, overrideId);
        modifiedDataDictionary.parseDataDictionaryConfigurationFiles();
        modifiedDataDictionary.validateDD();
        return modifiedDataDictionary;
    }

    private static DataDictionary copyDataDictionaryWithOverride(DataDictionary old) {
        DataDictionary copiedDataDictionary = new DataDictionary();
        copiedDataDictionary.setModuleDictionaryFiles(DataDictionaryOverrideUtils.copyModuleDictionaryFilesWithOverride(old.getModuleDictionaryFiles()));
        copiedDataDictionary.setModuleLoadOrder(DataDictionaryOverrideUtils.copyModuleLoadOrderWithOverride(old.getModuleLoadOrder()));
        return copiedDataDictionary;
    }

    private static List<String> copyModuleLoadOrderWithOverride(List<String> loadOrder) {
        ArrayList<String> copiedLoadOrder = new ArrayList<String>(loadOrder);
        if (!copiedLoadOrder.contains("OVERRIDE")) {
            copiedLoadOrder.add("OVERRIDE");
        }
        return copiedLoadOrder;
    }

    private static Map<String, List<Resource>> copyModuleDictionaryFilesWithOverride(Map<String, List<Resource>> moduleDictionaryFiles) {
        Map<String, List<Resource>> copiedResources = DataDictionaryOverrideUtils.copyModuleDictionaryFiles(moduleDictionaryFiles);
        copiedResources.putIfAbsent("OVERRIDE", new ArrayList());
        return copiedResources;
    }

    private static Map<String, List<Resource>> copyModuleDictionaryFiles(Map<String, List<Resource>> moduleDictionaryFiles) {
        return moduleDictionaryFiles.entrySet().stream().map(entry -> CollectionUtils.entry((String)entry.getKey(), new ArrayList((Collection)entry.getValue()))).collect(CollectionUtils.entriesToMap());
    }

    private static void addOrReplaceOverrideResource(DataDictionary dataDictionary, String overrideId, Resource resource) {
        List overrideFiles = (List)dataDictionary.getModuleDictionaryFiles().get("OVERRIDE");
        int previousOverrideIndex = -1;
        for (int i = 0; i < overrideFiles.size(); ++i) {
            Resource r = (Resource)overrideFiles.get(i);
            if (!(r instanceof InMemoryResource) || !overrideId.equals(r.getDescription())) continue;
            previousOverrideIndex = i;
            break;
        }
        if (previousOverrideIndex != -1) {
            ((List)dataDictionary.getModuleDictionaryFiles().get("OVERRIDE")).set(previousOverrideIndex, resource);
        } else {
            ((List)dataDictionary.getModuleDictionaryFiles().get("OVERRIDE")).add(resource);
        }
    }

    private static void removeOverrideResource(DataDictionary dataDictionary, String overrideId) {
        List overrideFiles = (List)dataDictionary.getModuleDictionaryFiles().get("OVERRIDE");
        Iterator i = overrideFiles.iterator();
        while (i.hasNext()) {
            Resource r = (Resource)i.next();
            if (!(r instanceof InMemoryResource) || !overrideId.equals(r.getDescription())) continue;
            i.remove();
            break;
        }
    }
}

