/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.impl.workflow;

import java.util.List;
import javax.persistence.OptimisticLockException;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.elasticsearch.ElasticsearchIndexService;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.coeus.sys.framework.workflow.LastActionService;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kew.api.action.ActionType;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kew.framework.postprocessor.ActionTakenEvent;
import org.kuali.rice.kew.framework.postprocessor.AfterProcessEvent;
import org.kuali.rice.kew.framework.postprocessor.BeforeProcessEvent;
import org.kuali.rice.kew.framework.postprocessor.DeleteEvent;
import org.kuali.rice.kew.framework.postprocessor.DocumentLockingEvent;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteLevelChange;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteStatusChange;
import org.kuali.rice.kew.framework.postprocessor.ProcessDocReport;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.service.PostProcessorService;
import org.kuali.rice.krad.util.LegacyUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="kcPostProcessorService")
@Transactional
public class KcPostProcessorServiceImpl
implements PostProcessorService {
    private static final Logger LOG = LogManager.getLogger(KcPostProcessorServiceImpl.class);
    @Autowired
    @Qualifier(value="lastActionService")
    private LastActionService lastActionService;
    @Autowired
    @Qualifier(value="postProcessorService")
    private PostProcessorService postProcessorService;
    @Autowired
    @Qualifier(value="globalVariableService")
    private GlobalVariableService globalVariableService;
    @Autowired
    @Qualifier(value="kualiConfigurationService")
    private ConfigurationService configurationService;
    @Autowired
    @Qualifier(value="documentService")
    private DocumentService documentService;
    @Autowired
    @Qualifier(value="parameterService")
    private ParameterService parameterService;
    @Autowired(required=false)
    @Qualifier(value="elasticsearchIndexService")
    private ElasticsearchIndexService elasticsearchIndexService;

    public ProcessDocReport doNonDocumentSavingRouteStatusChange(DocumentRouteStatusChange statusChangeEvent) throws Exception {
        return (ProcessDocReport)LegacyUtils.doInLegacyContext((String)statusChangeEvent.getDocumentId(), (UserSession)this.establishPostProcessorUserSession(), () -> {
            try {
                Document document;
                if (LOG.isInfoEnabled()) {
                    LOG.info((CharSequence)new StringBuilder("started handling route status change from ").append(statusChangeEvent.getOldRouteStatus()).append(" to ").append(statusChangeEvent.getNewRouteStatus()).append(" for document ").append(statusChangeEvent.getDocumentId()));
                }
                if ((document = this.documentService.getByDocumentHeaderId(statusChangeEvent.getDocumentId())) == null) {
                    if (!"X".equals(statusChangeEvent.getNewRouteStatus())) {
                        throw new RuntimeException("unable to load document " + statusChangeEvent.getDocumentId());
                    }
                } else {
                    document.doRouteStatusChange(statusChangeEvent);
                    if (!document.getDocumentHeader().getWorkflowDocument().isSaved()) {
                        document.getDocumentHeader().getWorkflowDocument().saveDocumentData();
                    }
                }
                if (LOG.isInfoEnabled()) {
                    LOG.info((CharSequence)new StringBuilder("finished handling route status change from ").append(statusChangeEvent.getOldRouteStatus()).append(" to ").append(statusChangeEvent.getNewRouteStatus()).append(" for document ").append(statusChangeEvent.getDocumentId()));
                }
            }
            catch (Exception e) {
                this.logAndRethrow("route status", e);
            }
            return new ProcessDocReport(true, "");
        });
    }

    private void logAndRethrow(String changeType, Exception e) throws RuntimeException {
        LOG.error("caught exception while handling " + changeType + " change", (Throwable)e);
        this.logOptimisticDetails(5, e);
        throw new RuntimeException("post processor caught exception while handling " + changeType + " change: " + e.getMessage(), e);
    }

    private void logOptimisticDetails(int depth, Throwable t) {
        if (depth > 0 && t != null) {
            Object sourceObject = null;
            boolean optLockException = false;
            if (t instanceof OptimisticLockException) {
                sourceObject = ((OptimisticLockException)t).getEntity();
                optLockException = true;
            } else if (t instanceof OptimisticLockingFailureException) {
                sourceObject = t.getMessage();
                optLockException = true;
            } else if (t.getClass().getName().equals("org.apache.ojb.broker.OptimisticLockException")) {
                try {
                    sourceObject = PropertyUtils.getSimpleProperty((Object)t, (String)"sourceObject");
                }
                catch (Exception ex) {
                    LOG.warn("Unable to retrieve source object from OJB OptimisticLockException", (Throwable)ex);
                }
                optLockException = true;
            }
            if (optLockException) {
                if (sourceObject != null) {
                    if (sourceObject instanceof String) {
                        LOG.error("source of OptimisticLockException Unknown.  Message: " + sourceObject);
                    } else {
                        LOG.error("source of OptimisticLockException = " + sourceObject.getClass().getName() + " ::= " + sourceObject);
                    }
                }
            } else {
                Throwable cause = t.getCause();
                if (cause != t) {
                    this.logOptimisticDetails(--depth, cause);
                }
            }
        }
    }

    public ProcessDocReport doRouteStatusChange(DocumentRouteStatusChange statusChangeEvent) throws Exception {
        return this.globalVariableService.doInNewGlobalVariables(this.establishPostProcessorUserSession(), () -> this.doNonDocumentSavingRouteStatusChange(statusChangeEvent));
    }

    public ProcessDocReport doRouteLevelChange(DocumentRouteLevelChange levelChangeEvent) throws Exception {
        return this.globalVariableService.doInNewGlobalVariables(this.establishPostProcessorUserSession(), () -> this.postProcessorService.doRouteLevelChange(levelChangeEvent));
    }

    public ProcessDocReport doDeleteRouteHeader(DeleteEvent event) throws Exception {
        return this.postProcessorService.doDeleteRouteHeader(event);
    }

    public ProcessDocReport doActionTaken(ActionTakenEvent event) throws Exception {
        return this.globalVariableService.doInNewGlobalVariables(this.establishPostProcessorUserSession(), () -> this.postProcessorService.doActionTaken(event));
    }

    public ProcessDocReport afterActionTaken(ActionType actionPerformed, ActionTakenEvent event) throws Exception {
        return this.postProcessorService.afterActionTaken(actionPerformed, event);
    }

    public ProcessDocReport beforeProcess(BeforeProcessEvent processEvent) throws Exception {
        return this.postProcessorService.beforeProcess(processEvent);
    }

    public ProcessDocReport afterProcess(AfterProcessEvent processEvent) throws Exception {
        ProcessDocReport processReport = this.postProcessorService.afterProcess(processEvent);
        this.indexDocumentIfApplicable(processEvent.getDocumentId());
        return processReport;
    }

    public List<String> getDocumentIdsToLock(DocumentLockingEvent lockingEvent) throws Exception {
        return this.postProcessorService.getDocumentIdsToLock(lockingEvent);
    }

    protected void indexDocumentIfApplicable(String documentId) {
        if (this.configurationService.getPropertyValueAsBoolean("elasticsearch.enabled")) {
            this.elasticsearchIndexService.index(documentId);
        }
    }

    protected UserSession establishPostProcessorUserSession() throws WorkflowException {
        if (this.globalVariableService.getUserSession() == null) {
            return new UserSession("kr");
        }
        return this.globalVariableService.getUserSession();
    }

    public void setPostProcessorService(PostProcessorService postProcessorService) {
        this.postProcessorService = postProcessorService;
    }

    public PostProcessorService getPostProcessorService() {
        return this.postProcessorService;
    }

    public GlobalVariableService getGlobalVariableService() {
        return this.globalVariableService;
    }

    public void setGlobalVariableService(GlobalVariableService globalVariableService) {
        this.globalVariableService = globalVariableService;
    }

    public LastActionService getLastActionService() {
        return this.lastActionService;
    }

    public void setLastActionService(LastActionService lastActionService) {
        this.lastActionService = lastActionService;
    }

    public DocumentService getDocumentService() {
        return this.documentService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }
}

