/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.contacts;

import java.util.HashMap;
import org.kuali.coeus.common.framework.type.InvestigatorCreditType;
import org.kuali.coeus.common.framework.version.sequence.associate.SequenceAssociate;
import org.kuali.coeus.propdev.impl.person.creditsplit.CreditSplit;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.SkipVersioning;
import org.kuali.kra.award.contacts.AwardPerson;
import org.kuali.kra.award.home.Award;
import org.kuali.rice.krad.service.BusinessObjectService;

public final class AwardPersonCreditSplit
extends KcPersistableBusinessObjectBase
implements CreditSplit,
SequenceAssociate<Award> {
    private static final String INV_CREDIT_TYPE_CODE_FIELD_NAME = "code";
    private static final long serialVersionUID = -6999442247404810830L;
    private Long awardPersonCreditSplitId;
    @SkipVersioning
    private AwardPerson awardPerson;
    private ScaleTwoDecimal credit;
    private InvestigatorCreditType investigatorCreditType;
    private String invCreditTypeCode;
    private Long awardContactId;

    public AwardPersonCreditSplit() {
    }

    AwardPersonCreditSplit(InvestigatorCreditType investigatorCreditType, ScaleTwoDecimal credit) {
        this.setInvestigatorCreditType(investigatorCreditType);
        this.setCredit(credit);
    }

    public Long getAwardContactId() {
        return this.awardContactId;
    }

    public AwardPerson getAwardPerson() {
        return this.awardPerson;
    }

    public Long getAwardPersonCreditSplitId() {
        return this.awardPersonCreditSplitId;
    }

    @Override
    public ScaleTwoDecimal getCredit() {
        return this.credit != null ? this.credit : ScaleTwoDecimal.ZERO;
    }

    @Override
    public String getInvCreditTypeCode() {
        this.refreshInvestigatorCreditTypeIfNeeded();
        return this.invCreditTypeCode;
    }

    public InvestigatorCreditType getInvestigatorCreditType() {
        this.refreshInvestigatorCreditTypeIfNeeded();
        return this.investigatorCreditType;
    }

    public void setAwardContactId(Long awardContactId) {
        this.awardContactId = awardContactId;
    }

    public void setAwardPerson(AwardPerson awardPerson) {
        this.awardPerson = awardPerson;
        this.awardContactId = awardPerson != null ? awardPerson.getAwardContactId() : null;
    }

    public void setAwardPersonCreditSplitId(Long awardPersonCreditSplitId) {
        this.awardPersonCreditSplitId = awardPersonCreditSplitId;
    }

    @Override
    public void setCredit(ScaleTwoDecimal argCredit) {
        this.credit = argCredit;
    }

    @Override
    public void setInvCreditTypeCode(String argInvCreditTypeCode) {
        this.invCreditTypeCode = argInvCreditTypeCode;
    }

    public void setInvestigatorCreditType(InvestigatorCreditType investigatorCreditType) {
        this.investigatorCreditType = investigatorCreditType;
        this.invCreditTypeCode = investigatorCreditType != null ? investigatorCreditType.getCode() : null;
    }

    protected BusinessObjectService getBusinessObjectService() {
        return KcServiceLocator.getService(BusinessObjectService.class);
    }

    private void refreshInvestigatorCreditTypeIfNeeded() {
        if (!(this.invCreditTypeCode == null || this.investigatorCreditType != null && this.invCreditTypeCode.equals(this.investigatorCreditType.getCode()))) {
            HashMap<String, String> keyMap = new HashMap<String, String>();
            keyMap.put(INV_CREDIT_TYPE_CODE_FIELD_NAME, this.invCreditTypeCode);
            this.investigatorCreditType = (InvestigatorCreditType)this.getBusinessObjectService().findByPrimaryKey(InvestigatorCreditType.class, keyMap);
        }
    }

    @Override
    public Award getSequenceOwner() {
        return this.awardPerson != null ? this.awardPerson.getAward() : null;
    }

    @Override
    public void setSequenceOwner(Award newlyVersionedOwner) {
        if (this.awardPerson != null) {
            this.awardPerson.setAward(newlyVersionedOwner);
        }
    }

    @Override
    public Integer getSequenceNumber() {
        return this.awardPerson != null ? this.awardPerson.getSequenceNumber() : 0;
    }

    @Override
    public void resetPersistenceState() {
        this.awardPersonCreditSplitId = null;
    }
}

