/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.web.struts.action;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.coeus.common.framework.compliance.core.SaveSpecialReviewLinkEvent;
import org.kuali.coeus.common.framework.compliance.core.SpecialReviewService;
import org.kuali.coeus.common.framework.keyword.KeywordsService;
import org.kuali.coeus.common.framework.version.history.VersionHistory;
import org.kuali.coeus.sys.api.model.AbstractDecimal;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.award.AwardForm;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardAmountInfo;
import org.kuali.kra.award.home.AwardCfda;
import org.kuali.kra.award.home.keywords.AwardScienceKeyword;
import org.kuali.kra.award.home.rules.AwardAddCfdaEvent;
import org.kuali.kra.award.specialreview.AwardSpecialReview;
import org.kuali.kra.award.web.struts.action.ApprovedSubawardActionHelper;
import org.kuali.kra.award.web.struts.action.AwardAction;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.event.DocumentEvent;
import org.kuali.rice.krad.util.GlobalVariables;

public class AwardHomeAction
extends AwardAction {
    private static final String AWARD_VERSION_EDITPENDING_PROMPT_KEY = "message.award.version.editpending.prompt";
    private ApprovedSubawardActionHelper approvedSubawardActionHelper = new ApprovedSubawardActionHelper();
    private GlobalVariableService globalVariableService;
    private static final String AWARD_LIST = "awardList";

    public ActionForward addFundingProposal(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ((AwardForm)form).getFundingProposalBean().addFundingProposal();
        return mapping.findForward("basic");
    }

    public ActionForward addApprovedSubaward(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.approvedSubawardActionHelper.addApprovedSubaward(((AwardForm)form).getApprovedSubawardFormHelper());
        return mapping.findForward("basic");
    }

    public ActionForward deleteApprovedSubaward(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        AwardDocument awardDocument = awardForm.getAwardDocument();
        int delApprovedSubaward = this.getLineToDelete(request);
        awardDocument.getAward().getAwardApprovedSubawards().remove(delApprovedSubaward);
        return mapping.findForward("basic");
    }

    public ActionForward addAwardCfda(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        AwardDocument awardDocument = awardForm.getAwardDocument();
        AwardCfda newAwardCfda = awardForm.getNewAwardCfda();
        Award award = awardDocument.getAward();
        newAwardCfda.setAwardId(award.getAwardId());
        newAwardCfda.setAward(award);
        newAwardCfda.setAwardNumber(award.getAwardNumber());
        newAwardCfda.setSequenceNumber(award.getSequenceNumber());
        award.getAwardCfdas().add(newAwardCfda);
        awardForm.setNewAwardCfda(new AwardCfda());
        this.getKualiRuleService().applyRules((DocumentEvent)new AwardAddCfdaEvent(awardDocument));
        return mapping.findForward("basic");
    }

    public ActionForward deleteAwardCfda(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        AwardDocument awardDocument = awardForm.getAwardDocument();
        int delAwardCfda = this.getLineToDelete(request);
        awardDocument.getAward().getAwardCfdas().remove(delAwardCfda);
        return mapping.findForward("basic");
    }

    public ActionForward open(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward actionForward = super.execute(mapping, form, request, response);
        AwardForm awardForm = (AwardForm)form;
        String commandParam = request.getParameter("command");
        if (StringUtils.isNotBlank((CharSequence)commandParam) && commandParam.equals("initiate") && StringUtils.isNotBlank((CharSequence)request.getParameter("awardId"))) {
            Award award = this.findSelectedAward(request.getParameter("awardId"));
            this.initializeFormWithAward(awardForm, award);
        }
        return actionForward;
    }

    public ActionForward recalculateSubawardTotal(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.approvedSubawardActionHelper.recalculateSubawardTotal(((AwardForm)form).getApprovedSubawardFormHelper());
        return mapping.findForward("basic");
    }

    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward actionForward = super.execute(mapping, form, request, response);
        AwardForm awardForm = (AwardForm)form;
        String commandParam = request.getParameter("command");
        if (StringUtils.isNotBlank((CharSequence)commandParam) && commandParam.equals("initiate") && StringUtils.isNotBlank((CharSequence)request.getParameter("awardId"))) {
            Award award = this.findSelectedAward(request.getParameter("awardId"));
            this.initializeFormWithAward(awardForm, award);
        }
        if (StringUtils.isNotBlank((CharSequence)commandParam) && "redirectAwardHistoryFullViewForPopup".equals(commandParam)) {
            String awardDocumentNumber = request.getParameter("awardDocumentNumber");
            String awardNumber = request.getParameter("awardNumber");
            actionForward = this.redirectAwardHistoryFullViewForPopup(mapping, form, request, response, awardDocumentNumber, awardNumber);
        }
        return actionForward;
    }

    public ActionForward refresh(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        super.refresh(mapping, form, request, response);
        GlobalVariables.getUserSession().removeObject("linkedProposals");
        AwardForm awardMultiLookupForm = (AwardForm)form;
        String lookupResultsBOClassName = request.getParameter("lookupResultsBOClassName");
        String lookupResultsSequenceNumber = request.getParameter("lookupResultsSequenceNumber");
        awardMultiLookupForm.setLookupResultsBOClassName(lookupResultsBOClassName);
        awardMultiLookupForm.setLookupResultsSequenceNumber(lookupResultsSequenceNumber);
        Award awardDocument = awardMultiLookupForm.getAwardDocument().getAward();
        this.getKeywordService().addKeywords(awardDocument, awardMultiLookupForm);
        awardDocument.refreshReferenceObject("sponsor");
        return mapping.findForward("basic");
    }

    @Override
    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String navigateTo;
        ActionForward forward = mapping.findForward("basic");
        AwardForm awardForm = (AwardForm)form;
        AwardDocument awardDocument = awardForm.getAwardDocument();
        this.getAwardService().updateCurrentAwardAmountInfo(awardDocument.getAward());
        awardForm.getProjectPersonnelBean().updateLeadUnit();
        if (this.getReportTrackingService().shouldAlertReportTrackingDetailChange(awardForm.getAwardDocument().getAward())) {
            GlobalVariables.getMessageMap().putWarning("document.awardList[0].awardExecutionDate", "warning.reportTracking.updateFromDateChange", new String[]{""});
        }
        boolean isAwardProtocolLinkingEnabled = this.getParameterService().getParameterValueAsBoolean("KC-PROTOCOL", "Document", "irb.protocol.award.linking.enabled");
        List<AwardSpecialReview> specialReviews = awardDocument.getAward().getSpecialReviews();
        if (!isAwardProtocolLinkingEnabled || this.applyRules((DocumentEvent)new SaveSpecialReviewLinkEvent<AwardSpecialReview>((Document)awardDocument, specialReviews))) {
            forward = super.save(mapping, form, request, response);
            awardDocument.getAward().refreshReferenceObject("sponsor");
            Award award = awardDocument.getAward();
            this.persistSpecialReviewProtocolFundingSourceLink(award, isAwardProtocolLinkingEnabled);
        }
        if ((navigateTo = awardForm.getNavigateTo()) == null || navigateTo.equalsIgnoreCase("home")) {
            this.getKualiRuleService().applyRules((DocumentEvent)new AwardAddCfdaEvent(awardDocument));
        }
        return forward;
    }

    protected Award getActiveAwardVersion(Award award) {
        return this.getAwardVersionService().getActiveAwardVersion(award.getAwardNumber());
    }

    protected void setTotalsOnAward(Award award) {
        AwardAmountInfo aai = award.getLastAwardAmountInfo();
        if (aai == null) {
            return;
        }
        ScaleTwoDecimal obligatedDirectTotal = aai.getObligatedTotalDirect() != null ? aai.getObligatedTotalDirect() : ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal obligatedIndirectTotal = aai.getObligatedTotalIndirect() != null ? aai.getObligatedTotalIndirect() : ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal anticipatedDirectTotal = aai.getAnticipatedTotalDirect() != null ? aai.getAnticipatedTotalDirect() : ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal anticipatedIndirectTotal = aai.getAnticipatedTotalIndirect() != null ? aai.getAnticipatedTotalIndirect() : ScaleTwoDecimal.ZERO;
        aai.setAmountObligatedToDate((ScaleTwoDecimal)obligatedDirectTotal.add((AbstractDecimal)obligatedIndirectTotal));
        aai.setAnticipatedTotalAmount((ScaleTwoDecimal)anticipatedDirectTotal.add((AbstractDecimal)anticipatedIndirectTotal));
    }

    private void persistSpecialReviewProtocolFundingSourceLink(Award award, boolean isAwardProtocolLinkingEnabled) {
        if (isAwardProtocolLinkingEnabled) {
            SpecialReviewService specialReviewService = KcServiceLocator.getService(SpecialReviewService.class);
            for (AwardSpecialReview specialReview : award.getSpecialReviews()) {
                if (!"1".equals(specialReview.getSpecialReviewTypeCode())) continue;
                String protocolNumber = specialReview.getProtocolNumber();
                String fundingSourceNumber = award.getAwardNumber();
                String fundingSourceTypeCode = "6";
                String fundingSourceName = award.getSponsorName();
                String fundingSourceTitle = award.getTitle();
                if (specialReviewService.isLinkedToProtocolFundingSource(protocolNumber, fundingSourceNumber, fundingSourceTypeCode)) continue;
                specialReviewService.addProtocolFundingSourceForSpecialReview(protocolNumber, fundingSourceNumber, fundingSourceTypeCode, fundingSourceName, fundingSourceTitle);
            }
        }
    }

    @Override
    public ActionForward close(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        this.getAwardService().checkAwardNumber(awardForm.getAwardDocument().getAward());
        return super.close(mapping, (ActionForm)awardForm, request, response);
    }

    @Override
    public ActionForward performLookup(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String parameterName = (String)request.getAttribute("methodToCallAttribute");
        if (StringUtils.isNotBlank((CharSequence)parameterName) && parameterName.contains(".performLookup") && parameterName.contains("InstitutionalProposal")) {
            GlobalVariables.getUserSession().addObject("linkedProposals", ((AwardForm)form).getLinkedProposals());
        }
        return super.performLookup(mapping, form, request, response);
    }

    protected KeywordsService<AwardScienceKeyword> getKeywordService() {
        return KcServiceLocator.getService(KeywordsService.class);
    }

    public ActionForward selectAllScienceKeyword(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        AwardDocument awardDocument = awardForm.getAwardDocument();
        List<AwardScienceKeyword> keywords = awardDocument.getAward().getKeywords();
        for (AwardScienceKeyword awardScienceKeyword : keywords) {
            awardScienceKeyword.setSelectKeyword(true);
        }
        return mapping.findForward("basic");
    }

    public ActionForward deleteSelectedScienceKeyword(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        AwardDocument awardDocument = awardForm.getAwardDocument();
        this.getKeywordService().deleteKeyword(awardDocument.getAward());
        return mapping.findForward("basic");
    }

    public ActionForward editOrVersion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward;
        AwardForm awardForm = (AwardForm)form;
        AwardDocument awardDocument = awardForm.getAwardDocument();
        Award award = awardDocument.getAward();
        AwardDocument parentSyncAward = this.getAwardSyncService().getAwardLockingHierarchyForSync(awardDocument, GlobalVariables.getUserSession().getPrincipalId());
        if (parentSyncAward != null) {
            KNSGlobalVariables.getMessageList().add("error.award.awardhierarchy.sync.locked", new String[]{parentSyncAward.getDocumentNumber()});
            return mapping.findForward("basic");
        }
        if (this.getTimeAndMoneyExistenceService().validateTimeAndMoneyRule(award, awardForm.getAwardHierarchyBean().getRootNode().getAwardNumber())) {
            if (award.getAwardSequenceStatus().equalsIgnoreCase("PENDING")) {
                response.sendRedirect(this.buildForwardUrl(awardForm.getDocId()));
                return null;
            }
            forward = this.checkVersionAndEdit(mapping, form, request, response, awardForm, award);
        } else {
            this.getTimeAndMoneyExistenceService().addAwardVersionErrorMessage();
            forward = mapping.findForward("basic");
        }
        return forward;
    }

    public ActionForward checkVersionAndEdit(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, AwardForm awardForm, Award award) throws Exception {
        ActionForward forward;
        VersionHistory foundPending = this.getVersionHistoryService().findPendingVersion(award);
        this.cleanUpUserSession();
        if (foundPending != null) {
            String question = request.getParameter("buttonClicked");
            forward = question == null ? this.showPromptForEditingPendingVersion(mapping, form, request, response) : this.processPromptForEditingPendingVersionResponse(mapping, request, response, awardForm, foundPending);
        } else if (this.getVersionHistoryService().isAnotherUserEditingDocument(award.getAwardDocument().getDocumentNumber())) {
            this.getGlobalVariableService().getMessageMap().putError("document.documentHeader.documentNumber", "message.document.version.another.user.editing", new String[]{"Award", this.globalVariableService.getUserSession().getPerson().getFirstName(), this.globalVariableService.getUserSession().getPerson().getLastName(), this.globalVariableService.getUserSession().getPrincipalName()});
            forward = mapping.findForward("basic");
        } else {
            if (this.getVersionHistoryService().isVersionLockOn()) {
                this.getPessimisticLockService().generateNewLock(award.getAwardDocument().getDocumentNumber(), this.getVersionHistoryService().getVersionLockDescriptor(award.getAwardDocument().getDocumentTypeCode(), award.getAwardDocument().getDocumentNumber()), this.getGlobalVariableService().getUserSession().getPerson());
            }
            awardForm.getAwardDocument().refreshReferenceObject(AWARD_LIST);
            AwardDocument newAwardDocument = this.getAwardVersionService().createAndSaveNewAwardVersion(awardForm.getAwardDocument());
            this.reinitializeAwardForm(awardForm, newAwardDocument);
            forward = new ActionForward(this.buildForwardUrl(newAwardDocument.getDocumentNumber()), true);
        }
        return forward;
    }

    public ActionForward addAwardTransferringSponsor(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ((AwardForm)form).getDetailsAndDatesFormHelper().addAwardTransferringSponsor();
        return mapping.findForward("basic");
    }

    public ActionForward deleteAwardTransferringSponsor(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ((AwardForm)form).getDetailsAndDatesFormHelper().deleteAwardTransferringSponsor(this.getLineToDelete(request));
        return mapping.findForward("basic");
    }

    public ActionForward deleteAwardFundingProposal(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ((AwardForm)form).getFundingProposalBean().deleteAwardFundingProposal(this.getLineToDelete(request));
        return mapping.findForward("basic");
    }

    protected Award findSelectedAward(String awardId) {
        HashMap<String, String> fieldMap = new HashMap<String, String>();
        fieldMap.put("awardId", awardId);
        List awards = (List)this.getBusinessObjectService().findMatching(Award.class, fieldMap);
        return (Award)awards.get(0);
    }

    private void initializeFormWithAward(AwardForm awardForm, Award award) throws WorkflowException {
        this.reinitializeAwardForm(awardForm, this.findDocumentForAward(award));
    }

    private AwardDocument findDocumentForAward(Award award) throws WorkflowException {
        AwardDocument document = (AwardDocument)this.getDocumentService().getByDocumentHeaderId(award.getAwardDocument().getDocumentNumber());
        document.setAward(award);
        return document;
    }

    private void reinitializeAwardForm(AwardForm awardForm, AwardDocument document) throws WorkflowException {
        awardForm.populateHeaderFields(document.getDocumentHeader().getWorkflowDocument());
        awardForm.setDocument((Document)document);
        document.setDocumentSaveAfterAwardLookupEditOrVersion(true);
        awardForm.initialize();
    }

    private ActionForward showPromptForEditingPendingVersion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.performQuestionWithoutInput(mapping, form, request, response, "EDIT_OR_VERSION_QUESTION_ID", this.getResources(request).getMessage(AWARD_VERSION_EDITPENDING_PROMPT_KEY), "confirmationQuestion", "cancel", "");
    }

    private ActionForward processPromptForEditingPendingVersionResponse(ActionMapping mapping, HttpServletRequest request, HttpServletResponse response, AwardForm awardForm, VersionHistory foundPending) throws WorkflowException, IOException {
        ActionForward forward;
        String buttonClicked = request.getParameter("buttonClicked");
        if ("1".equals(buttonClicked)) {
            forward = mapping.findForward("basic");
        } else {
            this.initializeFormWithAward(awardForm, (Award)foundPending.getSequenceOwner());
            response.sendRedirect(this.buildForwardUrl(awardForm.getAwardDocument().getDocumentNumber()));
            forward = null;
        }
        return forward;
    }

    public ActionForward applySponsorTemplate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        ActionForward result = this.fullSyncToAwardTemplate(mapping, form, request, response);
        awardForm.buildReportTrackingBeans();
        return result;
    }

    private ActionForward redirectAwardHistoryFullViewForPopup(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, String awardDocumentNumber, String awardNumber) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        response.sendRedirect("awardHistory.do?methodToCall=openWindow&awardDocumentNumber=" + awardDocumentNumber + "&awardNumber=" + awardNumber + "&docTypeName=" + awardForm.getDocTypeName());
        return null;
    }

    public GlobalVariableService getGlobalVariableService() {
        if (this.globalVariableService == null) {
            this.globalVariableService = KcServiceLocator.getService(GlobalVariableService.class);
        }
        return this.globalVariableService;
    }
}

