/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.external.budget.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.budget.framework.calculator.BudgetCalculationService;
import org.kuali.coeus.common.budget.framework.core.CostElement;
import org.kuali.coeus.common.budget.framework.rate.RateType;
import org.kuali.coeus.sys.api.model.AbstractDecimal;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.kfs.kc_kfs.v2_0.BudgetAdjustmentCreationStatusDTO;
import org.kuali.kfs.kc_kfs.v2_0.BudgetAdjustmentParametersDTO;
import org.kuali.kfs.kc_kfs.v2_0.Details;
import org.kuali.kfs.module.external.kc.service.BudgetAdjustmentService;
import org.kuali.kra.award.budget.AwardBudgetExt;
import org.kuali.kra.award.budget.document.AwardBudgetDocument;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.external.budget.BudgetAdjustmentClient;
import org.kuali.kra.external.budget.BudgetAdjustmentServiceHelper;
import org.kuali.kra.external.budget.FinancialObjectCodeMapping;
import org.kuali.kra.external.budget.RateClassRateType;
import org.kuali.kra.external.unit.service.InstitutionalUnitService;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.ObjectUtils;

public abstract class BudgetAdjustmentClientBase
implements BudgetAdjustmentClient {
    protected static final String SOAP_SERVICE_NAME = "budgetAdjustmentServiceSOAP";
    protected static final QName SERVICE_NAME = new QName("http://kfs.kuali.org/kc-kfs/v2_0", "budgetAdjustmentServiceSOAP");
    private static final Logger LOG = LogManager.getLogger(BudgetAdjustmentClientBase.class);
    private DocumentService documentService;
    private ParameterService parameterService;
    private BudgetCalculationService budgetCalculationService;
    private BusinessObjectService businessObjectService;
    private InstitutionalUnitService institutionalUnitService;
    private BudgetAdjustmentServiceHelper budgetAdjustmentServiceHelper;
    private ConfigurationService configurationService;

    protected abstract BudgetAdjustmentService getServiceHandle();

    @Override
    public void createBudgetAdjustmentDocument(AwardBudgetDocument awardBudgetDocument) throws Exception {
        BudgetAdjustmentParametersDTO parametersDTO = new BudgetAdjustmentParametersDTO();
        boolean complete = this.setBudgetAdjustmentParameters(awardBudgetDocument, parametersDTO);
        if (complete) {
            try {
                BudgetAdjustmentService port = this.getServiceHandle();
                LOG.info("Invoking createBudgetAdjustment...");
                BudgetAdjustmentCreationStatusDTO budgetAdjustmentStatus = port.createBudgetAdjustment(parametersDTO);
                if (budgetAdjustmentStatus.getStatus().equalsIgnoreCase("success")) {
                    Object completeErrorMessage;
                    if (budgetAdjustmentStatus.getDocumentNumber() == null) {
                        GlobalVariables.getMessageMap().putError("GlobalMessages", "error.award.createAccount.nullDocumentNumber", new String[0]);
                        awardBudgetDocument.refresh();
                        completeErrorMessage = "Document number returned from KFS budget adjustment service is null.";
                        GlobalVariables.getMessageMap().putError("GLOBAL_ERRORS", "error.award.budget.adjustment.document.not.created", new String[]{completeErrorMessage});
                        LOG.warn((String)completeErrorMessage);
                    } else {
                        awardBudgetDocument.getBudget().setBudgetAdjustmentDocumentNumber(budgetAdjustmentStatus.getDocumentNumber());
                        this.documentService.saveDocument((Document)awardBudgetDocument);
                    }
                    if (ObjectUtils.isNotNull(budgetAdjustmentStatus.getErrorMessages()) && !budgetAdjustmentStatus.getErrorMessages().isEmpty()) {
                        completeErrorMessage = "";
                        List<String> errorMessages = budgetAdjustmentStatus.getErrorMessages();
                        for (String errorMessage : errorMessages) {
                            completeErrorMessage = (String)completeErrorMessage + errorMessage;
                        }
                        GlobalVariables.getMessageMap().putError("GLOBAL_ERRORS", "error.budget.adjustment.saved.with.errors", new String[]{completeErrorMessage});
                    }
                } else {
                    Object completeErrorMessage = "";
                    List<String> errorMessages = budgetAdjustmentStatus.getErrorMessages();
                    for (String errorMessage : errorMessages) {
                        completeErrorMessage = (String)completeErrorMessage + errorMessage;
                    }
                    GlobalVariables.getMessageMap().putError("GLOBAL_ERRORS", "error.award.budget.adjustment.document.not.created", new String[]{completeErrorMessage});
                }
            }
            catch (WebServiceException e) {
                String errorMessage = "Cannot connect to the service. The service may be down, please try again later.";
                GlobalVariables.getMessageMap().putError("GLOBAL_ERRORS", "error.award.createAccount.cannotConnect", new String[0]);
                LOG.error(errorMessage + e.getMessage(), (Throwable)e);
            }
        }
    }

    public boolean setBudgetAdjustmentParameters(AwardBudgetDocument awardBudgetDocument, BudgetAdjustmentParametersDTO parametersDTO) throws Exception {
        boolean complete = true;
        complete &= this.createBudgetAdjustmentDocumentHeader(awardBudgetDocument, parametersDTO);
        this.budgetCalculationService.calculateBudgetSummaryTotals(awardBudgetDocument.getAwardBudget());
        HashMap<String, ScaleTwoDecimal> accountingLines = new HashMap<String, ScaleTwoDecimal>();
        complete &= this.setNonPersonnelAccountingLines(awardBudgetDocument, accountingLines);
        complete &= this.setNonPersonnelCalculatedDirectCostAccountingLines(awardBudgetDocument, accountingLines);
        complete &= this.setPersonnelSalaryAccountingLines(awardBudgetDocument, accountingLines);
        complete &= this.setPersonnnelCalculatedDirectCost(awardBudgetDocument, accountingLines);
        complete &= this.setIndirectCostAccountingLine(awardBudgetDocument, accountingLines);
        complete &= this.setPersonnelFringeAccountingLines(awardBudgetDocument, accountingLines);
        this.createAccountingLines(accountingLines, awardBudgetDocument, parametersDTO);
        if (accountingLines.isEmpty()) {
            int period = awardBudgetDocument.getBudget().getBudgetPeriods().size();
            GlobalVariables.getMessageMap().putError("GLOBAL_ERRORS", "error.award.budget.adjustment.empty.accounting.lines", new String[]{"" + period});
            complete &= false;
        }
        return complete;
    }

    protected boolean setPersonnnelCalculatedDirectCost(AwardBudgetDocument awardBudgetDocument, Map<String, ScaleTwoDecimal> accountingLines) {
        AwardBudgetExt currentBudget = awardBudgetDocument.getBudget();
        AwardBudgetExt previousBudget = this.getPrevBudget(awardBudgetDocument);
        boolean complete = true;
        Map<RateClassRateType, ScaleTwoDecimal> netPersonnelCalculatedDirectCost = this.getBudgetAdjustmentServiceHelper().getPersonnelCalculatedDirectCost(currentBudget, previousBudget);
        for (RateClassRateType rate : netPersonnelCalculatedDirectCost.keySet()) {
            LOG.info("Personnel calculated direct cost: " + rate.getRateType() + "-" + rate.getRateClass() + " = " + netPersonnelCalculatedDirectCost.get(rate));
            String financialObjectCode = this.getFinancialObjectCode(awardBudgetDocument, rate.getRateClass(), rate.getRateType());
            if (ObjectUtils.isNull((Object)financialObjectCode)) {
                complete &= false;
                continue;
            }
            if (!accountingLines.containsKey(financialObjectCode)) {
                accountingLines.put(financialObjectCode, netPersonnelCalculatedDirectCost.get(rate));
                continue;
            }
            accountingLines.put(financialObjectCode, (ScaleTwoDecimal)accountingLines.get(financialObjectCode).add((AbstractDecimal)netPersonnelCalculatedDirectCost.get(rate)));
        }
        return complete;
    }

    protected boolean setIndirectCostAccountingLine(AwardBudgetDocument awardBudgetDocument, Map<String, ScaleTwoDecimal> accountingLines) {
        AwardBudgetExt currentBudget = awardBudgetDocument.getBudget();
        AwardBudgetExt previousBudget = this.getPrevBudget(awardBudgetDocument);
        boolean complete = true;
        Map<RateClassRateType, ScaleTwoDecimal> netIndirectCost = this.getBudgetAdjustmentServiceHelper().getIndirectCost(currentBudget, previousBudget);
        for (RateClassRateType rate : netIndirectCost.keySet()) {
            Details details = new Details();
            details.setCurrentAmount(netIndirectCost.get(rate).toString());
            LOG.info("Indirect cost: " + rate.getRateType() + "-" + rate.getRateClass() + " = " + netIndirectCost.get(rate));
            String financialObjectCode = this.getFinancialObjectCode(awardBudgetDocument, rate.getRateClass(), rate.getRateType());
            if (ObjectUtils.isNull((Object)financialObjectCode)) {
                complete &= false;
                continue;
            }
            if (!accountingLines.containsKey(financialObjectCode)) {
                accountingLines.put(financialObjectCode, netIndirectCost.get(rate));
                continue;
            }
            accountingLines.put(financialObjectCode, (ScaleTwoDecimal)accountingLines.get(financialObjectCode).add((AbstractDecimal)netIndirectCost.get(rate)));
        }
        return complete;
    }

    protected boolean setPersonnelFringeAccountingLines(AwardBudgetDocument awardBudgetDocument, Map<String, ScaleTwoDecimal> accountingLines) {
        AwardBudgetExt currentBudget = awardBudgetDocument.getBudget();
        AwardBudgetExt previousBudget = this.getPrevBudget(awardBudgetDocument);
        boolean complete = true;
        Map<RateClassRateType, ScaleTwoDecimal> netFringeCost = this.getBudgetAdjustmentServiceHelper().getPersonnelFringeCost(currentBudget, previousBudget);
        for (RateClassRateType rate : netFringeCost.keySet()) {
            LOG.info("Personnel fringe cost: " + rate.getRateType() + "-" + rate.getRateClass() + " = " + netFringeCost.get(rate));
            String financialObjectCode = this.getFinancialObjectCode(awardBudgetDocument, rate.getRateClass(), rate.getRateType());
            if (ObjectUtils.isNull((Object)financialObjectCode)) {
                complete &= false;
                continue;
            }
            if (!accountingLines.containsKey(financialObjectCode)) {
                accountingLines.put(financialObjectCode, netFringeCost.get(rate));
                continue;
            }
            accountingLines.put(financialObjectCode, (ScaleTwoDecimal)accountingLines.get(financialObjectCode).add((AbstractDecimal)netFringeCost.get(rate)));
        }
        return complete;
    }

    protected boolean setPersonnelSalaryAccountingLines(AwardBudgetDocument awardBudgetDocument, Map<String, ScaleTwoDecimal> accountingLines) throws Exception {
        AwardBudgetExt currentBudget = awardBudgetDocument.getBudget();
        AwardBudgetExt previousBudget = this.getPrevBudget(awardBudgetDocument);
        boolean complete = true;
        SortedMap<String, ScaleTwoDecimal> netCost = this.getBudgetAdjustmentServiceHelper().getPersonnelSalaryCost(currentBudget, previousBudget);
        for (String name : netCost.keySet()) {
            String financialObjectCode = this.getFinancialObjectCode(name);
            if (ObjectUtils.isNull((Object)financialObjectCode)) {
                complete &= false;
                continue;
            }
            if (!accountingLines.containsKey(financialObjectCode)) {
                accountingLines.put(financialObjectCode, (ScaleTwoDecimal)netCost.get(name));
                continue;
            }
            accountingLines.put(financialObjectCode, (ScaleTwoDecimal)accountingLines.get(financialObjectCode).add((AbstractDecimal)((ScaleTwoDecimal)netCost.get(name))));
        }
        return complete;
    }

    protected boolean setNonPersonnelCalculatedDirectCostAccountingLines(AwardBudgetDocument awardBudgetDocument, Map<String, ScaleTwoDecimal> accountingLines) {
        boolean complete = true;
        AwardBudgetExt currentBudget = awardBudgetDocument.getBudget();
        AwardBudgetExt previousBudget = this.getPrevBudget(awardBudgetDocument);
        SortedMap<RateType, ScaleTwoDecimal> netExpense = this.getBudgetAdjustmentServiceHelper().getNonPersonnelCalculatedDirectCost(currentBudget, previousBudget);
        SortedMap<RateType, List<ScaleTwoDecimal>> currentNonPersonnelCalcDirectCost = awardBudgetDocument.getAwardBudget().getNonPersonnelCalculatedExpenseTotals();
        for (RateType rateType : netExpense.keySet()) {
            LOG.info("NonPersonnel calculated direct cost: " + rateType.getRateTypeCode() + "-" + rateType.getRateClassCode() + " = " + netExpense.get(rateType));
            if (rateType.getRateClass().getRateClassTypeCode().equalsIgnoreCase("O")) continue;
            List expenses = (List)currentNonPersonnelCalcDirectCost.get(rateType);
            Details details = new Details();
            details.setCurrentAmount(((ScaleTwoDecimal)netExpense.get(rateType)).toString());
            String financialObjectCode = this.getFinancialObjectCode(awardBudgetDocument, rateType.getRateClassCode(), rateType.getRateTypeCode());
            if (ObjectUtils.isNull((Object)financialObjectCode)) {
                complete &= false;
                continue;
            }
            if (!accountingLines.containsKey(financialObjectCode)) {
                accountingLines.put(financialObjectCode, (ScaleTwoDecimal)netExpense.get(rateType));
                continue;
            }
            accountingLines.put(financialObjectCode, (ScaleTwoDecimal)accountingLines.get(financialObjectCode).add((AbstractDecimal)((ScaleTwoDecimal)netExpense.get(rateType))));
        }
        return complete;
    }

    protected boolean setNonPersonnelAccountingLines(AwardBudgetDocument awardBudgetDocument, Map<String, ScaleTwoDecimal> accountingLines) {
        AwardBudgetExt currentBudget = awardBudgetDocument.getBudget();
        AwardBudgetExt previousBudget = this.getPrevBudget(awardBudgetDocument);
        HashMap<String, ScaleTwoDecimal> nonPersonnelCost = this.getBudgetAdjustmentServiceHelper().getNonPersonnelCost(currentBudget, previousBudget);
        boolean complete = true;
        for (String costElement : nonPersonnelCost.keySet()) {
            if (ObjectUtils.isNotNull((Object)this.getFinancialObjectCode(costElement))) {
                ScaleTwoDecimal currentAmount = (ScaleTwoDecimal)nonPersonnelCost.get(costElement).abs();
                if (!currentAmount.isNonZero()) continue;
                String financialObjectCode = this.getFinancialObjectCode(costElement);
                if (!accountingLines.containsKey(financialObjectCode)) {
                    accountingLines.put(financialObjectCode, nonPersonnelCost.get(costElement));
                } else {
                    accountingLines.put(financialObjectCode, (ScaleTwoDecimal)accountingLines.get(financialObjectCode).add((AbstractDecimal)nonPersonnelCost.get(costElement)));
                }
                LOG.info("NonPersonnelCalculatedDirectCost OC: " + financialObjectCode + " = " + accountingLines.get(financialObjectCode));
                continue;
            }
            GlobalVariables.getMessageMap().putError("GLOBAL_ERRORS", "error.award.budget.adjustment.financial.objectCode.mapping.not.found", new String[]{"Object Code: " + costElement});
            complete &= false;
        }
        return complete;
    }

    protected AwardBudgetExt getPrevBudget(AwardBudgetDocument awardBudgetDocument) {
        int currentVersionNumber = awardBudgetDocument.getBudget().getBudgetVersionNumber();
        AwardBudgetExt prevBudget = this.getPrevBudget((AwardDocument)awardBudgetDocument.getBudget().getBudgetParent().getDocument());
        if (ObjectUtils.isNotNull((Object)prevBudget.getBudgetVersionNumber()) && prevBudget.getBudgetVersionNumber() < currentVersionNumber) {
            this.budgetCalculationService.calculateBudgetSummaryTotals(prevBudget);
            return prevBudget;
        }
        return null;
    }

    protected String getParameterValue(String awardBudgetParameter) {
        return this.parameterService.getParameterValueAsString(AwardBudgetDocument.class, awardBudgetParameter);
    }

    protected String getPostedBudgetStatus() {
        return this.getParameterValue("awardBudgetStatusPosted");
    }

    protected AwardBudgetExt getPrevBudget(AwardDocument awardDocument) {
        return this.getNewestBudgetByStatus(awardDocument, Arrays.asList(this.getPostedBudgetStatus()));
    }

    protected AwardBudgetExt getNewestBudgetByStatus(AwardDocument awardDocument, List<String> statuses) {
        AwardBudgetExt result = null;
        for (AwardBudgetExt curVersion : awardDocument.getAward().getBudgets()) {
            if (!statuses.contains(curVersion.getAwardBudgetStatusCode()) || result != null && curVersion.getBudgetVersionNumber() <= result.getBudgetVersionNumber()) continue;
            result = curVersion;
        }
        if (result == null) {
            result = new AwardBudgetExt();
        }
        return result;
    }

    protected boolean createBudgetAdjustmentDocumentHeader(AwardBudgetDocument awardBudgetDocument, BudgetAdjustmentParametersDTO parametersDTO) {
        parametersDTO.setOrgDocNumber("");
        Award award = awardBudgetDocument.getBudget().getBudgetParent();
        parametersDTO.setSponsorType(award.getSponsor().getSponsorTypeCode());
        String COMMENT = "Generated from award budget -" + awardBudgetDocument.getDocumentNumber();
        parametersDTO.setDescription(COMMENT);
        parametersDTO.setPrincipalId(GlobalVariables.getUserSession().getPrincipalId());
        return true;
    }

    protected void createAccountingLines(Map<String, ScaleTwoDecimal> accountingLines, AwardBudgetDocument awardBudgetDocument, BudgetAdjustmentParametersDTO parametersDTO) {
        for (String objectCode : accountingLines.keySet()) {
            if (!accountingLines.get(objectCode).isNonZero()) continue;
            Details details = new Details();
            details.setCurrentAmount(accountingLines.get(objectCode).toString());
            details.setObjectCode(objectCode);
            details.setChart(this.getAwardChart(awardBudgetDocument));
            details.setAccount(this.getAwardAccount(awardBudgetDocument));
            details.setProjectCode("");
            details.setSubAccount("");
            parametersDTO.getDetails().add(details);
            LOG.info("ObjectCode: " + objectCode + "Amount: " + accountingLines.get(objectCode));
        }
    }

    protected String getAwardChart(AwardBudgetDocument awardBudgetDocument) {
        Award award = awardBudgetDocument.getBudget().getBudgetParent();
        return award.getFinancialChartOfAccountsCode();
    }

    protected String getFinancialObjectCode(AwardBudgetDocument awardBudgetDocument, String rateClassCode, String rateTypeCode) {
        Award award = awardBudgetDocument.getBudget().getBudgetParent();
        String activityTypeCode = award.getActivityTypeCode();
        String awardUnitNumber = award.getUnitNumber();
        List<FinancialObjectCodeMapping> results = this.getFinancialObjectCodesFromMappingTable(rateClassCode, rateTypeCode, awardUnitNumber);
        if (results.isEmpty()) {
            List<String> parentUnits = this.institutionalUnitService.getParentUnits(awardUnitNumber);
            for (String currentUnitNumber : parentUnits) {
                List<FinancialObjectCodeMapping> parentUnitResults = this.getFinancialObjectCodesFromMappingTable(rateClassCode, rateTypeCode, currentUnitNumber);
                if (parentUnitResults.isEmpty()) continue;
                return parentUnitResults.get(0).getFinancialObjectCode();
            }
            GlobalVariables.getMessageMap().putError("GLOBAL_ERRORS", "error.award.budget.adjustment.financial.objectCode.mapping.not.found", new String[]{" Rate Class Code: " + rateClassCode + " Rate Type Code: " + rateTypeCode + " Unit: " + award.getUnitNumber() + " Activity Type: " + award.getActivityTypeCode()});
            LOG.error("Mapping not found for rateClasssCode: " + rateClassCode + "rateTypeCode: " + rateTypeCode + "unitnumber: ");
            return null;
        }
        for (FinancialObjectCodeMapping result : results) {
            if (!ObjectUtils.isNotNull((Object)result.getActivityTypeCode()) || !result.getActivityTypeCode().equalsIgnoreCase(activityTypeCode)) continue;
            return result.getFinancialObjectCode();
        }
        LOG.info("Returning" + results.get(0).getFinancialObjectCode());
        return results.get(0).getFinancialObjectCode();
    }

    protected String getFinancialObjectCode(String costElementName) {
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("costElement", costElementName);
        CostElement costElement = (CostElement)this.getBusinessObjectService().findByPrimaryKey(CostElement.class, criteria);
        if (ObjectUtils.isNull((Object)costElement.getFinancialObjectCode())) {
            GlobalVariables.getMessageMap().putError("GLOBAL_ERRORS", "error.award.budget.adjustment.financial.objectCode.mapping.not.found", new String[]{"Object Code: " + costElementName});
            LOG.error("No financial system object code mapped to object code " + costElementName + " .");
        }
        return costElement.getFinancialObjectCode();
    }

    protected List<FinancialObjectCodeMapping> getFinancialObjectCodesFromMappingTable(String rateClassCode, String rateTypeCode, String unitNumber) {
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("rateClassCode", rateClassCode);
        criteria.put("rateTypeCode", rateTypeCode);
        criteria.put("unitNumber", unitNumber);
        ArrayList<FinancialObjectCodeMapping> results = new ArrayList<FinancialObjectCodeMapping>(this.businessObjectService.findMatching(FinancialObjectCodeMapping.class, criteria));
        return results;
    }

    protected String getAwardAccount(AwardBudgetDocument awardBudgetDocument) {
        Award award = awardBudgetDocument.getBudget().getBudgetParent();
        return award.getAccountNumber();
    }

    protected BudgetAdjustmentServiceHelper getBudgetAdjustmentServiceHelper() {
        return this.budgetAdjustmentServiceHelper;
    }

    @Override
    public void setBudgetAdjustmentServiceHelper(BudgetAdjustmentServiceHelper budgetAdjustmentServiceHelper) {
        this.budgetAdjustmentServiceHelper = budgetAdjustmentServiceHelper;
    }

    @Override
    public void setInstitutionalUnitService(InstitutionalUnitService institutionalUnitService) {
        this.institutionalUnitService = institutionalUnitService;
    }

    protected BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    @Override
    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    @Override
    public void setBudgetCalculationService(BudgetCalculationService budgetCalculationService) {
        this.budgetCalculationService = budgetCalculationService;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    @Override
    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    @Override
    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    @Override
    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }
}

