/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.external.dunningcampaign;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.kc_kfs.v2_0.DunningCampaignDTO;
import org.kuali.kfs.kc_kfs.v2_0.HashMapElement;
import org.kuali.kfs.module.external.kc.service.DunningCampaignService;
import org.kuali.kra.external.dunningcampaign.DunningCampaign;
import org.kuali.kra.external.dunningcampaign.DunningCampaignClient;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;

public abstract class DunningCampaignClientBase
implements DunningCampaignClient {
    protected static final String SOAP_SERVICE_NAME = "dunningCampaignServiceSOAP";
    protected static final QName SERVICE_NAME = new QName("http://kfs.kuali.org/kc-kfs/v2_0", "dunningCampaignServiceSOAP");
    private static final String ERROR_MESSAGE = "Cannot connect to the service. The service may be down, please try again later.";
    private static final Logger LOG = LogManager.getLogger(DunningCampaignClientBase.class);
    private ParameterService parameterService;

    protected abstract DunningCampaignService getServiceHandle();

    @Override
    public DunningCampaign getDunningCampaign(String campaignID) {
        try {
            DunningCampaignService port = this.getServiceHandle();
            LOG.info("Connecting to financial system...");
            DunningCampaign campaign = this.getDunningCampaign(port.getDunningCampaign(campaignID));
            return campaign;
        }
        catch (Exception e) {
            LOG.error(ERROR_MESSAGE + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    protected DunningCampaign getDunningCampaign(DunningCampaignDTO dto) {
        if (dto != null) {
            DunningCampaign campaign = new DunningCampaign();
            campaign.setCampaignID(dto.getCampaignID());
            campaign.setCampaignDescription(dto.getCampaignDescription());
            campaign.setActive(dto.isActive());
            return campaign;
        }
        return null;
    }

    protected List<DunningCampaign> getDunningCampaign(List<DunningCampaignDTO> dtos) {
        if (dtos != null) {
            ArrayList<DunningCampaign> result = new ArrayList<DunningCampaign>();
            for (DunningCampaignDTO dto : dtos) {
                result.add(this.getDunningCampaign(dto));
            }
            return result;
        }
        return null;
    }

    @Override
    public List<DunningCampaign> getMatching(Map<String, String> searchCriteria) {
        try {
            ArrayList<HashMapElement> mapElements = new ArrayList<HashMapElement>();
            for (Map.Entry<String, String> entry : searchCriteria.entrySet()) {
                HashMapElement element = new HashMapElement();
                element.setKey(entry.getKey());
                element.setValue(entry.getValue());
                mapElements.add(element);
            }
            DunningCampaignService port = this.getServiceHandle();
            LOG.info("Connecting to financial system...");
            List<DunningCampaign> campaigns = this.getDunningCampaign(port.getMatching(mapElements));
            return campaigns;
        }
        catch (Exception e) {
            LOG.error(ERROR_MESSAGE + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    protected ParameterService getParameterService() {
        return this.parameterService;
    }

    @Override
    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }
}

