/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.actions.decision;

import java.util.ArrayList;
import java.util.List;
import org.kuali.coeus.common.committee.impl.lookup.keyvalue.CommitteeDecisionMotionValuesFinder;
import org.kuali.kra.iacuc.IacucProtocol;
import org.kuali.kra.iacuc.IacucProtocolDocument;
import org.kuali.kra.iacuc.actions.submit.IacucProtocolSubmission;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.krad.document.Document;

public class IacucCommitteeDecisionMotionValuesFinder
extends CommitteeDecisionMotionValuesFinder {
    private static final long serialVersionUID = -449881228899486120L;

    @Override
    public List<KeyValue> getKeyValues() {
        List<KeyValue> originalList = super.getKeyValues();
        ArrayList<KeyValue> newList = new ArrayList<KeyValue>();
        for (KeyValue originalKV : originalList) {
            if ("3".equals(originalKV.getKey())) {
                newList.add((KeyValue)new ConcreteKeyValue("3", "Minor Revisions"));
                continue;
            }
            if ("4".equals(originalKV.getKey())) {
                newList.add((KeyValue)new ConcreteKeyValue("4", "Major Revisions"));
                continue;
            }
            newList.add(originalKV);
        }
        List<KeyValue> returnList = this.removeDisallowedMotions(newList);
        return returnList;
    }

    private List<KeyValue> removeDisallowedMotions(List<KeyValue> srcList) {
        ArrayList<KeyValue> returnList = new ArrayList<KeyValue>();
        IacucProtocol protocol = this.getProtocol();
        boolean isFYI = false;
        boolean isDMR = false;
        if (null != protocol) {
            IacucProtocolSubmission submission = (IacucProtocolSubmission)protocol.getProtocolSubmission();
            if (null != submission && "4".equals(submission.getProtocolReviewTypeCode())) {
                isFYI = true;
            } else if (null != submission && "2".equals(submission.getProtocolReviewTypeCode())) {
                isDMR = true;
            }
        }
        for (KeyValue srcKV : srcList) {
            if (isFYI) {
                if ("1".equals(srcKV.getKey()) || "3".equals(srcKV.getKey()) || "4".equals(srcKV.getKey())) continue;
                returnList.add(srcKV);
                continue;
            }
            if (isDMR) {
                if ("2".equals(srcKV.getKey())) continue;
                returnList.add(srcKV);
                continue;
            }
            returnList.add(srcKV);
        }
        return returnList;
    }

    private IacucProtocol getProtocol() {
        IacucProtocol retVal = null;
        Document document = this.getDocument();
        if (document != null && document instanceof IacucProtocolDocument) {
            retVal = ((IacucProtocolDocument)document).getProtocol();
        }
        return retVal;
    }
}

