/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.institutionalproposal.document.authorization;

import java.util.Map;
import java.util.Set;
import org.kuali.coeus.common.framework.auth.perm.KcAuthorizationService;
import org.kuali.coeus.sys.framework.model.KcTransactionalDocumentBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.institutionalproposal.document.InstitutionalProposalDocument;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kns.document.authorization.TransactionalDocumentAuthorizer;
import org.kuali.rice.kns.document.authorization.TransactionalDocumentAuthorizerBase;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.util.GlobalVariables;

public class InstitutionalProposalDocumentAuthorizer
extends TransactionalDocumentAuthorizerBase
implements TransactionalDocumentAuthorizer {
    public static final String ALLOW_INIT_FOR_DISAPPROVED_PD_SESSION_KEY = "DISAPPROVED_PD_WITH_LINKED_IP";

    public Set<String> getDocumentActions(Document document, Person user, Set<String> documentActions) {
        Set actions = super.getDocumentActions(document, user, documentActions);
        InstitutionalProposalDocument institutionalProposalDocument = (InstitutionalProposalDocument)document;
        if (this.canMaintainInstitutionalProposal(user, institutionalProposalDocument)) {
            actions.add("CAN_MAINTAIN_IP_ATTACHMENTS");
        }
        if (actions.contains("CAN_MAINTAIN_IP_ATTACHMENTS") || this.canViewInstitutionalProposalAttachments(user, institutionalProposalDocument)) {
            actions.add("CAN_VIEW_IP_ATTACHMENTS");
        }
        return actions;
    }

    protected void addRoleQualification(Object primaryBusinessObjectOrDocument, Map<String, String> attributes) {
        super.addRoleQualification(primaryBusinessObjectOrDocument, attributes);
        InstitutionalProposalDocument institutionalProposalDocument = (InstitutionalProposalDocument)primaryBusinessObjectOrDocument;
        if (institutionalProposalDocument.getInstitutionalProposal() != null && institutionalProposalDocument.getInstitutionalProposal().getLeadUnit() != null) {
            attributes.put("unitNumber", institutionalProposalDocument.getInstitutionalProposal().getLeadUnit().getUnitNumber());
        } else {
            attributes.put("unitNumber", "*");
        }
    }

    public boolean canInitiate(String documentTypeName, Person user) {
        if (GlobalVariables.getUserSession().getObjectMap().get(ALLOW_INIT_FOR_DISAPPROVED_PD_SESSION_KEY) != null) {
            GlobalVariables.getUserSession().removeObject(ALLOW_INIT_FOR_DISAPPROVED_PD_SESSION_KEY);
            return true;
        }
        return super.canInitiate(documentTypeName, user);
    }

    public boolean canBlanketApprove(Document document, Person user) {
        return !((KcTransactionalDocumentBase)document).isViewOnly() && super.canBlanketApprove(document, user);
    }

    public boolean canRoute(Document document, Person user) {
        return !((KcTransactionalDocumentBase)document).isViewOnly() && super.canRoute(document, user);
    }

    public boolean canCancel(Document document, Person user) {
        return !((KcTransactionalDocumentBase)document).isViewOnly() && super.canCancel(document, user);
    }

    private boolean canViewInstitutionalProposalAttachments(Person user, InstitutionalProposalDocument document) {
        return this.getKcAuthorizationService().hasPermission(user.getPrincipalId(), document, "View Proposal") || this.getKcAuthorizationService().hasPermission(user.getPrincipalId(), document, "Cancel Institutional Proposal") || this.getKcAuthorizationService().hasPermission(user.getPrincipalId(), document, "Save Institutional Proposal") || this.getKcAuthorizationService().hasPermission(user.getPrincipalId(), document, "Submit Institutional Proposal") || this.getKcAuthorizationService().hasPermission(user.getPrincipalId(), document, "Initiate Document");
    }

    private boolean canMaintainInstitutionalProposal(Person user, InstitutionalProposalDocument document) {
        return this.getKcAuthorizationService().hasPermission(user.getPrincipalId(), document, "Create Institutional Proposal") || this.getKcAuthorizationService().hasPermission(user.getPrincipalId(), document, "Edit Institutional Proposal");
    }

    private KcAuthorizationService getKcAuthorizationService() {
        return KcServiceLocator.getService(KcAuthorizationService.class);
    }
}

