/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.negotiations.lookup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.sponsor.Sponsor;
import org.kuali.coeus.common.framework.unit.Unit;
import org.kuali.kra.lookup.KraLookupableHelperServiceImpl;
import org.kuali.kra.negotiations.bo.Negotiation;
import org.kuali.kra.negotiations.lookup.NegotiationDao;
import org.kuali.rice.kim.api.permission.PermissionService;
import org.kuali.rice.kns.lookup.HtmlData;
import org.kuali.rice.kns.lookup.LookupUtils;
import org.kuali.rice.kns.web.struts.form.LookupForm;
import org.kuali.rice.kns.web.ui.Column;
import org.kuali.rice.kns.web.ui.Field;
import org.kuali.rice.kns.web.ui.ResultRow;
import org.kuali.rice.kns.web.ui.Row;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.util.BeanPropertyComparator;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.UrlFactory;

public class NegotiationLookupableHelperServiceImpl
extends KraLookupableHelperServiceImpl {
    private static final long serialVersionUID = -5559605739121335896L;
    private static final String USER_ID = "userId";
    private static final String VIEW_ACTIVITIES = "view activities";
    private NegotiationDao negotiationDao;
    private PermissionService permissionService;

    public List<? extends BusinessObject> getSearchResults(Map<String, String> fieldValues) {
        super.setBackLocationDocFormKey(fieldValues);
        if (this.getParameters().containsKey(USER_ID)) {
            fieldValues.put("associatedNegotiable.piId", ((String[])this.getParameters().get(USER_ID))[0]);
            fieldValues.put("negotiatorPersonId", ((String[])this.getParameters().get(USER_ID))[0]);
        }
        ArrayList<Negotiation> searchResults = new ArrayList<Negotiation>();
        searchResults.addAll(this.getNegotiationDao().getNegotiationResults(fieldValues));
        List defaultSortColumns = this.getDefaultSortColumns();
        if (defaultSortColumns.size() > 0) {
            Collections.sort(searchResults, new BeanPropertyComparator(defaultSortColumns, true));
        }
        return searchResults;
    }

    @Override
    public List<HtmlData> getCustomActionUrls(BusinessObject businessObject, List pkNames) {
        ArrayList<HtmlData> htmlDataList = new ArrayList<HtmlData>();
        Negotiation negotiation = (Negotiation)businessObject;
        htmlDataList.add((HtmlData)this.getOpenLink((Document)negotiation.getDocument()));
        if (this.isAuthorizedToViewActivitiesLookup(negotiation).booleanValue()) {
            htmlDataList.add((HtmlData)this.getViewActivitiesLink(negotiation));
        }
        htmlDataList.add((HtmlData)this.getMedusaLink(negotiation.getDocument().getDocumentNumber(), false));
        return htmlDataList;
    }

    public Boolean isAuthorizedToViewActivitiesLookup(Negotiation negotiation) {
        return this.getPermissionService().isAuthorized(this.getUserIdentifier(), "KC-NEGOTIATION", "VIEW ACTIVITIES - LOOKUP", Collections.singletonMap("negotiation", negotiation.getNegotiationId().toString()));
    }

    protected HtmlData.AnchorHtmlData getOpenLink(Document document) {
        HtmlData.AnchorHtmlData htmlData = new HtmlData.AnchorHtmlData();
        htmlData.setDisplayText("open");
        Properties parameters = new Properties();
        parameters.put("methodToCall", "docHandler");
        parameters.put("command", "displayDocSearchView");
        parameters.put("docTypeName", this.getDocumentTypeName());
        parameters.put("docId", document.getDocumentNumber());
        String href = UrlFactory.parameterizeUrl((String)("../" + this.getHtmlAction()), (Properties)parameters);
        htmlData.setHref(href);
        return htmlData;
    }

    protected HtmlData.AnchorHtmlData getViewActivitiesLink(Negotiation negotiation) {
        HtmlData.AnchorHtmlData htmlData = new HtmlData.AnchorHtmlData();
        htmlData.setDisplayText(VIEW_ACTIVITIES);
        Properties parameters = new Properties();
        parameters.put("methodToCall", "viewActivities");
        parameters.put("negotiationId", negotiation.getNegotiationId().toString());
        String href = UrlFactory.parameterizeUrl((String)("../" + this.getHtmlAction()), (Properties)parameters);
        htmlData.setHref(href);
        htmlData.setId("viewLightboxActivities");
        htmlData.setAnchorClass("iframe");
        return htmlData;
    }

    @Override
    protected String getDocumentTypeName() {
        return "NegotiationDocument";
    }

    @Override
    protected String getKeyFieldName() {
        return "negotiationId";
    }

    @Override
    protected String getHtmlAction() {
        return "negotiationNegotiation.do";
    }

    public NegotiationDao getNegotiationDao() {
        return this.negotiationDao;
    }

    public void setNegotiationDao(NegotiationDao negotiationDao) {
        this.negotiationDao = negotiationDao;
    }

    @Override
    public Collection performLookup(LookupForm lookupForm, Collection resultTable, boolean bounded) {
        String leadUnitName = "associatedNegotiable.leadUnitName";
        String leadUnitNumber = "associatedNegotiable.leadUnitNumber";
        String sponsorName = "associatedNegotiable.sponsorName";
        String piName = "associatedNegotiable.piName";
        Collection lookupStuff = super.performLookup(lookupForm, resultTable, bounded);
        for (ResultRow row : resultTable) {
            for (Column column : row.getColumns()) {
                if (StringUtils.equalsIgnoreCase((CharSequence)column.getPropertyName(), (CharSequence)"associatedNegotiable.leadUnitName") || StringUtils.equalsIgnoreCase((CharSequence)column.getPropertyName(), (CharSequence)"associatedNegotiable.sponsorName") || StringUtils.equalsIgnoreCase((CharSequence)column.getPropertyName(), (CharSequence)"associatedNegotiable.piName")) {
                    column.setPropertyURL("");
                    for (HtmlData.AnchorHtmlData data : column.getColumnAnchors()) {
                        if (data == null) continue;
                        data.setHref("");
                    }
                }
                if (!StringUtils.equalsIgnoreCase((CharSequence)column.getPropertyName(), (CharSequence)"associatedNegotiable.leadUnitNumber")) continue;
                String unitNumber = column.getPropertyValue();
                String newUrl = "inquiry.do?businessObjectClassName=" + Unit.class.getName() + "&unitNumber=" + unitNumber + "&methodToCall=start";
                column.setPropertyURL(newUrl);
                for (HtmlData.AnchorHtmlData data : column.getColumnAnchors()) {
                    if (data == null) continue;
                    data.setHref(newUrl);
                }
            }
        }
        return lookupStuff;
    }

    protected void setRows() {
        super.setRows();
        List lookupFieldAttributeList = null;
        if (this.getBusinessObjectMetaDataService().isLookupable(this.getBusinessObjectClass())) {
            lookupFieldAttributeList = this.getBusinessObjectMetaDataService().getLookupableFieldNames(this.getBusinessObjectClass());
        }
        for (Row row : this.getRows()) {
            for (Field field : row.getFields()) {
                if (StringUtils.equalsIgnoreCase((CharSequence)field.getPropertyName(), (CharSequence)"associatedNegotiable.sponsorCode")) {
                    field.setQuickFinderClassNameImpl(Sponsor.class.getName());
                    field.setFieldConversions("sponsorCode:associatedNegotiable.sponsorCode");
                    field.setLookupParameters("");
                    field.setBaseLookupUrl(LookupUtils.getBaseLookupUrl((boolean)false));
                    field.setImageSrc(null);
                    field.setInquiryParameters("associatedNegotiable.sponsorCode:sponsorCode");
                    field.setFieldDirectInquiryEnabled(true);
                    continue;
                }
                if (!StringUtils.equalsIgnoreCase((CharSequence)field.getPropertyName(), (CharSequence)"associatedNegotiable.leadUnitNumber")) continue;
                field.setQuickFinderClassNameImpl(Unit.class.getName());
                field.setFieldConversions("unitNumber:associatedNegotiable.leadUnitNumber");
                field.setLookupParameters("");
                field.setBaseLookupUrl(LookupUtils.getBaseLookupUrl((boolean)false));
                field.setImageSrc(null);
                field.setInquiryParameters("associatedNegotiable.leadUnitNumber:unitNumber");
                field.setFieldDirectInquiryEnabled(true);
            }
        }
    }

    protected String getUserIdentifier() {
        return GlobalVariables.getUserSession().getPrincipalId();
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public PermissionService getPermissionService() {
        return this.permissionService;
    }
}

