/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.coeus.coi.framework.Project;
import org.kuali.coeus.coi.framework.ProjectPublisher;
import org.kuali.coeus.coi.framework.ProjectRetrievalService;
import org.kuali.coeus.common.framework.auth.perm.KcAuthorizationService;
import org.kuali.coeus.common.framework.krms.KrmsRulesExecutionService;
import org.kuali.coeus.common.framework.print.AttachmentDataSource;
import org.kuali.coeus.common.notification.impl.service.KcNotificationService;
import org.kuali.coeus.common.questionnaire.framework.answer.AnswerHeader;
import org.kuali.coeus.common.questionnaire.framework.answer.SaveQuestionnaireAnswerEvent;
import org.kuali.coeus.common.questionnaire.framework.core.QuestionnaireHelperBase;
import org.kuali.coeus.common.questionnaire.framework.print.QuestionnairePrintingService;
import org.kuali.coeus.sys.framework.controller.KcTransactionalDocumentActionBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.validation.AuditHelper;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.ProtocolDocumentBase;
import org.kuali.kra.protocol.ProtocolFormBase;
import org.kuali.kra.protocol.auth.ProtocolTaskBase;
import org.kuali.kra.protocol.auth.UnitAclLoadService;
import org.kuali.kra.protocol.notification.ProtocolNotification;
import org.kuali.kra.protocol.notification.ProtocolNotificationContextBase;
import org.kuali.kra.protocol.personnel.ProtocolPersonTrainingService;
import org.kuali.kra.protocol.personnel.ProtocolPersonnelService;
import org.kuali.kra.protocol.questionnaire.SaveProtocolQuestionnaireEvent;
import org.kuali.rice.coreservice.framework.CoreFrameworkServiceLocator;
import org.kuali.rice.kns.lookup.LookupResultsService;
import org.kuali.rice.kns.web.struts.form.KualiDocumentFormBase;
import org.kuali.rice.kns.web.struts.form.KualiForm;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.bo.Note;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.event.DocumentEvent;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.KualiRuleService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.KRADUtils;

public abstract class ProtocolActionBase
extends KcTransactionalDocumentActionBase {
    private transient ProjectPublisher projectPublisher;

    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = super.execute(mapping, form, request, response);
        ProtocolFormBase protocolForm = (ProtocolFormBase)form;
        if (protocolForm.isAuditActivated()) {
            protocolForm.setUnitRulesMessages(this.getUnitRulesMessages(protocolForm.getProtocolDocument()));
        }
        if (GlobalVariables.getAuditErrorMap().isEmpty()) {
            KcServiceLocator.getService(AuditHelper.class).auditConditionally((ProtocolFormBase)form);
        }
        return forward;
    }

    protected abstract String getProtocolForwardNameHook();

    protected abstract String getQuestionnaireForwardNameHook();

    protected abstract String getPersonnelForwardNameHook();

    protected abstract String getNoteAndAttachmentForwardNameHook();

    protected abstract String getProtocolActionsForwardNameHook();

    protected abstract String getProtocolOnlineReviewForwardNameHook();

    protected abstract String getProtocolPermissionsForwardNameHook();

    protected abstract String getSpecialReviewForwardNameHook();

    protected abstract String getCustomDataForwardNameHook();

    protected abstract ProtocolNotification getProtocolNotificationHook();

    protected abstract String getProtocolHistoryForwardNameHook();

    public ActionForward protocol(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ProtocolFormBase protocolForm = (ProtocolFormBase)form;
        protocolForm.getProtocolHelper().prepareView();
        return this.branchToPanelOrNotificationEditor(mapping, protocolForm, this.getProtocolForwardNameHook());
    }

    public ActionForward permissions(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolFormBase protocolForm = (ProtocolFormBase)form;
        protocolForm.getPermissionsHelper().prepareView();
        return this.branchToPanelOrNotificationEditor(mapping, protocolForm, this.getProtocolPermissionsForwardNameHook());
    }

    public ActionForward personnel(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ProtocolFormBase protocolForm = (ProtocolFormBase)form;
        this.getProtocolPersonnelService().selectProtocolUnit(protocolForm.getProtocolDocument().getProtocol().getProtocolPersons());
        this.getProtocolPersonTrainingService().updatePersonTrained(protocolForm.getProtocolDocument().getProtocol().getProtocolPersons());
        protocolForm.getPersonnelHelper().prepareView();
        return this.branchToPanelOrNotificationEditor(mapping, protocolForm, this.getPersonnelForwardNameHook());
    }

    public ActionForward questionnaire(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ProtocolFormBase protocolForm = (ProtocolFormBase)form;
        protocolForm.getQuestionnaireHelper().prepareView();
        protocolForm.getQuestionnaireHelper().populateAnswers();
        protocolForm.getQuestionnaireHelper().setQuestionnaireActiveStatuses();
        return this.branchToPanelOrNotificationEditor(mapping, protocolForm, this.getQuestionnaireForwardNameHook());
    }

    public ActionForward noteAndAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolFormBase protocolForm = (ProtocolFormBase)form;
        protocolForm.initializeNotesAttachments();
        protocolForm.getNotesAttachmentsHelper().prepareView();
        return this.branchToPanelOrNotificationEditor(mapping, protocolForm, this.getNoteAndAttachmentForwardNameHook());
    }

    public ActionForward specialReview(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ProtocolFormBase protocolForm = (ProtocolFormBase)form;
        protocolForm.getSpecialReviewHelper().prepareView();
        return this.branchToPanelOrNotificationEditor(mapping, protocolForm, this.getSpecialReviewForwardNameHook());
    }

    public ActionForward protocolActions(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolFormBase protocolForm = (ProtocolFormBase)form;
        String command = request.getParameter("command");
        if ("displayDocSearchView".equals(command)) {
            String docIdRequestParameter = request.getParameter("docId");
            Document retrievedDocument = KRADServiceLocatorWeb.getDocumentService().getByDocumentHeaderId(docIdRequestParameter);
            protocolForm.setDocument(retrievedDocument);
            request.setAttribute("docId", (Object)docIdRequestParameter);
        }
        protocolForm.initializeProtocolAction();
        protocolForm.getActionHelper().setCurrentSubmissionNumber(-1);
        protocolForm.getActionHelper().prepareView();
        protocolForm.getActionHelper().prepareCommentsView();
        this.saveQuestionnaire(protocolForm);
        return this.branchToPanelOrNotificationEditor(mapping, protocolForm, this.getProtocolActionsForwardNameHook());
    }

    protected void saveQuestionnaire(ProtocolFormBase protocolForm) {
        protocolForm.getQuestionnaireHelper().prepareView();
        protocolForm.getQuestionnaireHelper().populateAnswers();
        protocolForm.getQuestionnaireHelper().setQuestionnaireActiveStatuses();
        Document document = protocolForm.getDocument();
        List<AnswerHeader> answerHeaders = protocolForm.getQuestionnaireHelper().getAnswerHeaders();
        if (this.applyRules((DocumentEvent)new SaveQuestionnaireAnswerEvent(document, answerHeaders)) && this.applyRules((DocumentEvent)new SaveProtocolQuestionnaireEvent(document, answerHeaders))) {
            protocolForm.getQuestionnaireHelper().preSave();
            this.getBusinessObjectService().save(answerHeaders);
        }
    }

    public ActionForward protocolHistory(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolFormBase protocolForm = (ProtocolFormBase)form;
        protocolForm.initializeProtocolHistory();
        protocolForm.getActionHelper().setCurrentSubmissionNumber(-1);
        protocolForm.getActionHelper().prepareView();
        protocolForm.getActionHelper().prepareCommentsView();
        protocolForm.getActionHelper().initSubmissionDetails();
        return this.branchToPanelOrNotificationEditor(mapping, protocolForm, this.getProtocolHistoryForwardNameHook());
    }

    public ActionForward customData(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ProtocolFormBase protocolForm = (ProtocolFormBase)form;
        protocolForm.getCustomDataHelper().prepareCustomData();
        return this.branchToPanelOrNotificationEditor(mapping, protocolForm, this.getCustomDataForwardNameHook());
    }

    protected ActionForward branchToPanelOrNotificationEditor(ActionMapping mapping, ProtocolFormBase protocolForm, String ulitmateDestination) {
        if (protocolForm.isShowNotificationEditor()) {
            protocolForm.setShowNotificationEditor(false);
            protocolForm.getNotificationHelper().getNotificationContext().setForwardName(ulitmateDestination);
            return mapping.findForward(this.getProtocolNotificationEditorHook());
        }
        return mapping.findForward(ulitmateDestination);
    }

    @Override
    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward actionForward = mapping.findForward("basic");
        ProtocolFormBase protocolForm = (ProtocolFormBase)form;
        ProtocolBase protocol = protocolForm.getProtocolDocument().getProtocol();
        ProtocolTaskBase task = this.createNewModifyProtocolTaskInstanceHook(protocol);
        AuditHelper auditHelper = KcServiceLocator.getService(AuditHelper.class);
        if (this.isAuthorized(task) && (!protocol.isCorrectionMode() || auditHelper.auditUnconditionally(protocolForm.getDocument()))) {
            protocolForm.setShowNotificationEditor(this.isInitialSave((Document)protocolForm.getProtocolDocument()));
            this.preSave(mapping, form, request, response);
            actionForward = super.save(mapping, form, request, response);
            this.postSave(mapping, form, request, response);
            Project project = this.getProjectRetrievalService().retrieveProject(protocolForm.getProtocolDocument().getProtocol().getProtocolNumber());
            if (project != null) {
                this.getProjectPublisher().publishProject(project);
            }
            if ("save".equals(protocolForm.getMethodToCall()) && protocolForm.isAuditActivated() && GlobalVariables.getMessageMap().hasNoErrors()) {
                actionForward = mapping.findForward(this.getProtocolActionsForwardNameHook());
            } else if (protocolForm.isShowNotificationEditor()) {
                ProtocolNotificationContextBase context = this.getProtocolInitialSaveNotificationContextHook(protocol);
                if (protocolForm.getNotificationHelper().getPromptUserForNotificationEditor(context)) {
                    protocolForm.getNotificationHelper().initializeDefaultValues(context);
                    if ("save".equals(protocolForm.getMethodToCall())) {
                        return mapping.findForward(this.getProtocolNotificationEditorHook());
                    }
                } else {
                    protocolForm.setShowNotificationEditor(false);
                    this.getNotificationService().sendNotificationAndPersist(context, this.getProtocolNotificationHook(), protocol);
                    return actionForward;
                }
            }
        }
        return actionForward;
    }

    protected abstract ProtocolNotificationContextBase getProtocolInitialSaveNotificationContextHook(ProtocolBase var1);

    protected abstract String getProtocolNotificationEditorHook();

    protected abstract ProtocolTaskBase createNewModifyProtocolTaskInstanceHook(ProtocolBase var1);

    public void preSave(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
    }

    public void postSave(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
    }

    @Override
    protected void initialDocumentSave(KualiDocumentFormBase form) throws Exception {
        ProtocolFormBase protocolForm = (ProtocolFormBase)form;
        ProtocolDocumentBase doc = protocolForm.getProtocolDocument();
        String userId = GlobalVariables.getUserSession().getPrincipalId();
        protocolForm.setShowNotificationEditor(true);
        this.initialDocumentSaveAddRolesHook(userId, doc.getProtocol());
        ProtocolBase permissionable = protocolForm.getProtocolDocument().getProtocol();
        UnitAclLoadService unitAclLoadService = this.getUnitAclLoadService();
        unitAclLoadService.loadUnitAcl(permissionable, userId);
    }

    protected abstract void initialDocumentSaveAddRolesHook(String var1, ProtocolBase var2);

    protected abstract void sendNotification(ProtocolFormBase var1);

    @Override
    protected ActionForward saveOnClose(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = super.saveOnClose(mapping, form, request, response);
        if (GlobalVariables.getMessageMap().hasErrors()) {
            forward = mapping.findForward("basic");
        }
        return forward;
    }

    public ActionForward refresh(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String lookupResultsSequenceNumber;
        super.refresh(mapping, form, request, response);
        ProtocolFormBase protocolForm = (ProtocolFormBase)form;
        ProtocolDocumentBase protocolDocument = protocolForm.getProtocolDocument();
        if ("multipleValues".equals(protocolForm.getRefreshCaller()) && StringUtils.isNotBlank((CharSequence)(lookupResultsSequenceNumber = protocolForm.getLookupResultsSequenceNumber()))) {
            Class<?> lookupResultsBOClass = Class.forName(protocolForm.getLookupResultsBOClassName());
            String userName = GlobalVariables.getUserSession().getPerson().getPrincipalId();
            LookupResultsService service = KcServiceLocator.getService(LookupResultsService.class);
            Collection selectedBOs = service.retrieveSelectedResultBOs(lookupResultsSequenceNumber, lookupResultsBOClass, userName);
            this.processMultipleLookupResults(protocolDocument, lookupResultsBOClass, selectedBOs);
        }
        if (StringUtils.isNotBlank((CharSequence)protocolForm.getFormKey())) {
            protocolForm.setFormKey("");
        }
        return mapping.findForward("basic");
    }

    protected <T extends BusinessObject> void processMultipleLookupResults(ProtocolDocumentBase protocolDocument, Class<T> lookupResultsBOClass, Collection<T> selectedBOs) {
    }

    @Override
    public ActionForward docHandler(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = null;
        ProtocolFormBase protocolForm = (ProtocolFormBase)form;
        String command = protocolForm.getCommand();
        if (command.startsWith("displayDocSearchViewdetailId")) {
            // empty if block
        }
        if (!"displayActionListInlineView".equals(command)) {
            if (this.getProtocolActionsMappingNameHoook().equals(command) || this.getProtocolOnlineReviewMappingNameHoook().equals(command)) {
                String docIdRequestParameter = request.getParameter("docId");
                Document retrievedDocument = KRADServiceLocatorWeb.getDocumentService().getByDocumentHeaderId(docIdRequestParameter);
                protocolForm.setDocument(retrievedDocument);
                request.setAttribute("docId", (Object)docIdRequestParameter);
                this.loadDocument((KualiDocumentFormBase)protocolForm);
            } else {
                forward = super.docHandler(mapping, form, request, response);
            }
        }
        if ("initiate".equals(protocolForm.getCommand())) {
            protocolForm.getProtocolDocument().initialize();
        } else {
            protocolForm.initialize();
        }
        if (this.getProtocolActionsMappingNameHoook().equals(command)) {
            forward = this.protocolActions(mapping, (ActionForm)protocolForm, request, response);
        }
        if (this.getProtocolOnlineReviewMappingNameHoook().equals(command)) {
            forward = this.onlineReview(mapping, (ActionForm)protocolForm, request, response);
        }
        return forward;
    }

    protected abstract String getProtocolOnlineReviewMappingNameHoook();

    protected abstract String getProtocolActionsMappingNameHoook();

    protected KualiRuleService getKualiRuleService() {
        return KcServiceLocator.getService(KualiRuleService.class);
    }

    protected final boolean applyRules(DocumentEvent event) {
        return this.getKualiRuleService().applyRules(event);
    }

    public ActionForward onlineReview(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return mapping.findForward(this.getProtocolOnlineReviewForwardNameHook());
    }

    protected KcAuthorizationService getKraAuthorizationService() {
        return KcServiceLocator.getService(KcAuthorizationService.class);
    }

    protected UnitAclLoadService getUnitAclLoadService() {
        return KcServiceLocator.getService(UnitAclLoadService.class);
    }

    protected abstract ProtocolPersonnelService getProtocolPersonnelService();

    protected abstract ProtocolPersonTrainingService getProtocolPersonTrainingService();

    protected QuestionnairePrintingService getQuestionnairePrintingService() {
        return KcServiceLocator.getService(QuestionnairePrintingService.class);
    }

    @Override
    public String buildForwardUrl(String routeHeaderId) {
        return super.buildForwardUrl(routeHeaderId);
    }

    protected List<String> getUnitRulesMessages(ProtocolDocumentBase protocolDoc) {
        KrmsRulesExecutionService rulesService = KcServiceLocator.getService(KrmsRulesExecutionService.class);
        return rulesService.processUnitValidations(protocolDoc.getProtocol().getLeadUnitNumber(), protocolDoc);
    }

    public ActionForward printQuestionnaireAnswer(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        HashMap<String, Object> reportParameters = new HashMap<String, Object>();
        ProtocolFormBase protocolForm = (ProtocolFormBase)form;
        ProtocolBase protocol = protocolForm.getActionHelper().getProtocol();
        int answerHeaderIndex = this.getSelectedLine(request);
        String methodToCall = (String)request.getAttribute("methodToCallAttribute");
        String formProperty = StringUtils.substringBetween((String)methodToCall, (String)".printQuestionnaireAnswer.", (String)".line");
        QuestionnaireHelperBase helper = (QuestionnaireHelperBase)BeanUtilsBean.getInstance().getPropertyUtils().getProperty((Object)form, formProperty);
        AnswerHeader answerHeader = helper.getAnswerHeaders().get(answerHeaderIndex);
        reportParameters.put("questionnaireSeqId", answerHeader.getQuestionnaire().getQuestionnaireSeqIdAsInteger());
        reportParameters.put("template", answerHeader.getQuestionnaire().getTemplate());
        reportParameters.put("coeusModuleSubItemCode", answerHeader.getModuleSubItemCode());
        AttachmentDataSource dataStream = this.getQuestionnairePrintingService().printQuestionnaireAnswer(protocol, reportParameters);
        if (dataStream.getData() != null) {
            this.streamToResponse(dataStream, response);
            forward = null;
        }
        return forward;
    }

    public ActionForward updateAnswerToNewVersion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodToCallStart = "methodToCall.updateAnswerToNewVersion.";
        String methodToCallEnd = ".line";
        String methodToCall = (String)request.getAttribute("methodToCallAttribute");
        String questionnaireHelperPath = methodToCall.substring(methodToCallStart.length(), methodToCall.indexOf(methodToCallEnd));
        QuestionnaireHelperBase helper = (QuestionnaireHelperBase)PropertyUtils.getNestedProperty((Object)form, (String)questionnaireHelperPath);
        helper.updateQuestionnaireAnswer(this.getLineToDelete(request));
        this.getBusinessObjectService().save(helper.getAnswerHeaders());
        return mapping.findForward("basic");
    }

    @Override
    public ActionForward recall(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward;
        ReasonPrompt prompt = new ReasonPrompt("DocRecall", "nonCancelling.recall.question.text", "nonCancellingRecallQuestion", "error.document.recall.reasonRequired", "recall", "1", "message.recall.noteTextIntro");
        ReasonPrompt.Response resp = prompt.ask(mapping, form, request, response);
        if (resp.forward != null) {
            forward = resp.forward;
        } else if ("DocRecall".equals(resp.question) && "0".equals(resp.button)) {
            KualiDocumentFormBase kualiDocumentFormBase = (KualiDocumentFormBase)form;
            this.doProcessingAfterPost((KualiForm)kualiDocumentFormBase, request);
            this.getDocumentService().recallDocument(kualiDocumentFormBase.getDocument(), resp.reason, false);
            forward = mapping.findForward("portal");
        } else {
            forward = mapping.findForward("basic");
        }
        return forward;
    }

    protected boolean applyRules(ProtocolFormBase protocolForm, DocumentEvent event) {
        return this.applyRules(event) & !protocolForm.isUnitRulesErrorsExist();
    }

    protected boolean isInitialSave(Document document) {
        String status = document.getDocumentHeader().getWorkflowDocument().getStatus().getLabel();
        return GlobalVariables.getMessageMap().hasNoErrors() && StringUtils.equals((CharSequence)"INITIATED", (CharSequence)status);
    }

    protected KcNotificationService getNotificationService() {
        return KcServiceLocator.getService(KcNotificationService.class);
    }

    public ProjectPublisher getProjectPublisher() {
        if (this.projectPublisher == null) {
            this.projectPublisher = KcServiceLocator.getService(ProjectPublisher.class);
        }
        return this.projectPublisher;
    }

    public void setProjectPublisher(ProjectPublisher projectPublisher) {
        this.projectPublisher = projectPublisher;
    }

    public abstract ProjectRetrievalService getProjectRetrievalService();

    private class ReasonPrompt {
        final String questionId;
        final String questionTextKey;
        final String questionType;
        final String missingReasonKey;
        final String questionCallerMapping;
        final String abortButton;
        final String noteIntroKey;

        private ReasonPrompt(String questionId, String questionTextKey, String questionType, String missingReasonKey, String questionCallerMapping, String abortButton, String noteIntroKey) {
            this.questionId = questionId;
            this.questionTextKey = questionTextKey;
            this.questionType = questionType;
            this.questionCallerMapping = questionCallerMapping;
            this.abortButton = abortButton;
            this.noteIntroKey = noteIntroKey;
            this.missingReasonKey = missingReasonKey;
        }

        public Response ask(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
            String context;
            String question = request.getParameter("questionIndex");
            String reason = request.getParameter("reason");
            if (StringUtils.isBlank((CharSequence)reason) && (context = request.getParameter("context")) != null && StringUtils.contains((CharSequence)context, (CharSequence)"reason=")) {
                reason = StringUtils.substringAfter((String)context, (String)"reason=");
            }
            Object disapprovalNoteText = "";
            if (question == null) {
                return new Response(question, ProtocolActionBase.this.performQuestionWithInput(mapping, form, request, response, this.questionId, ProtocolActionBase.this.getKualiConfigurationService().getPropertyValueAsString(this.questionTextKey), this.questionType, this.questionCallerMapping, ""));
            }
            String buttonClicked = request.getParameter("buttonClicked");
            if (this.questionId.equals(question) && this.abortButton != null && this.abortButton.equals(buttonClicked)) {
                return new Response(question, mapping.findForward("basic"));
            }
            Object introNoteMessage = "";
            if (this.noteIntroKey != null) {
                introNoteMessage = ProtocolActionBase.this.getKualiConfigurationService().getPropertyValueAsString(this.noteIntroKey) + " ";
            }
            disapprovalNoteText = (String)introNoteMessage + reason;
            boolean warnForSensitiveData = CoreFrameworkServiceLocator.getParameterService().getParameterValueAsBoolean("KR-NS", "All", "SENSITIVE_DATA_PATTERNS_WARNING_IND");
            if (warnForSensitiveData) {
                String context2 = "reason=" + reason;
                ActionForward forward = ProtocolActionBase.this.checkAndWarnAboutSensitiveData(mapping, form, request, response, "reason", (String)disapprovalNoteText, this.questionCallerMapping, context2);
                if (forward != null) {
                    return new Response(question, forward);
                }
            } else if (KRADUtils.containsSensitiveDataPatternMatch((String)disapprovalNoteText)) {
                return new Response(question, ProtocolActionBase.this.performQuestionWithInputAgainBecauseOfErrors(mapping, form, request, response, this.questionId, ProtocolActionBase.this.getKualiConfigurationService().getPropertyValueAsString(this.questionTextKey), this.questionType, this.questionCallerMapping, "", reason, "error.document.fieldContainsPossibleSensitiveData", "reason", "reason"));
            }
            int disapprovalNoteTextLength = ((String)disapprovalNoteText).length();
            int noteTextMaxLength = ProtocolActionBase.this.getDataDictionaryService().getAttributeMaxLength(Note.class, "noteText");
            if (StringUtils.isBlank((CharSequence)reason) || disapprovalNoteTextLength > noteTextMaxLength) {
                if (reason == null) {
                    reason = "";
                }
                return new Response(question, ProtocolActionBase.this.performQuestionWithInputAgainBecauseOfErrors(mapping, form, request, response, this.questionId, ProtocolActionBase.this.getKualiConfigurationService().getPropertyValueAsString(this.questionTextKey), this.questionType, this.questionCallerMapping, "", reason, this.missingReasonKey, "reason", Integer.toString(noteTextMaxLength)));
            }
            return new Response(question, (String)disapprovalNoteText, buttonClicked);
        }

        private class Response {
            final String question;
            final ActionForward forward;
            final String reason;
            final String button;

            Response(String question, ActionForward forward) {
                this(question, forward, null, null);
            }

            Response(String question, String reason, String button) {
                this(question, null, reason, button);
            }

            private Response(String question, ActionForward forward, String reason, String button) {
                this.question = question;
                this.forward = forward;
                this.reason = reason;
                this.button = button;
            }
        }
    }
}

