/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.specialreview;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.compliance.core.SpecialReviewHelperBase;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocument;
import org.kuali.coeus.propdev.impl.specialreview.ProposalDevelopmentSpecialReviewService;
import org.kuali.coeus.propdev.impl.specialreview.ProposalSpecialReview;
import org.kuali.coeus.propdev.impl.specialreview.ProposalSpecialReviewAttachment;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;

public class SpecialReviewHelper
extends SpecialReviewHelperBase<ProposalSpecialReview> {
    private static final long serialVersionUID = 8832539481443727887L;
    private transient ProposalDevelopmentSpecialReviewService proposalDevelopmentSpecialReviewService;
    private ProposalDevelopmentDocument proposalDevelopmentDocument;
    private boolean modifySpecialReviewPermission;
    public ProposalSpecialReviewAttachment proposalSpecialReviewAttachment;

    public SpecialReviewHelper(ProposalDevelopmentDocument proposalDevelopmentDocument, boolean modifySpecialReviewPermission) {
        this.proposalDevelopmentDocument = proposalDevelopmentDocument;
        this.modifySpecialReviewPermission = modifySpecialReviewPermission;
        this.setNewSpecialReview(new ProposalSpecialReview());
        this.setLinkedProtocolNumbers(new ArrayList<String>());
        this.proposalSpecialReviewAttachment = new ProposalSpecialReviewAttachment();
    }

    @Override
    protected boolean hasModifySpecialReviewPermission(String principalId) {
        return this.modifySpecialReviewPermission;
    }

    @Override
    protected boolean isIrbProtocolLinkingEnabledForModule() {
        return this.getProposalDevelopmentSpecialReviewService().isIrbLinkingEnabled();
    }

    @Override
    protected boolean isIacucProtocolLinkingEnabledForModule() {
        return this.getProposalDevelopmentSpecialReviewService().isIacucLinkingEnabled();
    }

    public boolean isCreateIrbProtocolEnabled() {
        return this.getProposalDevelopmentSpecialReviewService().isCreateProtocolFromProposalEnabled("ENABLE_CREATE_PROPOSAL_TO_IRB_PROTOCOL");
    }

    public boolean isCreateIacucProtocolEnabled() {
        return this.getProposalDevelopmentSpecialReviewService().isCreateProtocolFromProposalEnabled("ENABLE_CREATE_PROPOSAL_TO_IACUC_PROTOCOL");
    }

    @Override
    protected List<ProposalSpecialReview> getSpecialReviews() {
        return this.getProposalDevelopmentDocument().getDevelopmentProposal().getPropSpecialReviews();
    }

    @Override
    public boolean isCanCreateIrbProtocol() {
        return this.getProposalDevelopmentSpecialReviewService().canCreateIrbProtocol(this.getProposalDevelopmentDocument());
    }

    @Override
    public boolean isCanCreateIacucProtocol() {
        return this.getProposalDevelopmentSpecialReviewService().canCreateIacucProtocol(this.getProposalDevelopmentDocument());
    }

    public void populatePropSpecialReviewApproverView(String summarySpecialReview) {
        if (!StringUtils.isEmpty((CharSequence)summarySpecialReview)) {
            String[] splitString = StringUtils.split((String)summarySpecialReview, (String)",");
            ArrayList<ProposalSpecialReview> propSpecialReviewFilteredList = new ArrayList<ProposalSpecialReview>();
            for (ProposalSpecialReview proposalSpecialReview : this.getProposalDevelopmentDocument().getDevelopmentProposal().getPropSpecialReviews()) {
                for (int i = 0; i < splitString.length; ++i) {
                    if (!proposalSpecialReview.getSpecialReviewTypeCode().equals(splitString[i])) continue;
                    propSpecialReviewFilteredList.add(proposalSpecialReview);
                }
            }
            this.getProposalDevelopmentDocument().getDevelopmentProposal().setPropSpecialReviews(propSpecialReviewFilteredList);
        }
    }

    public ProposalDevelopmentSpecialReviewService getProposalDevelopmentSpecialReviewService() {
        if (this.proposalDevelopmentSpecialReviewService == null) {
            this.proposalDevelopmentSpecialReviewService = KcServiceLocator.getService(ProposalDevelopmentSpecialReviewService.class);
        }
        return this.proposalDevelopmentSpecialReviewService;
    }

    public void setProposalDevelopmentSpecialReviewService(ProposalDevelopmentSpecialReviewService proposalDevelopmentSpecialReviewService) {
        this.proposalDevelopmentSpecialReviewService = proposalDevelopmentSpecialReviewService;
    }

    public ProposalDevelopmentDocument getProposalDevelopmentDocument() {
        return this.proposalDevelopmentDocument;
    }

    public void setProposalDevelopmentDocument(ProposalDevelopmentDocument proposalDevelopmentDocument) {
        this.proposalDevelopmentDocument = proposalDevelopmentDocument;
    }
}

