/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.impl.validation;

import java.util.Iterator;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.coeus.sys.framework.validation.AuditHelper;
import org.kuali.coeus.sys.framework.validation.Auditable;
import org.kuali.rice.kns.web.struts.form.KualiDocumentFormBase;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.event.DocumentAuditEvent;
import org.kuali.rice.krad.rules.rule.event.DocumentEvent;
import org.kuali.rice.krad.service.KualiRuleService;
import org.kuali.rice.krad.util.AuditCluster;
import org.kuali.rice.krad.util.GlobalVariables;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="auditHelper")
public class AuditHelperImpl
implements AuditHelper {
    @Autowired
    @Qualifier(value="kualiRuleService")
    private KualiRuleService ruleService;

    @Override
    public <T extends KualiDocumentFormBase> ActionForward setAuditMode(ActionMapping mapping, T form, boolean audit) {
        if (mapping == null) {
            throw new NullPointerException("the mapping is null");
        }
        if (form == null) {
            throw new NullPointerException("the form is null");
        }
        ((Auditable)form).setAuditActivated(audit);
        return mapping.findForward("basic");
    }

    @Override
    public <T extends Auditable> boolean auditConditionally(T form) {
        return this.auditDocumentFromForm(form, false);
    }

    @Override
    public <T extends Auditable> boolean auditUnconditionally(T form) {
        return this.auditDocumentFromForm(form, true);
    }

    @Override
    public boolean auditUnconditionally(Document document) {
        if (document == null) {
            throw new NullPointerException("the document is null");
        }
        return this.ruleService.applyRules((DocumentEvent)new DocumentAuditEvent(document));
    }

    private <T extends Auditable> boolean auditDocumentFromForm(T form, boolean alwaysApplyAudit) {
        if (form == null) {
            throw new NullPointerException("the form is null");
        }
        if (form.isAuditActivated() || alwaysApplyAudit) {
            return this.auditUnconditionally(form.getDocument());
        }
        return true;
    }

    @Override
    public <T extends Auditable> AuditHelper.ValidationState isValidSubmission(T form, boolean unconditionally) {
        AuditHelper.ValidationState result = AuditHelper.ValidationState.OK;
        boolean auditPassed = unconditionally ? this.auditUnconditionally(form) : this.auditConditionally(form);
        if (!auditPassed) {
            result = AuditHelper.ValidationState.WARNING;
            Iterator iter = GlobalVariables.getAuditErrorMap().keySet().iterator();
            while (iter.hasNext()) {
                AuditCluster auditCluster = (AuditCluster)GlobalVariables.getAuditErrorMap().get(iter.next());
                if (StringUtils.equalsIgnoreCase((CharSequence)auditCluster.getCategory(), (CharSequence)"Warnings")) continue;
                result = AuditHelper.ValidationState.ERROR;
                break;
            }
        }
        return result;
    }

    public KualiRuleService getRuleService() {
        return this.ruleService;
    }

    public void setRuleService(KualiRuleService kualiRuleService) {
        this.ruleService = kualiRuleService;
    }
}

