/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.excon.project;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.excon.project.ExconProjectAssociate;
import org.kuali.kra.excon.project.ExconProjectRPSMatchCodeFinder;
import org.kuali.rice.location.api.country.CountryService;

public class ExconProjectRPSEntity
extends ExconProjectAssociate
implements Comparable<ExconProjectRPSEntity> {
    private static final long serialVersionUID = 1652888857845217L;
    private static final Logger LOG = LogManager.getLogger(ExconProjectRPSEntity.class);
    private Long rpsEntityId;
    private Long projectId;
    private String firstName;
    private String lastName;
    private String otherNames;
    private String concatNames;
    private String companyName;
    private String streetAddress;
    private String city;
    private String state;
    private String countryCode;
    private Date birthdate;
    private String otherInfo;
    private String rpsMatchCode;
    private transient CountryService countryService;

    public Long getRpsEntityId() {
        return this.rpsEntityId;
    }

    public void setRpsEntityId(Long rpsEntityId) {
        this.rpsEntityId = rpsEntityId;
    }

    public Long getProjectId() {
        return this.projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getFirstName() {
        return this.firstName != null ? this.firstName : "";
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return this.lastName != null ? this.lastName : "";
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getOtherNames() {
        return this.otherNames != null ? this.otherNames : "";
    }

    public void setOtherNames(String otherNames) {
        this.otherNames = otherNames;
    }

    public String getConcatNames() {
        return this.concatNames;
    }

    public void setConcatNames(String concatNames) {
        this.concatNames = concatNames;
    }

    public String getEncodedNames() {
        try {
            return URLEncoder.encode(this.concatNames, StandardCharsets.US_ASCII);
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return "";
        }
    }

    public String getCompanyName() {
        return this.companyName != null ? this.companyName : "";
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public String getStreetAddress() {
        return this.streetAddress != null ? this.streetAddress : "";
    }

    public void setStreetAddress(String streetAddress) {
        this.streetAddress = streetAddress;
    }

    public String getCity() {
        return this.city != null ? this.city : "";
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getState() {
        return this.state != null ? this.state : "";
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getCountryCode() {
        return this.countryCode != null ? this.countryCode : "";
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public String getCountryName() {
        String countryName = "";
        if (!StringUtils.isEmpty((CharSequence)this.countryCode)) {
            countryName = this.getCountryService().getCountryByAlternateCode(this.countryCode).getName();
        }
        return countryName;
    }

    public String getShortCountryCode() {
        String shortCountryCode = "";
        if (!StringUtils.isEmpty((CharSequence)this.countryCode)) {
            shortCountryCode = this.getCountryService().getCountryByAlternateCode(this.countryCode).getCode();
        }
        return shortCountryCode;
    }

    public Date getBirthdate() {
        return this.birthdate;
    }

    public void setBirthdate(Date birthdate) {
        this.birthdate = birthdate;
    }

    public String getOtherInfo() {
        return this.otherInfo;
    }

    public void setOtherInfo(String otherInfo) {
        this.otherInfo = otherInfo;
    }

    public String getRpsMatchCode() {
        return this.rpsMatchCode;
    }

    public void setRpsMatchCode(String rpsMatchCode) {
        this.rpsMatchCode = rpsMatchCode;
    }

    public String getRpsMatchDescription() {
        if (!StringUtils.isEmpty((CharSequence)this.rpsMatchCode)) {
            return this.getMatchCodeFinder().getKeyLabel(this.rpsMatchCode);
        }
        return null;
    }

    protected ExconProjectRPSMatchCodeFinder getMatchCodeFinder() {
        return new ExconProjectRPSMatchCodeFinder();
    }

    @Override
    public void resetPersistenceState() {
        this.rpsEntityId = null;
        this.versionNumber = null;
    }

    @Override
    public int compareTo(ExconProjectRPSEntity exconProjectRPSEntityArg) {
        return exconProjectRPSEntityArg.getUpdateTimestamp().compareTo(this.getUpdateTimestamp());
    }

    protected CountryService getCountryService() {
        if (this.countryService == null) {
            this.countryService = KcServiceLocator.getService(CountryService.class);
        }
        return this.countryService;
    }
}

