/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.actions.print;

import edu.mit.coeus.xml.iacuc.AlternateDbSearchType;
import edu.mit.coeus.xml.iacuc.AmendRenewalType;
import edu.mit.coeus.xml.iacuc.CorrespondentType;
import edu.mit.coeus.xml.iacuc.ExceptionType;
import edu.mit.coeus.xml.iacuc.FundingSourceType;
import edu.mit.coeus.xml.iacuc.InvestigatorType;
import edu.mit.coeus.xml.iacuc.KeyStudyPersonType;
import edu.mit.coeus.xml.iacuc.LocationType;
import edu.mit.coeus.xml.iacuc.NotesType;
import edu.mit.coeus.xml.iacuc.OtherDataType;
import edu.mit.coeus.xml.iacuc.PersonType;
import edu.mit.coeus.xml.iacuc.PrinciplesType;
import edu.mit.coeus.xml.iacuc.PrintRequirementType;
import edu.mit.coeus.xml.iacuc.ProtocolActionsType;
import edu.mit.coeus.xml.iacuc.ProtocolDocument;
import edu.mit.coeus.xml.iacuc.ProtocolMasterDataType;
import edu.mit.coeus.xml.iacuc.ProtocolReviewerType;
import edu.mit.coeus.xml.iacuc.ProtocolType;
import edu.mit.coeus.xml.iacuc.ReferencesType;
import edu.mit.coeus.xml.iacuc.ResearchAreaType;
import edu.mit.coeus.xml.iacuc.RolesType;
import edu.mit.coeus.xml.iacuc.ScheduleSummaryType;
import edu.mit.coeus.xml.iacuc.SpecialReviewType;
import edu.mit.coeus.xml.iacuc.SpeciesType;
import edu.mit.coeus.xml.iacuc.StudyGroupType;
import edu.mit.coeus.xml.iacuc.SubmissionDetailsType;
import edu.mit.coeus.xml.iacuc.UserRolesType;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.time.DateUtils;
import org.kuali.coeus.common.committee.impl.bo.CommitteeBase;
import org.kuali.coeus.common.committee.impl.bo.CommitteeScheduleBase;
import org.kuali.coeus.common.framework.person.KcPerson;
import org.kuali.coeus.common.framework.person.KcPersonService;
import org.kuali.coeus.common.framework.sponsor.Sponsor;
import org.kuali.coeus.common.framework.unit.Unit;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.kra.iacuc.IacucExceptionCategory;
import org.kuali.kra.iacuc.IacucProtocol;
import org.kuali.kra.iacuc.IacucSpeciesCountType;
import org.kuali.kra.iacuc.actions.submit.IacucProtocolActionService;
import org.kuali.kra.iacuc.actions.submit.IacucProtocolSubmission;
import org.kuali.kra.iacuc.committee.print.IacucCommitteeXmlStream;
import org.kuali.kra.iacuc.committee.print.IacucScheduleXmlStream;
import org.kuali.kra.iacuc.committee.print.service.IacucPrintXmlUtilService;
import org.kuali.kra.iacuc.customdata.IacucProtocolCustomData;
import org.kuali.kra.iacuc.personnel.IacucProtocolPersonRolodex;
import org.kuali.kra.iacuc.procedures.IacucProcedure;
import org.kuali.kra.iacuc.procedures.IacucProtocolStudyGroup;
import org.kuali.kra.iacuc.procedures.IacucProtocolStudyGroupBean;
import org.kuali.kra.iacuc.species.IacucProtocolSpecies;
import org.kuali.kra.iacuc.species.exception.IacucProtocolException;
import org.kuali.kra.iacuc.threers.IacucAlternateSearch;
import org.kuali.kra.iacuc.threers.IacucPrinciples;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.actions.ProtocolActionBase;
import org.kuali.kra.protocol.actions.amendrenew.ProtocolAmendRenewalBase;
import org.kuali.kra.protocol.actions.print.ProtocolSummaryPrintOptions;
import org.kuali.kra.protocol.actions.print.ProtocolSummaryXmlStreamBase;
import org.kuali.kra.protocol.actions.submit.ProtocolReviewer;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionBase;
import org.kuali.kra.protocol.noteattachment.ProtocolNotepadBase;
import org.kuali.kra.protocol.personnel.ProtocolPersonBase;
import org.kuali.kra.protocol.personnel.ProtocolPersonRolodexBase;
import org.kuali.kra.protocol.personnel.ProtocolUnitBase;
import org.kuali.kra.protocol.protocol.funding.ProtocolFundingSourceBase;
import org.kuali.kra.protocol.protocol.location.ProtocolLocationBase;
import org.kuali.kra.protocol.protocol.reference.ProtocolReferenceBase;
import org.kuali.kra.protocol.protocol.research.ProtocolResearchAreaBase;
import org.kuali.kra.protocol.specialreview.ProtocolSpecialReviewBase;

public class IacucProtocolSummaryXmlStream
extends ProtocolSummaryXmlStreamBase<ProtocolDocument> {
    private IacucProtocolActionService iacucProtocolActionService;
    private IacucPrintXmlUtilService printXmlUtilService;
    private IacucScheduleXmlStream scheduleXmlStream;
    private IacucCommitteeXmlStream committeeXmlStream;
    private KcPersonService kcPersonService;
    protected static final String FLAG_YES = "Yes";
    protected static final String FLAG_NO = "No";

    @Override
    public Class<ProtocolDocument> type() {
        return ProtocolDocument.class;
    }

    @Override
    public Map<String, ProtocolDocument> generateXmlStream(KcPersistableBusinessObjectBase printableBusinessObject, Map<String, Object> reportParameters) {
        IacucProtocol protocol = (IacucProtocol)printableBusinessObject;
        ProtocolDocument protocolDocument = ProtocolDocument.Factory.newInstance();
        protocolDocument.setProtocol(this.getProtocolSummary(protocol, reportParameters));
        HashMap<String, ProtocolDocument> map = new HashMap<String, ProtocolDocument>();
        map.put("PrtocolSummary", protocolDocument);
        return map;
    }

    private String getOptionString(boolean printOption) {
        return printOption ? "1" : "0";
    }

    public ProtocolType getProtocolSummary(KcPersistableBusinessObjectBase printableBusinessObject, Map<?, Object> htData) {
        IacucProtocol protocol = (IacucProtocol)printableBusinessObject;
        protocol.refreshNonUpdateableReferences();
        ProtocolType protocolType = ProtocolType.Factory.newInstance();
        ArrayList<PrintRequirementType> printRequirementTypeList = new ArrayList<PrintRequirementType>();
        PrintRequirementType printRequirementType = PrintRequirementType.Factory.newInstance();
        if (htData != null) {
            ProtocolSummaryPrintOptions summaryOptions = (ProtocolSummaryPrintOptions)htData.get(ProtocolSummaryPrintOptions.class);
            printRequirementType.setOrganizationRequired(this.getOptionString(summaryOptions.isOrganizaition()));
            printRequirementType.setSpeciesGroupRequired(this.getOptionString(summaryOptions.isSpeciesAndGroups()));
            printRequirementType.setInvestigatorsRequired(this.getOptionString(summaryOptions.isInvestigator()));
            printRequirementType.setKeyPersonsRequired(this.getOptionString(summaryOptions.isStudyPersonnels()));
            printRequirementType.setCorrespondentsRequired(this.getOptionString(summaryOptions.isCorrespondents()));
            printRequirementType.setResearchAreasRequired(this.getOptionString(summaryOptions.isAreaOfResearch()));
            printRequirementType.setFundingSourcesRequired(this.getOptionString(summaryOptions.isFundingSource()));
            printRequirementType.setActionsRequired(this.getOptionString(summaryOptions.isActions()));
            printRequirementType.setProceduresRequired(this.getOptionString(summaryOptions.isProcedure()));
            printRequirementType.setSpecialReviewRequired(this.getOptionString(summaryOptions.isSpecialReview()));
            printRequirementType.setExceptionsRequired(this.getOptionString(summaryOptions.isException()));
            printRequirementType.setNotesRequired(this.getOptionString(summaryOptions.isNotes()));
            printRequirementType.setAmendRenewSRequired(this.getOptionString(summaryOptions.isAmmendmentRenewalSummary()));
            printRequirementType.setOtherDataRequired(this.getOptionString(summaryOptions.isOtherData()));
            printRequirementType.setUserRolesRequired(this.getOptionString(summaryOptions.isRoles()));
            printRequirementType.setReferencesRequired(this.getOptionString(summaryOptions.isReferences()));
            printRequirementType.setPrinciplesRequired(this.getOptionString(summaryOptions.isPrinciples()));
            printRequirementType.setProtocolDetailsRequired(this.getOptionString(summaryOptions.isProtocolDetails()));
            printRequirementType.setAlternativeSearchesRequired(this.getOptionString(summaryOptions.isPrinciples()));
        }
        printRequirementTypeList.add(printRequirementType);
        protocolType.setPrintRequirementArray(printRequirementTypeList.toArray(new PrintRequirementType[0]));
        printRequirementType.setCurrentDate(this.getDateTimeService().getCurrentCalendar());
        this.setProtocolPersons(protocol, protocolType);
        this.setProtocolLocations(protocol, protocolType);
        this.setProtocolResearchAreas(protocol, protocolType);
        this.setProtocolFundingResources(protocol, protocolType);
        this.setProtocolActions(protocol, protocolType);
        this.setProtocolSpecialReviewes(protocol, protocolType);
        this.setProtocolNotes(protocol, protocolType);
        this.setProtocolAmendmentRenewals(protocol, protocolType);
        this.setProtocolOtherData(protocol, protocolType);
        this.setProtocolReferences(protocol, protocolType);
        this.setProtocolUserRoles(protocol, protocolType);
        this.setProtocolMasterData(protocol, protocolType);
        this.setSpeciesGoups(protocol, protocolType);
        this.setProcedures(protocol, protocolType);
        this.setPrinciples(protocol, protocolType);
        this.setSubmissionDetails(protocol, protocolType);
        return protocolType;
    }

    private void setProtocolUserRoles(ProtocolBase protocol, ProtocolType protocolType) {
        ArrayList<RolesType> rolesTypeList = new ArrayList<RolesType>();
        ArrayList<UserRolesType> userRolesTypeList = new ArrayList<UserRolesType>();
        for (ProtocolPersonBase protocolPerson : protocol.getProtocolPersons()) {
            UserRolesType userRolesType = UserRolesType.Factory.newInstance();
            userRolesType.setRoleDesc(protocolPerson.getProtocolPersonRole().getDescription());
            userRolesType.setUnitName(protocolPerson.getPerson().getUnit().getUnitName());
            userRolesType.setUnitNumber(protocolPerson.getPerson().getUnit().getUnitNumber());
            userRolesType.setUserName(protocolPerson.getUserName());
            userRolesType.setUserId(protocolPerson.getPersonId());
            userRolesTypeList.add(userRolesType);
        }
        RolesType rolesType = RolesType.Factory.newInstance();
        rolesType.setUserRolesArray(userRolesTypeList.toArray(new UserRolesType[0]));
        rolesTypeList.add(rolesType);
        protocolType.setUserRolesArray(rolesTypeList.toArray(new RolesType[0]));
    }

    private void setSubmissionDetails(IacucProtocol protocol, ProtocolType protocolType) {
        this.addSubmissionDetails(protocol, protocolType, null, FLAG_NO);
    }

    private void addSubmissionDetails(IacucProtocol protocol, ProtocolType protocolType, Integer submissionNumber, String currentFlag) {
        IacucProtocolSubmission submissionInfoBean = (IacucProtocolSubmission)(submissionNumber == null ? protocol.getProtocolSubmission() : this.findProtocolSubmission(protocol, submissionNumber));
        if (submissionInfoBean == null || submissionInfoBean.getSubmissionNumber() == null) {
            return;
        }
        submissionInfoBean.refreshNonUpdateableReferences();
        ProtocolType.Submissions submission = protocolType.addNewSubmissions();
        SubmissionDetailsType submissionDetail = submission.addNewSubmissionDetails();
        submissionDetail.setAbstainerCount(BigInteger.valueOf(submissionInfoBean.getAbstainerCount().intValue()));
        if (submissionInfoBean.getNoVoteCount() != null) {
            submissionDetail.setNoVote(BigInteger.valueOf(submissionInfoBean.getNoVoteCount().intValue()));
        }
        submissionDetail.setProtocolNumber(submissionInfoBean.getProtocolNumber());
        if (submissionInfoBean.getProtocolReviewType() != null) {
            submissionDetail.setProtocolReviewTypeCode(new BigInteger(submissionInfoBean.getProtocolReviewTypeCode()));
            submissionDetail.setProtocolReviewTypeDesc(submissionInfoBean.getProtocolReviewType().getDescription());
        }
        List<ProtocolReviewer> vecReviewers = submissionInfoBean.getProtocolReviewers();
        for (ProtocolReviewer protocolReviewer : vecReviewers) {
            protocolReviewer.refreshNonUpdateableReferences();
            ProtocolReviewerType protocolReviewerType = submissionDetail.addNewProtocolReviewer();
            if (protocolReviewer.getProtocolReviewerType() != null) {
                protocolReviewerType.setReviewerTypeDesc(protocolReviewer.getProtocolReviewerType().getDescription());
                protocolReviewerType.setReviewerTypeCode(new BigInteger(String.valueOf(protocolReviewer.getReviewerTypeCode())));
            }
            PersonType personType = protocolReviewerType.addNewPerson();
            boolean isNonEmployee = protocolReviewer.getNonEmployeeFlag();
            if (isNonEmployee) {
                ProtocolPersonRolodexBase rolodex = (ProtocolPersonRolodexBase)this.getBusinessObjectService().findBySinglePrimaryKey(IacucProtocolPersonRolodex.class, (Object)protocolReviewer.getRolodexId());
                this.getPrintXmlUtilService().setPersonXml(rolodex, personType);
                continue;
            }
            KcPerson kcPerson = this.getKcPersonService().getKcPersonByPersonId(protocolReviewer.getPersonId());
            this.getPrintXmlUtilService().setPersonXml(kcPerson, personType);
        }
        submissionDetail.setSubmissionComments(submissionInfoBean.getComments());
        if (submissionInfoBean.getSubmissionDate() != null) {
            submissionDetail.setSubmissionDate(this.getDateTimeService().getCalendar((Date)submissionInfoBean.getSubmissionDate()));
        } else {
            submissionDetail.setSubmissionDate(this.getDateTimeService().getCurrentCalendar());
        }
        submissionDetail.setSubmissionNumber(BigInteger.valueOf(submissionInfoBean.getSubmissionNumber().intValue()));
        if (submissionInfoBean.getSubmissionStatus() != null) {
            submissionDetail.setSubmissionStatusCode(new BigInteger(submissionInfoBean.getSubmissionStatusCode()));
            submissionDetail.setSubmissionStatusDesc(submissionInfoBean.getSubmissionStatus().getDescription());
        }
        if (submissionInfoBean.getProtocolSubmissionType() != null) {
            submissionDetail.setSubmissionTypeCode(new BigInteger(submissionInfoBean.getSubmissionTypeCode()));
            submissionDetail.setSubmissionTypeDesc(submissionInfoBean.getProtocolSubmissionType().getDescription());
        }
        if (submissionInfoBean.getProtocolSubmissionQualifierType() != null) {
            submissionDetail.setSubmissionTypeQualifierCode(submissionInfoBean.getSubmissionTypeQualifierCode() == null ? new BigInteger("0") : new BigInteger(submissionInfoBean.getSubmissionTypeQualifierCode()));
            submissionDetail.setSubmissionTypeQualifierDesc(submissionInfoBean.getProtocolSubmissionQualifierType().getDescription());
        }
        submissionDetail.setVotingComments(submissionInfoBean.getVotingComments());
        if (submissionInfoBean.getYesVoteCount() != null) {
            submissionDetail.setYesVote(BigInteger.valueOf(submissionInfoBean.getYesVoteCount().intValue()));
        }
        this.getPrintXmlUtilService().setProtocolSubmissionAction(submissionInfoBean, submissionDetail);
        this.getPrintXmlUtilService().setSubmissionCheckListinfo(submissionInfoBean, submissionDetail);
        submission.setCurrentSubmissionFlag(currentFlag);
        this.setMinutes(submissionInfoBean, submission);
        if (submissionInfoBean.getCommitteeId() != null) {
            CommitteeBase committee = submissionInfoBean.getCommittee();
            this.getCommitteeXmlStream().setCommitteeMasterData(committee, submission.addNewCommitteeMasterData());
            this.getCommitteeXmlStream().setCommitteeMembers(committee, submission);
        }
        if (submissionInfoBean.getScheduleId() != null) {
            CommitteeScheduleBase committeeSchedule = submissionInfoBean.getCommitteeSchedule();
            this.getScheduleXmlStream().setScheduleMasterData(committeeSchedule, submission.addNewScheduleMasterData());
            ScheduleSummaryType nextSchedule = submission.addNewNextSchedule();
            this.getScheduleXmlStream().setNextSchedule(committeeSchedule, nextSchedule.addNewScheduleMasterData());
        }
    }

    private ProtocolSubmissionBase findProtocolSubmission(ProtocolBase protocol, Integer submissionNumber) {
        List<ProtocolSubmissionBase> protocolSubmissions = protocol.getProtocolSubmissions();
        for (ProtocolSubmissionBase protocolSubmission : protocolSubmissions) {
            if (!protocolSubmission.getSubmissionNumber().equals(submissionNumber)) continue;
            return protocolSubmission;
        }
        return null;
    }

    protected void setMinutes(ProtocolSubmissionBase submissionInfoBean, ProtocolType.Submissions submission) {
        CommitteeScheduleBase committeeSchedule = submissionInfoBean.getCommitteeSchedule();
        if (committeeSchedule != null) {
            this.getPrintXmlUtilService().setProtocolReviewMinutes(committeeSchedule, submissionInfoBean, submission);
        }
    }

    private void setProtocolReferences(ProtocolBase protocol, ProtocolType protocolType) {
        ReferencesType referencesType = ReferencesType.Factory.newInstance();
        ArrayList<ReferencesType> referncestypeList = new ArrayList<ReferencesType>();
        for (ProtocolReferenceBase protocolReference : protocol.getProtocolReferences()) {
            referencesType.setReferenceNumber(protocolReference.getProtocolReferenceNumber());
            if (protocolReference.getProtocolReferenceType() != null) {
                referencesType.setReferenceTypeCode(protocolReference.getProtocolReferenceType().getProtocolReferenceTypeCode());
                referencesType.setReferenceTypeDesc(protocolReference.getProtocolReferenceType().getDescription());
            }
            referencesType.setReferenceKey(protocolReference.getReferenceKey());
            referencesType.setApprovalDate(this.getDateTimeService().getCalendar((Date)protocolReference.getApprovalDate()));
            referencesType.setApplicationDate(this.getDateTimeService().getCalendar((Date)protocolReference.getApplicationDate()));
            referencesType.setComments(protocolReference.getComments());
            referncestypeList.add(referencesType);
        }
        protocolType.setReferencesArray(referncestypeList.toArray(new ReferencesType[0]));
    }

    private void setProtocolOtherData(IacucProtocol protocol, ProtocolType protocolType) {
        ArrayList<OtherDataType> otherDataTypeList = new ArrayList<OtherDataType>();
        for (IacucProtocolCustomData iacucProtocolCustomData : protocol.getIacucProtocolCustomDataList()) {
            OtherDataType otherDataType = OtherDataType.Factory.newInstance();
            if (iacucProtocolCustomData.getCustomAttribute() != null) {
                otherDataType.setColumnName(iacucProtocolCustomData.getCustomAttribute().getName());
                otherDataType.setColumnValue(iacucProtocolCustomData.getCustomAttribute().getValue());
            }
            otherDataTypeList.add(otherDataType);
        }
        protocolType.setOthersDataArray(otherDataTypeList.toArray(new OtherDataType[0]));
    }

    private void setProtocolAmendmentRenewals(ProtocolBase protocol, ProtocolType protocolType) {
        ArrayList<AmendRenewalType> amendRenewalTypeList = new ArrayList<AmendRenewalType>();
        for (ProtocolAmendRenewalBase protocolAmendRenewal : protocol.getProtocolAmendRenewals()) {
            AmendRenewalType amendRenewalType = AmendRenewalType.Factory.newInstance();
            amendRenewalType.setVersion(protocolAmendRenewal.getVersionNumber().toString());
            if (protocolAmendRenewal.getProtocol() != null && protocolAmendRenewal.getProtocol().getProtocolStatus() != null) {
                amendRenewalType.setProtocolStatusDesc(protocolAmendRenewal.getProtocol().getProtocolStatus().getDescription());
            }
            amendRenewalType.setDateCreated(this.getDateTimeService().getCalendar((Date)protocolAmendRenewal.getDateCreated()));
            amendRenewalType.setSummary(protocolAmendRenewal.getSummary());
            amendRenewalTypeList.add(amendRenewalType);
        }
        protocolType.setAmenRenewalArray(amendRenewalTypeList.toArray(new AmendRenewalType[0]));
    }

    private void setProtocolNotes(ProtocolBase protocol, ProtocolType protocolType) {
        ArrayList<NotesType> notesTypelist = new ArrayList<NotesType>();
        for (ProtocolNotepadBase protocolNotepad : protocol.getNotepads()) {
            NotesType notesType = NotesType.Factory.newInstance();
            notesType.setComments(protocolNotepad.getComments());
            notesType.setEntryNumber(protocolNotepad.getEntryNumber());
            if (protocolNotepad.getRestrictedView()) {
                notesType.setRestrictedView(FLAG_YES);
            } else {
                notesType.setRestrictedView(FLAG_NO);
            }
            notesType.setUpdateUser(protocolNotepad.getUpdateUser());
            notesType.setUpdateTimestamp(this.getDateTimeService().getCalendar((Date)protocolNotepad.getUpdateTimestamp()));
            notesTypelist.add(notesType);
        }
        protocolType.setNotesArray(notesTypelist.toArray(new NotesType[0]));
    }

    private void setProtocolSpecialReviewes(ProtocolBase protocol, ProtocolType protocolType) {
        List<ProtocolSpecialReviewBase> vecSpecialReview = protocol.getSpecialReviews();
        for (ProtocolSpecialReviewBase specialReviewBean : vecSpecialReview) {
            specialReviewBean.refreshNonUpdateableReferences();
            SpecialReviewType specialReview = protocolType.addNewSpecialReview();
            if (specialReviewBean.getApplicationDate() != null) {
                specialReview.setSpecialReviewApplicationDate(this.getDateTimeService().getCalendar((Date)specialReviewBean.getApplicationDate()));
            } else {
                specialReview.setSpecialReviewApplicationDate(this.getDateTimeService().getCurrentCalendar());
            }
            if (specialReviewBean.getApprovalDate() != null) {
                specialReview.setSpecialReviewApprovalDate(this.getDateTimeService().getCalendar((Date)specialReviewBean.getApprovalDate()));
            } else {
                specialReview.setSpecialReviewApprovalDate(this.getDateTimeService().getCurrentCalendar());
            }
            if (specialReviewBean.getApprovalType() != null) {
                specialReview.setSpecialReviewApprovalTypeCode(new BigInteger(specialReviewBean.getApprovalTypeCode()));
                specialReview.setSpecialReviewApprovalTypeDesc(specialReviewBean.getApprovalType().getDescription());
            }
            specialReview.setSpecialReviewComments(specialReviewBean.getComments());
            if (specialReviewBean.getSpecialReviewNumber() != null) {
                specialReview.setSpecialReviewNumber(BigInteger.valueOf(specialReviewBean.getSpecialReviewNumber().intValue()));
            }
            specialReview.setSpecialReviewProtocolNumber(specialReviewBean.getProtocolNumber());
            if (specialReviewBean.getSpecialReviewType() == null) continue;
            specialReview.setSpecialReviewTypeCode(new BigInteger(specialReviewBean.getSpecialReviewTypeCode()));
            specialReview.setSpecialReviewTypeDesc(specialReviewBean.getSpecialReviewType().getDescription());
        }
    }

    private void setProtocolActions(ProtocolBase protocol, ProtocolType protocolType) {
        ArrayList<ProtocolActionsType> protocolActionsTypeList = new ArrayList<ProtocolActionsType>();
        for (ProtocolActionBase protocolAction : protocol.getProtocolActions()) {
            ProtocolActionsType protocolActionsType = ProtocolActionsType.Factory.newInstance();
            protocolActionsType.setActionId(protocolAction.getActionId());
            if (protocolAction.getProtocolActionTypeCode() != null) {
                protocolActionsType.setActionTypeCode(Integer.parseInt(protocolAction.getProtocolActionTypeCode()));
                protocolActionsType.setActionTypeDesc(protocolAction.getProtocolActionType().getDescription());
            }
            protocolActionsType.setComments(protocolAction.getComments());
            if (protocolAction.getActionDate() != null) {
                protocolActionsType.setActionDate(this.getDateTimeService().getCalendar((Date)protocolAction.getActionDate()));
            }
            protocolActionsTypeList.add(protocolActionsType);
        }
        protocolType.setActionsArray(protocolActionsTypeList.toArray(new ProtocolActionsType[0]));
    }

    private void setProtocolFundingResources(ProtocolBase protocol, ProtocolType protocolType) {
        List<ProtocolFundingSourceBase> vecFundingSource = protocol.getProtocolFundingSources();
        for (ProtocolFundingSourceBase protocolFundingSourceBean : vecFundingSource) {
            FundingSourceType fundingSource = protocolType.addNewFundingSource();
            String fundingSourceCode = protocolFundingSourceBean.getFundingSourceNumber();
            int fundingSourceTypeCode = Integer.valueOf(protocolFundingSourceBean.getFundingSourceTypeCode());
            String fundingSourceName = this.getFundingSourceNameForType(fundingSourceTypeCode, fundingSourceCode);
            if (fundingSourceName != null) {
                fundingSource.setFundingSourceName(fundingSourceName);
            }
            if (protocolFundingSourceBean.getFundingSourceType() != null) {
                fundingSource.setTypeOfFundingSource(protocolFundingSourceBean.getFundingSourceType().getDescription());
            }
            fundingSource.setFundingSource(protocolFundingSourceBean.getFundingSourceNumber());
        }
    }

    private String getFundingSourceNameForType(int sourceType, String sourceCode) {
        String name = null;
        if (sourceType == 1) {
            Sponsor sponsorBean = (Sponsor)this.getBusinessObjectService().findBySinglePrimaryKey(Sponsor.class, (Object)sourceCode);
            if (sponsorBean != null) {
                name = sponsorBean.getSponsorName();
            }
        } else if (sourceType == 2) {
            Unit unitBean = (Unit)this.getBusinessObjectService().findBySinglePrimaryKey(Unit.class, (Object)sourceCode);
            if (unitBean != null) {
                name = unitBean.getUnitName();
            }
        } else {
            name = sourceCode;
        }
        return name;
    }

    private void setProtocolResearchAreas(ProtocolBase protocol, ProtocolType protocolType) {
        List<ProtocolResearchAreaBase> researchAreas = protocol.getProtocolResearchAreas();
        for (ProtocolResearchAreaBase protocolReasearchAreasBean : researchAreas) {
            protocolReasearchAreasBean.refreshNonUpdateableReferences();
            ResearchAreaType researchArea = protocolType.addNewResearchArea();
            researchArea.setResearchAreaCode(protocolReasearchAreasBean.getResearchAreaCode());
            if (protocolReasearchAreasBean.getResearchAreas() == null) continue;
            researchArea.setResearchAreaDescription(protocolReasearchAreasBean.getResearchAreas().getDescription());
        }
    }

    private void setProtocolLocations(ProtocolBase protocol, ProtocolType protocolType) {
        ArrayList<LocationType> locationTypeList = new ArrayList<LocationType>();
        for (ProtocolLocationBase protocolLocation : protocol.getProtocolLocations()) {
            LocationType locationType = LocationType.Factory.newInstance();
            if (protocolLocation.getProtocolOrganizationType() != null) {
                locationType.setOrgTypeDesc(protocolLocation.getProtocolOrganizationType().getDescription());
            }
            if (protocolLocation.getOrganization() != null) {
                locationType.setOrgName(protocolLocation.getOrganization().getOrganizationName());
                locationType.setAddress(protocolLocation.getOrganization().getAddress());
                locationType.setAnimalWelfareAssurance(protocolLocation.getOrganization().getAnimalWelfareAssurance());
            }
            locationTypeList.add(locationType);
        }
        protocolType.setOrganizationArray(locationTypeList.toArray(new LocationType[0]));
    }

    private void setProtocolPersons(IacucProtocol protocol, ProtocolType protocolType) {
        List<ProtocolPersonBase> vecInvestigator = protocol.getProtocolPersons();
        for (ProtocolPersonBase protocolPerson : vecInvestigator) {
            protocolPerson.refreshNonUpdateableReferences();
            if (protocolPerson.getProtocolPersonRoleId().equals("PI") || protocolPerson.getProtocolPersonRoleId().equals("COI")) {
                InvestigatorType investigator = protocolType.addNewInvestigator();
                if (protocolPerson.getProtocolPersonRoleId().equals("PI")) {
                    investigator.setPIFlag(true);
                }
                if (protocolPerson.getProtocolPersonRoleId().equals("PI") || protocolPerson.getProtocolPersonRoleId().equals("COI")) {
                    if (protocolPerson.isTrained()) {
                        investigator.setTrainingFlag(FLAG_YES);
                    } else {
                        investigator.setTrainingFlag(FLAG_NO);
                    }
                    if (protocolPerson.getAffiliationType() != null) {
                        investigator.setAffiliationDesc(protocolPerson.getAffiliationType().getDescription());
                    }
                    ArrayList<InvestigatorType.Unit> unitList = new ArrayList<InvestigatorType.Unit>();
                    for (ProtocolUnitBase protocolUnit : protocolPerson.getProtocolUnits()) {
                        InvestigatorType.Unit unit = InvestigatorType.Unit.Factory.newInstance();
                        unit.setUnitName(protocolUnit.getUnitName());
                        unit.setUnitNumber(protocolUnit.getUnitNumber());
                        unitList.add(unit);
                    }
                    investigator.setUnitArray(unitList.toArray(new InvestigatorType.Unit[0]));
                }
                this.getPrintXmlUtilService().setPersonRolodexType(protocolPerson, investigator.addNewPerson());
                continue;
            }
            if (protocolPerson.getProtocolPersonRoleId().equals("SP")) {
                KeyStudyPersonType keyStudyPerson = protocolType.addNewKeyStudyPerson();
                if (protocolPerson.getAffiliationType() != null) {
                    keyStudyPerson.setAffiliation(protocolPerson.getAffiliationType().getDescription());
                }
                if (protocolPerson.getRolodex() != null) {
                    keyStudyPerson.setRole(protocolPerson.getRolodex().getTitle());
                } else if (protocolPerson.getPerson() != null) {
                    keyStudyPerson.setRole(protocolPerson.getPerson().getDirectoryTitle());
                }
                if (protocolPerson.isTrained()) {
                    keyStudyPerson.setTrainingFlag(FLAG_YES);
                } else {
                    keyStudyPerson.setTrainingFlag(FLAG_NO);
                }
                this.getPrintXmlUtilService().setPersonRolodexType(protocolPerson, keyStudyPerson.addNewPerson());
                continue;
            }
            if (!protocolPerson.getProtocolPersonRoleId().equals("CRC") && !protocolPerson.getProtocolPersonRoleId().equals("CA")) continue;
            CorrespondentType correspondent = protocolType.addNewCorrespondent();
            correspondent.setTypeOfCorrespondent(protocolPerson.getProtocolPersonRole().getDescription());
            correspondent.setCorrespondentTypeDesc(protocolPerson.getProtocolPersonRole().getDescription());
            correspondent.setComments(protocolPerson.getComments());
            this.getPrintXmlUtilService().setPersonRolodexType(protocolPerson, correspondent.addNewPerson());
        }
    }

    private void setProtocolMasterData(IacucProtocol protocol, ProtocolType protocolType) {
        ProtocolMasterDataType protocolMaster = protocolType.addNewProtocolMasterData();
        if (protocol == null) {
            return;
        }
        protocol.refreshNonUpdateableReferences();
        protocolMaster.setProtocolNumber(protocol.getProtocolNumber());
        protocolMaster.setSequenceNumber(BigInteger.valueOf(protocol.getSequenceNumber().intValue()));
        protocolMaster.setProtocolTitle(protocol.getTitle());
        protocolMaster.setLayStatement1(protocol.getLayStatement1());
        protocolMaster.setLayStatement2(protocol.getLayStatement2());
        if (protocol.getSubmissionDate() != null) {
            protocolMaster.setApplicationDate(this.getDateTimeService().getCalendar((Date)protocol.getSubmissionDate()));
        }
        if (protocol.getProtocolStatus() != null) {
            protocolMaster.setProtocolStatusCode(new BigInteger(protocol.getProtocolStatusCode()));
            protocolMaster.setProtocolStatusDesc(protocol.getProtocolStatus().getDescription());
        }
        if (protocol.getProtocolType() != null) {
            protocolMaster.setProtocolTypeCode(new BigInteger(protocol.getProtocolTypeCode()));
            protocolMaster.setProtocolTypeDesc(protocol.getProtocolType().getDescription());
        }
        if (protocol.getDescription() != null) {
            protocolMaster.setProtocolDescription(protocol.getDescription());
        }
        if (protocol.getApprovalDate() != null) {
            protocolMaster.setApprovalDate(this.getDateTimeService().getCalendar((Date)protocol.getApprovalDate()));
        }
        if (protocol.getLastApprovalDate() != null) {
            protocolMaster.setLastApprovalDate(this.getDateTimeService().getCalendar((Date)protocol.getLastApprovalDate()));
        }
        if (protocol.getExpirationDate() != null) {
            protocolMaster.setExpirationDate(this.getDateTimeService().getCalendar((Date)protocol.getExpirationDate()));
        }
        if (protocol.getProtocolSubmission() != null) {
            protocolMaster.setBillableFlag(protocol.getProtocolSubmission().isBillable());
        }
        if (protocol.getFdaApplicationNumber() != null) {
            protocolMaster.setFdaApplicationNumber(protocol.getFdaApplicationNumber());
        }
        if (protocol.getReferenceNumber1() != null) {
            protocolMaster.setRefNumber1(protocol.getReferenceNumber1());
        }
        if (protocol.getReferenceNumber2() != null) {
            protocolMaster.setRefNumber2(protocol.getReferenceNumber2());
        }
        if (protocol.getInvestigator() != null) {
            protocolMaster.setPrincipleInvestigatorName(protocol.getInvestigator());
        }
        if (protocol.getOverviewTimeline() != null) {
            protocolMaster.setOverviewTimeline(protocol.getOverviewTimeline());
        }
        if (protocol.getProtocolProjectType() != null) {
            protocolMaster.setProjectTypeCode(BigInteger.valueOf(Integer.parseInt(protocol.getProtocolProjectType().getProjectTypeCode())));
            protocolMaster.setProjectTypeDesc(protocol.getProtocolProjectType().getDescription());
        }
    }

    private void setSpeciesGoups(IacucProtocol protocol, ProtocolType protocolType) {
        ArrayList<SpeciesType> speciesTypeList = new ArrayList<SpeciesType>();
        for (IacucProtocolSpecies iacucProtocolSpecies : protocol.getIacucProtocolSpeciesList()) {
            SpeciesType speciesType = SpeciesType.Factory.newInstance();
            speciesType.setSpeciesGroup(iacucProtocolSpecies.getSpeciesGroup());
            speciesType.setSpeciesDesc(iacucProtocolSpecies.getSpeciesName());
            speciesType.setStrain(iacucProtocolSpecies.getStrain());
            speciesType.setPainCategoryDesc(iacucProtocolSpecies.getPainCategoryName());
            speciesType.setPainCategoryCode(iacucProtocolSpecies.getPainCategoryCode());
            if (iacucProtocolSpecies.getUsdaCovered()) {
                speciesType.setIsUsdaCovered(FLAG_YES);
            } else {
                speciesType.setIsUsdaCovered(FLAG_NO);
            }
            speciesType.setCountTypeCode(iacucProtocolSpecies.getSpeciesCountCode());
            if (iacucProtocolSpecies.getSpeciesCountCode() != null) {
                HashMap<String, Integer> params = new HashMap<String, Integer>();
                params.put("speciesCountCode", iacucProtocolSpecies.getSpeciesCountCode());
                IacucSpeciesCountType iacucSpeciesCountType = (IacucSpeciesCountType)this.getBusinessObjectService().findByPrimaryKey(IacucSpeciesCountType.class, params);
                speciesType.setCountTypeDesc(iacucSpeciesCountType.getDescription());
            }
            speciesType.setSpeciesCount(iacucProtocolSpecies.getSpeciesCount());
            this.setExceptions(protocol, speciesType);
            speciesTypeList.add(speciesType);
        }
        protocolType.setSpeciesArray(speciesTypeList.toArray(new SpeciesType[0]));
    }

    private void setExceptions(IacucProtocol protocol, SpeciesType speciesType) {
        ArrayList<ExceptionType> exceptionTypeList = new ArrayList<ExceptionType>();
        for (IacucProtocolException iacucProtocolException : protocol.getIacucProtocolExceptions()) {
            ExceptionType exceptionType = ExceptionType.Factory.newInstance();
            String exceptionCategoryDescription = null;
            if (iacucProtocolException.getExceptionCategoryCode() != null) {
                HashMap<String, Integer> params = new HashMap<String, Integer>();
                params.put("exceptionCategoryCode", iacucProtocolException.getExceptionCategoryCode());
                exceptionCategoryDescription = ((IacucExceptionCategory)this.getBusinessObjectService().findByPrimaryKey(IacucExceptionCategory.class, params)).getExceptionCategoryDesc();
            }
            exceptionType.setExceptionCategoryDesc(exceptionCategoryDescription);
            exceptionType.setDescription(iacucProtocolException.getExceptionDescription());
            exceptionTypeList.add(exceptionType);
        }
        speciesType.setExceptionArray(exceptionTypeList.toArray(new ExceptionType[0]));
    }

    private void setPrinciples(IacucProtocol protocol, ProtocolType protocolType) {
        ArrayList<PrinciplesType> principleTypesList = new ArrayList<PrinciplesType>();
        for (IacucPrinciples iacucPrinciples : protocol.getIacucPrinciples()) {
            PrinciplesType principleTypes = PrinciplesType.Factory.newInstance();
            principleTypes.setReductionPrinciple(iacucPrinciples.getReduction());
            principleTypes.setRefinementPrinciple(iacucPrinciples.getRefinement());
            principleTypes.setReplacementPrinciple(iacucPrinciples.getReplacement());
            principleTypesList.add(principleTypes);
        }
        if (protocol.getIacucPrinciples() != null && protocol.getIacucPrinciples().size() > 0 && protocol.getIacucPrinciples().get(0).getSearchRequired() != null && protocol.getIacucPrinciples().get(0).getSearchRequired().equalsIgnoreCase("Y")) {
            ArrayList<AlternateDbSearchType> alternateDbSearchTypeList = new ArrayList<AlternateDbSearchType>();
            for (IacucAlternateSearch iacucAlternateSearch : protocol.getIacucAlternateSearches()) {
                AlternateDbSearchType alternateDbSearchType = AlternateDbSearchType.Factory.newInstance();
                alternateDbSearchType.setSearchDate(DateUtils.toCalendar((Date)iacucAlternateSearch.getSearchDate()));
                alternateDbSearchType.setYearsSearched(iacucAlternateSearch.getYearsSearched());
                if (iacucAlternateSearch.getDatabases() != null && iacucAlternateSearch.getDatabases().size() > 0) {
                    alternateDbSearchType.setDatabasDesc(iacucAlternateSearch.getDatabases().get(0).getAlternateSearchDatabaseName());
                }
                alternateDbSearchType.setKeywordsSearched(iacucAlternateSearch.getKeywords());
                alternateDbSearchType.setComments(iacucAlternateSearch.getComments());
                alternateDbSearchTypeList.add(alternateDbSearchType);
            }
            protocolType.setAlternateDbSearchArray(alternateDbSearchTypeList.toArray(new AlternateDbSearchType[0]));
        }
        protocolType.setPrinciplesArray(principleTypesList.toArray(new PrinciplesType[0]));
    }

    private void setProcedures(IacucProtocol protocol, ProtocolType protocolType) {
        ArrayList<StudyGroupType> studyGroupTypeList = new ArrayList<StudyGroupType>();
        IacucProtocolStudyGroup iacucProtocolStudyGroups = null;
        for (IacucProtocolStudyGroupBean iacucProtocolStudyGroup : protocol.getIacucProtocolStudyGroups()) {
            StudyGroupType studyGroupType = StudyGroupType.Factory.newInstance();
            studyGroupType.setProcedureCategoryCode(iacucProtocolStudyGroup.getProcedureCategoryCode());
            HashMap<String, Integer> params = new HashMap<String, Integer>();
            params.put("procedureCode", iacucProtocolStudyGroup.getProcedureCode());
            IacucProcedure iacucProcedure = (IacucProcedure)this.getBusinessObjectService().findByPrimaryKey(IacucProcedure.class, params);
            studyGroupType.setProcedureCode(iacucProtocolStudyGroup.getProcedureCode());
            if (iacucProcedure != null) {
                studyGroupType.setProcedureDesc(iacucProcedure.getProcedureDescription());
            }
            if (iacucProtocolStudyGroup.getIacucProtocolStudyGroups().size() > 0) {
                iacucProtocolStudyGroups = iacucProtocolStudyGroup.getIacucProtocolStudyGroups().get(0);
            }
            if (iacucProtocolStudyGroup.getIacucProcedureCategory() != null) {
                studyGroupType.setProcedureCategoryCode(iacucProtocolStudyGroup.getIacucProcedureCategory().getProcedureCategoryCode());
                studyGroupType.setProcedureCategoryDesc(iacucProtocolStudyGroup.getIacucProcedureCategory().getProcedureCategory());
            }
            if (iacucProtocolStudyGroups.getIacucProtocolSpecies() != null) {
                studyGroupType.setSpeciesGroup(iacucProtocolStudyGroups.getIacucProtocolSpecies().getSpeciesGroup());
            }
            if (iacucProtocolStudyGroups.getIacucPainCategory() != null) {
                studyGroupType.setPainCategoryDesc(iacucProtocolStudyGroups.getIacucPainCategory().getPainCategory());
            }
            studyGroupTypeList.add(studyGroupType);
        }
        protocolType.setStudyGroupArray(studyGroupTypeList.toArray(new StudyGroupType[0]));
    }

    public void setScheduleXmlStream(IacucScheduleXmlStream scheduleXmlStream) {
        this.scheduleXmlStream = scheduleXmlStream;
    }

    public IacucScheduleXmlStream getScheduleXmlStream() {
        return this.scheduleXmlStream;
    }

    public void setCommitteeXmlStream(IacucCommitteeXmlStream comitteeXmlStream) {
        this.committeeXmlStream = comitteeXmlStream;
    }

    public IacucCommitteeXmlStream getCommitteeXmlStream() {
        return this.committeeXmlStream;
    }

    public void setPrintXmlUtilService(IacucPrintXmlUtilService printXmlUtilService) {
        this.printXmlUtilService = printXmlUtilService;
    }

    public IacucPrintXmlUtilService getPrintXmlUtilService() {
        return this.printXmlUtilService;
    }

    public IacucProtocolActionService getIacucProtocolActionService() {
        return this.iacucProtocolActionService;
    }

    public void setIacucProtocolActionService(IacucProtocolActionService iacucProtocolActionService) {
        this.iacucProtocolActionService = iacucProtocolActionService;
    }

    public KcPersonService getKcPersonService() {
        return this.kcPersonService;
    }

    public void setKcPersonService(KcPersonService kcPersonService) {
        this.kcPersonService = kcPersonService;
    }
}

