/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.institutionalproposal.fundedawards;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.version.history.VersionHistory;
import org.kuali.coeus.common.framework.version.history.VersionHistoryService;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.fundingproposal.AwardFundingProposal;
import org.kuali.kra.institutionalproposal.ProposalStatus;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.kra.institutionalproposal.web.struts.form.InstitutionalProposalForm;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;

public class FundedAwardsBean
implements Serializable {
    private static final long serialVersionUID = 7202420195219545687L;
    private static final String ERROR_UNLOCK_PENDING_AWARDS = "error.institutionalProposal.unlockAward.pendingVersion";
    private InstitutionalProposalForm institutionalProposalForm;
    private transient BusinessObjectService businessObjectService;

    public FundedAwardsBean() {
    }

    public FundedAwardsBean(InstitutionalProposalForm institutionalProposalForm) {
        this();
        this.institutionalProposalForm = institutionalProposalForm;
    }

    public void removeUnlockedAwards() {
        InstitutionalProposal institutionalProposal = this.institutionalProposalForm.getInstitutionalProposalDocument().getInstitutionalProposal();
        Set<String> linkedPendingAwards = this.getLinkedPendingAwards(institutionalProposal, this.institutionalProposalForm.getSelectedAwardFundingProposals());
        if (!linkedPendingAwards.isEmpty()) {
            String awardNumbers = StringUtils.join(linkedPendingAwards, (String)", ");
            GlobalVariables.getMessageMap().putError("noKey", ERROR_UNLOCK_PENDING_AWARDS, new String[]{awardNumbers});
        } else {
            ArrayList<AwardFundingProposal> removedFundingProposals = new ArrayList<AwardFundingProposal>();
            ArrayUtils.reverse((Object[])this.institutionalProposalForm.getSelectedAwardFundingProposals());
            for (String indexToRemove : this.institutionalProposalForm.getSelectedAwardFundingProposals()) {
                removedFundingProposals.add(institutionalProposal.getAllFundingProposals().get(Integer.parseInt(indexToRemove)));
                institutionalProposal.getAllFundingProposals().remove(Integer.parseInt(indexToRemove));
            }
            this.getBusinessObjectService().delete(removedFundingProposals);
            if (institutionalProposal.getAllFundingProposals().isEmpty()) {
                institutionalProposal.setStatusCode(ProposalStatus.PENDING);
            }
            this.institutionalProposalForm.setSelectedAwardFundingProposals(null);
        }
    }

    public void selectAllFundedAwards() {
        String[] selectedAwardFundingProposals = new String[this.institutionalProposalForm.getInstitutionalProposalDocument().getInstitutionalProposal().getAwardFundingProposals().size()];
        for (int i = 0; i < this.institutionalProposalForm.getInstitutionalProposalDocument().getInstitutionalProposal().getAwardFundingProposals().size(); ++i) {
            selectedAwardFundingProposals[i] = Integer.toString(i);
        }
        this.institutionalProposalForm.setSelectedAwardFundingProposals(selectedAwardFundingProposals);
    }

    private Set<String> getLinkedPendingAwards(InstitutionalProposal institutionalProposal, String[] awardsToUnlock) {
        HashSet<String> linkedPendingAwards = new HashSet<String>();
        VersionHistoryService versionHistoryService = KcServiceLocator.getService(VersionHistoryService.class);
        for (String index : awardsToUnlock) {
            AwardFundingProposal fundingProposal = institutionalProposal.getAllFundingProposals().get(Integer.parseInt(index));
            VersionHistory pendingVersionHistory = versionHistoryService.findPendingVersion(Award.class, fundingProposal.getAward().getAwardNumber(), fundingProposal.getAward().getSequenceNumber().toString());
            if (pendingVersionHistory == null) continue;
            linkedPendingAwards.add(fundingProposal.getAward().getAwardNumber());
        }
        return linkedPendingAwards;
    }

    public BusinessObjectService getBusinessObjectService() {
        if (this.businessObjectService == null) {
            this.businessObjectService = KcServiceLocator.getService(BusinessObjectService.class);
        }
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }
}

