/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.committee.impl.rules;

import org.kuali.coeus.common.committee.impl.bo.CommitteeBase;
import org.kuali.coeus.common.committee.impl.bo.CommitteeMembershipBase;
import org.kuali.coeus.common.committee.impl.document.CommitteeDocumentBase;
import org.kuali.coeus.common.committee.impl.rule.event.DeleteCommitteeMemberEventBase;
import org.kuali.coeus.common.committee.impl.service.CommitteeMembershipServiceBase;
import org.kuali.coeus.sys.framework.rule.KcBusinessRule;
import org.kuali.coeus.sys.framework.rule.KcTransactionalDocumentRuleBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;

public abstract class DeleteCommitteeMemberRuleBase
extends KcTransactionalDocumentRuleBase
implements KcBusinessRule<DeleteCommitteeMemberEventBase> {
    private static final String ID = "document.committeeList[0].committeeMemberships[";
    private static final String AS_REVIEWER = "as the person is a reviewer of the protocol";
    private static final String AS_ATTENDANCE = "as the person has attended a schedule meeting";
    private CommitteeMembershipServiceBase committeeMembershipService;

    @Override
    public boolean processRules(DeleteCommitteeMemberEventBase event) {
        boolean rulePassed = true;
        int i = 0;
        for (CommitteeMembershipBase member : event.getCommitteeMemberships()) {
            if (member.isDelete() && this.getCommitteeMembershipService().isMemberAssignedToReviewer(member, ((CommitteeBase)((CommitteeDocumentBase)event.getDocument()).getCommittee()).getCommitteeId())) {
                this.reportError(ID + i + "].delete", "error.committeeMember.delete", AS_REVIEWER);
                rulePassed = false;
            }
            if (member.isDelete() && this.getCommitteeMembershipService().isMemberAttendedMeeting(member, ((CommitteeBase)((CommitteeDocumentBase)event.getDocument()).getCommittee()).getCommitteeId())) {
                this.reportError(ID + i + "].delete", "error.committeeMember.delete", AS_ATTENDANCE);
                rulePassed = false;
            }
            ++i;
        }
        return rulePassed;
    }

    private CommitteeMembershipServiceBase getCommitteeMembershipService() {
        if (this.committeeMembershipService == null) {
            this.committeeMembershipService = KcServiceLocator.getService(this.getCommitteeMembershipServiceClassHook());
        }
        return this.committeeMembershipService;
    }

    protected abstract Class<? extends CommitteeMembershipServiceBase> getCommitteeMembershipServiceClassHook();
}

