/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.framework.dd;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import org.springframework.core.io.AbstractResource;
import org.springframework.util.Assert;

public final class InMemoryDataDictionaryResource
extends AbstractResource {
    private final byte[] source;
    private final String description;

    public InMemoryDataDictionaryResource(byte[] source, String description) {
        Assert.notNull((Object)source, (String)"source cannot be null");
        Assert.hasText((String)description, (String)"description cannot be null or spaces");
        this.source = source;
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.source);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        InMemoryDataDictionaryResource that = (InMemoryDataDictionaryResource)((Object)o);
        if (!Arrays.equals(this.source, that.source)) {
            return false;
        }
        return this.description.equals(that.description);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.source);
        result = 31 * result + this.description.hashCode();
        return result;
    }

    public String toString() {
        return "InMemoryDataDictionaryResource{description='" + this.description + "'}";
    }
}

