/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.actions.modifysubmission;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.sys.framework.rule.KcTransactionalDocumentRuleBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.iacuc.actions.modifysubmission.IacucProtocolModifySubmissionBean;
import org.kuali.kra.iacuc.actions.modifysubmission.IacucProtocolModifySubmissionRule;
import org.kuali.kra.iacuc.actions.submit.IacucProtocolReviewType;
import org.kuali.kra.iacuc.actions.submit.IacucProtocolReviewerType;
import org.kuali.kra.iacuc.actions.submit.IacucProtocolSubmissionQualifierType;
import org.kuali.kra.iacuc.actions.submit.IacucProtocolSubmissionType;
import org.kuali.kra.iacuc.actions.submit.IacucValidProtoSubRevType;
import org.kuali.kra.iacuc.actions.submit.IacucValidProtoSubTypeQual;
import org.kuali.kra.iacuc.onlinereview.IacucProtocolOnlineReviewService;
import org.kuali.kra.protocol.ProtocolDocumentBase;
import org.kuali.kra.protocol.ProtocolOnlineReviewDocumentBase;
import org.kuali.kra.protocol.actions.submit.ProtocolReviewerBeanBase;
import org.kuali.kra.protocol.actions.submit.ValidProtoSubRevType;
import org.kuali.kra.protocol.actions.submit.ValidProtoSubTypeQual;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.ObjectUtils;

public class IacucProtocolModifySubmissionRuleImpl
extends KcTransactionalDocumentRuleBase
implements IacucProtocolModifySubmissionRule {
    private IacucProtocolOnlineReviewService protocolOnlineReviewService;
    private static final String PRIMARY_REVIEWER_TYPE = "1";
    private static final String SECONDARY_REVIEWER_TYPE = "2";

    @Override
    public boolean processModifySubmissionRule(ProtocolDocumentBase document, IacucProtocolModifySubmissionBean actionBean) {
        boolean valid = true;
        Object errorParameters = null;
        if (StringUtils.isBlank((CharSequence)actionBean.getProtocolReviewTypeCode())) {
            GlobalVariables.getMessageMap().putErrorWithoutFullErrorPath("actionHelper.iacucProtocolModifySubmissionBean.protocolReviewTypeCode", "error.protocol.reviewTypeCode.notFound", new String[]{errorParameters});
            valid = false;
        }
        if (StringUtils.isBlank((CharSequence)actionBean.getSubmissionTypeCode())) {
            GlobalVariables.getMessageMap().putErrorWithoutFullErrorPath("actionHelper.iacucProtocolModifySubmissionBean.submissionTypeCode", "error.protocol.submissionTypeCode.notFound", new String[]{errorParameters});
            valid = false;
        }
        if (StringUtils.isNotBlank((CharSequence)actionBean.getSubmissionTypeCode())) {
            valid &= this.isValidSubmTypeQual(actionBean);
            if (StringUtils.isNotBlank((CharSequence)actionBean.getProtocolReviewTypeCode())) {
                valid &= this.isValidSubmReviewType(actionBean);
            }
        }
        return valid &= this.validAssignReviewers(document, actionBean);
    }

    public boolean validAssignReviewers(ProtocolDocumentBase document, IacucProtocolModifySubmissionBean actionBean) {
        boolean isValid = true;
        int totalValidReviewers = 0;
        List<ProtocolReviewerBeanBase> reviewers = actionBean.getReviewers();
        List<ProtocolOnlineReviewDocumentBase> protocolOnlineReviewDocuments = this.getProtocolOnlineReviewService().getProtocolReviewDocumentsForCurrentSubmission(document.getProtocol());
        for (int i = 0; i < reviewers.size(); ++i) {
            ProtocolReviewerBeanBase reviewer = reviewers.get(i);
            if (ObjectUtils.isNotNull((Object)reviewer.getReviewerTypeCode()) && (reviewer.getReviewerTypeCode().equals(PRIMARY_REVIEWER_TYPE) || reviewer.getReviewerTypeCode().equals(SECONDARY_REVIEWER_TYPE))) {
                ++totalValidReviewers;
            }
            if (!this.isReviewerValid(reviewer, i)) {
                isValid = false;
                continue;
            }
            if (!StringUtils.isBlank((CharSequence)reviewer.getReviewerTypeCode())) continue;
            for (ProtocolOnlineReviewDocumentBase pDocument : protocolOnlineReviewDocuments) {
                if (!reviewer.isProtocolReviewerBeanForReviewer(pDocument.getProtocolOnlineReview().getProtocolReviewer())) continue;
                isValid &= this.isValidRemovalRequest(pDocument, reviewer, i);
            }
        }
        if (StringUtils.equals((CharSequence)actionBean.getProtocolReviewTypeCode(), (CharSequence)SECONDARY_REVIEWER_TYPE) && totalValidReviewers == 0) {
            IacucProtocolReviewType protocolReviewType = this.getBo(IacucProtocolReviewType.class, "reviewTypeCode", actionBean.getProtocolReviewTypeCode());
            GlobalVariables.getMessageMap().putErrorWithoutFullErrorPath("actionHelper.iacucProtocolModifySubmissionBean.protocolReviewTypeCode", "error.protocol.reviewTypeCode.reviewer.mismatch", new String[]{protocolReviewType.getDescription()});
            isValid = false;
        }
        return isValid;
    }

    public boolean isValidRemovalRequest(ProtocolOnlineReviewDocumentBase document, ProtocolReviewerBeanBase reviewer, int reviewerIndex) {
        boolean isValid = true;
        WorkflowDocument workflowDocument = document.getDocumentHeader().getWorkflowDocument();
        String propertyName = "actionHelper.iacucProtocolModifySubmissionBean.reviewer[" + reviewerIndex + "].reviewerTypeCode";
        String documentRouteStatus = workflowDocument.getStatus().getCode();
        if (StringUtils.equals((CharSequence)"F", (CharSequence)documentRouteStatus)) {
            this.reportWarning(propertyName, "warning.protocol.reviewer.removeReview.cannotRemoveFinalReview", reviewer.getFullName());
        }
        if (document.getProtocolOnlineReview().getCommitteeScheduleMinutes().size() > 0) {
            this.reportWarning(propertyName, "warning.protocol.reviewer.removeReview.cannotRemoveReviewWithComments", reviewer.getFullName(), "" + document.getProtocolOnlineReview().getCommitteeScheduleMinutes().size());
        }
        if (StringUtils.equals((CharSequence)document.getProtocolOnlineReview().getProtocolOnlineReviewStatusCode(), (CharSequence)"F")) {
            this.reportWarning(propertyName, "warning.protocol.reviewer.removeReview.cannotRemoveFinalReview", reviewer.getFullName());
        }
        return isValid;
    }

    private boolean isReviewerValid(ProtocolReviewerBeanBase reviewer, int reviewerIndex) {
        boolean isValid = true;
        String reviewerTypeCode = reviewer.getReviewerTypeCode();
        String propertyName = "actionHelper.iacucProtocolModifySubmissionBean.reviewer[" + reviewerIndex + "].reviewerTypeCode";
        if (!StringUtils.isBlank((CharSequence)reviewerTypeCode) && this.isReviewerTypeInvalid(reviewerTypeCode)) {
            isValid = false;
            this.reportError(propertyName, "error.protocol.reviewerTypeCode.invalid", reviewer.getFullName());
        }
        return isValid;
    }

    private boolean isReviewerTypeInvalid(String reviewerTypeCode) {
        return !this.existsUnique(IacucProtocolReviewerType.class, "reviewerTypeCode", reviewerTypeCode);
    }

    private boolean existsUnique(Class<? extends BusinessObject> boType, String propertyName, String keyField) {
        if (keyField != null) {
            BusinessObjectService businessObjectService = KcServiceLocator.getService(BusinessObjectService.class);
            HashMap<String, String> fieldValues = new HashMap<String, String>();
            fieldValues.put(propertyName, keyField);
            if (businessObjectService.countMatching(boType, fieldValues) == 1) {
                return true;
            }
        }
        return false;
    }

    private boolean isValidSubmReviewType(IacucProtocolModifySubmissionBean submitAction) {
        boolean valid = true;
        if (StringUtils.isNotBlank((CharSequence)submitAction.getSubmissionTypeCode()) && StringUtils.isNotBlank((CharSequence)submitAction.getProtocolReviewTypeCode())) {
            HashMap<String, String> fieldValues = new HashMap<String, String>();
            fieldValues.put("submissionTypeCode", submitAction.getSubmissionTypeCode());
            List validProtoSubRevTypes = (List)this.getBusinessObjectService().findMatching(IacucValidProtoSubRevType.class, fieldValues);
            if (!validProtoSubRevTypes.isEmpty()) {
                ArrayList<String> reviewTypes = new ArrayList<String>();
                for (ValidProtoSubRevType validProtoSubRevType : validProtoSubRevTypes) {
                    reviewTypes.add(validProtoSubRevType.getProtocolReviewTypeCode());
                }
                if (!reviewTypes.contains(submitAction.getProtocolReviewTypeCode())) {
                    GlobalVariables.getMessageMap().putError("actionHelper.iacucProtocolModifySubmissionBean.protocolReviewTypeCode", "invalid.submreviewtype", new String[]{this.getBo(IacucProtocolSubmissionType.class, "submissionTypeCode", submitAction.getSubmissionTypeCode()).getDescription(), this.getBo(IacucProtocolReviewType.class, "reviewTypeCode", submitAction.getProtocolReviewTypeCode()).getDescription()});
                    valid = false;
                }
            }
        }
        return valid;
    }

    private boolean isValidSubmTypeQual(IacucProtocolModifySubmissionBean submitAction) {
        boolean valid = true;
        if (StringUtils.isNotBlank((CharSequence)submitAction.getSubmissionTypeCode())) {
            HashMap<String, String> fieldValues = new HashMap<String, String>();
            fieldValues.put("submissionTypeCode", submitAction.getSubmissionTypeCode());
            List validProtoSubTypeQuals = (List)this.getBusinessObjectService().findMatching(IacucValidProtoSubTypeQual.class, fieldValues);
            if (!validProtoSubTypeQuals.isEmpty()) {
                ArrayList<String> typeQuals = new ArrayList<String>();
                for (ValidProtoSubTypeQual validProtoSubTypeQual : validProtoSubTypeQuals) {
                    typeQuals.add(validProtoSubTypeQual.getSubmissionTypeQualCode());
                }
                if (StringUtils.isBlank((CharSequence)submitAction.getSubmissionQualifierTypeCode()) || !typeQuals.contains(submitAction.getSubmissionQualifierTypeCode())) {
                    String desc = "";
                    IacucProtocolSubmissionQualifierType typeQual = this.getBo(IacucProtocolSubmissionQualifierType.class, "submissionQualifierTypeCode", submitAction.getSubmissionQualifierTypeCode());
                    if (typeQual != null) {
                        desc = typeQual.getDescription();
                    }
                    GlobalVariables.getMessageMap().putError("actionHelper.iacucProtocolModifySubmissionBean.submissionQualifierTypeCode", "invalid.submtypequal", new String[]{this.getBo(IacucProtocolSubmissionType.class, "submissionTypeCode", submitAction.getSubmissionTypeCode()).getDescription(), desc});
                    valid = false;
                }
            }
        }
        return valid;
    }

    private <BO extends BusinessObject> BO getBo(Class<BO> boType, String propertyName, String keyField) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put(propertyName, keyField);
        List results = (List)this.getBusinessObjectService().findMatching(boType, fieldValues);
        if (results.isEmpty()) {
            return null;
        }
        return (BO)((BusinessObject)results.get(0));
    }

    private IacucProtocolOnlineReviewService getProtocolOnlineReviewService() {
        if (this.protocolOnlineReviewService == null) {
            this.protocolOnlineReviewService = KcServiceLocator.getService(IacucProtocolOnlineReviewService.class);
        }
        return this.protocolOnlineReviewService;
    }
}

