/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.correspondence;

import org.apache.commons.lang3.StringUtils;
import org.kuali.kra.protocol.correspondence.BatchCorrespondenceBase;
import org.kuali.kra.protocol.correspondence.BatchCorrespondenceDetailBase;
import org.kuali.rice.krad.util.GlobalVariables;

public abstract class BatchCorrespondenceDetailRuleBase {
    private static final String SEND_CORRESPONDENCE_AFTER_EVENT = "AFTER";
    private static final String PROPERTY_NAME_DAYS_TO_EVENT = "newBatchCorrespondenceDetail.daysToEvent";
    private static final String PROPERTY_NAME_PROTO_CORRESP_TYPE_CODE = "newBatchCorrespondenceDetail.protoCorrespTypeCode";
    private static final String PROPERTY_NAME_FINAL_ACTION_DAY = "batchCorrespondence.finalActionDay";
    private static final String PROPERTY_NAME_FINAL_ACTION_TYPE_CODE = "batchCorrespondence.finalActionTypeCode";
    private static final String PROPERTY_NAME_FINAL_ACTION_CORRESP_TYPE = "batchCorrespondence.finalActionCorrespType";

    public boolean processAddBatchCorrespondenceDetailRules(BatchCorrespondenceBase batchCorrespondence, BatchCorrespondenceDetailBase newBatchCorrespondenceDetail) {
        boolean rulePassed = true;
        rulePassed &= this.validateDaysToEvent(batchCorrespondence, newBatchCorrespondenceDetail);
        return rulePassed &= this.validateProtoCorrespTypeCode(newBatchCorrespondenceDetail);
    }

    private boolean validateDaysToEvent(BatchCorrespondenceBase batchCorrespondence, BatchCorrespondenceDetailBase newBatchCorrespondenceDetails) {
        boolean isValid = true;
        if (newBatchCorrespondenceDetails.getDaysToEvent() == null) {
            GlobalVariables.getMessageMap().putError(PROPERTY_NAME_DAYS_TO_EVENT, "error.batch.correspondence.days.to.event.not.specified", new String[0]);
            isValid = false;
        } else if (newBatchCorrespondenceDetails.getDaysToEvent() < 0) {
            GlobalVariables.getMessageMap().putError(PROPERTY_NAME_DAYS_TO_EVENT, "error.batch.correspondence.days.to.event.negative", new String[0]);
            isValid = false;
        } else if (StringUtils.equals((CharSequence)batchCorrespondence.getSendCorrespondence(), (CharSequence)SEND_CORRESPONDENCE_AFTER_EVENT) && newBatchCorrespondenceDetails.getDaysToEvent() >= batchCorrespondence.getFinalActionDay()) {
            GlobalVariables.getMessageMap().putError(PROPERTY_NAME_DAYS_TO_EVENT, "error.batch.correspondence.days.to.event.invalid", new String[]{Integer.toString(batchCorrespondence.getFinalActionDay() - 1)});
            isValid = false;
        } else if (this.isDuplicate(batchCorrespondence, newBatchCorrespondenceDetails)) {
            GlobalVariables.getMessageMap().putError(PROPERTY_NAME_DAYS_TO_EVENT, "error.batch.correspondence.days.to.event.duplicate", new String[0]);
            isValid = false;
        }
        return isValid;
    }

    private boolean isDuplicate(BatchCorrespondenceBase batchCorrespondence, BatchCorrespondenceDetailBase newBatchCorrespondenceDetails) {
        if (batchCorrespondence.getFinalActionDay().equals(newBatchCorrespondenceDetails.getDaysToEvent())) {
            return true;
        }
        for (BatchCorrespondenceDetailBase batchCorrespondenceDetail : batchCorrespondence.getBatchCorrespondenceDetails()) {
            if (!batchCorrespondenceDetail.getDaysToEvent().equals(newBatchCorrespondenceDetails.getDaysToEvent())) continue;
            return true;
        }
        return false;
    }

    private boolean validateProtoCorrespTypeCode(BatchCorrespondenceDetailBase newBatchCorrespondenceDetails) {
        if (StringUtils.isBlank((CharSequence)newBatchCorrespondenceDetails.getProtoCorrespTypeCode())) {
            GlobalVariables.getMessageMap().putError(PROPERTY_NAME_PROTO_CORRESP_TYPE_CODE, "error.batch.correspondence.proto.corresp.type.code.not.specified", new String[0]);
            return false;
        }
        return true;
    }

    public boolean processSaveBatchCorrespondenceDetailRules(BatchCorrespondenceBase batchCorrespondence) {
        boolean rulePassed = true;
        rulePassed &= this.validateFinalActionDay(batchCorrespondence);
        rulePassed &= this.validateFinalActionTypeCode(batchCorrespondence);
        return rulePassed &= this.validatefinalActionCorrespType(batchCorrespondence);
    }

    private boolean validateFinalActionDay(BatchCorrespondenceBase batchCorrespondence) {
        if (batchCorrespondence.getFinalActionDay() == null) {
            GlobalVariables.getMessageMap().putError(PROPERTY_NAME_FINAL_ACTION_DAY, "error.batch.correspondence.final.action.day.not.specified", new String[0]);
            return false;
        }
        if (StringUtils.equals((CharSequence)batchCorrespondence.getSendCorrespondence(), (CharSequence)SEND_CORRESPONDENCE_AFTER_EVENT)) {
            for (BatchCorrespondenceDetailBase batchCorrespondenceDetail : batchCorrespondence.getBatchCorrespondenceDetails()) {
                if (batchCorrespondenceDetail.getDaysToEvent() < batchCorrespondence.getFinalActionDay()) continue;
                GlobalVariables.getMessageMap().putError(PROPERTY_NAME_FINAL_ACTION_DAY, "error.batch.correspondence.final.action.day.invalid", new String[0]);
                return false;
            }
        }
        return true;
    }

    private boolean validateFinalActionTypeCode(BatchCorrespondenceBase batchCorrespondence) {
        if (batchCorrespondence.getFinalActionTypeCode() == null) {
            GlobalVariables.getMessageMap().putError(PROPERTY_NAME_FINAL_ACTION_TYPE_CODE, "error.batch.correspondence.final.action.type.code.not.specified", new String[0]);
            return false;
        }
        return true;
    }

    private boolean validatefinalActionCorrespType(BatchCorrespondenceBase batchCorrespondence) {
        if (batchCorrespondence.getFinalActionCorrespType() == null) {
            GlobalVariables.getMessageMap().putError(PROPERTY_NAME_FINAL_ACTION_CORRESP_TYPE, "error.batch.correspondence.final.action.corresp.type.not.specified", new String[0]);
            return false;
        }
        return true;
    }
}

