/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.permission;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.coeus.common.framework.auth.perm.KcAuthorizationService;
import org.kuali.coeus.common.permissions.impl.bo.PermissionsRoleState;
import org.kuali.coeus.common.permissions.impl.bo.PermissionsUserEditRoles;
import org.kuali.coeus.common.permissions.impl.web.bean.Role;
import org.kuali.coeus.common.permissions.impl.web.bean.User;
import org.kuali.coeus.common.permissions.impl.web.struts.action.PermissionsActionHelperBase;
import org.kuali.coeus.common.permissions.impl.web.struts.form.PermissionsForm;
import org.kuali.coeus.common.permissions.impl.web.struts.form.PermissionsHelperBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.protocol.ProtocolActionBase;
import org.kuali.kra.protocol.ProtocolDocumentBase;
import org.kuali.rice.krad.document.Document;

public class ProtocolPermissionsActionHelper
extends PermissionsActionHelperBase {
    private static final long serialVersionUID = -4490013895383993701L;

    public ProtocolPermissionsActionHelper(ProtocolActionBase parentAction) {
        super(parentAction);
    }

    @Override
    protected void addUserToRoleInDatabase(Document document, String userId, String roleName) {
        ProtocolDocumentBase protocolDocument = (ProtocolDocumentBase)document;
        this.getKraAuthorizationService().addDocumentLevelRole(userId, roleName, protocolDocument.getProtocol());
    }

    @Override
    protected void removeUserFromRoleInDatabase(Document document, String userId, String roleName) {
        ProtocolDocumentBase protocolDocument = (ProtocolDocumentBase)document;
        this.getKraAuthorizationService().removeDocumentLevelRole(userId, roleName, protocolDocument.getProtocol());
    }

    private KcAuthorizationService getKraAuthorizationService() {
        return KcServiceLocator.getService(KcAuthorizationService.class);
    }

    @Override
    public ActionForward editRoles(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PermissionsForm permissionsForm = (PermissionsForm)form;
        PermissionsHelperBase permissionsHelper = permissionsForm.getPermissionsHelper();
        int lineNum = this.getLineNum(request);
        User user = permissionsHelper.getUsers().get(lineNum);
        PermissionsUserEditRoles editRoles = new PermissionsUserEditRoles();
        editRoles.setLineNum(lineNum);
        editRoles.setJavaScriptEnabled(this.isJavaScriptEnabled(request));
        editRoles.setUserName(user.getPerson().getUserName());
        editRoles.setPrinipalInvestigator(this.isPrincipalInvestigator((ProtocolDocumentBase)permissionsForm.getDocument(), user.getPerson().getPersonId()));
        ArrayList<PermissionsRoleState> roleStates = new ArrayList<PermissionsRoleState>();
        List<Role> roles = permissionsHelper.getNormalRoles();
        for (Role role : roles) {
            PermissionsRoleState roleState = new PermissionsRoleState(role);
            roleStates.add(roleState);
        }
        editRoles.setRoleStates(roleStates);
        List<Role> userRoles = user.getRoles();
        for (Role userRole : userRoles) {
            editRoles.setRoleState(userRole.getName(), Boolean.TRUE);
        }
        permissionsHelper.setUserEditRoles(editRoles);
        return mapping.findForward("permissionsEditRoles");
    }

    private int getLineNum(HttpServletRequest request) {
        String lineNumStr = request.getParameter("line");
        try {
            return Integer.parseInt(lineNumStr);
        }
        catch (Exception ex) {
            return this.getLineToDelete(request);
        }
    }

    private int getLineToDelete(HttpServletRequest request) {
        return this.getSelectedLine(request);
    }

    private int getSelectedLine(HttpServletRequest request) {
        int selectedLine = -1;
        String parameterName = (String)request.getAttribute("methodToCallAttribute");
        if (StringUtils.isNotBlank((CharSequence)parameterName)) {
            String lineNumber = StringUtils.substringBetween((String)parameterName, (String)".line", (String)".");
            selectedLine = Integer.parseInt(lineNumber);
        }
        return selectedLine;
    }

    private boolean isJavaScriptEnabled(HttpServletRequest request) {
        String lineNumStr = request.getParameter("line");
        try {
            Integer.parseInt(lineNumStr);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    private boolean isPrincipalInvestigator(ProtocolDocumentBase protocolDocument, String personId) {
        return StringUtils.equals((CharSequence)personId, (CharSequence)protocolDocument.getProtocol().getPrincipalInvestigatorId());
    }
}

