/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.protocol.research;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.sys.framework.rule.KcTransactionalDocumentRuleBase;
import org.kuali.kra.protocol.ProtocolDocumentBase;
import org.kuali.kra.protocol.protocol.research.ProtocolResearchAreaBase;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.DocumentAuditRule;
import org.kuali.rice.krad.util.AuditCluster;
import org.kuali.rice.krad.util.AuditError;
import org.kuali.rice.krad.util.GlobalVariables;

public abstract class ProtocolResearchAreaAuditRuleBase
extends KcTransactionalDocumentRuleBase
implements DocumentAuditRule {
    private static final String ADDITIONAL_INFORMATION_AUDIT_ERRORS = "additionalInformationAuditErrors";
    private List<AuditError> auditErrors;

    public boolean processRunAuditBusinessRules(Document document) {
        boolean isValid = true;
        ProtocolDocumentBase protocolDocument = (ProtocolDocumentBase)document;
        this.auditErrors = new ArrayList<AuditError>();
        boolean bl = isValid = !protocolDocument.getProtocol().isEmptyProtocolResearchAreas();
        if (!isValid) {
            this.addErrorToAuditErrors();
        }
        this.reportAndCreateAuditCluster();
        return isValid &= this.isEveryResearchAreaActive(protocolDocument);
    }

    protected void addErrorToAuditErrors() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("protocol");
        stringBuilder.append(".");
        stringBuilder.append("Area of Research");
        this.auditErrors.add(new AuditError("document.protocolList[0].newDescription", "error.protocol.researchArea.required", stringBuilder.toString()));
    }

    private boolean isEveryResearchAreaActive(ProtocolDocumentBase document) {
        boolean inactiveFound = false;
        Object inactiveResearchAreaCode = "";
        List<ProtocolResearchAreaBase> pras = document.getProtocol().getProtocolResearchAreas();
        if (CollectionUtils.isNotEmpty(pras)) {
            for (ProtocolResearchAreaBase protocolResearchArea : pras) {
                if (protocolResearchArea.getResearchAreas().isActive()) continue;
                inactiveFound = true;
                if (StringUtils.isBlank((CharSequence)inactiveResearchAreaCode)) {
                    inactiveResearchAreaCode = protocolResearchArea.getResearchAreaCode();
                    continue;
                }
                inactiveResearchAreaCode = (String)inactiveResearchAreaCode + ", " + protocolResearchArea.getResearchAreaCode();
            }
        }
        if (inactiveFound) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("protocol");
            stringBuilder.append(".");
            stringBuilder.append("Area of Research");
            this.auditErrors.add(new AuditError("document.protocolList[0].newDescription", "error.protocol.researchArea.notactive", stringBuilder.toString(), new String[]{inactiveResearchAreaCode}));
        }
        return !inactiveFound;
    }

    protected void reportAndCreateAuditCluster() {
        if (this.auditErrors.size() > 0) {
            GlobalVariables.getAuditErrorMap().put(ADDITIONAL_INFORMATION_AUDIT_ERRORS, new AuditCluster("Protocol", this.auditErrors, "Error"));
        }
    }
}

