/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl.multicampus;

import java.util.Collection;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.multicampus.MultiCampusIdentityService;
import org.kuali.coeus.common.framework.person.attr.KcPersonExtendedAttributes;
import org.kuali.rice.kim.api.identity.IdentityService;
import org.kuali.rice.kim.api.identity.affiliation.EntityAffiliationContract;
import org.kuali.rice.kim.api.identity.entity.Entity;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="multiCampusIdentityService")
public class MultiCampusIdentityServiceImpl
implements MultiCampusIdentityService {
    @Autowired
    @Qualifier(value="businessObjectService")
    private BusinessObjectService businessObjectService;
    @Autowired
    @Qualifier(value="identityService")
    private IdentityService identityService;

    @Override
    public String getMultiCampusPrincipalName(String principalName, String campusCode) {
        String result = principalName;
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("multiCampusPrincipalName", principalName);
        Collection multiCampusPersons = this.getBusinessObjectService().findMatching(KcPersonExtendedAttributes.class, fieldValues);
        for (KcPersonExtendedAttributes multiCampusPerson : multiCampusPersons) {
            String principalId = multiCampusPerson.getPersonId();
            if (!this.hasCampusAffiliation(principalId, campusCode)) continue;
            result = this.getIdentityService().getPrincipal(principalId).getPrincipalName();
            break;
        }
        return result;
    }

    private boolean hasCampusAffiliation(String principalId, String campusCode) {
        boolean hasCampusAffiliation = false;
        Entity entityInfo = this.getIdentityService().getEntityByPrincipalId(principalId);
        for (EntityAffiliationContract affiliation : entityInfo.getAffiliations()) {
            if (!StringUtils.equals((CharSequence)campusCode, (CharSequence)affiliation.getCampusCode())) continue;
            hasCampusAffiliation = true;
            break;
        }
        return hasCampusAffiliation;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public IdentityService getIdentityService() {
        return this.identityService;
    }

    public void setIdentityService(IdentityService identityService) {
        this.identityService = identityService;
    }
}

