/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.custom.CustomDataContainer;
import org.kuali.coeus.common.framework.custom.DocumentCustomData;
import org.kuali.coeus.common.framework.krms.KrmsRulesContext;
import org.kuali.coeus.common.notification.impl.bo.KcNotification;
import org.kuali.coeus.common.questionnaire.framework.answer.AnswerHeader;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.iacuc.IacucProtocolDocument;
import org.kuali.kra.iacuc.actions.IacucProtocolStatus;
import org.kuali.kra.iacuc.actions.copy.IacucProtocolCopyService;
import org.kuali.kra.iacuc.actions.submit.IacucProtocolSubmission;
import org.kuali.kra.iacuc.actions.submit.IacucProtocolSubmissionStatus;
import org.kuali.kra.iacuc.actions.submit.IacucProtocolSubmissionType;
import org.kuali.kra.iacuc.customdata.IacucProtocolCustomData;
import org.kuali.kra.iacuc.noteattachment.IacucProtocolAttachmentFilter;
import org.kuali.kra.iacuc.noteattachment.IacucProtocolAttachmentProtocol;
import org.kuali.kra.iacuc.personnel.IacucProtocolPersonnelService;
import org.kuali.kra.iacuc.procedures.IacucProcedurePersonResponsible;
import org.kuali.kra.iacuc.procedures.IacucProtocolProcedureService;
import org.kuali.kra.iacuc.procedures.IacucProtocolSpeciesStudyGroup;
import org.kuali.kra.iacuc.procedures.IacucProtocolStudyGroup;
import org.kuali.kra.iacuc.procedures.IacucProtocolStudyGroupBean;
import org.kuali.kra.iacuc.procedures.IacucProtocolStudyGroupLocation;
import org.kuali.kra.iacuc.protocol.IacucProtocolProjectType;
import org.kuali.kra.iacuc.protocol.research.IacucProtocolResearchArea;
import org.kuali.kra.iacuc.questionnaire.IacucProtocolModuleQuestionnaireBean;
import org.kuali.kra.iacuc.species.IacucProtocolSpecies;
import org.kuali.kra.iacuc.species.exception.IacucProtocolException;
import org.kuali.kra.iacuc.summary.IacucAlternateSearchSummary;
import org.kuali.kra.iacuc.summary.IacucProcedureSummary;
import org.kuali.kra.iacuc.summary.IacucProtocolExceptionSummary;
import org.kuali.kra.iacuc.summary.IacucProtocolSpeciesSummary;
import org.kuali.kra.iacuc.summary.IacucProtocolSummary;
import org.kuali.kra.iacuc.summary.IacucThreeRsSummary;
import org.kuali.kra.iacuc.threers.IacucAlternateSearch;
import org.kuali.kra.iacuc.threers.IacucPrinciples;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.ProtocolSpecialVersion;
import org.kuali.kra.protocol.actions.ProtocolActionBase;
import org.kuali.kra.protocol.actions.ProtocolStatusBase;
import org.kuali.kra.protocol.actions.amendrenew.ProtocolAmendRenewModuleBase;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionBase;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionStatusBase;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionTypeBase;
import org.kuali.kra.protocol.noteattachment.ProtocolAttachmentProtocolBase;
import org.kuali.kra.protocol.protocol.research.ProtocolResearchAreaBase;
import org.kuali.kra.protocol.summary.ProtocolSummary;
import org.kuali.rice.krad.util.GlobalVariables;

public class IacucProtocol
extends ProtocolBase
implements CustomDataContainer {
    private static final long serialVersionUID = 7380281405644745576L;
    private static final String NO = "no";
    private static final String PROTOCOL_PROJECT_TYPE = "protocolProjectType";
    private boolean isBillable;
    private String layStatement1;
    private String layStatement2;
    private String protocolProjectTypeCode;
    private String overviewTimeline;
    private String speciesStudyGroupIndicator;
    private String alternativeSearchIndicator;
    private String scientificJustifIndicator;
    private Timestamp createTimestamp;
    private String createUser;
    private IacucProtocolProjectType protocolProjectType;
    private List<IacucProtocolCustomData> iacucProtocolCustomDataList;
    private List<IacucPrinciples> iacucPrinciples;
    private List<IacucAlternateSearch> iacucAlternateSearches;
    private List<IacucProtocolSpecies> iacucProtocolSpeciesList;
    private List<IacucProtocolException> iacucProtocolExceptions;
    private List<IacucProtocolStudyGroupBean> iacucProtocolStudyGroups;
    private List<IacucProtocolStudyGroupBean> iacucProtocolStudyGroupBeans;
    private List<IacucProtocolStudyGroupLocation> iacucProtocolStudyGroupLocations;
    private List<IacucProtocolSpeciesStudyGroup> iacucProtocolStudyGroupSpeciesList;
    private Integer speciesCode;
    private Integer exceptionCategoryCode;

    public IacucProtocol() {
        this.setCreateTimestamp(new Timestamp(new Date().getTime()));
        if (GlobalVariables.getUserSession() != null) {
            this.setCreateUser(GlobalVariables.getUserSession().getPrincipalId());
        }
        this.setScientificJustifIndicator(NO);
        this.setSpecialReviewIndicator(NO);
        this.setSpeciesStudyGroupIndicator(NO);
        this.setKeyStudyPersonIndicator(NO);
        this.setFundingSourceIndicator(NO);
        this.setCorrespondentIndicator(NO);
        this.setReferenceIndicator(NO);
        this.setAlternativeSearchIndicator(NO);
        this.setIacucProtocolSpeciesList(new ArrayList<IacucProtocolSpecies>());
        this.setIacucAlternateSearches(new ArrayList<IacucAlternateSearch>());
        this.setIacucProtocolCustomDataList(new ArrayList<IacucProtocolCustomData>());
        this.setIacucProtocolExceptions(new ArrayList<IacucProtocolException>());
        this.setIacucProtocolStudyGroups(new ArrayList<IacucProtocolStudyGroupBean>());
        this.setIacucProtocolStudyGroupBeans(new ArrayList<IacucProtocolStudyGroupBean>());
        this.setIacucProtocolStudyGroupLocations(new ArrayList<IacucProtocolStudyGroupLocation>());
        this.setIacucProtocolStudyGroupSpeciesList(new ArrayList<IacucProtocolSpeciesStudyGroup>());
        this.initIacucPrinciples();
    }

    @Override
    public List buildListOfDeletionAwareLists() {
        List managedLists = super.buildListOfDeletionAwareLists();
        managedLists.add(this.getIacucProtocolCustomDataList());
        managedLists.add(this.getIacucPrinciples());
        managedLists.add(this.getIacucAlternateSearches());
        ArrayList<IacucProtocolStudyGroupLocation> locationResponsibleProcedures = new ArrayList<IacucProtocolStudyGroupLocation>();
        ArrayList<IacucProcedurePersonResponsible> personResponsibleProcedures = new ArrayList<IacucProcedurePersonResponsible>();
        ArrayList<IacucProtocolStudyGroup> iacucProtocolStudyGroups = new ArrayList<IacucProtocolStudyGroup>();
        for (IacucProtocolStudyGroupBean iacucProtocolStudyGroupBean : this.getIacucProtocolStudyGroups()) {
            iacucProtocolStudyGroups.addAll(iacucProtocolStudyGroupBean.getIacucProtocolStudyGroups());
            for (IacucProtocolStudyGroup iacucProtocolStudyGroup : iacucProtocolStudyGroupBean.getIacucProtocolStudyGroups()) {
                personResponsibleProcedures.addAll(iacucProtocolStudyGroup.getIacucProcedurePersonResponsibleList());
                locationResponsibleProcedures.addAll(iacucProtocolStudyGroup.getIacucProcedureLocationResponsibleList());
            }
        }
        managedLists.add(locationResponsibleProcedures);
        managedLists.add(personResponsibleProcedures);
        managedLists.add(iacucProtocolStudyGroups);
        managedLists.add(this.getIacucProtocolStudyGroups());
        managedLists.add(this.getIacucProtocolExceptions());
        managedLists.add(this.getIacucProtocolSpeciesList());
        return managedLists;
    }

    public IacucProtocolSubmission getIacucProtocolSubmission() {
        return (IacucProtocolSubmission)this.getProtocolSubmission();
    }

    public boolean getIsBillable() {
        return this.isBillable;
    }

    public void setIsBillable(boolean isBillable) {
        this.isBillable = isBillable;
    }

    public String getLayStatement1() {
        return this.layStatement1;
    }

    public void setLayStatement1(String layStatement1) {
        this.layStatement1 = layStatement1;
    }

    public String getLayStatement2() {
        return this.layStatement2;
    }

    public void setLayStatement2(String layStatement2) {
        this.layStatement2 = layStatement2;
    }

    public String getOverviewTimeline() {
        return this.overviewTimeline;
    }

    public void setOverviewTimeline(String overviewTimeline) {
        this.overviewTimeline = overviewTimeline;
    }

    public String getSpeciesStudyGroupIndicator() {
        return this.speciesStudyGroupIndicator;
    }

    public void setSpeciesStudyGroupIndicator(String speciesStudyGroupIndicator) {
        this.speciesStudyGroupIndicator = speciesStudyGroupIndicator;
    }

    public String getAlternativeSearchIndicator() {
        return this.alternativeSearchIndicator;
    }

    public void setAlternativeSearchIndicator(String alternativeSearchIndicator) {
        this.alternativeSearchIndicator = alternativeSearchIndicator;
    }

    public String getScientificJustifIndicator() {
        return this.scientificJustifIndicator;
    }

    public void setScientificJustifIndicator(String scientificJustifIndicator) {
        this.scientificJustifIndicator = scientificJustifIndicator;
    }

    public void setIacucProtocolDocument(IacucProtocolDocument iacucProtocolDocument) {
        this.setProtocolDocument(iacucProtocolDocument);
    }

    public IacucProtocolDocument getIacucProtocolDocument() {
        return (IacucProtocolDocument)this.getProtocolDocument();
    }

    public void setBillable(boolean isBillable) {
        this.isBillable = isBillable;
    }

    @Override
    public Timestamp getCreateTimestamp() {
        return this.createTimestamp;
    }

    @Override
    public void setCreateTimestamp(Timestamp createTimestamp) {
        this.createTimestamp = createTimestamp;
    }

    @Override
    public String getCreateUser() {
        return this.createUser;
    }

    @Override
    public void setCreateUser(String createUser) {
        this.createUser = createUser;
    }

    @Override
    protected IacucProtocolPersonnelService getProtocolPersonnelService() {
        return KcServiceLocator.getService(IacucProtocolPersonnelService.class);
    }

    @Override
    public String getNamespace() {
        return "KC-IACUC";
    }

    @Override
    protected String getDefaultProtocolStatusCodeHook() {
        return "100";
    }

    @Override
    protected String getDefaultProtocolTypeCodeHook() {
        return null;
    }

    @Override
    protected ProtocolSubmissionStatusBase getProtocolSubmissionStatusNewInstanceHook() {
        return new IacucProtocolSubmissionStatus();
    }

    @Override
    protected ProtocolSubmissionTypeBase getProtocolSubmissionTypeNewInstanceHook() {
        return new IacucProtocolSubmissionType();
    }

    @Override
    protected ProtocolSubmissionBase getProtocolSubmissionNewInstanceHook() {
        return new IacucProtocolSubmission();
    }

    @Override
    protected ProtocolStatusBase getProtocolStatusNewInstanceHook() {
        return new IacucProtocolStatus();
    }

    @Override
    public String getDocumentRoleTypeCode() {
        return "KC-IACUC";
    }

    @Override
    public List<String> getRoleNames() {
        ArrayList<String> roleNames = new ArrayList<String>();
        roleNames.add("IACUC Protocol Aggregator");
        roleNames.add("IACUC Protocol Viewer");
        return roleNames;
    }

    public List<IacucPrinciples> getIacucPrinciples() {
        return this.iacucPrinciples;
    }

    public void setIacucPrinciples(List<IacucPrinciples> iacucPrinciples) {
        this.iacucPrinciples = iacucPrinciples;
    }

    public List<IacucProtocolSpecies> getIacucProtocolSpeciesList() {
        return this.iacucProtocolSpeciesList;
    }

    public void setIacucProtocolSpeciesList(List<IacucProtocolSpecies> iacucProtocolSpeciesList) {
        this.iacucProtocolSpeciesList = iacucProtocolSpeciesList;
    }

    @Override
    protected ProtocolResearchAreaBase getNewProtocolResearchAreaInstance() {
        return new IacucProtocolResearchArea();
    }

    public List<IacucAlternateSearch> getIacucAlternateSearches() {
        return this.iacucAlternateSearches;
    }

    public void setIacucAlternateSearches(List<IacucAlternateSearch> iacucAlternateSearches) {
        this.iacucAlternateSearches = iacucAlternateSearches;
    }

    public void setProtocolProjectTypeCode(String protocolProjectTypeCode) {
        this.protocolProjectTypeCode = protocolProjectTypeCode;
    }

    public String getProtocolProjectTypeCode() {
        return this.protocolProjectTypeCode;
    }

    public void setProtocolProjectType(IacucProtocolProjectType protocolProjectType) {
        this.protocolProjectType = protocolProjectType;
    }

    public IacucProtocolProjectType getProtocolProjectType() {
        return this.protocolProjectType;
    }

    public List<IacucProtocolCustomData> getIacucProtocolCustomDataList() {
        return this.iacucProtocolCustomDataList;
    }

    public void setIacucProtocolCustomDataList(List<IacucProtocolCustomData> iacucProtocolCustomDataList) {
        this.iacucProtocolCustomDataList = iacucProtocolCustomDataList;
    }

    public List<IacucProtocolException> getIacucProtocolExceptions() {
        return this.iacucProtocolExceptions;
    }

    public void setIacucProtocolExceptions(List<IacucProtocolException> iacucProtocolExceptions) {
        this.iacucProtocolExceptions = iacucProtocolExceptions;
    }

    private void initIacucPrinciples() {
        ArrayList<IacucPrinciples> newPrinciples = new ArrayList<IacucPrinciples>();
        IacucPrinciples iPrinciples = new IacucPrinciples();
        newPrinciples.add(iPrinciples);
        this.setIacucPrinciples(newPrinciples);
    }

    public Integer getSpeciesCode() {
        return this.speciesCode;
    }

    public void setSpeciesCode(Integer speciesCode) {
        this.speciesCode = speciesCode;
    }

    public Integer getExceptionCategoryCode() {
        return this.exceptionCategoryCode;
    }

    public void setExceptionCategoryCode(Integer exceptionCategoryCode) {
        this.exceptionCategoryCode = exceptionCategoryCode;
    }

    @Override
    public List<AnswerHeader> getAnswerHeaderForProtocol(ProtocolBase protocol) {
        IacucProtocolModuleQuestionnaireBean moduleQuestionnaireBean = new IacucProtocolModuleQuestionnaireBean((IacucProtocol)protocol);
        moduleQuestionnaireBean.setModuleSubItemCode("0");
        return this.getQuestionnaireAnswerService().getQuestionnaireAnswer(moduleQuestionnaireBean);
    }

    @Override
    public void initializeProtocolAttachmentFilter() {
        IacucProtocolAttachmentFilter protocolAttachmentFilter = new IacucProtocolAttachmentFilter();
        try {
            String defaultSortBy = this.getParameterService().getParameterValueAsString(IacucProtocolDocument.class, "IACUC_PROTOCOL_ATTACHMENT_DEFAULT_SORT");
            if (StringUtils.isNotBlank((CharSequence)defaultSortBy)) {
                protocolAttachmentFilter.setSortBy(defaultSortBy);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setProtocolAttachmentFilter(protocolAttachmentFilter);
    }

    @Override
    public String getDocumentKey() {
        return "protocol";
    }

    @Override
    public ProtocolSummary getProtocolSummary() {
        ProtocolSummary protocolSummary = this.createProtocolSummary();
        this.addPersonnelSummaries(protocolSummary);
        this.addResearchAreaSummaries(protocolSummary);
        this.addAttachmentSummaries(protocolSummary);
        this.addFundingSourceSummaries(protocolSummary);
        this.addOrganizationSummaries(protocolSummary);
        this.addSpecialReviewSummaries(protocolSummary);
        this.addAdditionalInfoSummary(protocolSummary);
        this.addThreeRsSummary((IacucProtocolSummary)protocolSummary);
        this.addSpeciesAndGroupsSummaries((IacucProtocolSummary)protocolSummary);
        this.addExceptionsSummaries((IacucProtocolSummary)protocolSummary);
        this.addProceduresSummaries((IacucProtocolSummary)protocolSummary);
        return protocolSummary;
    }

    @Override
    protected ProtocolSummary createProtocolSummary() {
        IacucProtocolSummary summary = new IacucProtocolSummary();
        summary.setLastProtocolAction(this.getLastProtocolAction());
        summary.setProtocolNumber(this.getProtocolNumber());
        summary.setPiName(this.getPrincipalInvestigator().getPersonName());
        summary.setPiProtocolPersonId(this.getPrincipalInvestigator().getProtocolPersonId());
        summary.setInitialSubmissionDate(this.getInitialSubmissionDate());
        summary.setApprovalDate(this.getApprovalDate());
        summary.setLastApprovalDate(this.getLastApprovalDate());
        summary.setExpirationDate(this.getExpirationDate());
        if (this.getProtocolType() == null) {
            this.refreshReferenceObject("protocolType");
        }
        summary.setType(this.getProtocolType().getDescription());
        if (this.getProtocolStatus() == null) {
            this.refreshReferenceObject("protocolStatus");
        }
        summary.setStatus(this.getProtocolStatus().getDescription());
        summary.setTitle(this.getTitle());
        summary.setLayStmt1(this.getLayStatement1());
        summary.setLayStmt2(this.getLayStatement2());
        if (this.getProtocolProjectType() == null) {
            this.refreshReferenceObject(PROTOCOL_PROJECT_TYPE);
        }
        summary.setProjectType(this.protocolProjectType != null ? this.protocolProjectType.getDescription() : "N/A");
        return summary;
    }

    protected void addThreeRsSummary(IacucProtocolSummary protocolSummary) {
        IacucThreeRsSummary threeRsSummary = new IacucThreeRsSummary();
        if (this.getIacucPrinciples().size() > 0) {
            IacucPrinciples principles = this.getIacucPrinciples().get(0);
            threeRsSummary.setReduction(principles.getReduction());
            threeRsSummary.setRefinement(principles.getRefinement());
            threeRsSummary.setReplacement(principles.getReplacement());
            for (IacucAlternateSearch alternateSearch : this.iacucAlternateSearches) {
                threeRsSummary.getAlternateSearchSummaries().add(new IacucAlternateSearchSummary(alternateSearch));
                threeRsSummary.setSearchRequired("Y".equals(principles.getSearchRequired()));
            }
        }
        protocolSummary.setThreeRsInfo(threeRsSummary);
    }

    protected void addSpeciesAndGroupsSummaries(IacucProtocolSummary protocolSummary) {
        for (IacucProtocolSpecies species : this.iacucProtocolSpeciesList) {
            IacucProtocolSpeciesSummary newSummary = new IacucProtocolSpeciesSummary(species);
            protocolSummary.getSpeciesSummaries().add(newSummary);
        }
    }

    protected void addExceptionsSummaries(IacucProtocolSummary protocolSummary) {
        for (IacucProtocolException exception : this.iacucProtocolExceptions) {
            IacucProtocolExceptionSummary newSummary = new IacucProtocolExceptionSummary(exception);
            protocolSummary.getExceptionSummaries().add(newSummary);
        }
    }

    protected void addProceduresSummaries(IacucProtocolSummary protocolSummary) {
        protocolSummary.setProcedureOverviewSummary(this.overviewTimeline);
        for (IacucProtocolStudyGroupBean studyGroupBean : this.getIacucProtocolStudyGroups()) {
            for (IacucProtocolStudyGroup studyGroup : studyGroupBean.getIacucProtocolStudyGroups()) {
                IacucProcedureSummary newSummary = new IacucProcedureSummary(studyGroup, studyGroupBean.getIacucProcedureCategory(), studyGroupBean.getIacucProcedure());
                protocolSummary.getProcedureSummaries().add(newSummary);
            }
        }
    }

    public List<IacucProtocolStudyGroupBean> getIacucProtocolStudyGroups() {
        return this.iacucProtocolStudyGroups;
    }

    public void setIacucProtocolStudyGroups(List<IacucProtocolStudyGroupBean> iacucProtocolStudyGroups) {
        this.iacucProtocolStudyGroups = iacucProtocolStudyGroups;
    }

    public List<IacucProtocolStudyGroupBean> getIacucProtocolStudyGroupBeans() {
        return this.iacucProtocolStudyGroupBeans;
    }

    public void setIacucProtocolStudyGroupBeans(List<IacucProtocolStudyGroupBean> iacucProtocolStudyGroupBeans) {
        this.iacucProtocolStudyGroupBeans = iacucProtocolStudyGroupBeans;
    }

    @Override
    protected String getProtocolModuleAddModifyAttachmentCodeHook() {
        return "008";
    }

    @Override
    protected boolean isExpirationDateToBeUpdated(ProtocolBase protocol) {
        return super.isExpirationDateToBeUpdated(protocol) || ((IacucProtocol)protocol).isContinuation();
    }

    @Override
    public void merge(ProtocolBase amendment, String protocolModuleTypeCode) {
        if (StringUtils.equals((CharSequence)protocolModuleTypeCode, (CharSequence)"001")) {
            this.mergeGeneralInfo(amendment);
        } else if (StringUtils.equals((CharSequence)protocolModuleTypeCode, (CharSequence)"004")) {
            this.mergeResearchAreas(amendment);
        } else if (StringUtils.equals((CharSequence)protocolModuleTypeCode, (CharSequence)"024")) {
            this.mergeFundingSources(amendment);
        } else if (StringUtils.equals((CharSequence)protocolModuleTypeCode, (CharSequence)"017")) {
            this.mergeOrganizations(amendment);
        } else if (StringUtils.equals((CharSequence)protocolModuleTypeCode, (CharSequence)"002")) {
            this.mergePersonnel(amendment);
        } else if (StringUtils.equals((CharSequence)protocolModuleTypeCode, (CharSequence)"008")) {
            if (amendment.isAmendment() || amendment.isRenewal() || !amendment.getAttachmentProtocols().isEmpty() && this.getAttachmentProtocols().isEmpty()) {
                this.mergeAttachments(amendment);
            } else {
                this.restoreAttachments(this);
            }
        } else if (StringUtils.equals((CharSequence)protocolModuleTypeCode, (CharSequence)"016")) {
            this.mergeReferences(amendment);
        } else if (StringUtils.equals((CharSequence)protocolModuleTypeCode, (CharSequence)"007")) {
            this.mergeSpecialReview(amendment);
        } else if (StringUtils.equals((CharSequence)protocolModuleTypeCode, (CharSequence)"023")) {
            this.mergeOthers(amendment);
        } else if (StringUtils.equals((CharSequence)protocolModuleTypeCode, (CharSequence)"025")) {
            this.mergeProtocolPermissions(amendment);
        } else if (StringUtils.equals((CharSequence)protocolModuleTypeCode, (CharSequence)"026")) {
            this.mergeProtocolQuestionnaire(amendment);
        } else if (StringUtils.equals((CharSequence)protocolModuleTypeCode, (CharSequence)"036")) {
            this.mergeProtocolThreers(amendment);
        } else if (StringUtils.equals((CharSequence)protocolModuleTypeCode, (CharSequence)"032")) {
            this.mergeProtocolSpeciesAndGroups(amendment);
        } else if (StringUtils.equals((CharSequence)protocolModuleTypeCode, (CharSequence)"031")) {
            this.mergeProtocolProcedures(amendment);
        } else if (StringUtils.equals((CharSequence)protocolModuleTypeCode, (CharSequence)"033")) {
            this.mergeProtocolExceptions(amendment);
        }
    }

    @Override
    protected void removeMergeableLists(List<ProtocolAmendRenewModuleBase> modules) {
        for (ProtocolAmendRenewModuleBase module : modules) {
            String protocolModuleTypeCode = module.getProtocolModuleTypeCode();
            if (StringUtils.equals((CharSequence)protocolModuleTypeCode, (CharSequence)"004")) {
                this.getProtocolResearchAreas().clear();
                continue;
            }
            if (StringUtils.equals((CharSequence)protocolModuleTypeCode, (CharSequence)"024")) {
                this.getProtocolFundingSources().clear();
                continue;
            }
            if (StringUtils.equals((CharSequence)protocolModuleTypeCode, (CharSequence)"017")) {
                this.getProtocolLocations().clear();
                continue;
            }
            if (StringUtils.equals((CharSequence)protocolModuleTypeCode, (CharSequence)"002")) {
                this.getProtocolPersons().clear();
                continue;
            }
            if (StringUtils.equals((CharSequence)protocolModuleTypeCode, (CharSequence)"016")) {
                this.getProtocolReferences().clear();
                continue;
            }
            if (StringUtils.equals((CharSequence)protocolModuleTypeCode, (CharSequence)"036")) {
                this.getIacucPrinciples().clear();
                continue;
            }
            if (StringUtils.equals((CharSequence)protocolModuleTypeCode, (CharSequence)"031")) {
                this.getIacucPrinciples().clear();
                continue;
            }
            if (!StringUtils.equals((CharSequence)protocolModuleTypeCode, (CharSequence)"033")) continue;
            this.getIacucPrinciples().clear();
        }
    }

    @Override
    protected void mergeProtocolAction(ProtocolBase amendment) {
        List<ProtocolActionBase> protocolActions = this.deepCopy(amendment.getProtocolActions());
        Collections.sort(protocolActions, (action1, action2) -> action1.getActionId().compareTo(action2.getActionId()));
        protocolActions.remove(0);
        protocolActions.remove(protocolActions.size() - 1);
        for (ProtocolActionBase protocolAction : protocolActions) {
            protocolAction.setProtocolNumber(this.getProtocolNumber());
            protocolAction.setProtocolActionId(null);
            protocolAction.setSequenceNumber(this.getSequenceNumber());
            protocolAction.setProtocolId(this.getProtocolId());
            String index = amendment.getProtocolNumber().substring(11);
            protocolAction.setActionId(this.getNextValue("actionId"));
            String type = this.getProtocolMergeType(amendment);
            if (StringUtils.isNotBlank((CharSequence)protocolAction.getComments())) {
                protocolAction.setComments(type + "-" + index + ": " + protocolAction.getComments());
            } else {
                protocolAction.setComments(type + "-" + index + ": ");
            }
            for (KcNotification notification : protocolAction.getProtocolNotifications()) {
                notification.setDocumentNumber(this.getProtocolDocument().getDocumentNumber());
                notification.setNotificationId(null);
            }
            for (KcNotification notification : protocolAction.getProtocolNotifications()) {
                notification.setDocumentNumber(this.getProtocolDocument().getDocumentNumber());
                notification.setNotificationId(null);
            }
            this.getProtocolActions().add(protocolAction);
        }
    }

    @Override
    protected void mergeGeneralInfo(ProtocolBase amendment) {
        super.mergeGeneralInfo(amendment);
        this.layStatement1 = ((IacucProtocol)amendment).layStatement1;
        this.layStatement2 = ((IacucProtocol)amendment).layStatement2;
        this.overviewTimeline = ((IacucProtocol)amendment).overviewTimeline;
        this.protocolProjectTypeCode = ((IacucProtocol)amendment).protocolProjectTypeCode;
    }

    protected void mergeProtocolThreers(ProtocolBase amendment) {
        this.getProtocolCopyService().copyProtocolThreers((IacucProtocol)amendment, this);
    }

    protected void mergeProtocolSpeciesAndGroups(ProtocolBase amendment) {
        this.getProtocolProcedureService().mergeProtocolSpecies((IacucProtocol)amendment, this);
    }

    protected void mergeProtocolProcedures(ProtocolBase amendment) {
        this.getProtocolProcedureService().mergeProtocolProcedures((IacucProtocol)amendment, this);
    }

    protected void mergeProtocolExceptions(ProtocolBase amendment) {
        this.getProtocolCopyService().copyProtocolExceptions((IacucProtocol)amendment, this);
    }

    protected IacucProtocolCopyService getProtocolCopyService() {
        return KcServiceLocator.getService(IacucProtocolCopyService.class);
    }

    public boolean isContinuation() {
        return this.getProtocolNumber() != null && this.getProtocolNumber().contains(ProtocolSpecialVersion.CONTINUATION.getCode());
    }

    protected String getProtocolMergeType(ProtocolBase amendment) {
        IacucProtocol protocolAmend = (IacucProtocol)amendment;
        String type = ProtocolSpecialVersion.AMENDMENT.getDescription();
        if (protocolAmend.isRenewal()) {
            type = ProtocolSpecialVersion.RENEWAL.getDescription();
        } else if (protocolAmend.isContinuation()) {
            type = ProtocolSpecialVersion.CONTINUATION.getDescription();
        } else if (protocolAmend.isFYI()) {
            type = ProtocolSpecialVersion.FYI.getDescription();
        }
        return type;
    }

    @Override
    public boolean isNew() {
        return !this.isAmendment() && !this.isRenewal() && !this.isContinuation() && !this.isFYI();
    }

    public boolean isContinuationWithoutAmendment() {
        return this.isContinuation() && CollectionUtils.isEmpty(this.getProtocolAmendRenewal().getModules());
    }

    @Override
    public String getAmendedProtocolNumber() {
        if (this.isAmendment()) {
            return StringUtils.substringBefore((String)this.getProtocolNumber(), (String)ProtocolSpecialVersion.AMENDMENT.getCode());
        }
        if (this.isRenewal()) {
            return StringUtils.substringBefore((String)this.getProtocolNumber(), (String)ProtocolSpecialVersion.RENEWAL.getCode());
        }
        if (this.isContinuation()) {
            return StringUtils.substringBefore((String)this.getProtocolNumber(), (String)ProtocolSpecialVersion.CONTINUATION.getCode());
        }
        if (this.isFYI()) {
            return StringUtils.substringBefore((String)this.getProtocolNumber(), (String)ProtocolSpecialVersion.FYI.getCode());
        }
        return null;
    }

    @Override
    protected void prePersist() {
        super.prePersist();
    }

    protected IacucProtocolProcedureService getProtocolProcedureService() {
        return KcServiceLocator.getService(IacucProtocolProcedureService.class);
    }

    @Override
    public KrmsRulesContext getKrmsRulesContext() {
        return this.getIacucProtocolDocument();
    }

    @Override
    public void populateAdditionalQualifiedRoleAttributes(Map<String, String> qualifiedRoleAttributes) {
        if (qualifiedRoleAttributes == null) {
            qualifiedRoleAttributes = new HashMap<String, String>();
        }
        String protocolNumber = this.getProtocolNumber() != null ? this.getProtocolNumber() : "*";
        qualifiedRoleAttributes.put("protocol", protocolNumber);
    }

    @Override
    protected Class<? extends ProtocolAttachmentProtocolBase> getProtocolAttachmentProtocolClassHook() {
        return IacucProtocolAttachmentProtocol.class;
    }

    public List<IacucProtocolStudyGroupLocation> getIacucProtocolStudyGroupLocations() {
        return this.iacucProtocolStudyGroupLocations;
    }

    public void setIacucProtocolStudyGroupLocations(List<IacucProtocolStudyGroupLocation> iacucProtocolStudyGroupLocations) {
        this.iacucProtocolStudyGroupLocations = iacucProtocolStudyGroupLocations;
    }

    public List<IacucProtocolSpeciesStudyGroup> getIacucProtocolStudyGroupSpeciesList() {
        return this.iacucProtocolStudyGroupSpeciesList;
    }

    public void setIacucProtocolStudyGroupSpeciesList(List<IacucProtocolSpeciesStudyGroup> iacucProtocolStudyGroupSpeciesList) {
        this.iacucProtocolStudyGroupSpeciesList = iacucProtocolStudyGroupSpeciesList;
    }

    @Override
    protected void mergePersonnel(ProtocolBase amendment) {
        super.mergePersonnel(amendment);
        this.getProtocolProcedureService().mergeProtocolProcedurePersonnel(this);
    }

    @Override
    public List<? extends DocumentCustomData> getCustomDataList() {
        return this.getProtocolDocument().getDocumentCustomData();
    }
}

