/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.actions.submit;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.committee.impl.bo.CommitteeMembershipBase;
import org.kuali.coeus.common.committee.impl.service.CommitteeServiceBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.iacuc.actions.IacucActionHelper;
import org.kuali.kra.iacuc.actions.IacucProtocolActionBean;
import org.kuali.kra.iacuc.actions.submit.IacucProtocolReviewerBean;
import org.kuali.kra.iacuc.committee.service.IacucCommitteeService;
import org.kuali.kra.protocol.actions.ActionHelperBase;
import org.kuali.kra.protocol.actions.submit.ProtocolReviewerBeanBase;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmitAction;
import org.springframework.util.AutoPopulatingList;

public class IacucProtocolSubmitAction
extends IacucProtocolActionBean
implements ProtocolSubmitAction {
    private static final long serialVersionUID = 4456005318168340284L;
    private String submissionTypeCode = "";
    private String protocolReviewTypeCode = "";
    private String submissionQualifierTypeCode = "";
    protected String committeeId = "";
    protected String scheduleId = "";
    protected boolean committeeIdChanged = false;
    protected boolean scheduleIdChanged = false;
    protected boolean reviewerListAvailable = false;
    protected int numberOfReviewers = 0;
    protected List<ProtocolReviewerBeanBase> reviewers = new AutoPopulatingList(IacucProtocolReviewerBean.class);
    private String newCommitteeId = "";
    private String newScheduleId = "";
    private boolean javascriptEnabled = true;

    public IacucProtocolSubmitAction(ActionHelperBase actionHelper) {
        super(actionHelper);
    }

    @Override
    public void prepareView() {
        if (!this.getJavascriptEnabled()) {
            if (!(StringUtils.isBlank((CharSequence)this.committeeId) || this.committeeIdChanged || StringUtils.isBlank((CharSequence)this.scheduleId))) {
                if (this.scheduleIdChanged) {
                    this.reviewers.clear();
                    this.buildReviewers();
                }
            } else {
                this.reviewers.clear();
                this.reviewerListAvailable = false;
            }
        } else {
            this.reviewers.subList(this.numberOfReviewers, this.reviewers.size()).clear();
        }
    }

    private void buildReviewers() {
        this.reviewerListAvailable = true;
        List<CommitteeMembershipBase> members = this.getProtocol().filterOutProtocolPersonnel(this.getCommitteeService().getAvailableMembers(this.committeeId, this.scheduleId));
        for (CommitteeMembershipBase member : members) {
            this.reviewers.add(new IacucProtocolReviewerBean(member));
        }
    }

    @Override
    public void setNumberOfReviewers(int numberOfReviewers) {
        this.numberOfReviewers = numberOfReviewers;
    }

    @Override
    public CommitteeServiceBase getCommitteeService() {
        return KcServiceLocator.getService(IacucCommitteeService.class);
    }

    @Override
    public String getSubmissionTypeCode() {
        return this.submissionTypeCode;
    }

    @Override
    public void setSubmissionTypeCode(String submissionTypeCode) {
        this.submissionTypeCode = submissionTypeCode;
    }

    @Override
    public String getProtocolReviewTypeCode() {
        return this.protocolReviewTypeCode;
    }

    @Override
    public void setProtocolReviewTypeCode(String protocolReviewTypeCode) {
        this.protocolReviewTypeCode = protocolReviewTypeCode;
    }

    @Override
    public String getSubmissionQualifierTypeCode() {
        return this.submissionQualifierTypeCode;
    }

    @Override
    public void setSubmissionQualifierTypeCode(String submissionQualifierTypeCode) {
        this.submissionQualifierTypeCode = submissionQualifierTypeCode;
    }

    @Override
    public String getCommitteeId() {
        return this.committeeId;
    }

    @Override
    public void setCommitteeId(String committeeId) {
        this.committeeIdChanged = true;
        if (StringUtils.equals((CharSequence)this.committeeId, (CharSequence)committeeId)) {
            this.committeeIdChanged = false;
        }
        this.committeeId = committeeId;
        this.newCommitteeId = committeeId;
    }

    @Override
    public void setNewCommitteeId(String id) {
        this.newCommitteeId = id;
    }

    @Override
    public String getNewCommitteeId() {
        return this.newCommitteeId;
    }

    @Override
    public String getScheduleId() {
        return this.scheduleId;
    }

    @Override
    public void setScheduleId(String scheduleId) {
        this.scheduleIdChanged = true;
        if (StringUtils.equals((CharSequence)this.scheduleId, (CharSequence)scheduleId)) {
            this.scheduleIdChanged = false;
        }
        this.scheduleId = scheduleId;
        this.newScheduleId = scheduleId;
    }

    @Override
    public String getNewScheduleId() {
        return this.newScheduleId;
    }

    @Override
    public boolean isReviewerListAvailable() {
        return this.reviewerListAvailable;
    }

    @Override
    public List<ProtocolReviewerBeanBase> getReviewers() {
        return this.reviewers;
    }

    @Override
    public ProtocolReviewerBeanBase getReviewer(int i) {
        return this.reviewers.get(i);
    }

    @Override
    public List<ProtocolReviewerBeanBase> getLeftReviewers() {
        ArrayList<ProtocolReviewerBeanBase> leftReviewers = new ArrayList<ProtocolReviewerBeanBase>();
        for (int i = 0; i < (this.reviewers.size() + 1) / 2; ++i) {
            leftReviewers.add(this.reviewers.get(i));
        }
        return leftReviewers;
    }

    @Override
    public List<ProtocolReviewerBeanBase> getRightReviewers() {
        ArrayList<ProtocolReviewerBeanBase> rightReviewers = new ArrayList<ProtocolReviewerBeanBase>();
        for (int i = (this.reviewers.size() + 1) / 2; i < this.reviewers.size(); ++i) {
            rightReviewers.add(this.reviewers.get(i));
        }
        return rightReviewers;
    }

    @Override
    public void setReviewers(List<ProtocolReviewerBeanBase> reviewerBeans) {
        this.reviewers = reviewerBeans;
    }

    @Override
    public boolean getJavascriptEnabled() {
        return this.javascriptEnabled;
    }

    @Override
    public void setJavascriptEnabled(boolean javascriptEnabled) {
        this.javascriptEnabled = javascriptEnabled;
    }

    public IacucProtocolSubmitAction(IacucActionHelper actionHelper) {
        super(actionHelper);
    }
}

