/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.actions.submit;

import java.sql.Date;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.kuali.coeus.coi.framework.Project;
import org.kuali.coeus.coi.framework.ProjectPublisher;
import org.kuali.coeus.coi.framework.ProjectRetrievalService;
import org.kuali.coeus.common.committee.impl.bo.CommitteeScheduleBase;
import org.kuali.coeus.common.committee.impl.meeting.CommitteeScheduleMinuteBase;
import org.kuali.kra.iacuc.IacucProtocol;
import org.kuali.kra.iacuc.IacucProtocolDocument;
import org.kuali.kra.iacuc.actions.IacucProtocolAction;
import org.kuali.kra.iacuc.actions.IacucProtocolStatus;
import org.kuali.kra.iacuc.actions.assignreviewers.IacucProtocolAssignReviewersService;
import org.kuali.kra.iacuc.actions.submit.IacucProtocolSubmission;
import org.kuali.kra.iacuc.actions.submit.IacucProtocolSubmissionBuilder;
import org.kuali.kra.iacuc.actions.submit.IacucProtocolSubmitAction;
import org.kuali.kra.iacuc.actions.submit.IacucProtocolSubmitActionService;
import org.kuali.kra.iacuc.committee.meeting.IacucCommitteeScheduleMinute;
import org.kuali.kra.protocol.actions.submit.ProtocolActionService;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.document.authorization.PessimisticLock;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DocumentService;

public class IacucProtocolSubmitActionServiceImpl
implements IacucProtocolSubmitActionService {
    private static final String PROTOCOL_NUMBER = "protocolNumber";
    private static final String SUBMITTED_TO_IACUC = "SubmittedToIACUC";
    private DocumentService documentService;
    private ProtocolActionService protocolActionService;
    private BusinessObjectService businessObjectService;
    private IacucProtocolAssignReviewersService iacucProtocolAssignReviewersService;
    private DataObjectService dataObjectService;
    private ProjectRetrievalService projectRetrievalService;
    private ProjectPublisher projectPublisher;

    @Override
    public int getTotalSubmissions(IacucProtocol protocol) {
        int totalSubmissions = 0;
        for (IacucProtocolSubmission protocolSubmission : this.getProtocolSubmissions(protocol.getProtocolNumber())) {
            int submissionNumber = protocolSubmission.getSubmissionNumber();
            if (submissionNumber <= totalSubmissions || protocolSubmission.getSequenceNumber() > protocol.getSequenceNumber()) continue;
            totalSubmissions = submissionNumber;
        }
        return totalSubmissions;
    }

    protected List<IacucProtocolSubmission> getProtocolSubmissions(String protocolNumber) {
        Collection submissions = this.businessObjectService.findMatching(IacucProtocolSubmission.class, Collections.singletonMap(PROTOCOL_NUMBER, protocolNumber));
        return new ArrayList<IacucProtocolSubmission>(submissions);
    }

    @Override
    public void submitToIacucForReview(IacucProtocol protocol, IacucProtocolSubmitAction submitAction) {
        IacucProtocolDocument protocolDocument;
        List locks;
        String prevSubmissionStatus = protocol.getProtocolSubmission().getSubmissionStatusCode();
        String submissionTypeCode = protocol.getProtocolSubmission().getSubmissionTypeCode();
        IacucProtocolSubmission submission = this.createProtocolSubmission(protocol, submitAction);
        if (protocol.getInitialSubmissionDate() == null) {
            protocol.setInitialSubmissionDate(new Date(submission.getSubmissionDate().getTime()));
        }
        this.getIacucProtocolAssignReviewersService().assignReviewers(submission, submitAction.getReviewers());
        IacucProtocolAction protocolAction = new IacucProtocolAction(protocol, submission, "101");
        protocolAction.setComments(SUBMITTED_TO_IACUC);
        protocolAction.setPrevProtocolStatusCode(protocol.getProtocolStatusCode());
        protocolAction.setPrevSubmissionStatusCode(prevSubmissionStatus);
        protocolAction.setSubmissionTypeCode(submissionTypeCode);
        protocolAction.setCreatedSubmission(true);
        protocol.getProtocolActions().add(protocolAction);
        IacucProtocolStatus protocolStatus = new IacucProtocolStatus();
        protocolStatus.setProtocolStatusCode("101");
        protocolStatus.setDescription(SUBMITTED_TO_IACUC);
        protocol.setProtocolStatus(protocolStatus);
        protocol.setProtocolStatusCode("101");
        this.protocolActionService.updateProtocolStatus(protocolAction, protocol);
        if (submission.getScheduleIdFk() != null) {
            this.updateDefaultSchedule(submission);
        }
        if ((locks = protocol.getProtocolDocument().getPessimisticLocks()) != null) {
            for (PessimisticLock lock : locks) {
                this.dataObjectService.delete((Object)lock);
            }
        }
        protocol.getProtocolDocument().getPessimisticLocks().clear();
        try {
            protocolDocument = (IacucProtocolDocument)this.documentService.saveDocument((Document)protocol.getProtocolDocument());
        }
        catch (WorkflowException e) {
            throw new RuntimeException(e);
        }
        protocol.refresh();
        Project project = this.getProjectRetrievalService().retrieveProject(protocolDocument.getIacucProtocol().getProtocolNumber());
        if (project != null) {
            this.getProjectPublisher().publishProject(project);
        }
    }

    protected void updateDefaultSchedule(IacucProtocolSubmission submission) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("protocolIdFk", submission.getProtocolId().toString());
        fieldValues.put("scheduleIdFk", CommitteeScheduleBase.DEFAULT_SCHEDULE_ID.toString());
        List minutes = (List)this.businessObjectService.findMatching(IacucCommitteeScheduleMinute.class, fieldValues);
        if (!minutes.isEmpty()) {
            for (CommitteeScheduleMinuteBase minute : minutes) {
                minute.setScheduleIdFk(submission.getScheduleIdFk());
            }
            this.businessObjectService.save(minutes);
        }
    }

    protected IacucProtocolSubmission createProtocolSubmission(IacucProtocol protocol, IacucProtocolSubmitAction submitAction) {
        IacucProtocolSubmissionBuilder submissionBuilder = new IacucProtocolSubmissionBuilder(protocol, submitAction.getSubmissionTypeCode());
        submissionBuilder.setSubmissionTypeQualifierCode(submitAction.getSubmissionQualifierTypeCode());
        submissionBuilder.setProtocolReviewTypeCode(submitAction.getProtocolReviewTypeCode());
        this.setSubmissionStatus(submissionBuilder, submitAction);
        this.setCommittee(submissionBuilder, submitAction);
        this.setSchedule(submissionBuilder, submitAction);
        return submissionBuilder.create();
    }

    protected void setSubmissionStatus(IacucProtocolSubmissionBuilder submissionBuilder, IacucProtocolSubmitAction submitAction) {
        submissionBuilder.setSubmissionStatus("101");
    }

    protected void setCommittee(IacucProtocolSubmissionBuilder submissionBuilder, IacucProtocolSubmitAction submitAction) {
        submissionBuilder.setCommittee(submitAction.getNewCommitteeId());
    }

    protected void setSchedule(IacucProtocolSubmissionBuilder submissionBuilder, IacucProtocolSubmitAction submitAction) {
        submissionBuilder.setSchedule(submitAction.getNewScheduleId());
    }

    public IacucProtocolAssignReviewersService getIacucProtocolAssignReviewersService() {
        return this.iacucProtocolAssignReviewersService;
    }

    public void setIacucProtocolAssignReviewersService(IacucProtocolAssignReviewersService iacucProtocolAssignReviewersService) {
        this.iacucProtocolAssignReviewersService = iacucProtocolAssignReviewersService;
    }

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    public ProjectPublisher getProjectPublisher() {
        return this.projectPublisher;
    }

    public void setProjectPublisher(ProjectPublisher projectPublisher) {
        this.projectPublisher = projectPublisher;
    }

    public ProjectRetrievalService getProjectRetrievalService() {
        return this.projectRetrievalService;
    }

    public void setProjectRetrievalService(ProjectRetrievalService projectRetrievalService) {
        this.projectRetrievalService = projectRetrievalService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public void setProtocolActionService(ProtocolActionService protocolActionService) {
        this.protocolActionService = protocolActionService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public DocumentService getDocumentService() {
        return this.documentService;
    }

    public ProtocolActionService getProtocolActionService() {
        return this.protocolActionService;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }
}

