/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl.print.watermark;

import com.lowagie.text.BadElementException;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Image;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfGState;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStamper;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.framework.print.watermark.WatermarkBean;
import org.kuali.coeus.common.framework.print.watermark.WatermarkConstants;
import org.kuali.coeus.common.framework.print.watermark.WatermarkService;
import org.springframework.stereotype.Component;

@Component(value="watermarkService")
public class WatermarkServiceImpl
implements WatermarkService {
    private static final Logger LOG = LogManager.getLogger(WatermarkServiceImpl.class);

    @Override
    public byte[] applyWatermark(byte[] pdfBytes, WatermarkBean watermarkBean) throws Exception {
        byte[] pdfFileData = pdfBytes;
        try {
            if (watermarkBean != null) {
                PdfReader origFile = new PdfReader(pdfBytes);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                PdfStamper stamper = new PdfStamper(origFile, (OutputStream)byteArrayOutputStream);
                stamper.setFormFlattening(true);
                stamper.close();
                byteArrayOutputStream = this.attachWatermarking(watermarkBean, byteArrayOutputStream.toByteArray());
                pdfFileData = byteArrayOutputStream.toByteArray();
            }
        }
        catch (Exception exception) {
            LOG.error("Exception occurred in WatermarkServiceImpl. Water mark Exception: " + exception);
        }
        return pdfFileData;
    }

    private ByteArrayOutputStream attachWatermarking(WatermarkBean watermarkBean, byte[] pdfContent) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ByteArrayOutputStream copyByteArrayOutputStream = new ByteArrayOutputStream();
        Document document = null;
        PdfWriter writer = null;
        try {
            PdfReader reader = new PdfReader(pdfContent);
            PdfReader pdfReader = new PdfReader(pdfContent);
            int nop = reader.getNumberOfPages();
            document = nop > 0 ? new Document(reader.getPageSizeWithRotation(1)) : new Document();
            writer = PdfWriter.getInstance((Document)document, (OutputStream)byteArrayOutputStream);
            this.watermarkPageDocument(document, writer, reader);
            byte[] bs = byteArrayOutputStream.toByteArray();
            pdfReader = new PdfReader(bs);
            PdfStamper pdfStamp = new PdfStamper(pdfReader, (OutputStream)copyByteArrayOutputStream);
            this.decorateWatermark(pdfStamp, watermarkBean);
        }
        catch (IOException decorateWatermark) {
            LOG.error("Exception occurred in WatermarkServiceImpl. Water mark Exception: " + decorateWatermark.getMessage());
        }
        catch (DocumentException documentException) {
            LOG.error("Exception occurred in WatermarkServiceImpl. Water mark Exception: " + documentException.getMessage());
        }
        return copyByteArrayOutputStream;
    }

    private void decorateWatermark(PdfStamper watermarkPdfStamper, WatermarkBean watermarkBean) {
        watermarkPdfStamper.setFormFlattening(true);
        PdfReader pdfReader = watermarkPdfStamper.getReader();
        int pageCount = pdfReader.getNumberOfPages();
        int pdfPageNumber = 0;
        while (pdfPageNumber < pageCount) {
            PdfContentByte pdfContents = watermarkPdfStamper.getOverContent(++pdfPageNumber);
            Rectangle rectangle = pdfReader.getPageSizeWithRotation(pdfPageNumber);
            if (watermarkBean.getType().equalsIgnoreCase("IMAGE")) {
                this.decoratePdfWatermarkImage(pdfContents, (int)rectangle.getWidth(), (int)rectangle.getHeight(), watermarkBean);
            }
            if (watermarkBean.getType().equalsIgnoreCase("TEXT")) {
                this.decoratePdfWatermarkText(pdfContents, rectangle, watermarkBean);
            }
            watermarkPdfStamper.setFormFlattening(true);
        }
        try {
            watermarkPdfStamper.close();
        }
        catch (IOException decorateWatermark) {
            LOG.error("Exception occurred in WatermarkServiceImpl. decorateWatermark Exception: " + decorateWatermark.getMessage());
        }
        catch (DocumentException documentException) {
            LOG.error("Exception occurred in WatermarkServiceImpl. decorateWatermark Exception: " + documentException.getMessage());
        }
    }

    private void decoratePdfWatermarkText(PdfContentByte pdfContentByte, Rectangle rectangle, WatermarkBean watermarkBean) {
        float OPACITY = 0.3f;
        PdfGState pdfGState = new PdfGState();
        pdfGState.setFillOpacity(0.3f);
        int pageWidth = (int)rectangle.getWidth();
        int pageHeight = (int)rectangle.getHeight();
        try {
            if (watermarkBean.getType().equalsIgnoreCase("TEXT")) {
                pdfContentByte.beginText();
                pdfContentByte.setGState(pdfGState);
                Color fillColor = watermarkBean.getFont().getColor() == null ? WatermarkConstants.DEFAULT_WATERMARK_COLOR : watermarkBean.getFont().getColor();
                pdfContentByte.setColorFill(fillColor);
                if (watermarkBean.getPosition().equals("FOOTER")) {
                    pdfContentByte.setFontAndSize(watermarkBean.getFont().getBaseFont(), (float)watermarkBean.getPositionFont().getSize());
                    if (watermarkBean.getAlignment().equals("CENTER")) {
                        pdfContentByte.showTextAligned(1, watermarkBean.getText(), (rectangle.getLeft(rectangle.getBorderWidthLeft()) + rectangle.getRight(rectangle.getBorderWidthRight())) / 2.0f, rectangle.getBottom(rectangle.getBorderWidthBottom() + (float)watermarkBean.getPositionFont().getSize()), 0.0f);
                    } else if (watermarkBean.getAlignment().equals("RIGHT")) {
                        pdfContentByte.showTextAligned(2, watermarkBean.getText(), rectangle.getRight(rectangle.getBorderWidthRight()), rectangle.getBottom(rectangle.getBorderWidthBottom() + (float)watermarkBean.getPositionFont().getSize()), 0.0f);
                    } else if (watermarkBean.getAlignment().equals("LEFT")) {
                        pdfContentByte.showTextAligned(0, watermarkBean.getText(), rectangle.getLeft(rectangle.getBorderWidthLeft()), rectangle.getBottom(rectangle.getBorderWidthBottom() + (float)watermarkBean.getPositionFont().getSize()), 0.0f);
                    }
                } else if (watermarkBean.getPosition().equals("HEADER")) {
                    pdfContentByte.setFontAndSize(watermarkBean.getFont().getBaseFont(), (float)watermarkBean.getPositionFont().getSize());
                    if (watermarkBean.getAlignment().equals("CENTER")) {
                        pdfContentByte.showTextAligned(1, watermarkBean.getText(), (rectangle.getLeft(rectangle.getBorderWidthLeft()) + rectangle.getRight(rectangle.getBorderWidthRight())) / 2.0f, rectangle.getTop(rectangle.getBorderWidthTop() + (float)watermarkBean.getPositionFont().getSize()), 0.0f);
                    } else if (watermarkBean.getAlignment().equals("RIGHT")) {
                        pdfContentByte.showTextAligned(2, watermarkBean.getText(), rectangle.getRight(rectangle.getBorderWidthRight()), rectangle.getTop(rectangle.getBorderWidthTop() + (float)watermarkBean.getPositionFont().getSize()), 0.0f);
                    } else if (watermarkBean.getAlignment().equals("LEFT")) {
                        pdfContentByte.showTextAligned(0, watermarkBean.getText(), rectangle.getLeft(rectangle.getBorderWidthLeft()), rectangle.getTop(rectangle.getBorderWidthTop() + (float)watermarkBean.getPositionFont().getSize()), 0.0f);
                    }
                } else {
                    pdfContentByte.setFontAndSize(watermarkBean.getFont().getBaseFont(), (float)watermarkBean.getFont().getSize());
                    int textWidth = (int)pdfContentByte.getEffectiveStringWidth(watermarkBean.getText(), false);
                    int diagonal = (int)Math.sqrt(pageWidth * pageWidth + pageHeight * pageHeight);
                    int pivotPoint = (diagonal - textWidth) / 2;
                    float angle = (float)Math.atan((float)pageHeight / (float)pageWidth);
                    float x = (float)(pivotPoint * pageWidth) / (float)diagonal;
                    float y = (float)(pivotPoint * pageHeight) / (float)diagonal;
                    float x1 = (float)((double)((float)watermarkBean.getFont().getSize() / 2.0f) * Math.sin(angle));
                    float y1 = (float)((double)((float)watermarkBean.getFont().getSize() / 2.0f) * Math.cos(angle));
                    pdfContentByte.showTextAligned(0, watermarkBean.getText(), x + x1, y - y1, (float)Math.toDegrees(angle));
                }
                pdfContentByte.endText();
            }
        }
        catch (Exception exception) {
            LOG.error("Exception occurred in WatermarkServiceImpl. Water mark Exception: " + exception.getMessage());
        }
    }

    private void watermarkPageDocument(Document document, PdfWriter writer, PdfReader reader) {
        document.open();
        int totalPages = reader.getNumberOfPages();
        for (int pageCount = 1; pageCount <= totalPages; ++pageCount) {
            PdfContentByte contents = writer.getDirectContent();
            document.setPageSize(reader.getPageSize(pageCount));
            document.newPage();
            PdfImportedPage page = writer.getImportedPage(reader, pageCount);
            contents.addTemplate((PdfTemplate)page, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
        }
        document.close();
    }

    private void decoratePdfWatermarkImage(PdfContentByte pdfContentByte, int pageWidth, int pageHeight, WatermarkBean watermarkBean) {
        PdfGState pdfGState = new PdfGState();
        float OPACITY = 0.3f;
        try {
            Image watermarkImage;
            if (watermarkBean.getType().equalsIgnoreCase("IMAGE") && (watermarkImage = Image.getInstance((Image)watermarkBean.getFileImage())) != null) {
                pdfGState.setFillOpacity(0.3f);
                pdfContentByte.setGState(pdfGState);
                float height = watermarkImage.getPlainHeight();
                float width = watermarkImage.getPlainWidth();
                int diagonal = (int)Math.sqrt(pageWidth * pageWidth + pageHeight * pageHeight);
                int pivotPoint = (diagonal - (int)width) / 2;
                float angle = (float)Math.atan((float)pageHeight / (float)pageWidth);
                float absPosX = (float)(pivotPoint * pageWidth) / (float)diagonal;
                float absPosY = (float)(pivotPoint * pageHeight) / (float)diagonal;
                watermarkImage.setAbsolutePosition(absPosX, absPosY);
                if ((float)(pageWidth / 2) < width) {
                    watermarkImage.scaleToFit((float)(pageWidth / 2), (float)(pageHeight / 2));
                } else {
                    watermarkImage.scaleToFit(width, height);
                }
                pdfContentByte.addImage(watermarkImage);
            }
        }
        catch (BadElementException badElementException) {
            LOG.error("WatermarkDecoratorImpl  Error found: " + badElementException.getMessage());
        }
        catch (DocumentException documentException) {
            LOG.error("WatermarkDecoratorImpl Error found: " + documentException.getMessage());
        }
    }
}

