/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.actions.print;

import edu.mit.irb.irbnamespace.CommitteeMasterDataDocument;
import edu.mit.irb.irbnamespace.NextScheduleDateDocument;
import edu.mit.irb.irbnamespace.RenewalReminderDocument;
import java.sql.Date;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.kra.committee.bo.Committee;
import org.kuali.kra.committee.bo.CommitteeSchedule;
import org.kuali.kra.committee.print.CommitteeXmlStream;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.actions.print.ProtocolXmlStream;
import org.kuali.kra.protocol.actions.ProtocolActionBase;
import org.kuali.kra.protocol.actions.print.RenewalReminderStreamBase;

public class RenewalReminderStream
extends RenewalReminderStreamBase<RenewalReminderDocument> {
    private ProtocolXmlStream protocolXmlStream;
    private CommitteeXmlStream committeeXmlStream;

    @Override
    public Class<RenewalReminderDocument> type() {
        return RenewalReminderDocument.class;
    }

    @Override
    public Map<String, RenewalReminderDocument> generateXmlStream(KcPersistableBusinessObjectBase printableBusinessObject, Map<String, Object> reportParameters) {
        Protocol protocol = (Protocol)printableBusinessObject;
        RenewalReminderDocument renewalReminderDocument = RenewalReminderDocument.Factory.newInstance();
        RenewalReminderDocument.RenewalReminder renewalReminder = RenewalReminderDocument.RenewalReminder.Factory.newInstance();
        renewalReminder.setCurrentDate(this.getDateTimeService().getCurrentCalendar());
        String committeeId = (String)reportParameters.get("committeeId");
        Committee committee = null;
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("committeeId", committeeId);
        Collection committees = this.getBusinessObjectService().findMatching(Committee.class, fieldValues);
        if (committees.size() > 0) {
            committee = (Committee)Collections.max(committees);
        }
        CommitteeMasterDataDocument.CommitteeMasterData committeeMasterData = CommitteeMasterDataDocument.CommitteeMasterData.Factory.newInstance();
        this.committeeXmlStream.setCommitteeMasterData(committee, committeeMasterData);
        renewalReminder.setCommitteeMasterData(committeeMasterData);
        List committeSchedules = committee.getCommitteeSchedules();
        int rowNumber = 0;
        for (CommitteeSchedule committeeSchedule : committeSchedules) {
            if (rowNumber < 5) break;
            if (!committeeSchedule.getScheduledDate().after(this.getDateTimeService().getCurrentDate()) && !committeeSchedule.getScheduledDate().equals(this.getDateTimeService().getCurrentDate())) continue;
            NextScheduleDateDocument.NextScheduleDate nextScheduleDateType = renewalReminder.addNewNextScheduleDate();
            nextScheduleDateType.setScheduleDate(this.getDateTimeService().getCalendar((java.util.Date)committeeSchedule.getScheduledDate()));
            nextScheduleDateType.setScheduleNumber(++rowNumber);
        }
        if (reportParameters.get("protoCorrespTypeCode") != null && ("23".equals(reportParameters.get("protoCorrespTypeCode")) || "24".equals(reportParameters.get("protoCorrespTypeCode")))) {
            this.setActionDate(protocol);
        }
        if (reportParameters.get("submissionNumber") == null) {
            renewalReminder.setProtocol(this.protocolXmlStream.getProtocol(protocol));
        } else {
            renewalReminder.setProtocol(this.protocolXmlStream.getProtocol(protocol, (Integer)reportParameters.get("submissionNumber")));
        }
        HashMap<String, RenewalReminderDocument> xmlObjectMap = new HashMap<String, RenewalReminderDocument>();
        renewalReminderDocument.setRenewalReminder(renewalReminder);
        xmlObjectMap.put("Renewal reminder", renewalReminderDocument);
        return xmlObjectMap;
    }

    private void setActionDate(Protocol protocol) {
        for (ProtocolActionBase action : protocol.getProtocolActions()) {
            if (!"203".equals(action.getProtocolActionTypeCode()) && !"202".equals(action.getProtocolActionTypeCode())) continue;
            protocol.setExpirationDate(new Date(action.getActionDate().getTime()));
        }
    }

    public void setProtocolXmlStream(ProtocolXmlStream protocolXmlStream) {
        this.protocolXmlStream = protocolXmlStream;
    }

    public void setCommitteeXmlStream(CommitteeXmlStream committeeXmlStream) {
        this.committeeXmlStream = committeeXmlStream;
    }
}

