/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.kim.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.org.OrganizationService;
import org.kuali.coeus.common.framework.org.crrspndnt.OrganizationCorrespondent;
import org.kuali.coeus.common.framework.unit.UnitService;
import org.kuali.coeus.common.framework.unit.crrspndnt.UnitCorrespondent;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.summary.ProtocolSummary;
import org.kuali.kra.protocol.protocol.location.ProtocolLocationBase;
import org.kuali.kra.protocol.summary.OrganizationSummary;
import org.kuali.rice.core.api.membership.MemberType;
import org.kuali.rice.kim.api.role.RoleMembership;
import org.kuali.rice.kim.framework.role.RoleTypeService;
import org.kuali.rice.kns.kim.role.DerivedRoleTypeServiceBase;

public class IrbCorrespondentDerivedRoleTypeServiceImpl
extends DerivedRoleTypeServiceBase
implements RoleTypeService {
    private OrganizationService organizationService;
    private UnitService unitService;
    private final String ROLE_NAME_ORGANIZATION_CORRESPONDENT = "Organization Correspondent";
    private final String ROLE_NAME_UNIT_CORRESPONDENT = "Unit Correspondent";
    private final String PERFORMING_ORG_TYPE_CODE = "1";
    protected List<String> requiredAttributes = new ArrayList<String>();

    public IrbCorrespondentDerivedRoleTypeServiceImpl() {
        this.requiredAttributes.add("protocol");
    }

    public boolean hasDerivedRole(String principalId, List<String> groupIds, String namespaceCode, String roleName, Map<String, String> qualification) {
        if ("Organization Correspondent".equals(roleName)) {
            return this.hasApplicationRoleOrganization(principalId, groupIds, namespaceCode, roleName, qualification);
        }
        if ("Unit Correspondent".equals(roleName)) {
            return this.hasApplicationRoleUnit(principalId, groupIds, namespaceCode, roleName, qualification);
        }
        return false;
    }

    public boolean hasApplicationRoleOrganization(String principalId, List<String> groupIds, String namespaceCode, String roleName, Map<String, String> qualification) {
        String protocolNumber = qualification.get("protocol");
        Protocol protocol = this.getProtocolByNumber(protocolNumber);
        if (protocol != null) {
            for (ProtocolLocationBase location : protocol.getProtocolLocations()) {
                if (!"1".equals(location.getProtocolOrganizationTypeCode())) continue;
                List<OrganizationCorrespondent> organizationCorrespondents = this.getOrganizationService().retrieveOrganizationCorrespondentsByOrganizationId(location.getOrganizationId());
                for (OrganizationCorrespondent organizationCorrespondent : organizationCorrespondents) {
                    if (!organizationCorrespondent.getPersonId().equals(principalId)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean hasApplicationRoleUnit(String principalId, List<String> groupIds, String namespaceCode, String roleName, Map<String, String> qualification) {
        String protocolNumber = qualification.get("protocol");
        Protocol protocol = this.getProtocolByNumber(protocolNumber);
        String unitNumber = protocol.getLeadUnitNumber();
        if (StringUtils.isNotBlank((CharSequence)unitNumber)) {
            List<UnitCorrespondent> unitCorrespondents = this.getUnitService().retrieveUnitCorrespondentsByUnitNumber(unitNumber);
            for (UnitCorrespondent unitCorrespondent : unitCorrespondents) {
                if (!unitCorrespondent.getPersonId().equals(principalId)) continue;
                return true;
            }
        }
        return false;
    }

    public List<RoleMembership> getRoleMembersFromDerivedRole(String namespaceCode, String roleName, Map<String, String> qualification) {
        this.validateRequiredAttributesAgainstReceived(qualification);
        String protocolNumber = qualification.get("protocol");
        if (protocolNumber != null) {
            Protocol protocol = this.getProtocolByNumber(protocolNumber);
            if ("Organization Correspondent".equals(roleName)) {
                return this.getRoleMembersFromApplicationRoleOrganization(protocol, namespaceCode, roleName, qualification);
            }
            if ("Unit Correspondent".equals(roleName)) {
                return this.getRoleMembersFromApplicationRoleUnit(protocol, namespaceCode, roleName, qualification);
            }
        }
        return new ArrayList<RoleMembership>();
    }

    public List<RoleMembership> getRoleMembersFromApplicationRoleOrganization(Protocol protocol, String namespaceCode, String roleName, Map<String, String> qualification) {
        ProtocolSummary protocolSummary = protocol.getProtocolSummary();
        ArrayList<RoleMembership> members = new ArrayList<RoleMembership>();
        for (OrganizationSummary orgSummary : protocolSummary.getOrganizations()) {
            String organizationId = orgSummary.getId();
            if (!StringUtils.isNotBlank((CharSequence)organizationId)) continue;
            List<OrganizationCorrespondent> organizationCorrespondents = this.getOrganizationService().retrieveOrganizationCorrespondentsByOrganizationId(organizationId);
            for (OrganizationCorrespondent organizationCorrespondent : organizationCorrespondents) {
                if (!StringUtils.isNotBlank((CharSequence)organizationCorrespondent.getPersonId())) continue;
                members.add(RoleMembership.Builder.create(null, null, (String)organizationCorrespondent.getPersonId(), (MemberType)MemberType.PRINCIPAL, null).build());
            }
        }
        return members;
    }

    public List<RoleMembership> getRoleMembersFromApplicationRoleUnit(Protocol protocol, String namespaceCode, String roleName, Map<String, String> qualification) {
        String unitNumber = protocol.getLeadUnitNumber();
        ArrayList<RoleMembership> members = new ArrayList<RoleMembership>();
        if (StringUtils.isNotBlank((CharSequence)unitNumber)) {
            List<UnitCorrespondent> unitCorrespondents = this.getUnitService().retrieveUnitCorrespondentsByUnitNumber(unitNumber);
            for (UnitCorrespondent unitCorrespondent : unitCorrespondents) {
                if (!StringUtils.isNotBlank((CharSequence)unitCorrespondent.getPersonId())) continue;
                members.add(RoleMembership.Builder.create(null, null, (String)unitCorrespondent.getPersonId(), (MemberType)MemberType.PRINCIPAL, null).build());
            }
        }
        return members;
    }

    private UnitService getUnitService() {
        if (this.unitService == null) {
            this.unitService = KcServiceLocator.getService(UnitService.class);
        }
        return this.unitService;
    }

    private OrganizationService getOrganizationService() {
        if (this.organizationService == null) {
            this.organizationService = KcServiceLocator.getService(OrganizationService.class);
        }
        return this.organizationService;
    }

    private Protocol getProtocolByNumber(String protocolNumber) {
        HashMap<String, String> keymap = new HashMap<String, String>();
        keymap.put("protocolNumber", protocolNumber);
        keymap.put("active", "Y");
        return (Protocol)this.getBusinessObjectService().findByPrimaryKey(Protocol.class, keymap);
    }

    public boolean dynamicRoleMembership(String namespaceCode, String roleName) {
        super.dynamicRoleMembership(namespaceCode, roleName);
        return true;
    }
}

