/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.framework.unit.sync;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.unit.sync.UnitRole;
import org.kuali.coeus.sys.framework.lookup.KcKualiLookupableHelperServiceImpl;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PredicateFactory;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.kim.framework.role.RoleEbo;
import org.kuali.rice.kim.impl.role.RoleBoLite;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.data.DataObjectService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="unitRoleLookupableHelperService")
@Scope(value="prototype")
public class UnitRoleLookupableHelperService
extends KcKualiLookupableHelperServiceImpl {
    private static final String KIM_TYPE_ID = "kimTypeId";
    private static final String ACTIVE = "active";
    private static final String ID = "id";
    private static final String NAMESPACE_CODE = "namespaceCode";
    private static final String NAME = "name";
    private static final String DESCRIPTION = "description";
    private static final String UNIT_HIERARCHY = "unitHierarchy";
    private static final String TRUE = "Y";
    private static final String FALSE = "N";
    @Autowired
    @Qualifier(value="dataObjectService")
    private DataObjectService dataObjectService;

    public List<? extends BusinessObject> getSearchResults(Map<String, String> fieldValues) {
        String description;
        String name;
        String namespaceCode;
        ArrayList<Predicate> andPredicates = new ArrayList<Predicate>();
        String id = fieldValues.get(ID);
        if (StringUtils.isNotBlank((CharSequence)id)) {
            andPredicates.add(PredicateFactory.likeIgnoreCase((String)ID, (CharSequence)id));
        }
        if (StringUtils.isNotBlank((CharSequence)(namespaceCode = fieldValues.get(NAMESPACE_CODE)))) {
            andPredicates.add(PredicateFactory.likeIgnoreCase((String)NAMESPACE_CODE, (CharSequence)namespaceCode));
        }
        if (StringUtils.isNotBlank((CharSequence)(name = fieldValues.get(NAME)))) {
            andPredicates.add(PredicateFactory.likeIgnoreCase((String)NAME, (CharSequence)name));
        }
        if (StringUtils.isNotBlank((CharSequence)(description = fieldValues.get(DESCRIPTION)))) {
            andPredicates.add(PredicateFactory.likeIgnoreCase((String)DESCRIPTION, (CharSequence)description));
        }
        andPredicates.add(PredicateFactory.equal((String)ACTIVE, (Object)true));
        String unitHierarchy = fieldValues.get(UNIT_HIERARCHY);
        if (TRUE.equals(unitHierarchy)) {
            andPredicates.add(PredicateFactory.equal((String)KIM_TYPE_ID, (Object)"10001"));
        } else if (FALSE.equals(unitHierarchy)) {
            andPredicates.add(PredicateFactory.equal((String)KIM_TYPE_ID, (Object)"10000"));
        } else {
            andPredicates.add(PredicateFactory.or((Predicate[])new Predicate[]{PredicateFactory.equal((String)KIM_TYPE_ID, (Object)"10001"), PredicateFactory.equal((String)KIM_TYPE_ID, (Object)"10000")}));
        }
        return this.getDataObjectService().findMatching(RoleBoLite.class, QueryByCriteria.Builder.fromPredicates(andPredicates)).getResults().stream().sorted(Comparator.comparing(RoleEbo::getNamespaceCode).thenComparing(RoleEbo::getName)).map(UnitRole::fromRoleBoLite).collect(Collectors.toList());
    }

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }
}

