/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl.medusa;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.compliance.core.SpecialReview;
import org.kuali.coeus.common.framework.medusa.MedusaNode;
import org.kuali.coeus.common.framework.medusa.MedusaService;
import org.kuali.coeus.common.framework.version.VersionStatus;
import org.kuali.coeus.common.framework.version.history.VersionHistory;
import org.kuali.coeus.common.framework.version.history.VersionHistoryService;
import org.kuali.coeus.common.framework.version.sequence.owner.SequenceOwner;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.kra.award.AwardAmountInfoService;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardAmountInfo;
import org.kuali.kra.award.home.fundingproposal.AwardFundingProposal;
import org.kuali.kra.iacuc.IacucProtocol;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.kra.institutionalproposal.proposaladmindetails.ProposalAdminDetails;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.negotiations.bo.Negotiable;
import org.kuali.kra.negotiations.bo.Negotiation;
import org.kuali.kra.negotiations.service.NegotiationService;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.protocol.funding.ProtocolFundingSourceBase;
import org.kuali.kra.subaward.bo.SubAward;
import org.kuali.kra.subaward.bo.SubAwardFundingSource;
import org.kuali.kra.subaward.service.SubAwardService;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.bo.DocumentHeader;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component(value="medusaService")
@Lazy
public class MedusaServiceImpl
implements MedusaService {
    public static final int MAX_DESCRIPTION_LENGTH = 160;
    public static final String SHOW_MEDUSA_DOCUMENT_DESCRIPTIONS_PARAMETER = "Show_Document_Descriptions_In_Medusa";
    public static final String REACT_MEDUSA_ENABLED_PARAMETER = "Enable_Improved_Medusa_UI";
    private static final int INST_PROPOSAL_STATUS_FUNDED = 2;
    @Autowired
    @Qualifier(value="businessObjectService")
    private BusinessObjectService businessObjectService;
    @Autowired
    @Qualifier(value="dataObjectService")
    private DataObjectService dataObjectService;
    @Autowired
    @Qualifier(value="awardAmountInfoService")
    private AwardAmountInfoService awardAmountInfoService;
    @Autowired
    @Qualifier(value="versionHistoryService")
    private VersionHistoryService versionHistoryService;
    @Autowired
    @Qualifier(value="negotiationService")
    private NegotiationService negotiationService;
    @Autowired
    @Qualifier(value="subAwardService")
    private SubAwardService subAwardService;
    @Autowired
    @Qualifier(value="parameterService")
    private ParameterService parameterService;

    @Override
    public MedusaNode getMedusaNode(String moduleName, Long moduleId) {
        MedusaNode curNode = new MedusaNode();
        curNode.setType(moduleName);
        if (StringUtils.equalsIgnoreCase((CharSequence)"award", (CharSequence)moduleName)) {
            Award award = (Award)this.businessObjectService.findByPrimaryKey(Award.class, this.getFieldValues("awardId", moduleId));
            curNode.setBo(award);
            curNode.setExtraInfo(this.awardAmountInfoService.fetchAwardAmountInfoWithHighestTransactionId(award.getAwardAmountInfos()));
        } else if (StringUtils.equalsIgnoreCase((CharSequence)"IP", (CharSequence)moduleName)) {
            InstitutionalProposal proposal = (InstitutionalProposal)this.businessObjectService.findByPrimaryKey(InstitutionalProposal.class, this.getFieldValues("proposalId", moduleId));
            proposal.setNsfCodeBo(proposal.getNsfCodeBo());
            curNode.setBo(proposal);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)"DP", (CharSequence)moduleName)) {
            DevelopmentProposal devProp = this.getDevelopmentProposal(moduleId.toString());
            devProp.setNsfCodeBo(devProp.getNsfCodeBo());
            curNode.setBo(devProp);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)"neg", (CharSequence)moduleName)) {
            Negotiation negotiation = this.getNegotiation(moduleId);
            curNode.setBo(negotiation);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)"subaward", (CharSequence)moduleName)) {
            SubAward subaward = this.getSubAwardBySubawardCode(moduleId);
            curNode.setBo(subaward);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)"irb", (CharSequence)moduleName)) {
            Protocol protocol = this.getProtocol(moduleId);
            curNode.setBo(protocol);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)"iacuc", (CharSequence)moduleName)) {
            IacucProtocol protocol = this.getIacuc(moduleId);
            curNode.setBo(protocol);
        }
        return curNode;
    }

    @Override
    public List<MedusaNode> getMedusaByProposal(String moduleName, Long moduleIdentifier) {
        String preferredModule = "IP";
        return this.getMedusaTree(moduleName, moduleIdentifier, preferredModule);
    }

    @Override
    public List<MedusaNode> getMedusaByAward(String moduleName, Long moduleIdentifier) {
        String preferredModule = "award";
        return this.getMedusaTree(moduleName, moduleIdentifier, preferredModule);
    }

    protected List<MedusaNode> getMedusaTree(String moduleName, Long moduleIdentifier, String preferredModule) {
        IacucProtocol protocol;
        List<MedusaNode> nodes = new ArrayList<MedusaNode>();
        HashMap<Object, List<Object>> graph = new HashMap<Object, List<Object>>();
        if (StringUtils.equals((CharSequence)moduleName, (CharSequence)"award")) {
            Award award = this.getAward(moduleIdentifier);
            this.addVertex(graph, award);
            this.buildGraph(graph, award);
            nodes = this.getParentNodes(graph, new String[]{preferredModule, "award"});
        } else if (StringUtils.equals((CharSequence)moduleName, (CharSequence)"IP")) {
            InstitutionalProposal proposal = this.getInstitutionalProposal(moduleIdentifier);
            this.addVertex(graph, proposal);
            this.buildGraph(graph, proposal);
            nodes = this.getParentNodes(graph, new String[]{preferredModule, "IP"});
        } else if (StringUtils.equals((CharSequence)moduleName, (CharSequence)"DP")) {
            DevelopmentProposal proposal = this.getDevelopmentProposal(moduleIdentifier.toString());
            this.addVertex(graph, proposal);
            this.buildGraph(graph, proposal);
            nodes = this.getParentNodes(graph, new String[]{preferredModule, "DP"});
        } else if (StringUtils.equals((CharSequence)moduleName, (CharSequence)"neg")) {
            Negotiation negotiation = this.getNegotiation(moduleIdentifier);
            if (negotiation != null) {
                this.addVertex(graph, negotiation);
                this.buildGraph(graph, negotiation);
                nodes = this.getParentNodes(graph, new String[]{preferredModule, "neg"});
            }
        } else if (StringUtils.equals((CharSequence)moduleName, (CharSequence)"subaward")) {
            SubAward subAward = this.getSubAward(moduleIdentifier);
            if (subAward != null) {
                this.addVertex(graph, subAward);
                this.buildGraph(graph, subAward);
                nodes = this.getParentNodes(graph, new String[]{preferredModule, "subaward"});
            }
        } else if (StringUtils.equals((CharSequence)moduleName, (CharSequence)"irb")) {
            Protocol protocol2 = this.getProtocol(moduleIdentifier);
            if (protocol2 != null) {
                this.addVertex(graph, protocol2);
                this.buildGraph(graph, protocol2);
                nodes = this.getParentNodes(graph, new String[]{preferredModule, "irb"});
            }
        } else if (StringUtils.equals((CharSequence)moduleName, (CharSequence)"iacuc") && (protocol = this.getIacuc(moduleIdentifier)) != null) {
            this.addVertex(graph, protocol);
            this.buildGraph(graph, protocol);
            nodes = this.getParentNodes(graph, new String[]{preferredModule, "iacuc"});
        }
        return nodes;
    }

    protected Object addVertex(HashMap<Object, List<Object>> graph, Object bo) {
        Object graphBo = this.findMatchingBo(graph.keySet(), bo);
        if (graphBo == null) {
            graph.put(bo, new ArrayList());
            return bo;
        }
        return graphBo;
    }

    protected void addEdge(HashMap<Object, List<Object>> graph, Object bo1, Object bo2) {
        Object graphBo1 = this.addVertex(graph, bo1);
        Object graphBo2 = this.addVertex(graph, bo2);
        if (this.findMatchingBo((Collection<Object>)graph.get(graphBo1), graphBo2) == null) {
            graph.get(graphBo1).add(graphBo2);
        }
        if (this.findMatchingBo((Collection<Object>)graph.get(graphBo2), graphBo1) == null) {
            graph.get(graphBo2).add(graphBo1);
        }
    }

    protected List<MedusaNode> getParentNodes(HashMap<Object, List<Object>> graph, String[] preferedOrder) {
        ArrayList<MedusaNode> parentNodes = new ArrayList<MedusaNode>();
        for (String prefType : preferedOrder) {
            for (Object bo : graph.keySet()) {
                MedusaNode node = this.getNode(bo);
                if (!StringUtils.equals((CharSequence)node.getType(), (CharSequence)prefType)) continue;
                parentNodes.add(node);
            }
            if (!parentNodes.isEmpty()) break;
        }
        for (MedusaNode node : parentNodes) {
            ArrayList<MedusaNode> seenNodes = new ArrayList<MedusaNode>(parentNodes);
            this.populateChildNodes(graph, node, seenNodes);
        }
        return parentNodes;
    }

    protected void populateChildNodes(HashMap<Object, List<Object>> graph, MedusaNode node, List<MedusaNode> parentNodes) {
        Collection links = graph.get(node.getBo());
        for (Object bo : links) {
            MedusaNode nextNode = this.getNode(bo);
            if (parentNodes != null && this.isBoInList(parentNodes, bo)) continue;
            node.getChildNodes().add(nextNode);
            parentNodes.add(node);
            this.populateChildNodes(graph, nextNode, parentNodes);
        }
    }

    protected boolean isBoInList(List<MedusaNode> nodes, Object bo) {
        for (MedusaNode node : nodes) {
            if (!this.areBusinessObjectsEqual(node.getBo(), bo)) continue;
            return true;
        }
        return false;
    }

    protected void buildGraph(HashMap<Object, List<Object>> graph, SubAward subAward) {
        Collection<Award> awards = this.getAwards(subAward);
        for (Award award : awards) {
            this.addToGraph(graph, award, subAward);
        }
        Collection<Negotiation> negotiations = this.getNegotiations((BusinessObject)subAward);
        for (Negotiation negotiation : negotiations) {
            this.addToGraph(graph, negotiation, subAward);
        }
    }

    protected void buildGraph(HashMap<Object, List<Object>> graph, ProtocolBase protocol) {
        for (ProtocolFundingSourceBase fundingSource : protocol.getProtocolFundingSources()) {
            if (StringUtils.equals((CharSequence)fundingSource.getFundingSourceTypeCode(), (CharSequence)"6")) {
                this.addToGraph(graph, this.getAward(fundingSource.getFundingSourceNumber()), protocol);
                continue;
            }
            if (StringUtils.equals((CharSequence)fundingSource.getFundingSourceTypeCode(), (CharSequence)"5")) {
                this.addToGraph(graph, this.getInstitutionalProposal(fundingSource.getFundingSourceNumber()), protocol);
                continue;
            }
            if (!StringUtils.equals((CharSequence)fundingSource.getFundingSourceTypeCode(), (CharSequence)"4")) continue;
            this.addToGraph(graph, this.getDevelopmentProposal(fundingSource.getFundingSourceNumber()), protocol);
        }
    }

    protected void addSpecialReviewLinksToGraph(HashMap<Object, List<Object>> graph, List<? extends SpecialReview> specialReviews, Object existingBo) {
        Map<String, Boolean> specialReviewLinking = this.getSpecialReviewLinkingEnabled(existingBo);
        for (SpecialReview specialReview : specialReviews) {
            ProtocolBase protocol;
            if (StringUtils.equals((CharSequence)specialReview.getSpecialReviewTypeCode(), (CharSequence)"1") && specialReviewLinking.get("1").booleanValue() && !StringUtils.equals((CharSequence)specialReview.getApprovalTypeCode(), (CharSequence)"3")) {
                protocol = this.getProtocol(specialReview.getProtocolNumber());
                if (protocol == null) continue;
                this.addToGraph(graph, protocol, existingBo);
                continue;
            }
            if (!StringUtils.equals((CharSequence)specialReview.getSpecialReviewTypeCode(), (CharSequence)"2") || !specialReviewLinking.get("2").booleanValue() || StringUtils.equals((CharSequence)specialReview.getApprovalTypeCode(), (CharSequence)"3") || (protocol = this.getIacuc(specialReview.getProtocolNumber())) == null) continue;
            this.addToGraph(graph, protocol, existingBo);
        }
    }

    protected Map<String, Boolean> getSpecialReviewLinkingEnabled(Object existingBo) {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        String irbLinkingName = null;
        String iacucLinkingName = null;
        if (existingBo instanceof DevelopmentProposal) {
            irbLinkingName = "irb.protocol.development.proposal.linking.enabled";
            iacucLinkingName = "iacuc.protocol.proposal.development.linking.enabled";
        } else if (existingBo instanceof InstitutionalProposal) {
            irbLinkingName = "irb.protocol.institute.proposal.linking.enabled";
            iacucLinkingName = "iacuc.protocol.institute.proposal.linking.enabled";
        } else if (existingBo instanceof Award) {
            irbLinkingName = "irb.protocol.award.linking.enabled";
            iacucLinkingName = "iacuc.protocol.award.linking.enabled";
        }
        if (irbLinkingName != null) {
            result.put("1", this.getParameterService().getParameterValueAsBoolean("KC-PROTOCOL", "Document", irbLinkingName));
        } else {
            result.put("1", Boolean.FALSE);
        }
        if (iacucLinkingName != null) {
            result.put("2", this.getParameterService().getParameterValueAsBoolean("KC-IACUC", "Document", iacucLinkingName));
        } else {
            result.put("2", Boolean.FALSE);
        }
        return result;
    }

    protected void buildGraph(HashMap<Object, List<Object>> graph, Award award) {
        Collection<InstitutionalProposal> proposals = this.getProposals(award);
        for (InstitutionalProposal institutionalProposal : proposals) {
            this.addToGraph(graph, institutionalProposal, award);
        }
        Collection<Negotiation> negotiations = this.getNegotiations((BusinessObject)award);
        for (Negotiation negotiation : negotiations) {
            this.addToGraph(graph, negotiation, award);
        }
        Collection<SubAward> collection = this.getSubAwards(award);
        for (SubAward subAward : collection) {
            this.addToGraph(graph, subAward, award);
        }
        this.addSpecialReviewLinksToGraph(graph, award.getSpecialReviews(), award);
    }

    protected void buildGraph(HashMap<Object, List<Object>> graph, InstitutionalProposal proposal) {
        Collection<Award> awards = this.getAwards(proposal);
        for (Award award : awards) {
            this.addToGraph(graph, award, proposal);
        }
        Collection<DevelopmentProposal> proposals = this.getDevelopmentProposals(proposal);
        for (DevelopmentProposal devProp : proposals) {
            this.addToGraph(graph, devProp, proposal);
        }
        Collection<Negotiation> collection = this.getNegotiations((BusinessObject)proposal);
        for (Negotiation negotiation : collection) {
            this.addToGraph(graph, negotiation, proposal);
        }
        this.addSpecialReviewLinksToGraph(graph, proposal.getSpecialReviews(), proposal);
    }

    protected void buildGraph(HashMap<Object, List<Object>> graph, DevelopmentProposal devProp) {
        Collection<InstitutionalProposal> proposals = this.getProposals(devProp);
        for (InstitutionalProposal proposal : proposals) {
            this.addToGraph(graph, proposal, devProp);
        }
        this.addSpecialReviewLinksToGraph(graph, devProp.getPropSpecialReviews(), devProp);
    }

    protected void buildGraph(HashMap<Object, List<Object>> graph, Negotiation negotiation) {
        Negotiable bo = this.getNegotiationService().getAssociatedObject(negotiation);
        if (bo instanceof Award || bo instanceof InstitutionalProposal || bo instanceof SubAward) {
            this.addToGraph(graph, bo, negotiation);
        }
    }

    protected void addToGraph(HashMap<Object, List<Object>> graph, Object newBo, Object existingBo) {
        if (newBo == null || existingBo == null) {
            throw new RuntimeException("Inavlid or null Medusa link found");
        }
        if (this.findMatchingBo(graph.keySet(), newBo) == null) {
            this.addEdge(graph, existingBo, newBo);
            if (newBo instanceof Award) {
                this.buildGraph(graph, (Award)newBo);
            } else if (newBo instanceof InstitutionalProposal) {
                this.buildGraph(graph, (InstitutionalProposal)newBo);
            } else if (newBo instanceof DevelopmentProposal) {
                this.buildGraph(graph, (DevelopmentProposal)newBo);
            } else if (newBo instanceof Negotiation) {
                this.buildGraph(graph, (Negotiation)newBo);
            } else if (newBo instanceof SubAward) {
                this.buildGraph(graph, (SubAward)newBo);
            } else if (newBo instanceof Protocol) {
                this.buildGraph(graph, (Protocol)newBo);
            } else if (newBo instanceof IacucProtocol) {
                this.buildGraph(graph, (IacucProtocol)newBo);
            }
        } else {
            this.addEdge(graph, existingBo, newBo);
        }
    }

    protected Object findMatchingBo(Collection<Object> boSet, Object bo) {
        for (Object curBo : boSet) {
            if (!this.areBusinessObjectsEqual(bo, curBo)) continue;
            return curBo;
        }
        return null;
    }

    protected boolean areBusinessObjectsEqual(Object bo1, Object bo2) {
        return bo1 instanceof DevelopmentProposal && bo2 instanceof DevelopmentProposal ? Objects.equals(((DevelopmentProposal)bo1).getProposalNumber(), ((DevelopmentProposal)bo2).getProposalNumber()) : (bo1 instanceof InstitutionalProposal && bo2 instanceof InstitutionalProposal ? Objects.equals(((InstitutionalProposal)bo1).getProposalId(), ((InstitutionalProposal)bo2).getProposalId()) : (bo1 instanceof Award && bo2 instanceof Award ? Objects.equals(((Award)bo1).getAwardId(), ((Award)bo2).getAwardId()) : (bo1 instanceof Negotiation && bo2 instanceof Negotiation ? Objects.equals(((Negotiation)bo1).getNegotiationId(), ((Negotiation)bo2).getNegotiationId()) : (bo1 instanceof SubAward && bo2 instanceof SubAward ? Objects.equals(((SubAward)bo1).getSubAwardId(), ((SubAward)bo2).getSubAwardId()) : (bo1 instanceof Protocol && bo2 instanceof Protocol ? Objects.equals(((Protocol)bo1).getProtocolId(), ((Protocol)bo2).getProtocolId()) : bo1 instanceof IacucProtocol && bo2 instanceof IacucProtocol && Objects.equals(((IacucProtocol)bo1).getProtocolId(), ((IacucProtocol)bo2).getProtocolId()))))));
    }

    protected DevelopmentProposal getDevelopmentProposal(String proposalNumber) {
        return (DevelopmentProposal)this.dataObjectService.find(DevelopmentProposal.class, (Object)proposalNumber);
    }

    protected InstitutionalProposal getInstitutionalProposal(Long proposalId) {
        InstitutionalProposal proposal = (InstitutionalProposal)this.businessObjectService.findByPrimaryKey(InstitutionalProposal.class, this.getFieldValues("proposalId", proposalId));
        if (proposal == null) {
            return null;
        }
        InstitutionalProposal currentProposal = this.getInstitutionalProposal(proposal.getProposalNumber());
        return currentProposal == null ? proposal : currentProposal;
    }

    protected InstitutionalProposal getInstitutionalProposal(String proposalNumber) {
        VersionStatus status;
        InstitutionalProposal currentProposal = null;
        VersionStatus[] versionStatusArray = new VersionStatus[]{VersionStatus.ACTIVE, VersionStatus.PENDING, VersionStatus.ARCHIVED};
        int n = versionStatusArray.length;
        for (int i = 0; i < n && (currentProposal = this.getNewestProposalByStatus(proposalNumber, status = versionStatusArray[i])) == null; ++i) {
        }
        return currentProposal;
    }

    protected Award getAward(Long awardId) {
        Award award = (Award)this.businessObjectService.findByPrimaryKey(Award.class, this.getFieldValues("awardId", awardId));
        if (award == null) {
            return null;
        }
        Award currentAward = (Award)this.getActiveOrCurrentVersion(Award.class, award.getAwardNumber());
        return currentAward == null ? award : currentAward;
    }

    protected Award getAward(String awardNumber) {
        Award currentAward = (Award)this.getActiveOrCurrentVersion(Award.class, awardNumber);
        return currentAward;
    }

    protected Negotiation getNegotiation(Long negotiationId) {
        Negotiation negotiation = negotiationId == null ? null : (Negotiation)this.businessObjectService.findBySinglePrimaryKey(Negotiation.class, (Object)negotiationId);
        return negotiation;
    }

    protected SubAward getSubAward(Long subAwardId) {
        SubAward subAward = (SubAward)this.businessObjectService.findBySinglePrimaryKey(SubAward.class, (Object)subAwardId);
        if (subAward == null) {
            return null;
        }
        SubAward currentSubAward = (SubAward)this.getActiveOrCurrentVersion(SubAward.class, subAward.getSubAwardCode());
        if (currentSubAward != null) {
            this.getSubAwardService().calculateAmountInfo(currentSubAward);
        }
        return currentSubAward == null ? subAward : currentSubAward;
    }

    protected SubAward getSubAwardBySubawardCode(Long subAwardCode) {
        HashMap<String, Long> values = new HashMap<String, Long>();
        values.put("subAwardCode", subAwardCode);
        List subAward = (List)this.businessObjectService.findMatching(SubAward.class, values);
        if (subAward.isEmpty()) {
            return null;
        }
        SubAward currentSubAward = (SubAward)this.getActiveOrCurrentVersion(SubAward.class, ((SubAward)subAward.get(0)).getSubAwardCode());
        if (currentSubAward != null) {
            this.getSubAwardService().calculateAmountInfo(currentSubAward);
        }
        return currentSubAward == null ? (SubAward)subAward.get(0) : currentSubAward;
    }

    protected Protocol getProtocol(Long protocolId) {
        Protocol protocol = (Protocol)this.businessObjectService.findBySinglePrimaryKey(Protocol.class, (Object)protocolId);
        return protocol;
    }

    protected Protocol getProtocol(String protocolNumber) {
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("protocolNumber", protocolNumber);
        List versions = (List)this.businessObjectService.findMatching(Protocol.class, values);
        Protocol newest = null;
        for (Protocol version : versions) {
            if (newest != null && version.getSequenceNumber() <= newest.getSequenceNumber()) continue;
            newest = version;
        }
        return newest;
    }

    protected IacucProtocol getIacuc(Long protocolId) {
        IacucProtocol protocol = (IacucProtocol)this.businessObjectService.findBySinglePrimaryKey(IacucProtocol.class, (Object)protocolId);
        return protocol;
    }

    protected IacucProtocol getIacuc(String protocolNumber) {
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("protocolNumber", protocolNumber);
        List versions = (List)this.businessObjectService.findMatching(IacucProtocol.class, values);
        IacucProtocol newest = null;
        for (IacucProtocol version : versions) {
            if (newest != null && version.getSequenceNumber() <= newest.getSequenceNumber()) continue;
            newest = version;
        }
        return newest;
    }

    protected SequenceOwner getActiveOrCurrentVersion(Class<? extends SequenceOwner<?>> clazz, String sequenceName) {
        VersionHistory activeVersion = this.versionHistoryService.findActiveVersion(clazz, sequenceName);
        SequenceOwner<? extends SequenceOwner<?>> bestVersion = null;
        if (activeVersion != null) {
            bestVersion = activeVersion.getSequenceOwner();
        } else {
            List<VersionHistory> history = this.versionHistoryService.loadVersionHistory(clazz, sequenceName);
            if (history != null && !history.isEmpty()) {
                VersionHistory best = history.get(0);
                for (VersionHistory curVersion : history) {
                    if (curVersion.getVersionNumber() <= best.getVersionNumber() || curVersion.getStatus() == VersionStatus.CANCELED) continue;
                    best = curVersion;
                }
                bestVersion = best.getSequenceOwner();
            }
        }
        return bestVersion;
    }

    protected MedusaNode getNode(Object bo) {
        if (bo instanceof Award) {
            return this.getNode((Award)bo);
        }
        if (bo instanceof InstitutionalProposal) {
            return this.getNode((InstitutionalProposal)bo);
        }
        if (bo instanceof DevelopmentProposal) {
            return this.getNode((DevelopmentProposal)bo);
        }
        if (bo instanceof Negotiation) {
            return this.getNode((Negotiation)bo);
        }
        if (bo instanceof SubAward) {
            return this.getNode((SubAward)bo);
        }
        if (bo instanceof Protocol) {
            return this.getNode((Protocol)bo);
        }
        if (bo instanceof IacucProtocol) {
            return this.getNode((IacucProtocol)bo);
        }
        return null;
    }

    protected MedusaNode getNode(Award award) {
        AwardAmountInfo awardAmountInfo = this.awardAmountInfoService.fetchAwardAmountInfoWithHighestTransactionId(award.getAwardAmountInfos());
        MedusaNode node = new MedusaNode();
        node.setBo(award);
        node.setType("award");
        this.setDocumentDescriptionIfEnabled(node, "1", (Document)award.getAwardDocument());
        node.setExtraInfo(awardAmountInfo);
        return node;
    }

    protected MedusaNode getNode(InstitutionalProposal proposal) {
        MedusaNode node = new MedusaNode();
        node.setBo(proposal);
        node.setType("IP");
        this.setDocumentDescriptionIfEnabled(node, "2", (Document)proposal.getInstitutionalProposalDocument());
        proposal.setNsfCodeBo(proposal.getNsfCodeBo());
        return node;
    }

    protected MedusaNode getNode(DevelopmentProposal proposal) {
        MedusaNode node = new MedusaNode();
        node.setBo(proposal);
        node.setType("DP");
        this.setDocumentDescriptionIfEnabled(node, "3", (Document)proposal.getProposalDocument());
        return node;
    }

    protected MedusaNode getNode(Negotiation negotiation) {
        MedusaNode node = new MedusaNode();
        node.setBo(negotiation);
        node.setType("neg");
        this.setDocumentDescriptionIfEnabled(node, "5", (Document)negotiation.getDocument());
        return node;
    }

    protected MedusaNode getNode(SubAward subAward) {
        MedusaNode node = new MedusaNode();
        node.setBo(subAward);
        node.setType("subaward");
        this.setDocumentDescriptionIfEnabled(node, "4", (Document)subAward.getSubAwardDocument());
        return node;
    }

    protected MedusaNode getNode(Protocol protocol) {
        MedusaNode node = new MedusaNode();
        node.setBo(protocol);
        node.setType("irb");
        this.setDocumentDescriptionIfEnabled(node, "7", (Document)protocol.getProtocolDocument());
        return node;
    }

    protected MedusaNode getNode(IacucProtocol protocol) {
        MedusaNode node = new MedusaNode();
        node.setBo(protocol);
        node.setType("iacuc");
        this.setDocumentDescriptionIfEnabled(node, "9", (Document)protocol.getProtocolDocument());
        return node;
    }

    protected Collection<DevelopmentProposal> getDevelopmentProposals(InstitutionalProposal instProposal) {
        ArrayList<DevelopmentProposal> devProposals = new ArrayList<DevelopmentProposal>();
        Collection proposalVersions = this.businessObjectService.findMatching(InstitutionalProposal.class, this.getFieldValues("proposalNumber", instProposal.getProposalNumber()));
        for (InstitutionalProposal ip : proposalVersions) {
            Collection proposalAdminDetails = this.businessObjectService.findMatching(ProposalAdminDetails.class, this.getFieldValues("instProposalId", ip.getProposalId()));
            for (ProposalAdminDetails proposalAdminDetail : proposalAdminDetails) {
                devProposals.add(this.getDevelopmentProposal(proposalAdminDetail.getDevProposalNumber()));
            }
        }
        return devProposals;
    }

    protected Collection<Award> getAwards(SubAward subAward) {
        ArrayList<Award> awards = new ArrayList<Award>();
        SubAward newestSubAaward = this.getSubAward(subAward.getSubAwardCode());
        List<SubAwardFundingSource> subAwardFundingSources = newestSubAaward.getSubAwardFundingSourceList();
        for (SubAwardFundingSource subAwardFundingSource : subAwardFundingSources) {
            awards.add(this.getAward(subAwardFundingSource.getAwardId()));
        }
        return awards;
    }

    protected SubAward getSubAward(String subAwardCode) {
        SubAward subAward = (SubAward)this.getActiveOrCurrentVersion(SubAward.class, subAwardCode);
        return subAward;
    }

    protected Collection<SubAward> getSubAwards(Award award) {
        List<SubAward> subAwards = this.getSubAwardService().getLinkedSubAwards(award);
        return subAwards;
    }

    protected Collection<Award> getAwards(InstitutionalProposal ip) {
        ArrayList<Award> awards = new ArrayList<Award>();
        Collection institutionalProposalVersions = this.businessObjectService.findMatching(InstitutionalProposal.class, this.getFieldValues("proposalNumber", ip.getProposalNumber()));
        for (InstitutionalProposal curIp : institutionalProposalVersions) {
            List<AwardFundingProposal> awardFundingProposals = curIp.getAwardFundingProposals();
            for (AwardFundingProposal awardFunding : awardFundingProposals) {
                if (!awardFunding.isActive() || curIp.isCancelled()) continue;
                awards.add(this.getAward(awardFunding.getAwardId()));
            }
        }
        InstitutionalProposal activeProposal = this.getNewestProposalByStatus(ip.getProposalNumber(), VersionStatus.ACTIVE);
        if (activeProposal != null && StringUtils.isNotBlank((CharSequence)activeProposal.getCurrentAwardNumber()) && activeProposal.getStatusCode() != 2) {
            Collection proposalCurrentAwards = this.businessObjectService.findMatching(Award.class, this.getFieldValues("awardNumber", activeProposal.getCurrentAwardNumber()));
            for (Award curAward : proposalCurrentAwards) {
                awards.add(this.getAward(curAward.getAwardId()));
            }
        }
        return awards;
    }

    protected InstitutionalProposal getNewestProposalByStatus(String proposalNumber, VersionStatus status) {
        Collection versions = this.getBusinessObjectService().findMatching(InstitutionalProposal.class, this.getFieldValues("proposalNumber", proposalNumber));
        InstitutionalProposal newestProposal = null;
        for (InstitutionalProposal curProposal : versions) {
            if (newestProposal == null && curProposal.isActiveVersion()) {
                newestProposal = curProposal;
                continue;
            }
            if (!curProposal.isActiveVersion() || curProposal.getSequenceNumber() <= newestProposal.getSequenceNumber()) continue;
            newestProposal = curProposal;
        }
        return newestProposal;
    }

    protected Collection<InstitutionalProposal> getProposals(Award award) {
        ArrayList<InstitutionalProposal> ips = new ArrayList<InstitutionalProposal>();
        Collection awardVersions = this.businessObjectService.findMatching(Award.class, this.getFieldValues("awardNumber", award.getAwardNumber()));
        for (Award curAward : awardVersions) {
            List<AwardFundingProposal> awardFundingProposals = curAward.getFundingProposals();
            for (AwardFundingProposal awardFunding : awardFundingProposals) {
                InstitutionalProposal curProposal = (InstitutionalProposal)this.businessObjectService.findByPrimaryKey(InstitutionalProposal.class, this.getFieldValues("proposalId", awardFunding.getProposalId()));
                boolean proposalNotCancelled = !curProposal.isCancelled();
                if (!proposalNotCancelled || !awardFunding.isActive()) continue;
                ips.add(this.getInstitutionalProposal(awardFunding.getProposalId()));
            }
        }
        Collection curAwardIps = this.businessObjectService.findMatching(InstitutionalProposal.class, this.getFieldValues("currentAwardNumber", award.getAwardNumber()));
        for (InstitutionalProposal proposal : curAwardIps) {
            if (proposal.getStatusCode() == 2 || !proposal.isActiveVersion()) continue;
            ips.add(this.getInstitutionalProposal(proposal.getProposalId()));
        }
        return ips;
    }

    protected Collection<InstitutionalProposal> getProposals(DevelopmentProposal devProposal) {
        Collection proposalAdminDetails = this.businessObjectService.findMatching(ProposalAdminDetails.class, this.getFieldValues("devProposalNumber", devProposal.getProposalNumber()));
        return proposalAdminDetails.stream().map(ProposalAdminDetails::getInstProposalId).filter(Objects::nonNull).map(this::getInstitutionalProposal).collect(Collectors.toList());
    }

    protected Collection<Negotiation> getNegotiations(BusinessObject bo) {
        return this.getNegotiationService().getAssociatedNegotiations(bo);
    }

    protected void setDocumentDescriptionIfEnabled(MedusaNode node, String coeusModule, Document document) {
        if (this.getDocumentDescriptionDisplayModules().contains(coeusModule) || this.getDocumentDescriptionDisplayModules().contains("*")) {
            String description = Optional.ofNullable(document).map(Document::getDocumentHeader).map(DocumentHeader::getDocumentDescription).map(d -> d.length() > 160 ? d.substring(0, 160).concat("...") : d).orElse("");
            node.setDocumentDescription(description);
        }
    }

    @Override
    public Collection<String> getDocumentDescriptionDisplayModules() {
        return this.getParameterService().getParameterValuesAsString("KC-GEN", "All", SHOW_MEDUSA_DOCUMENT_DESCRIPTIONS_PARAMETER);
    }

    @Override
    public boolean isReactMedusaEnabled() {
        return this.getParameterService().getParameterValueAsBoolean("KC-GEN", "All", REACT_MEDUSA_ENABLED_PARAMETER, Boolean.valueOf(false));
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    protected Map<String, Object> getFieldValues(String key, Object value) {
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put(key, value);
        return fieldValues;
    }

    protected AwardAmountInfoService getAwardAmountInfoService() {
        return this.awardAmountInfoService;
    }

    public void setAwardAmountInfoService(AwardAmountInfoService awardAmountInfoService) {
        this.awardAmountInfoService = awardAmountInfoService;
    }

    protected VersionHistoryService getVersionHistoryService() {
        return this.versionHistoryService;
    }

    public void setVersionHistoryService(VersionHistoryService versionHistoryService) {
        this.versionHistoryService = versionHistoryService;
    }

    protected NegotiationService getNegotiationService() {
        return this.negotiationService;
    }

    public void setNegotiationService(NegotiationService negotiationService) {
        this.negotiationService = negotiationService;
    }

    protected SubAwardService getSubAwardService() {
        return this.subAwardService;
    }

    public void setSubAwardService(SubAwardService subAwardService) {
        this.subAwardService = subAwardService;
    }

    protected ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }
}

