/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.protocol.funding.impl;

import java.sql.Date;
import java.util.Calendar;
import java.util.List;
import org.kuali.coeus.common.framework.auth.perm.KcAuthorizationService;
import org.kuali.coeus.common.framework.person.editable.PersonEditableService;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocument;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentService;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentUtils;
import org.kuali.coeus.propdev.impl.person.KeyPersonnelService;
import org.kuali.coeus.propdev.impl.person.KeyPersonnelServiceImpl;
import org.kuali.coeus.propdev.impl.person.ProposalPerson;
import org.kuali.coeus.propdev.impl.specialreview.ProposalSpecialReview;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.ProtocolDocument;
import org.kuali.kra.irb.ProtocolForm;
import org.kuali.kra.irb.protocol.ProtocolHelper;
import org.kuali.kra.irb.protocol.funding.ProtocolFundingSource;
import org.kuali.kra.irb.protocol.funding.ProtocolProposalDevelopmentDocumentService;
import org.kuali.kra.protocol.protocol.funding.ProtocolFundingSourceBase;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.bo.DocumentHeader;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.util.GlobalVariables;

public class ProtocolProposalDevelopmentDocumentServiceImpl
implements ProtocolProposalDevelopmentDocumentService {
    @Override
    public ProposalDevelopmentDocument createProposalDevelopmentDocument(ProtocolForm protocolForm) throws Exception {
        ProposalDevelopmentDocument proposalDevelopmentDocument = null;
        Protocol protocol = protocolForm.getProtocolDocument().getProtocol();
        if (this.isAuthorizedCreateProposal(protocolForm.getProtocolHelper())) {
            DocumentService docService = KRADServiceLocatorWeb.getDocumentService();
            proposalDevelopmentDocument = (ProposalDevelopmentDocument)docService.getNewDocument(ProposalDevelopmentDocument.class);
            ProposalDevelopmentService proposalDevelopmentService = KcServiceLocator.getService(ProposalDevelopmentService.class);
            this.populateDocumentOverview(protocol, proposalDevelopmentDocument);
            this.populateRequiredFields(protocol, proposalDevelopmentDocument);
            proposalDevelopmentService.initializeUnitOrganizationLocation(proposalDevelopmentDocument);
            proposalDevelopmentService.initializeProposalSiteNumbers(proposalDevelopmentDocument);
            this.populateProposalPerson_Investigator(protocol, proposalDevelopmentDocument);
            this.populateProposalSpecialReview(protocol, proposalDevelopmentDocument);
            docService.saveDocument((Document)proposalDevelopmentDocument);
            this.initializeAuthorization(proposalDevelopmentDocument);
        }
        return proposalDevelopmentDocument;
    }

    protected void populateDocumentOverview(Protocol protocol, ProposalDevelopmentDocument proposalDocument) {
        ProtocolDocument protocolDocument = (ProtocolDocument)protocol.getProtocolDocument();
        DocumentHeader proposalDocumentHeader = proposalDocument.getDocumentHeader();
        DocumentHeader protocolDocumentHeader = protocolDocument.getDocumentHeader();
        proposalDocumentHeader.setDocumentDescription("PD - " + protocolDocumentHeader.getDocumentDescription());
        proposalDocumentHeader.setExplanation("Document created from Protocol - " + protocolDocument.getDocumentNumber());
        proposalDocumentHeader.setOrganizationDocumentNumber(protocolDocumentHeader.getOrganizationDocumentNumber());
    }

    protected void populateRequiredFields(Protocol protocol, ProposalDevelopmentDocument proposalDocument) throws Exception {
        DevelopmentProposal developmentProposal = proposalDocument.getDevelopmentProposal();
        developmentProposal.setTitle(protocol.getTitle());
        developmentProposal.setOwnedByUnit(protocol.getLeadUnit().getUnit());
        developmentProposal.setOwnedByUnitNumber(protocol.getLeadUnitNumber());
        developmentProposal.setRequestedStartDateInitial(new Date(System.currentTimeMillis()));
        ParameterService parameterService = KcServiceLocator.getService(ParameterService.class);
        String projectEndDateParameter = parameterService.getParameterValueAsString(ProtocolDocument.class, "protocolProjectEndDateNumberOfYears");
        int numberOfYears = Integer.parseInt(projectEndDateParameter);
        Calendar calendar = Calendar.getInstance();
        calendar.add(1, numberOfYears);
        calendar.add(5, -1);
        Date projectEndDate = new Date(calendar.getTimeInMillis());
        developmentProposal.setRequestedEndDateInitial(projectEndDate);
        String activityTypeCode = ProposalDevelopmentUtils.getProposalDevelopmentDocumentParameter("ACTIVITY_TYPE_CODE_RESEARCH");
        String proposalTypeCode = ProposalDevelopmentUtils.getProposalDevelopmentDocumentParameter("PROPOSAL_TYPE_CODE_NEW");
        developmentProposal.setActivityTypeCode(activityTypeCode);
        developmentProposal.setProposalTypeCode(proposalTypeCode);
        List<ProtocolFundingSourceBase> protocolFundingSources = protocol.getProtocolFundingSources();
        ProtocolFundingSourceBase sponsorProtocolFundingSource = null;
        for (ProtocolFundingSourceBase protocolFundingSource : protocolFundingSources) {
            if (!protocolFundingSource.isSponsorFunding()) continue;
            sponsorProtocolFundingSource = (ProtocolFundingSource)protocolFundingSource;
            break;
        }
        if (sponsorProtocolFundingSource != null) {
            developmentProposal.setSponsorCode(sponsorProtocolFundingSource.getFundingSourceNumber());
        }
    }

    protected void initializeAuthorization(ProposalDevelopmentDocument document) {
        String userId = GlobalVariables.getUserSession().getPrincipalId();
        KcAuthorizationService kraAuthService = KcServiceLocator.getService(KcAuthorizationService.class);
        kraAuthService.addDocumentLevelRole(userId, "Aggregator", document);
    }

    public void populateProposalPerson_Investigator(Protocol protocol, ProposalDevelopmentDocument proposalDocument) {
        ProposalPerson proposalPerson = new ProposalPerson();
        proposalPerson.setPersonId(protocol.getPrincipalInvestigatorId());
        PersonEditableService personEditableService = KcServiceLocator.getService(PersonEditableService.class);
        personEditableService.populateContactFieldsFromPersonId(proposalPerson);
        proposalPerson.setProposalPersonRoleId("PI");
        proposalPerson.setDevelopmentProposal(proposalDocument.getDevelopmentProposal());
        proposalPerson.setProposalPersonNumber(new Integer(1));
        proposalPerson.setOptInUnitStatus(false);
        proposalPerson.setOptInCertificationStatus(false);
        proposalDocument.getDevelopmentProposal().getProposalPersons().add(proposalPerson);
        KeyPersonnelServiceImpl keyPersonnelService = (KeyPersonnelServiceImpl)KcServiceLocator.getService(KeyPersonnelService.class);
        keyPersonnelService.populateProposalPerson(proposalPerson, proposalDocument);
        keyPersonnelService.assignLeadUnit(proposalPerson, proposalDocument.getDevelopmentProposal().getOwnedByUnitNumber());
    }

    protected void populateProposalSpecialReview(Protocol protocol, ProposalDevelopmentDocument proposalDocument) {
        if (protocol != null) {
            Integer specialReviewNumber = proposalDocument.getDocumentNextValue("SPECIAL_REVIEW_NUMBER");
            ProposalSpecialReview specialReview = new ProposalSpecialReview();
            specialReview.setSpecialReviewNumber(specialReviewNumber);
            specialReview.setSpecialReviewTypeCode("1");
            specialReview.setApprovalTypeCode("1");
            specialReview.setProtocolNumber(protocol.getProtocolNumber());
            specialReview.setDevelopmentProposal(proposalDocument.getDevelopmentProposal());
            specialReview.setProtocolStatus(protocol.getProtocolStatus().getDescription());
            specialReview.setComments("A Special Review has been inserted.");
            proposalDocument.getDevelopmentProposal().getPropSpecialReviews().add(specialReview);
        }
    }

    protected boolean isAuthorizedCreateProposal(ProtocolHelper protocolHelper) {
        boolean canCreateProposal = protocolHelper.isCanCreateProposalDevelopment();
        return canCreateProposal;
    }
}

