/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.budget.impl.nonpersonnel;

import java.sql.Date;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.budget.framework.core.Budget;
import org.kuali.coeus.common.budget.framework.core.BudgetException;
import org.kuali.coeus.common.budget.framework.core.CostElement;
import org.kuali.coeus.common.budget.framework.nonpersonnel.BudgetJustificationService;
import org.kuali.coeus.common.budget.framework.nonpersonnel.BudgetJustificationWrapper;
import org.kuali.coeus.common.budget.framework.nonpersonnel.BudgetLineItem;
import org.kuali.coeus.common.budget.framework.period.BudgetPeriod;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="budgetJustificationService")
public class BudgetJustificationServiceImpl
implements BudgetJustificationService {
    protected final Logger LOG = LogManager.getLogger(BudgetJustificationServiceImpl.class);
    @Autowired
    @Qualifier(value="businessObjectService")
    private BusinessObjectService businessObjectService;
    @Autowired
    @Qualifier(value="globalVariableService")
    private GlobalVariableService globalVariableService;

    @Override
    public void consolidateExpenseJustifications(Budget budget, BudgetJustificationWrapper budgetJustificationWrapper) throws BudgetException {
        if (!budget.areLineItemJustificationsPresent()) {
            this.LOG.error("There are no line item budget justifications");
            throw new BudgetException();
        }
        this.addConsolidatedLineItemJustificationText(budget, budgetJustificationWrapper);
    }

    @Override
    public void preSave(Budget budget, BudgetJustificationWrapper budgetJustificationWrapper) {
        this.updateJustficationMetaData(budgetJustificationWrapper);
        budget.setBudgetJustification(budgetJustificationWrapper.toString());
    }

    protected String getLoggedInUserNetworkId() {
        return this.globalVariableService.getUserSession().getPrincipalName();
    }

    protected Map<String, CostElement> loadCostElements() {
        Collection costElements = this.getBusinessObjectService().findAll(CostElement.class);
        TreeMap<String, CostElement> costElementsMappedToCostElementCode = new TreeMap<String, CostElement>();
        for (CostElement costElement : costElements) {
            costElementsMappedToCostElementCode.put(costElement.getCostElement(), costElement);
        }
        return costElementsMappedToCostElementCode;
    }

    protected void addBudgetPeriodFooter(StringBuilder sb) {
        sb.append("\n");
    }

    protected void addBudgetPeriodHeader(StringBuilder sb, int budgetPeriodNumber) {
        sb.append("Period ");
        sb.append(budgetPeriodNumber);
        sb.append("\n");
    }

    protected void addConsolidatedLineItemJustificationText(Budget budget, BudgetJustificationWrapper budgetJustificationWrapper) {
        String existingJustificationText = budgetJustificationWrapper.getJustificationText();
        StringBuilder sb = new StringBuilder();
        if (!StringUtils.isEmpty((CharSequence)existingJustificationText)) {
            sb.append(existingJustificationText);
            this.addLineItemJustificationTextSeparatorText(sb);
        }
        for (BudgetPeriod budgetPeriod : budget.getBudgetPeriods()) {
            if (budgetPeriod.getBudgetLineItems().size() <= 0) continue;
            this.addJustificationTextByBudgetPeriod(budgetPeriod, sb);
        }
        budgetJustificationWrapper.setJustificationText(sb.toString());
    }

    protected void addJustificationTextByBudgetPeriod(BudgetPeriod budgetPeriod, StringBuilder sb) {
        Map<String, CostElement> costElementsMappedToCostElementCode = this.loadCostElements();
        boolean periodHeaderAdded = false;
        for (BudgetLineItem lineItem : budgetPeriod.getBudgetLineItems()) {
            periodHeaderAdded = this.addLineItemJustificationText(costElementsMappedToCostElementCode, sb, budgetPeriod.getBudgetPeriod(), periodHeaderAdded, lineItem);
        }
        if (periodHeaderAdded) {
            this.addBudgetPeriodFooter(sb);
        }
    }

    protected boolean addLineItemJustificationText(Map<String, CostElement> costElementsMappedToCostElementCode, StringBuilder sb, int budgetPeriodNumber, boolean periodHeaderAdded, BudgetLineItem lineItem) {
        String lineItemJustification = lineItem.getBudgetJustification();
        if (!StringUtils.isEmpty((CharSequence)lineItemJustification)) {
            if (!periodHeaderAdded) {
                this.addBudgetPeriodHeader(sb, budgetPeriodNumber);
                periodHeaderAdded = true;
            }
            this.addLineItemJustificationTextElements(costElementsMappedToCostElementCode, sb, lineItem, lineItemJustification);
        }
        return periodHeaderAdded;
    }

    protected void addLineItemJustificationTextElements(Map<String, CostElement> costElementsMappedToCostElementCode, StringBuilder sb, BudgetLineItem lineItem, String lineItemJustification) {
        sb.append(costElementsMappedToCostElementCode.get(lineItem.getCostElement()).getDescription());
        sb.append("\n");
        sb.append(lineItemJustification);
        sb.append("\n");
    }

    protected void addLineItemJustificationTextSeparatorText(StringBuilder sb) {
        sb.append("\n\n");
        sb.append("***************************");
        sb.append("\n\n");
    }

    protected void updateJustficationMetaData(BudgetJustificationWrapper budgetJustificationWrapper) {
        String updateUser = this.getLoggedInUserNetworkId();
        budgetJustificationWrapper.setLastUpdateUser(updateUser);
        budgetJustificationWrapper.setLastUpdateTime(new Date(System.currentTimeMillis()));
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public GlobalVariableService getGlobalVariableService() {
        return this.globalVariableService;
    }

    public void setGlobalVariableService(GlobalVariableService globalVariableService) {
        this.globalVariableService = globalVariableService;
    }
}

