/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.questionnaire.impl.print;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kuali.coeus.common.framework.print.AbstractPrint;
import org.kuali.coeus.common.framework.print.AttachmentDataSource;
import org.kuali.coeus.common.framework.print.Printable;
import org.kuali.coeus.common.framework.print.PrintingException;
import org.kuali.coeus.common.framework.print.PrintingService;
import org.kuali.coeus.common.questionnaire.framework.core.Questionnaire;
import org.kuali.coeus.common.questionnaire.framework.print.QuestionnairePrint;
import org.kuali.coeus.common.questionnaire.framework.print.QuestionnairePrintingService;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.actions.submit.ProtocolSubmission;
import org.kuali.kra.protocol.actions.print.QuestionnairePrintOption;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="questionnairePrintingService")
public class QuestionnairePrintingServiceImpl
implements QuestionnairePrintingService {
    private static final String PROTOCOL_NUMBER = "protocolNumber";
    private static final String SUBMISSION_NUMBER = "submissionNumber";
    @Autowired
    @Qualifier(value="printingService")
    private PrintingService printingService;
    @Autowired
    @Qualifier(value="questionnairePrint")
    private QuestionnairePrint questionnairePrint;
    @Autowired
    @Qualifier(value="businessObjectService")
    private BusinessObjectService businessObjectService;

    @Override
    public AttachmentDataSource printQuestionnaire(KcPersistableBusinessObjectBase printableBusinessObject, Map<String, Object> reportParameters) throws PrintingException {
        AttachmentDataSource source = null;
        QuestionnairePrint printable = this.getQuestionnairePrint();
        if (printable != null) {
            printable.setPrintableBusinessObject(printableBusinessObject);
            printable.setReportParameters(reportParameters);
            source = this.getPrintingService().print(printable);
            source.setName("Questionnaire-" + reportParameters.get("documentNumber") + ".pdf");
            source.setType("application/pdf");
        }
        return source;
    }

    @Override
    public AttachmentDataSource printQuestionnaireAnswer(KcPersistableBusinessObjectBase printableBusinessObject, Map<String, Object> reportParameters) throws PrintingException {
        AttachmentDataSource source = null;
        QuestionnairePrint printable = this.getQuestionnairePrint();
        if (printable != null) {
            printable.setPrintableBusinessObject(printableBusinessObject);
            printable.setReportParameters(reportParameters);
            source = this.getPrintingService().print(printable);
            source.setName("QuestionnaireAnswer" + reportParameters.get("id") + ".pdf");
            source.setType("application/pdf");
        }
        return source;
    }

    private Questionnaire getQuestionnaire(Long questionnaireRefId) {
        HashMap<String, Long> pkMap = new HashMap<String, Long>();
        pkMap.put("id", questionnaireRefId);
        return (Questionnaire)this.businessObjectService.findByPrimaryKey(Questionnaire.class, pkMap);
    }

    @Override
    public List<Printable> getQuestionnairePrintable(KcPersistableBusinessObjectBase printableBusinessObject, List<QuestionnairePrintOption> questionnairesToPrints) {
        ArrayList<Printable> printables = new ArrayList<Printable>();
        for (QuestionnairePrintOption printOption : questionnairesToPrints) {
            if (!printOption.isSelected()) continue;
            QuestionnairePrint printable = new QuestionnairePrint();
            ((AbstractPrint)printable).setXmlStream(this.getQuestionnairePrint().getXmlStream());
            HashMap<String, Object> reportParameters = new HashMap<String, Object>();
            Questionnaire questionnaire = this.getQuestionnaire(printOption.getQuestionnaireId());
            reportParameters.put("questionnaireSeqId", questionnaire.getQuestionnaireSeqIdAsInteger());
            reportParameters.put("id", questionnaire.getId());
            reportParameters.put("template", questionnaire.getTemplate());
            reportParameters.put("moduleSubItemCode", printOption.getSubItemCode());
            if ("2".equals(printOption.getSubItemCode())) {
                reportParameters.put(PROTOCOL_NUMBER, printOption.getItemKey());
                reportParameters.put(SUBMISSION_NUMBER, printOption.getSubItemKey());
            }
            printable.setPrintableBusinessObject(this.getProtocolPrintable(printOption));
            printable.setReportParameters(reportParameters);
            printables.add(printable);
        }
        return printables;
    }

    private Protocol getProtocolPrintable(QuestionnairePrintOption printOption) {
        if ("2".equals(printOption.getSubItemCode())) {
            HashMap<String, String> keyValues = new HashMap<String, String>();
            keyValues.put(PROTOCOL_NUMBER, printOption.getItemKey());
            keyValues.put(SUBMISSION_NUMBER, printOption.getSubItemKey());
            return ((ProtocolSubmission)((List)this.businessObjectService.findMatchingOrderBy(ProtocolSubmission.class, keyValues, "submissionId", false)).get(0)).getProtocol();
        }
        HashMap<String, String> keyValues = new HashMap<String, String>();
        keyValues.put(PROTOCOL_NUMBER, printOption.getItemKey());
        keyValues.put("sequenceNumber", printOption.getSubItemKey());
        return (Protocol)((List)this.businessObjectService.findMatching(Protocol.class, keyValues)).get(0);
    }

    public PrintingService getPrintingService() {
        return this.printingService;
    }

    public void setPrintingService(PrintingService printingService) {
        this.printingService = printingService;
    }

    public QuestionnairePrint getQuestionnairePrint() {
        return this.questionnairePrint;
    }

    public void setQuestionnairePrint(QuestionnairePrint questionnairePrint) {
        this.questionnairePrint = questionnairePrint;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }
}

