/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.onlinereview.authorization;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.workflow.KcWorkflowService;
import org.kuali.kra.irb.ProtocolOnlineReviewDocument;
import org.kuali.kra.irb.onlinereview.ProtocolOnlineReview;
import org.kuali.kra.irb.onlinereview.authorization.ProtocolOnlineReviewAuthorizer;
import org.kuali.kra.irb.onlinereview.authorization.ProtocolOnlineReviewTask;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.DocumentService;

public class ModifyProtocolOnlineReviewAuthorizer
extends ProtocolOnlineReviewAuthorizer {
    private static final Logger LOG = LogManager.getLogger(ModifyProtocolOnlineReviewAuthorizer.class);
    private KcWorkflowService kraWorkflowService;

    @Override
    public boolean isAuthorized(String userId, ProtocolOnlineReviewTask task) {
        boolean hasPermission = true;
        ProtocolOnlineReview protocolOnlineReview = task.getProtocolOnlineReview();
        ProtocolOnlineReviewDocument protocolDoc = null;
        try {
            protocolDoc = (ProtocolOnlineReviewDocument)KcServiceLocator.getService(DocumentService.class).getByDocumentHeaderId(protocolOnlineReview.getProtocolOnlineReviewDocument().getDocumentNumber());
        }
        catch (WorkflowException e) {
            LOG.error(String.format("Could not find ProtocolOnlineReview, document number %s", protocolOnlineReview.getProtocolOnlineReviewDocument().getDocumentNumber()));
            return false;
        }
        if (protocolOnlineReview.getProtocolOnlineReviewId() == null) {
            return false;
        }
        hasPermission = !protocolOnlineReview.getProtocolOnlineReviewDocument().isViewOnly() && (this.hasPermission(userId, protocolOnlineReview, "Maintain Protocol Online Reviews") && this.kraWorkflowService.isEnRoute((Document)protocolDoc) || this.hasPermission(userId, protocolOnlineReview, "Maintain Protocol Online Review Comments") && this.kraWorkflowService.isUserApprovalRequested((Document)protocolDoc, userId));
        return hasPermission;
    }

    public KcWorkflowService getKraWorkflowService() {
        return this.kraWorkflowService;
    }

    public void setKraWorkflowService(KcWorkflowService kraWorkflowService) {
        this.kraWorkflowService = kraWorkflowService;
    }
}

